;; Eulisp Module
;; Author: pab
;; File: aux-macros.em
;; Date: Mon Aug  3 13:36:43 1992
;;
;; Project:
;; Description: 
;;

(defmodule aux-macros
        (standard0
         list-fns
         
         )
        ()
       
(defmacro break forms
  `(@break-cont@ (progn ,@forms)))

(defmacro continue ()
  `(@continue-cont@ '(() t)))

;(defmacro while (pred . forms)
;  `(let/cc @break-cont@
;	   (map-while (lambda () ,@forms)
;		      (lambda () ,pred)
;		      ())))

(defmacro while (pred . forms)
    `(let/cc @break-cont@
       (map-while (lambda (@continue-cont@) ,@forms)
                  (lambda () ,pred)
                  ())))

;(defun map-while (ff pf val)
;  (labels ((mwc  (val)
;		 (if (pf)
;		     (mwc (ff))
;		   (cons val ()))))
;	  (let ((ans (mwc val)))
;	    (car ans))))


(defun map-while (ff pf val)
  (let ((ans (let/cc cc (map-while-cont ff pf cc val))))
    (if (cdr ans)
	(map-while ff pf val)
      (car ans))))

(defun map-while-cont (ff pf cc val)
  (if (pf)
      (map-while-cont ff pf cc (ff cc))
    (cons val ())))

(defmacro docdr (var arglis . body)
  `(when (not (null ,arglis))
	 (let ((,var  ,arglis)
	       (rest (cdr ,arglis)))
	   (while ,var
	    (when ,var
		  ,@body
		  (if rest
		      (progn
			(setq ,var  rest)
			(setq rest (cdr rest)))
		    (setq ,var nil)))))))

(export docdr)

(defmacro docollect (var arg-lis . body)
  `(when (not (null ,arg-lis))
	 (let ((,var (car ,arg-lis))
	       (rest (cdr ,arg-lis))
	       (new-lis nil))
	   (while ,var
	    (when ,var
		  (setq new-lis  (append new-lis (list (progn ,@body))))
		  (if rest
		      (progn
			(setq ,var (car rest))
			(setq rest (cdr rest)))
		    (setq ,var nil))))
	   new-lis)))

(export docollect)

(defmacro docollect-unique (var arg-lis . body)
  `(when (not (null ,arg-lis))
	 (let ((,var (car ,arg-lis))
	       (rest (cdr ,arg-lis))
	       (new-lis nil)
	       (temp nil))
	   (while ,var
	     (when (not (memq (setq temp (progn ,@body)) new-lis))
			(setq new-lis  (append new-lis (list temp))))
		  (if rest
		      (progn
			(setq ,var (car rest))
			(setq rest (cdr rest)))
		    (setq ,var nil)))
	   new-lis)))

(export docollect-unique)

(defmacro dotimes (var num . body)
  `(let ((,var 1))
     (while (or (< ,var ,num) (= ,var ,num))
	    ,@body
	    (setq ,var (+ ,var 1)))))


(export dotimes)
  ;; List macros...

(defmacro push (val st) `(setq ,st (cons ,val ,st)))


(defmacro pop (st) `(let ((val (car ,st)))
			(setq ,st (cdr ,st))
			val))
(export push pop)

(defmacro incf (arg)
  `(setq ,arg (+ 1 ,arg)))

(export incf)

(defmacro decf (arg)
  `(setq ,arg (- ,arg 1)))

(export decf)

(defmacro trap (value . forms)
  `(let/cc escape
	   (with-handler (lambda (a b) (escape ,value)) ,@forms)))

(export trap)

(defmacro multiple-setq forms
    (if forms
      `(progn 
         (setq ,(car forms) ,(cadr forms))
         (multiple-setq ,@(cddr forms)))
      `(progn)))

(export multiple-setq)

(defmacro dolist (var arglist . body)
  `(mapc (lambda (,var) ,@body) ,arglist))

(export dolist)

(defmacro do* (control test-result . body)
    (let ((decl nil) (label (gensym)) (vl nil) (step nil)
          (test (car test-result))
          (result (cdr test-result)))


      (mapc (lambda (c)
	      (when (symbolp c) (setq c (list c)))
	      (push (list (car c) (cadr c)) vl)
	      (unless (not (consp (cddr c)))
		      (push (car c) step)
		      (push (caddr c) step)))
	      control)
      
      `(let* ,(reverse vl)
;	 ,@decl
	 (while (not ,test) 
	   (progn ,@body)
	   (multiple-setq ,@(reverse step)))
	 (progn ,@result))))

(export do*)  





(defun sll-signature (ll)
    (let ((cl-name nil))
      (cond ((not (consp ll)) nil)
            ((consp (car ll))
	     (cons (cadar ll) (sll-signature (cdr ll))))
	    (t (cons 'object (sll-signature (cdr ll)))))))


(defun sll-formals (ll)
    (cond ((not (consp ll)) nil)
          ((consp (car ll)) (cons (caar ll) (sll-formals (cdr ll))))
          (t (cons (car ll) (sll-formals (cdr ll))))))

(defmacro make-method (name sll . body)
  `(let* ((k nil)
	  (method (make-instance (generic-function-method-class ,name)
			'signature (list ,@(sll-signature sll))
			'function
			  (lambda (***method-status-handle***
				   ***method-args-handle***
				   ,@(sll-formals sll)) 
			    ,@body))))
     (add-method ,name method)
    method))





(export make-method break continue while map-while map-while-cont)

      ;; end module
      )
