;; Eulisp Module
;; Author: pab
;; File: standard0.em
;; Date: Thu Dec 17 16:03:19 1992
;;
;; Project:
;; Description: 
;;  All Of Eulisp. This is the compiled version....

(defmodule standard0
  ((rename ((car real-car) (cdr real-cdr) (vector-ref real-vector-ref))
	   standard)
   (rename ((car internal-car) (cdr internal-cdr)) lists)
   (rename ((vector-ref internal-vector-ref)) vectors)
   semaphores
   )
  ()
  (expose (except (scan-args fold) standard))
  (expose semaphores)
  (export slot-description-initargs slot-value
	  class-direct-slot-descriptions
	  allocate-instance 
	  make-instance initialize-instance
	  generic-function-method-class
	  slot-value-using-slot-description
	  class-direct-slot-descriptions)

  (defconstant make-instance make)
  (defconstant allocate-instance allocate)
  (defconstant initialize-instance initialize)
  (defconstant generic-function-method-class generic-method-class)
  
  (defun slot-description-initargs (x)
    (if (slot-description-initarg x)
	(list (slot-description-initarg x))
      nil))
  
  (defun slot-value (obj name)
    ((slot-description-slot-reader (find-slot-description (class-of obj) name)) obj))

  (defun slot-value-using-slot-description (o s)
    ((slot-description-slot-reader s) o))

  ((setter setter) slot-value-using-slot-description 
   (lambda (o s v)
     ((slot-description-slot-writer s) o v)))

  (defconstant class-direct-slot-descriptions class-slot-descriptions)
  
  (defconstant *safety* (if (equal (getenv "FEEL_SAFETY") "None") nil t))

  (defconstant car (if *safety* internal-car real-car))
  (defconstant cdr (if *safety* internal-cdr real-cdr))
  (defconstant vector-ref (if *safety* internal-vector-ref real-vector-ref))
  (export car cdr vector-ref)
  (defconstant pair <pair>)

  (export pair)

;; end module
  )
