;; Eulisp Module
;; Author: pab
;; File: sems.em
;; Date: Tue May  5 23:23:43 1992
;;
;; Project:
;; Description: 
;;

(defmodule semaphores
  (extras0
   macros0
   defs
   init
   sems
   telos1
   threads
   
   )
  ()
  (expose threads)

  (defstruct semaphore ()
    ((real-sem initform (make-primitive-semaphore)
	       reader semaphore-real-sem))
    constructor make-semaphore
    predicate semaphore-p)

  (defgeneric open-semaphore (sem))
  (defgeneric close-semaphore (sem))
  (defgeneric initialize-semaphore (sem))
    
  (defmethod open-semaphore ((x object))
    (error "Wrong class for open-semaphore" Internal-Error))
  
  (defmethod open-semaphore ((x semaphore))
    (open-primitive-semaphore (semaphore-real-sem x))
    x)

  (defmethod close-semaphore ((x object))
    (error "Wrong class for close-semaphore" Internal-Error))
  
  (defmethod close-semaphore ((x semaphore))
    (close-primitive-semaphore (semaphore-real-sem x))
    x)

  (defmethod initialize-semaphore ((x object))
    (error "Wrong class for initialize-semaphore" Internal-Error))
  
  (defmethod initialize-semaphore ((x semaphore))
    (initialize-primitive-semaphore (semaphore-real-sem x))
    x)

  (export make-semaphore open-semaphore close-semaphore semaphore-p initialize-semaphore
	  semaphore)
  
  ;; Thread Junk. Doesn't belong, but nowhere better for it..
  (defmethod allocate ((x thread-class) lst)
    (generic_allocate_instance\,Thread_Class x lst))

  (defmethod initialize ((x thread) lst)
    (let ((new (call-next-method)))
      (initialize-thread new lst)
      new))
  
  (add-method generic-prin 
	      (make method
		    'signature (list thread object)
		    'function generic_generic_prin\,Thread\,Object))
  

  ;; end module
  )
