;; Eulisp Module
;; Author: pab
;; File: error0.em
;; Date: Tue Nov  3 15:02:40 1992
;;
;; Project:
;; Description: 
;;

(defmodule error0
  (init
   extras0 
   macros0
   defs
   )
  ()
  (deflocal *the-cont* ())

  (defgeneric generic-error-printer (c1 c2))

  (defmethod generic-error-printer ((c condition) cont)
    (flush (standard-output-stream))
    (flush (standard-error-stream))
    (format (standard-error-stream) "Trapped ~a ~a!~%" 
	    (if cont "continuable" "non-continuable") 
	    (class-name (class-of c)))
    (setq *the-cont* cont)
    (mapc (lambda (slot)
	    (let ((v ((slot-description-slot-reader slot) c)))
	      (if (eq v unbound-slot-value) ()
		  (format (standard-error-stream) "  ~a: ~a~%"
			  (slot-description-name slot) v))))
	  (class-slot-descriptions (class-of c))))
  
  (export generic-error-printer)
  
  (set-print-error-callback generic-error-printer)

  (defun !cont x
    (let ((cont *the-cont*))
      (setq *the-cont* nil)
      (if (null x) (cont nil)
	(cont (car x)))))
  
  (export !cont)

  (defun std-apply-any (x . args)
    (generic-apply x args))
  
  (defgeneric generic-apply (fn args))

  (set-no-function-callback std-apply-any)

  (defmethod generic-apply ((x object) args)
    (error "invalid operator" invalid-operator 'error-value x 'op x 'args args))

  (defmethod generic-apply ((gf generic-function) args)
    ((generic-discriminator gf) args))

  (defmethod generic-apply ((fn function) args)
    (apply fn args))


  (export generic-apply invalid-operator invalid-operator-args invalid-operator-op)
;; (1 + 2) => 3
;;  (defmethod generic-apply ((x number) args)
;;    (if (numberp (car args))
;;	(call-next-method)
;;      (apply (car args) (cons x (cdr args)))))
  
  ;; Stuff that shouldn't be here until I call it extend.em
  
  (defmethod generic-prin ((x generic-function) stream)
    (format stream "#<~a: ~a>" (class-name (class-of x)) (generic-name x)))

  (defmethod generic-write ((x generic-function) stream)
    (format stream "#<~a: ~a>" (class-name (class-of x)) (generic-name x)))

  (defmethod generic-prin ((x method) stream)
    (format stream "#<method: ~a (~a)>" 
	    (if (null (method-generic-function x)) 
		"{unattached}"
	      (generic-name (method-generic-function x)))
	    (mapcar class-name (method-signature x))))
  (defmethod generic-write ((x method) stream)
    (format stream "#<method: ~a (~a)>" 
	    (if (null (method-generic-function x)) 
		"{unattached}"
	      (generic-name (method-generic-function x)))
	    (mapcar class-name (method-signature x))))

  ;; end module
  )
