;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: string -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: module string
-----------------------------------------------------------------------------------
File:    string.em
Version: 1.2 (last modification on Tue Jan  4 11:31:21 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/EulispModules/string.em[1.2]:
  
[1.1] Wed Mar 10 13:13:11 1993 imohr@isst published
  [Mon Mar  8 14:36:33 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Tue Jan  4 11:31:36 1994 wheick@isst published
  [Mon Nov  8 13:12:36 1993] Intention for change:
  complete like 0.99: stringp converter equal copy binary<
  as-lower-case as-upper-case

-----------------------------------------------------------------------------------
|#

#module string

(import 
 (eulisp-kernel
  (only (code-char char string< string> subseq concatenate
                   stringp
                   copy-seq
                   string<
                   numberp
                   string-downcase 
                   string-upcase
                   )
    common-lisp)
  (rename ((make-string cl:make-string))
    common-lisp)
  (only (binary<) compare-generic)
  character-generic ; as-lower-case as-upper-case
  copy-generic ; deep-copy shallow-copy
  )

 export 
 (make-string 
  string-ref        ; not in el 
  string-lt         ; not in el
  string-gt         ; not in el
  string-slice      ; not in el
  string-append     ; not in el
  )

 export
 (
  ;converter
  deep-copy
  shallow-copy
  binary<
  as-lower-case
  as-upper-case)

 expose 
 ((only (stringp equal) common-lisp))

 syntax
 (eulisp-kernel
  (rename ((defun cl:defun))
    common-lisp)
  (only (&optional) 
    common-lisp)))


(make-eulisp-class string)

;(export make-string 
;  string-ref        ; not in el 
;  string-lt         ; not in el
;  string-gt         ; not in el
;  string-slice      ; not in el
;  string-append     ; not in el
;  )

;(expose stringp equal)

;(export
;  converter
;  deep-copy
;  shallow-copy
;  binary<
;  as-lower-case
;  as-upper-case)

(defconstant $null-char (code-char 0))

(cl:defun make-string (n &optional (character $null-char))
(cl:make-string n :initial-element  character))

(defun string-ref (string n)
(char string n))

(defun string-lt (string1 string2)
(string< string1 string2))

(defun string-gt (string1 string2)
(string> string1 string2))

(defun string-slice (string start end)
(subseq string start end))

(defun string-append (string1 string2)
(concatenate 'cl:string string1 string2))


(defmethod deep-copy ((strng <string>))
  (copy-seq strng))

(defmethod shallow-copy ((strng <string>))
  (copy-seq strng))

(defmethod binary< ((strng1 <string>)(strng2 <string>))
  (if (numberp (string< strng1 strng2))
    t
    ()))

(defmethod as-lower-case ((strng <string>))
  (string-downcase strng))

(defmethod as-upper-case ((strng <string>))
  (string-upcase strng))


#module-end


