;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: number -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: the abstract number classes and its operations
-----------------------------------------------------------------------------------
File:    number.em
Version: 1.3 (last modification on Wed Jan 19 08:07:51 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/EulispModules/number.em[1.3]:
  
[1.1] Wed Mar 10 13:12:41 1993 imohr@isst published
  [Mon Mar  8 14:35:50 1993] Intention for change:
  Log not inside comments
  - with new file header
  - Log-message inside balanced comment
[1.2] Tue Jan  4 11:30:41 1994 wheick@isst saved
  [Thu Nov 11 14:56:31 1993] Intention for change:
  complete like 0.99
[1.3] Wed Jan 19 08:15:15 1994 wheick@isst published
  done

-----------------------------------------------------------------------------------
|#

#module number

(import
 (eulisp-kernel
  number-i
  (only (binary< binary=) compare-generic) ; binary< binary=
  (only (< = + - * / mod gcd lcm rem plusp minusp) 
    common-lisp)
  )

 syntax
 (eulisp-kernel
  number-i)
 
 expose 
 ((only (numberp integerp floatp
                 + - * / < > <= >=
                 max min gcd lcm abs 
                 zerop signum 
                 ceiling floor round truncate
                 evenp oddp)
    common-lisp)
  number-i)
 
 export
 (binary<
  binary= 
  binary+ 
  binary- 
  binary* 
  binary/ 
  binary-mod 
  binary-gcd 
  binary-lcm
  binary%
  %
  negate
  positivep
  negativep)
 )


;(make-eulisp-class number)
(make-eulisp-class integer)
(make-eulisp-class float)

(defmethod binary< ((n1 <number>) (n2 <number>))
  (< n1 n2))

(defmethod binary= ((n1 <number>) (n2 <number>))
  (= n1 n2))

(defun binary+ (n1 n2)
  (+ n1 n2))

(defun binary- (n1 n2)
  (- n1 n2))

(defun binary* (n1 n2)
  (* n1 n2))

(defun binary/ (n1 n2)
  (/ n1 n2))

(defun binary-mod (n1 n2)
  (mod n1 n2))

(defun binary-gcd (n1 n2)
  (gcd n1 n2))

(defun binary-lcm (n1 n2)
  (lcm n1 n2))

(defun binary% (n1 n2)
  (rem n1 n2))

(defun % (n1 n2)
  (rem n1 n2))

(defun negate (n)
  (- n))

(defun positivep (n)
  (plusp n))

(defun negativep (n)
  (minusp n))

#module-end
