;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el-conditions-0 -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: el-conditions in cl
-----------------------------------------------------------------------------------
File:    el-conditions-0.em
Version: 1.4 (last modification on Fri Feb  4 15:55:06 1994)
State:   published

DESCRIPTION:
fake of the EL-Condition system

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
system rised conditions cannot have a continuation
here one can only accept a condition
Error and cerror not exported because of package conflicts in n-1 files
AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/EulispModules/el-conditions-0.em[1.4]:
  el-conditions because of name clash with cmucl
[1.1] Fri Feb  4 06:32:50 1994 ukriegel@isst saved
  [Fri Feb  4 06:30:29 1994] Intention for change:
  export signal
[1.2] Fri Feb  4 07:28:40 1994 ukriegel@isst saved
  [Fri Feb  4 06:43:17 1994] Intention for change:
  --- no intent expressed ---new module syntax, exports signal
[1.3] Fri Feb  4 08:56:58 1994 ukriegel@isst saved
  [Fri Feb  4 08:56:31 1994] Intention for change:
  --- no intent expressed ---
[1.4] Fri Feb  4 15:55:25 1994 ukriegel@isst published
  [Fri Feb  4 13:38:09 1994] Intention for change:
  --- no intent expressed ---

-----------------------------------------------------------------------------------
|#

#module el-conditions-0
(import
  (eulisp-kernel
   (only (class-of) common-lisp);;to make ingo's emulator happy
   (rename ((signal cl:signal)
            (error cl:error)
            (make-condition cl:make-condition)
            (make-instance cl:make-instance)
            (mapcar cl:mapcar)
            (append cl:append)
	    (gensym cl:gensym)
            (find-class cl:find-class)
            (condition cl:condition)
            (block cl:block)
            (return-from cl:return-from)
            (subtypep cl:subtypep)
            (format cl:format)
            (division-by-zero cl:division-by-zero))
     (only (apply error mapcar gensym signal make-condition make-instance append find-class condition
                  block subtypep return-from format subtypep class-of) common-lisp)))
  syntax 
  (eulisp-kernel
   (rename ((defmacro cl:defmacro)
            (handler-bind cl:handler-bind)) 
     (only (handler-bind defmacro) common-lisp)))
  
  
  export (let/cc with-handled-conditions defcondition
 	         ;error cerror no-handler
                 condition-message
                 ))


;;; -----------------------------------------------------------------------------------
;;; faked eulisp version
;;; -----------------------------------------------------------------------------------

(defmacro defcondition (name supers slots)
`(defconstant ,name (cl:defclass ,name ,supers ,slots )))

(defmacro with-handled-conditions
             (condition-variable-action-list . forms)
  (let* ((handler-bind-list 
          (cl:mapcar (lambda(x)
                       (let* ((condition (car x))
                              (lambda-list (if (null (car(cdr x)))
                                             (list (cl:gensym)(cl:gensym))
                                             (car (cdr x))))
                              (forms (cdr (cdr x)))
                              (cond-var (car lambda-list))
                              (lambda1 
                               (cl:append (list 'lambda lambda-list) forms)))
                         
                         (list 
                          condition                        
                          (cl:append 
                           (list 'lambda
                                 (list cond-var)) 
                           (list 
                            (list 'funcall lambda1
                                  cond-var
                                  (list 'if (list 'cl:subtypep (list 'cl:class-of cond-var) (list
                                                                                       'cl:find-class ''<condition>))
                                        (list
                                         'condition-continuation cond-var) '())))))
                         
                         ))
                     condition-variable-action-list)))
    `(cl:handler-bind ,handler-bind-list ,@forms)))


(defmacro let/cc (name . forms)
  (let ((tmp (cl:gensym)))
        `(cl:block ,name
           (let ((,name (lambda(,tmp)(cl:return-from ,name ,tmp))))
             ,@forms))))

;; local macro definitions



;;definitions and init-forms






#module-end


