#ifdef NIL_REGISTER
  register t_Null NIL NIL_REGISTER;
  #define SET_NIL     NIL=&Empty_List.I
  #define XCALL(call) ({register typeof(call) AUX=call; SET_NIL; AUX;})
  #define YCALL(call) (call, SET_NIL)
#else 
  #define NIL &Empty_List.I
  #define SET_NIL     
  #define XCALL(call) call
  #define YCALL(call) call
#endif

#ifndef STRUCTURE_ALIGNMENT
  #define STRUCTURE_ALIGNMENT
#endif

#define V_LITERAL(el_type, name, length) \
struct name{unsigned int L; void *C; el_type I[length];} name
#define S_LITERAL(type, name) \
struct name{unsigned int unused; void *C; struct type I;} name
#define LITERAL(name) \
struct name name STRUCTURE_ALIGNMENT
#define STAG(class) \
0, class
#define VTAG(length, class) \
length, class

#ifdef FIXED_PRECISION_INTEGER_30
  #define SMALL_INT_SKIP
#else
  #define SMALL_INT_SKIP char small_int_skip[65535]={0}
#endif

#ifndef LSHIFTR
#include <limits.h>
int LSHIFTR(int i, int s)
{return (i>>s) & (LONG_MAX>>(s-1));}
#endif
#ifndef ASHIFTR
int ASHIFTR(int i, int s)
{return (i<0) ? -((-i)>>s) : i>>s;}
#endif
