/* NIL_REGISTER */
/* if set the value of NIL_REGISTER is used in
register t_Null NIL NIL_REGISTER; */

#ifdef __GNUC__
  #ifdef sparc
  #define NIL_REGISTER asm("%g6")
  #endif
#endif

/* FIXED_PRECISION_INTEGER_30 */
/* if set, the fixed precision integers of EuLisp are coded by int<<1|1
so they use effectively 30 bits for representing a short Lisp integer
if not set the fixed precision integers appear as C-long int with the 
highest 17 bits used for the sign; so only 15 bits are used effectively */

#define FIXED_PRECISION_INTEGER_30

#ifdef __GNUC__
  #ifdef sparc
    #define STRUCTURE_ALIGNMENT __attribute__ ((aligned (8)))
  #endif
#endif

/* optimized shift operations */
#ifdef __GNUC__
#ifdef sparc
 #define LSHIFTR(i,s)\
({register typeof(i) __value;\
  if (__alignof__(__value)!=4)\
  asm("sll %1,%3,%0;srl %0,%2,%0;srl %0,%3,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s), "i,i" (32-__alignof__(__value)*8));\
  else\
  asm("srl %1,%2,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s));\
  __value;})

#define ASHIFTR(i,s)\
({register typeof(i) __value;\
  if (__alignof__(__value)!=4)\
  asm("sll %1,%3,%0;sra %0,%2,%0;sra %0,%3,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s), "i,i" (32-__alignof__(__value)*8));\
  else\
  asm("sra %1,%2,%0" \
      : "=r,r" (__value) \
      : "r,r" (i),"i,r" (s));\
  __value;})

#endif
#endif











