;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-init -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-------------------------------------------------------------------------------
TITLE: Initialization of the Typ Inference System
-------------------------------------------------------------------------------
File:    ti-init.em
Version: 1.19 (last modification on Fri Jan 28 16:15:36 1994)
State:   published

DESCRIPTION:
This module provides functions to reset and initialize the type
inference system

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY:  
Log for /export/home/saturn/ukriegel/Dist/Apply/ti-init.em[1.19]:
  
[1.1] Wed May  5 11:25:26 1993 akind@isst proposed
  
[1.2] Tue May 18 17:22:11 1993 akind@isst proposed
  
[1.3] Thu Jun  3 13:09:22 1993 akind@isst proposed
  
[1.4] Tue Aug  3 11:47:02 1993 akind@isst proposed
  
[1.5] Wed Aug 11 13:34:57 1993 akind@isst proposed
  
[1.6] Wed Aug 18 16:09:59 1993 akind@isst proposed
  
[1.7] Fri Aug 20 17:23:20 1993 akind@isst proposed
  
[1.8] Wed Aug 25 17:38:58 1993 akind@isst proposed
  
[1.9] Fri Aug 27 17:29:46 1993 akind@isst published
  
[1.10] Thu Sep 23 14:33:06 1993 akind@isst proposed
  
[1.11] Fri Oct  1 14:41:12 1993 akind@isst saved
  [Mon Sep 27 10:47:59 1993] Intention for change:
  expose %pointer, %union, %prestruct .
[1.12] Fri Oct  1 18:49:47 1993 imohr@isst proposed
  [Fri Oct  1 14:55:17 1993] Intention for change:
  + %jmpbuf, %pjmpbuf
[1.13] Mon Oct 11 10:30:22 1993 akind@isst saved
  
[1.14] Tue Oct 12 10:32:15 1993 akind@isst published
  
[1.15] Thu Oct 21 15:03:41 1993 akind@isst saved
  
[1.16] Tue Nov  9 17:37:44 1993 akind@isst proposed
  
[1.17] Tue Jan  4 11:46:27 1994 akind@isst saved
  [Mon Dec 13 13:44:06 1993] Intention for change:
[1.18] Wed Jan 19 13:19:10 1994 akind@isst saved
  
[1.19] Mon Jan 31 09:34:55 1994 akind@isst published
  [Mon Jan 10 12:49:48 1994] Intention for change:
  --- no intent expressed ---

-------------------------------------------------------------------------------
|#
	       		       		  
#module ti-init
(import (lzs mzs ti ti-codes ti-lattice ti-exprs ti-eqs ti-meet-join 
	     ti-write ti-signature
	     (only (mapc maphash dolist) common-lisp)) 
 syntax (ti)
 export (ti-initialize update-all-type-expr-codes))

;;; ---------------------------------------------------------------------------
;;; INITIALIZATION
;;; ---------------------------------------------------------------------------

;; Initialize the type inference system.
(defun ti-initialize ()
  (reset-funs-with-defined-signatures)
  (reset-actual-type-var-id)
  (reset-def-strategic-lattice-types)
  (initialize-ti-statistics)
  (initialize-lattice)
  (add-sys-types))

;;; ---------------------------------------------------------------------------
;;; ADDING SYSTEM TYPES
;;; ---------------------------------------------------------------------------

;; Add the predefined system functions (TAIL functions) to the lattice.
(defun add-sys-types ()
  (def-strategic-lattice-type ^(%number (top) (bottom)))
  (setq *%integer*
    (def-strategic-lattice-type ^(%integer (%number) (bottom))))
  (def-strategic-lattice-type ^(%unsigned-integer (%integer) (bottom)))
  (def-strategic-lattice-type ^(%signed-integer (%integer) (bottom)))
  (def-sys-lattice-type ^(%unsigned-byte-integer (%unsigned-integer) (bottom)))
  (def-sys-lattice-type ^(%signed-byte-integer (%signed-integer) (bottom)))
  (def-sys-lattice-type ^(%unsigned-half-integer (%unsigned-integer) (bottom)))
  (def-sys-lattice-type ^(%signed-half-integer (%signed-integer) (bottom)))
  (def-sys-lattice-type ^(%unsigned-word-integer (%unsigned-integer) (bottom)))
  (def-sys-lattice-type ^(%signed-word-integer (%signed-integer) (bottom)))
  (def-strategic-lattice-type ^(%float (%number) (bottom)))
  (def-sys-lattice-type ^(%single-float (%float) (bottom)))
  (def-sys-lattice-type ^(%double-float (%float) (bottom)))
  (def-sys-lattice-type ^(%extended-float (%float) (bottom)))
;;; ---------------------------------------------------------------------------
  (setq *%void*
    (def-sys-lattice-type ^(%void (top) (bottom))))
  (setq *%false*
    (def-strategic-lattice-type ^(%false (top) (bottom))))
;  (def-strategic-lattice-type ^(%character (top) (bottom)))
  (def-sys-lattice-type ^(%string (top) (bottom)))
;;; ---------------------------------------------------------------------------
  (def-strategic-lattice-type ^(%defined-type (top) (bottom)))
;  (def-strategic-lattice-type ^(%pointer (%defined-type) (bottom)))
;  (def-strategic-lattice-type ^(%vector (%defined-type) (bottom)))
  ;; All user defined classes are subclasses of %struct.
  (def-strategic-lattice-type ^(%struct (%defined-type) (bottom)))
;  (def-strategic-lattice-type ^(%prestruct (%defined-type) (bottom)))
;  (def-strategic-lattice-type ^(%union (%defined-type) (bottom)))
;;; ---------------------------------------------------------------------------
  (def-sys-lattice-type ^(%jmpbuf (top) (bottom)))
  (def-sys-lattice-type ^(%pjmpbuf (top) (bottom)))
;;; ---------------------------------------------------------------------------
  (setq *%function*
    (def-sys-lattice-type ^(%function (top) (bottom)))))

;;; ---------------------------------------------------------------------------
;;; RECOMPUTE THE CODES OF ALL TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

;; Signatures are read in before all lattice types are included into the
;; lattice. Thus before inference starts the type expression codes have to
;; be updated.
(defun update-all-type-expr-codes ()
  (ti-format t "~%Update all type expression codes ...")
  (update-lattice-type-expr-codes *top*)
  (mapc #'update-type-expr-codes (funs-with-defined-signatures))
  (ti-format t " done."))

;; Set all codes of lattice type expressions registered in the *the-lattice* 
;; to the code of the corresponding lattice type.
(defun update-lattice-type-expr-codes (lattice-type)
  (let ((expr (?atomic-expr lattice-type)))
    (if expr
	(setf (?code expr) (?code lattice-type))))
  (mapc #'update-lattice-type-expr-codes (?subtypes lattice-type)))

(defun update-atomic-type-expr-codes (atomic-expr)
  (let ((new-code (?code (compute-to-atom (?name atomic-expr))))
	(old-code (?code atomic-expr)))
    (if (null (eq-code-p old-code new-code))
	(progn
	  (setf (?code atomic-expr) new-code)
	  (ti-format t "~%Notice: code of expr ~A updated"
		     (ti-print-string-no-cr atomic-expr))))))

(defgeneric update-type-expr-codes (obj))

(defmethod update-type-expr-codes ((obj <type-descr>))
  (dolist (equ (?equations (?type-vars obj)))
    (let ((left-expr (?left-expr equ))
	  (right-expr (?right-expr equ)))
      (if (atomic-type-p left-expr)
	  (update-atomic-type-expr-codes left-expr))
      (if (atomic-type-p right-expr)
	  (update-atomic-type-expr-codes right-expr)))))

(defmethod update-type-expr-codes ((obj <fun>))
  (mapc #'update-type-expr-codes (?signature obj)))

#module-end
