;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-copy -*-
#|
-------------------------------------------------------------------------------
TITLE: Copying Type Inference Objects
-------------------------------------------------------------------------------
File:    ti-copy.em
Version: 1.22 (last modification on Wed Feb  9 08:56:48 1994)
State:   proposed

DESCRIPTION:
This module provides a generic function to copy all kinds of objects
that are concerned during the type inference process.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/ti-copy.em[1.22]:
  
[1.1] Fri Apr 23 09:52:27 1993 akind@isst proposed
  
[1.2] Wed May  5 11:24:59 1993 akind@isst saved
  
[1.3] Thu May  6 17:27:30 1993 akind@isst proposed
  
[1.4] Wed May 19 13:10:09 1993 akind@isst proposed
  
[1.5] Mon May 24 12:08:00 1993 akind@isst proposed
  
[1.6] Thu May 27 10:11:41 1993 akind@isst proposed
  
[1.7] Thu Jul 22 13:43:32 1993 akind@isst proposed
  
[1.8] Thu Jul 22 14:27:29 1993 akind@isst proposed
  
[1.9] Wed Aug 11 13:34:41 1993 akind@isst proposed
  
[1.10] Wed Aug 18 16:09:35 1993 akind@isst proposed
  
[1.11] Fri Aug 20 17:23:12 1993 akind@isst proposed
  
[1.12] Tue Aug 24 16:25:03 1993 akind@isst published
  
[1.13] Thu Sep 23 14:32:40 1993 akind@isst proposed
  
[1.14] Fri Oct  1 14:40:35 1993 akind@isst saved
  [Thu Sep 23 15:43:52 1993] Intention for change:
[1.15] Mon Oct 11 10:29:46 1993 akind@isst saved
  
[1.16] Tue Oct 12 10:32:01 1993 akind@isst published
  
[1.17] Thu Oct 21 15:03:18 1993 akind@isst saved
  
[1.18] Tue Nov  9 17:36:49 1993 akind@isst proposed
  
[1.19] Tue Jan  4 11:41:03 1994 akind@isst saved
  [Mon Dec 13 13:15:20 1993] Intention for change:
  y
[1.20] Mon Jan 31 09:34:37 1994 akind@isst proposed
  [Tue Jan 11 09:54:49 1994] Intention for change:
  --- no intent expressed ---
[1.21] Tue Feb  8 17:24:27 1994 akind@isst published
  [Tue Feb  8 16:54:50 1994] Intention for change:
  new header
[1.22] Wed Feb  9 08:57:22 1994 imohr@isst proposed
  [Wed Feb  9 08:51:16 1994] Intention for change:
  syntax-import -> syntax
 

-------------------------------------------------------------------------------
|#


#module ti-copy
(import (mzs 
	 ti 
	 ti-lattice 
	 ti-write 
	 ti-exprs 
	 ti-eqs 
	 ti-meet-join
	 (only (make-array copy-alist dotimes mapcar) 
	       common-lisp))
  syntax (ti)
  export (ti-copy-descr ti-copy&rename-descr
	  ti-copy-stack ti-copy&rename-stack
	  ti-copy-subs ti-copy&rename-subs
	  ti-copy&rename-equ ti-copy&rename-var
	  ti-copy-vec ti-copy&rename-vec
	  copy-descr-up-to application-subs))

;;; ---------------------------------------------------------------------------
;;; COPYING TYPE EQUATIONS
;;; ---------------------------------------------------------------------------

(defun ti-copy-stack (stack)
  (make <type-equation-stack>
	:equations (copy-alist (?equations stack))))
  
(defun ti-copy&rename-stack (stack new-vars . same-vars)
  (make <type-equation-stack>
	:equations
	(mapcar (lambda (equ)
		  (ti-copy&rename-equ equ new-vars (consp same-vars)))
		(?equations stack))))

(defun ti-copy-subs (subs)
  (make <type-var-substitutions>
	:equations (copy-alist (?equations subs))))
  
(defun ti-copy&rename-subs (subs new-vars . same-vars)
  (make <type-var-substitutions>
	:equations (mapcar (lambda (equ)
			     (ti-copy&rename-equ equ new-vars (consp same-vars)))
			   (?equations subs))))

(defun ti-copy&rename-equ (equ new-vars . same-vars)
  (let ((with-same-vars (consp same-vars))
	(left-expr (?left-expr equ))
	(right-expr (?right-expr equ)))
    (cons (if (type-var-p left-expr)
	      (ti-copy&rename-var left-expr new-vars with-same-vars)
	    left-expr)
	  (if (type-var-p right-expr)
	      (ti-copy&rename-var (cdr equ) new-vars with-same-vars)
	    right-expr))))

(defun ti-copy-vec (vec)
  (let* ((size (length vec))
	 (new-vec (make-array size)))
    (dovector (var i vec)
      (setf (vector-ref new-vec i) var))
    new-vec))

(defun ti-copy&rename-vec (vec new-vars . same-vars)
  (let* ((size (length vec))
	 (new-vec (make-array size)))
    (dotimes (i size)
      (setf (vector-ref new-vec i)
	(ti-copy&rename-var (vector-ref vec i) new-vars (consp same-vars))))
    new-vec))

(defun ti-copy&rename-var (var new-vars . same-vars)
  (let ((equ (get-substitution new-vars var)))
    (if equ
	(make <type-var> :id (?id (?right-expr equ)))
      (if same-vars
	  (make <type-var> :id (?id var))
	(let ((new-var (new-type-var)))
	  (add-substitution new-vars var new-var)
	  new-var)))))

;;; ---------------------------------------------------------------------------
;;; COPYING DESCRIPTORS
;;; ---------------------------------------------------------------------------

(defgeneric ti-copy-descr (descr))

;;(defmethod ti-copy-descr (descr)
;;  (ti-error)
;;  descr)

(defmethod ti-copy-descr ((descr <formal-type-descr>))
  (make <formal-type-descr>
	:type-vars (ti-copy-subs (?type-vars descr))
	:type-vec (ti-copy-vec (?type-vec descr))
	:stat (?stat descr)
	:t-descr-before (?t-descr-before descr)
	:type-spec (?type-spec descr)))

(defmethod ti-copy-descr ((descr <recursive-type-descr>))
  (make <recursive-type-descr>
	:type-vars (ti-copy-subs (?type-vars descr))
	:type-vec (ti-copy-vec (?type-vec descr))
	:stat (?stat descr)
	:t-descr-before (?t-descr-before descr)
	:type-spec (?type-spec descr)))

(defmethod ti-copy-descr ((descr <act-type-descr>))
  (make <act-type-descr>
	:type-vars (ti-copy-subs (?type-vars descr))
	:type-vec (ti-copy-vec (?type-vec descr))
	:stat (?stat descr)
	:t-descr-before (?t-descr-before descr)
	:type-spec (?type-spec descr)))

(defgeneric ti-copy&rename-descr (descr new-vars . same-vars))

(defmethod ti-copy&rename-descr ((descr <formal-type-descr>)
				 new-vars . same-vars)
  (let ((with-same-vars (consp same-vars)))
    (make <formal-type-descr>
	  :type-vars (ti-copy&rename-subs (?type-vars descr) new-vars with-same-vars)
	  :type-vec (ti-copy&rename-vec (?type-vec descr) new-vars with-same-vars)
	  :stat (?stat descr)
	  :t-descr-before (?t-descr-before descr)
	  :type-spec (?type-spec descr))))

(defmethod ti-copy&rename-descr ((descr <recursive-type-descr>)
				 new-vars . same-vars)
  (let ((with-same-vars (consp same-vars)))
    (make <recursive-type-descr>
	  :type-vars (ti-copy&rename-subs (?type-vars descr) new-vars with-same-vars)
	  :type-vec (ti-copy&rename-vec (?type-vec descr) new-vars with-same-vars)
	  :stat (?stat descr)
	  :t-descr-before (?t-descr-before descr)
	  :type-spec (?type-spec descr))))

(defmethod ti-copy&rename-descr ((descr <act-type-descr>)
				 new-vars . same-vars)
  (let ((with-same-vars (consp same-vars)))
    (make <act-type-descr>
	  :type-vars (ti-copy&rename-subs (?type-vars descr) new-vars with-same-vars)
	  :type-vec (ti-copy&rename-vec (?type-vec descr) new-vars with-same-vars)
	  :stat (?stat descr)
	  :t-descr-before (?t-descr-before descr)
	  :type-spec (?type-spec descr))))

;;; Copy a type descriptor up to a given index.
(defgeneric copy-descr-up-to (descr max-index))

(defmethod copy-descr-up-to ((descr <formal-type-descr>)
			     (max-index <single-precision-integer>))
  (let* ((vec (?type-vec descr))
	 (size (length vec))
	 (new-vec (make-array size)))
    (dotimes (i (length vec))
      (setf (vector-ref new-vec i) (vector-ref vec i)))
    (make <formal-type-descr>
	  :type-vars (ti-copy-subs (?type-vars descr))
	  :type-vec new-vec
	  :stat (?stat descr)
	  :t-descr-before (?t-descr-before descr)
	  :type-spec 0)))

(defmethod copy-descr-up-to ((descr <act-type-descr>) 
			     (max-index <single-precision-integer>))
  (let* ((vec (?type-vec descr))
	 (size (length vec))
	 (new-vec (make-array size)))
    (dotimes (i (length vec))
      (setf (vector-ref new-vec i) (vector-ref vec i)))
    (make <act-type-descr>
	  :type-vars (ti-copy-subs (?type-vars descr))
	  :type-vec new-vec
	  :stat (?stat descr)
	  :t-descr-before (?t-descr-before descr)
	  :type-spec 0)))

;;; ---------------------------------------------------------------------------
;;; Answer subs when formal-descr is applied to actual-descr.
(defun application-subs (formal-descr	;<type-descr>
			 actual-descr	;<type-descr>
			 . same-vars)
  (let ((copy-subs (make <type-var-substitutions>)))
    (vec-application-subs (?type-vec formal-descr)
			  (?type-vec actual-descr)
			  0
			  copy-subs)
    (ti-copy&rename-subs (?type-vars formal-descr) copy-subs (consp same-vars))))

(defun vec-application-subs (vec-left vec-right index subs)
  (if (< index (length vec-left))
    (let ((left-var (vector-ref vec-left index))
	  (right-var (vector-ref vec-right index)))
      (if (null (eq-type-var-p left-var right-var))
	  (add-substitution subs left-var right-var))
      (vec-application-subs vec-left vec-right (+ index 1) subs))))

#module-end