;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: SIMPLE-PROGRAMMING -*-
;;; -----------------------------------------------------------------------------------
;;; TITLE: simple-programming.lisp
;;; -----------------------------------------------------------------------------------
;;;
;;; DESCRIPTION: provides macro to facilitate class definition
;;;
;;; REQUIRES: 
;;; 
;;; NOTES: 
;;;
;;; PROBLEMS: 
;;;
;;; CONTACT:  
;;;
;;; HISTORY:
;;; CREATED: 27/11/1992 by *ak* 
;;;
;;;
;;; END OF HISTORY
;;; -----------------------------------------------------------------------------------

(defpackage "SIMPLE-PROGRAMMING" 
  (:shadowing-import-from el-modules eval-when ))
(in-package "SIMPLE-PROGRAMMING")

;       ########################################################
(eval-when 
   (:compile-toplevel :load-toplevel :execute)
  (export '(defclass-simple make-class-definition 
             annotations structure-part make)))
;       ########################################################

(eval-when 
   (:compile-toplevel :load-toplevel :execute)
;        ----------------
  (defun apply-class-name (name)
;        ----------------
    (intern (concatenate 'string "<" (string name) ">"))))

(defmacro make (class &rest options)
 `(make-instance ,class ,@options))

;      ---------------------
(defun make-class-definition (name supers slots)
;      ---------------------
(let ((new-names nil) 
      class-name
      (structure-part nil)
      (annotations nil)
      (annotations? nil))
  (flet ((new-name (prefix name suffix)
           (setq name 
                 (intern (concatenate 'string 
                                      prefix (string name) suffix)))
           (push name new-names)
           name))
    (setq slots
          (mapcan 
           #'(lambda (slot-desc)
               (if (eq slot-desc :annotations) 
                 (progn (setq annotations? t) nil)
                 (progn
                   (when (atom slot-desc) (setq slot-desc (list slot-desc)))
                   (let* ((name (car slot-desc)))
                     (if annotations? 
                       (push name annotations)
                       (push name structure-part))
                     (list 
                      (append slot-desc
                              (list :accessor
                                    (new-name "?" name "")
                                    :writer
                                    (new-name "!" name "")
                                    :initarg
                                    (intern (string name) 
                                  (find-package "KEYWORD")))))))))
           slots))
    (push `(structure-part :allocation :class :initform ',structure-part
			:reader get-structure-part)
          slots)
    (push `(annotations :allocation :class :initform ',annotations
			:reader get-annotations)
          slots)
    (setq class-name (new-name "<" name ">"))
    (setq supers (mapcar #'apply-class-name supers))
    `(progn
       (defclass ,class-name ,supers (,@slots))
       (#+(and :franz-inc :allegro)defparameter
	#-(and :franz-inc :allegro)setq 
	  ,class-name (find-class ',class-name))
       (defun ,(new-name "" name "-P") (x) (typep x ',class-name))
       (eval-when 
	  (:compile-toplevel :load-toplevel :execute)
         (export ',new-names)) 
       ',class-name))))

;         ----------------
(defmacro defclass-simple (name supers &rest slots) 
;         ----------------
  (make-class-definition name supers slots))