;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs2mzs -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    lzs2mzs.em
Version: 1.14 (last modification on Fri Jan 28 16:27:47 1994)
State:   published

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Firedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/lzs2mzs.em[1.14]:
  text
[1.1] Thu Mar 18 09:01:10 1993 hfried@isst proposed
  [Fri Mar  5 13:04:50 1993] Intention for change:
[1.2] Wed Mar 24 13:49:41 1993 hfried@isst proposed
  [Thu Mar 18 09:13:02 1993] Intention for change:
  + glob anna
[1.3] Thu Mar 25 11:20:52 1993 hfried@isst proposed
  [Wed Mar 24 14:54:51 1993] Intention for change:
  + gen-fun
  new head
[1.4] Tue Apr 13 14:10:23 1993 hfried@isst proposed
  [Thu Mar 25 11:54:46 1993] Intention for change:
[1.5] Wed Jun  2 09:07:59 1993 hfried@isst proposed
  [Tue Apr 13 14:16:26 1993] Intention for change:
  druck cleartypes
[1.6] Wed Aug 18 11:50:59 1993 hfried@isst proposed
  [Thu Aug 12 14:56:08 1993] Intention for change:
  ident-counter
[1.7] Thu Aug 26 11:49:32 1993 hfried@isst proposed
  [Tue Aug 24 08:42:14 1993] Intention for change:
  balance types Ausschrift
[1.8] Wed Sep  1 10:28:26 1993 hfried@isst published
  [Wed Sep  1 09:31:56 1993] Intention for change:
  functions in literals
  .#
[1.9] Fri Oct 15 07:43:45 1993 hfried@isst published
  [Thu Oct 14 13:12:07 1993] Intention for change:
  add typecheck
[1.10] Thu Oct 21 15:05:33 1993 akind@isst saved
  
[1.11] Tue Nov  2 16:20:41 1993 akind@isst saved
  
[1.12] Tue Nov 16 11:53:11 1993 hfried@isst proposed
  [Mon Nov  8 11:20:51 1993] Intention for change:
  typpropa. II
[1.13] Tue Jan  4 11:44:12 1994 akind@isst saved
  [Tue Dec 14 16:05:52 1993] Intention for change:
[1.14] Mon Jan 31 09:33:26 1994 akind@isst published
  [Tue Jan 11 09:53:28 1994] Intention for change:
  --- no intent expressed ---

-----------------------------------------------------------------------------------
|#

#module-name lzs2mzs
#module-import 
( level-1-eulisp
  simple-programming
  LZS 
  MZS 
  context 
  analyse-h
  vector ; make-vector and vector-ref
  arg-context
  function-call-context
  function-label
  join-label-context
  progn-context
  switch-context
  test-context
  void-context
  type-propagation
  type-inference
  (only (mapc format) common-lisp)
  lzs-to-mzs-fun
  cleartypes
  side-effects
  expand-literal
  apply-funs
  types-hand-on
  debugging
  )

#module-syntax-import 
( level-1-eulisp )
#module-syntax-definitions
#module-header-end

(export  lzs2mzs)

;;---------------------------------------------------------------------------
;; (lzs2mzs /list-of-<module>-or-<modul>/) ---> /list-of-moduel/
;; --------------------------------------------------------------------------

;      #######
(defun lzs2mzs (modul-or-list)
;      #######
  (lzs2mzs1 (if (consp modul-or-list) modul-or-list (list modul-or-list))))

;      --------
(defun lzs2mzs1 (mlist)
;      --------
  ; -------------------------------------------
  ; pass from 0 ---> 1
  (analysis-side-effects mlist)
; (mapc #'lzs2mzs-modul mlist) only the top-level form from first module
  ; -------------------------------------------
  ; pass from 1 ---> 3
  (lzs2mzs-modul (car mlist))
  (mapc #'lzs2mzs-fun (get-functions-used-in-literals))
  (lzs2mzs-fun typecheck)
  ;(lzs2mzs-fun no-applicable-method-error)
  ; --------------- handle types ---------------
  ; first step: balance types
  (mapc #'clear-types-modul1 mlist)
;  (ti::ti-error)
  ; --------------------------------------------
  ; second step: balance-applications
  (if *global-optimization*
      (mapc #'clear-types-modul2-global-optimization mlist)
    (mapc #'clear-types-modul2 mlist))
  ; --------------------------------------------
  ; third step: propagete new types
  ; pass from 3 ---> 5
  (if *global-optimization*
      (types-hand-on-modules mlist))
  ; --------------------------------------------
  ; fourth step: balance types
  (if *global-optimization*
      (mapc #'clear-types-modul1 mlist))
  ; --------------------------------------------
  ; fifth step: convert to sys-types
;  (mapc #'reset-signature (?fun-list $tail-module))
  (mapc #'clear-types-modul3 mlist)
  (synthesis-types-in-side-effects mlist)
  mlist)

(defun clear-types-modul1 (modul)
;  (format t "~%balance types (~a)" (+ 1 (length (?fun-list modul))))
  (format t "b")
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types1 funs)
    (if main-fun (clear-types1 main-fun))))

(defun clear-types-modul2 (modul)
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types2 funs)
    (if main-fun (clear-types2 main-fun))))

(defun clear-types-modul2-global-optimization (modul)
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types2-global-optimization funs)
    (if main-fun (clear-types2-global-optimization main-fun))))

(defun clear-types-modul3 (modul)
  (let ((funs (?fun-list modul))
	(main-fun (?toplevel-forms modul)))
    (mapc #'clear-types3 funs)
    (if main-fun (clear-types3 main-fun))))

;      -------------
(defun lzs2mzs-modul (modul)
;      -------------
  (setq indent-counter 0)
;  (mapc #'lzs2mzs-fun (?fun-list modul)) 
  (if (?toplevel-forms modul) (lzs2mzs-fun (?toplevel-forms modul)) 
      (format t "~% modul contains no top-level forms !!!"))
  (mapc #'lzs2mzs-exported-fun (?fun-list modul))
;  (mapc #'clear-types (?fun-list modul))
;  (if (?toplevel-forms modul) (clear-types (?toplevel-forms modul)) ())
)

(defun lzs2mzs-exported-fun (fun)
  (if (eq (?pass fun) 3) ()
      (if (and (global-fun-p fun) (?exported fun))
        (lzs2mzs-fun fun) ())))

#module-end