;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: LZS -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


;;; -----------------------------------------------------------------------------------
;;; TITLE: 
;;; -----------------------------------------------------------------------------------
;;;
;;; DESCRIPTION: 
;;;
;;; REQUIRES: 
;;; 
;;; NOTES: 
;;;
;;; PROBLEMS: 
;;;
;;; CONTACT:  
;;;
;;; HISTORY:
;;;
;;; $Log: lzs.lisp,v $
;;; Revision 1.1  1992/08/07  14:07:10  ukriegel
;;; Initial revision
;;;
;;; Revision 1.1  1992/08/06  10:05:11  ukriegel
;;; Initial revision
;;;

;;; HISTORY:
;;; *ak* 4.2.93 Annotation (type-expr) bei class-def angefuegt
;;; *ak* 2.2.93 Annotation (signature) bei fun angefuegt
;;; *rr* 1.2.93 init fr place
;;; *rr* 26.1.93
;;; - ein slot statement-status in fun
;;; *rr* 22.1.93 
;;; - einige neue slots in <special-sys-fun>
;;; *hf* 26.11.92
;;; - in den Funktionen Annotationen f"ur die Typinferenz (var-descr,
;;; type-descr, type-descr-s, actual, applications) , Seiteneffektanalyse
;;; (used-gvars set-gvars), lokale Optimierungen (function-label, calls,
;;; rec-calls) und Codegenerierung (place closure-place function-type
;;; closure-vars) eingef"ugt.
;;; - Bei globalen Variablen und Konstanten (defined-named-const,
;;; imported-named-const, defined-sys, imported-sym, structured-literal,
;;; defined-class, imported-class, literal-instance) die Annotation type (Typinferenz)
;;; und die Annotation place (Codegenerierung) hinzugef"ugt. 
;;; - bei local-stativc Variablen die Annotation link und place eingef"uhrt. 
;;; *im* 18.06.92
;;; - Mixin GLOBAL for all global defined lzs-objects (global in module)
;;; - Mixin IMPORTED for all imported lzs-objects           
;;; - classes are now global and may be exported
;;; - require/provide removed
;;; - annotations of the CLICC-compiler commented out
;;;
;;; *im* 10.06.92
;;; - Superklasse LZS-OBJECT fuer alle lzs-Objekte, fuer Standardeigenschaften 
;;; - Mixin NAMED fuer benannte Objekte mit Slot IDENTIFIER (explizite Definition
;;; des identifier-slots gestrichen), Accessor ist ?IDENTIFIER
;;;
;;; *im* 09.06.92
;;; Klassen var, named-const, module, class-def, slot-descr, fun, cont:
;;; +  (identifier :type symbol)  
;;;
;;; Revision 1.20  1992/06/04  16:15:30  hk
;;; Defaultwert fuer mv-spec von importierten Fkt. auf 1 gesetzt.
;;;
;;; Revision 1.19  1992/06/04  12:45:17  hk
;;; In sym den Slot ?const in ?constant-value umbenannt.
;;;
;;; Revision 1.18  1992/06/04  12:10:19  hk
;;; Den Slot mv-spec von cont mit nil initialisiert.
;;;
;;; Revision 1.17  1992/06/03  17:18:33  hk
;;; In defined-fun wurden deeper-level-calls in higher-level-calls umbenannt.
;;;
;;; Revision 1.16  1992/06/03  16:42:19  hk
;;; Schreibfehler
;;;
;;; Revision 1.15  1992/06/03  14:20:48  hk
;;; In setq-form Slot var-ref in location umbenannt, wg. named-const.
;;;
;;; Revision 1.14  1992/06/03  13:46:39  hk
;;; Slots in special-sys-fun mit nil vorbelegt.
;;;
;;; Revision 1.13  1992/06/03  13:39:34  hk
;;; In defined-sym im Slot package gibt es den ausgezeichneten Wert 'uninterned.
;;;
;;; Revision 1.12  1992/06/03  08:29:55  hk
;;; In named-const Slot const in value umbenannt.
;;;
;;; Revision 1.11.1.1  1992/06/03  08:13:13  hk
;;; In named-const Slot const in value umbenannt.
;;;
;;; Revision 1.11  1992/06/03  07:21:32  hk
;;; Annotation read bei named-const hinzugefuegt.
;;;
;;; Revision 1.10  1992/06/02  14:24:08  hk
;;; In literal-instance slot-value-list durch value-list ersetzt.
;;;
;;; Revision 1.9  1992/05/31  19:54:18  hk
;;; package-list ist nur Annotation von module, toplevel-forms hat Typ fun.
;;;
;;; Revision 1.8  1992/05/27  15:27:56  hk
;;; Package Slot eines Symbols ist nil, falls uninterned, d.h. #:symbol.
;;;
;;; Revision 1.7  1992/05/27  14:25:08  hk
;;; Fuer die Klassen wird automatisch ein Praedikat <name>-p definiert.
;;; Module haben eine Komponente package-list (nur fuer CL).
;;; mv-app und apply-app gestrichen, dafuer mv-lambda neu hinzu.
;;; einge Umbenennungen: method -> method-def,
;;;                      struct-literal -> structured-literal.
;;; In Instanzen von params haben Slots den Defaultwert (); eine nicht weiter
;;; initialisierte Instanz entspricht damit einer leeren Lambda-Liste.
;;;
;;; Revision 1.6  1992/05/07  12:43:38  hk
;;; Slots 'symbol', 'initform' und 'initargs' zu 'class-def'
;;; hinzugefuegt. Nach Bonn geschickt.
;;;
;;; Revision 1.5  1992/04/30  12:38:22  hk
;;; Nach Berlin geschickt, nach Durchsicht der Bezeichner und
;;; Definition mittels 'deflzs'
;;;
;;; Revision 1.4  1992/04/29  13:08:18  hk
;;; Zwischenversion vor der Umstellung auf Defclass.
;;;
;;; Revision 1.3  1992/04/24  09:42:57  hk
;;; Slot argument-precedence-order in generic-fun eingefuegt
;;;
;;; Revision 1.1  1992/04/24  07:16:06  hk
;;; Initial revision
;;;

Log for /export/home/saturn/ukriegel/Dist/Apply/lzs.em[1.14]:
  lzs.lisp as module
[1.1] Fri Nov 26 10:27:35 1993 imohr@isst proposed
  lzs and mzs as modules ok.
[1.2] Mon Nov 29 13:22:44 1993 imohr@isst proposed
  [Mon Nov 29 11:26:08 1993] Intention for change:
  correct naming of predicates
[1.3] Tue Nov 30 13:56:11 1993 imohr@isst proposed
  [Tue Nov 30 11:16:48 1993] Intention for change:
  global was a submixin of named, therefore also named-p must be generated
  for classes which are 'global'
[1.4] Thu Jan 13 15:49:02 1994 imohr@isst saved
  [Thu Jan  6 14:50:37 1994] Intention for change:
  + get-slot-value, set-slot-value
[1.5] Mon Jan 17 08:57:51 1994 wheick@isst saved
  eulisp1, module-id --> module
[1.6] Wed Jan 19 13:08:16 1994 hfried@isst saved
  [Wed Jan 19 13:01:16 1994] Intention for change:
  + body in get-slot-value, set-slot-value
[1.7] Mon Jan 24 15:12:57 1994 akind@isst saved
  [Wed Jan 19 15:12:19 1994] Intention for change:
  eulisp0 -> eulisp-level-0
[1.8] Mon Jan 24 15:18:03 1994 hfried@isst saved
  [Mon Jan 24 15:13:35 1994] Intention for change:
  + set-slot-value + get-slot-value bei fun
[1.9] Tue Jan 25 14:02:28 1994 wheick@isst saved
  done
[1.10] Fri Jan 28 11:55:52 1994 wheick@isst proposed
  [Tue Jan 25 08:36:40 1994] Intention for change:
  divide in lzs and lzs-syntax
  done
[1.11] Mon Jan 31 14:19:38 1994 imohr@isst proposed
  [Fri Jan 28 13:02:01 1994] Intention for change:
  literal-instance: + annotation unexpanded
[1.12] Wed Feb  2 09:16:08 1994 imohr@isst proposed
  [Tue Feb  1 12:03:56 1994] Intention for change:
  + annotation initial-value for imported-static
[1.13] Mon Feb  7 08:26:34 1994 imohr@isst proposed
  [Thu Feb  3 08:54:41 1994] Intention for change:
  remove annotation initialization from class-def
  new slot access and imported classes ok
[1.14] Mon Feb  7 16:48:16 1994 imohr@isst published
  [Mon Feb  7 14:40:29 1994] Intention for change:
  + specialization of defined-fun: predicate-fun

-----------------------------------------------------------------------------
|#

;;------------------------------------------------------------------------------
;; deflzs stuetzt sich nicht auf defstruct sondern auf defclass, weil
;; - in defclass fuer Slots eine Typspezifikation angegeben werden kann,
;;   ohne dass eine Initform angegeben werden muss,
;; - die Accessor-Funktionen generisch sind, und somit fuer verschiedene
;;   Klassen gleiche Namen haben koennen.
;;------------------------------------------------------------------------------


#module lzs

(import (level-0-eulisp
         apply-standard  ; only make-eulisp-class-id
         lzs-syntax      ; make-structure-and-annotation-slots
                         ; make-predicate-name
                         ; <lzs-object>
                         ; lzs-object-p
         accessors)
 syntax (level-0-eulisp 
         apply-standard) ; only the macro defstandardclass
; import ((only (append caar intern format last) 
;           common-lisp))
; syntax ((only (pushnew) 
;           common-lisp))
 syntax (lzs-syntax)    ; only the macro def-lzs-object
 export (def-lzs-object ;macro from lzs-syntax
         make-structure-and-annotation-slots
         make-predicate-name)
 export (imported-p named-p global-p) ;mixin predicates
 export (<lzs-object> lzs-object-p) ; from lzs-syntax
 export (?unexpanded) ;should be exported automatically
 expose (accessors)
 )





;;------------------------------------------------------------------------------
;; Definition der Strukturen, die die Knoten der Zwischensprache
;; repraesentieren.
;; Zuerst werden die Slots genannt, die den Strukturteil des Knotens beschreiben
;; und dann, gefolgt von dem Kommentar ``;; Annotation'' der Annotationsteil.
;;------------------------------------------------------------------------------



;;------------------------------------------------------------------------------
(def-lzs-object module (:named lzs-object)
  (fun-list :initform ())
  (class-def-list :initform ())
  (named-const-list :initform ())
  (var-list :initform ())
  (sym-list :initform ())
  (toplevel-forms :initform ())
  :Annotations
  ;;-----------
  (lex-env :initform ())
  (syntax-env :initform ())
  (exports :initform ())
  (syntax-exports :initform ())
  (used-runtime-modules :initform ())
  (used-syntax-modules :initform ())
  (c-imports :initform ())
  ) 


;;------------------------------------------------------------------------------
;; Superklasse aller Variablen.
;;------------------------------------------------------------------------------
(def-lzs-object var (:named lzs-object)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; Statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object static (var)
  :Annotations
  ;;-----------
  (type :initform ())
  )

;;------------------------------------------------------------------------------
;; Definierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object defined-static (static)
  :Annotations
  ;;-----------
  (type :initform ())
  )

;;------------------------------------------------------------------------------
;; Lokal definierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object local-static (defined-static)
  :Annotations
  ;;-----------
   (link :initform '())                 ; Verbindung zur Verwendung der
                                        ; Variablen
   (place :initform ())                 ; Adressausdruck                                  
  (closure :initform nil)               ; Kommt frei in einer Closure vor
  )

;;------------------------------------------------------------------------------
;; Global definierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object global-static (:global defined-static)
  :Annotations
  ;;-----------
   (read-stats :initform ())            ; Lesen von dieser glob. Variablen
   (write-stats :initform ())           ; Beschreiben dieser glob. Variablen
   type                                 ; Typausdruck
   (place :initform ())                  ; Adressausdruck
   (initial-value :initform ^unknown)
  )

;;------------------------------------------------------------------------------
;; Importierte statische Variable
;;------------------------------------------------------------------------------
(def-lzs-object imported-static (:global :imported static)
  :Annotations
  ;;-----------
   (read-stats :initform ())            ; Lesen von dieser glob. Variablen
   (write-stats :initform ())           ; Beschreiben dieser glob. Variablen
   type                                 ; Typausdruck
   (place :initform ())                 ; Adressausdruck
   (initial-value :initform ^unknown)   ; used only to transmit initial value
                                        ; for eval in .def-files
  )
;;------------------------------------------------------------------------------
;; Dynamische Variable.
;; Die Information, ob es sich um eine importierte und/oder exportierte Variable
;; handelt, kann aus dem Symbol ersehen werden.
;;------------------------------------------------------------------------------
(def-lzs-object dynamic (var)
  sym                       ; das zugehoerige Symbol
  :Annotations
  ;;-----------
   (read-stats :initform ())            ; Lesen von dieser glob. Variablen
   (write-stats :initform ())           ; Beschreiben dieser glob. Variablen
   type                                 ; Typausdruck
   (place :initform ())                 ; Adressausdruck
)                      

;;------------------------------------------------------------------------------
;; Variablen Referenz
;;------------------------------------------------------------------------------
(def-lzs-object var-ref ()
  var
  :Annotations
  ;;----------
  (read-gloc :initform ())              ; access to a dynamic variable
   )


;;------------------------------------------------------------------------------
;; Benannte Konstanten von Eulisp
;;------------------------------------------------------------------------------
(def-lzs-object named-const (:global lzs-object)
  (value                                ; self-evaluating || 'unknown
   :initform ^unknown)
  :Annotations
  ;;-----------
  (type :initform ())
  (place :initform ())                 ; Adressausdruck
  )
;;------------------------------------------------------------------------------
(def-lzs-object defined-named-const (named-const)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object imported-named-const (:imported named-const)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; Symbol
;; der Typ 'symbol' ist in CL reserviert.
;;------------------------------------------------------------------------------
(def-lzs-object sym (:global lzs-object)
  (constant-value                       ; for 'defconstant' in Common Lisp only
   :initform ^no-const)                 ; self-evaluating | 'unknown | 'no-const
  :Annotations
  ;;-----------
   type                                 ; type expression
   (place :initform ())                 ; address expression
   (expanded-literal :initform nil)     ; instance of <literal-instance>
   (syntactic :initform nil)            ; form at the syntactic level, i.e.
                                        ; before transformation to LZS
                                        ; needed to fasten eval during syntax expansion
  )

;;------------------------------------------------------------------------------
;; Im Modul definiertes Symbol.
;; Der Slot 'package' ist notwendig, wenn mehrere Packages als ein Modul
;; uebersetzt werden.
;;------------------------------------------------------------------------------
(def-lzs-object defined-sym (sym)
  name
  package                               ; Package-Name oder 'uninterned
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; Importiertes Symbol
;;------------------------------------------------------------------------------
(def-lzs-object imported-sym (:imported sym)
  :Annotations
  ;;-----------
  )


;;------------------------------------------------------------------------------
(def-lzs-object structured-literal ()
  value
  :Annotations
  ;;-----------
   type                                 ; Typausdruck
   (place :initform ())                  ; Adressausdruck
   (expanded-literal :initform nil)     ; instance of <literal-instance>
   (syntactic :initform nil)            ; form at the syntactic level, i.e.
                                        ; before transformation to LZS
                                        ; needed to fasten eval and to guarantee
                                        ; eq-equality during syntax expansion
  )
;;------------------------------------------------------------------------------
;; Eine zur Ubersetzungszeit bekannte Instanz einer Klasse.
;; Wird benoetigt zur Darstellung von #s(struct-name ..) in Common Lisp.
;;------------------------------------------------------------------------------
(def-lzs-object literal-instance (:named lzs-object)
  class
  value-list               ; Werte der Slots als Liste von Literals
  :Annotations
  ;;-----------
   type                                 ; Typausdruck
   (place :initform ())                 ; Adressausdruck
   (expanded :initform ())              ; a flag, needed only to avoid recursion
                                        ; during literal expansion
   (unexpanded :initform ^unknown)      ; the literal before expansion
   (gc-not-needed :initform ())
)   

;;------------------------------------------------------------------------------
;; Knoten zur Darstellung von definierenden und angewandten Vorkommen von
;; Klassen.
;; Die Klasse 'class' ist in CLOS schon vergeben, deshalb 'class-def'.
;;------------------------------------------------------------------------------
(def-lzs-object class-def (:global lzs-object)
  (supers :initform ())      ; list of class-def's
  (direct-slots :initform ()); list of slot-desc's
  (options :initform ())
  (converter :initform nil)             ; a generic-fun
  class                                 ; a metaclass
  :Annotations
  ;;-----------
   type                                 ; Typausdruck
   (lattice-type :initform ())		; lattice type for type inference
   (place :initform ())                 ; Adressausdruck
   (effective-slots :initform nil)
   (class-precedence-list :initform nil)
   (expanded-literal :initform nil)     ; instance of <literal-instance>
   (equal-pred :initform nil)
   (copy-fun :initform nil)
   (allocator :initform ^unknown)       ; fun which allocates instances
   (initargs :initform nil)
   (type-identifier :initform ())
   (subclasses :initform ())
  )

;;------------------------------------------------------------------------------
(def-lzs-object defined-class (class-def)

  :Annotations
  ;;----------
  representation
  gc-tracer
  (constructors :initform nil)
  (predicate :initform nil)
)

;;------------------------------------------------------------------------------
(def-lzs-object imported-class (:imported class-def)
  :Annotations
  ;;----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object slot-desc (:named lzs-object)
  (initfunction :initform nil)          ; the function returning the initial
                                        ; value 
  (initarg :initform nil)
  :Annotations
  ;;----------
  (initvalue :initform ^unknown)        ; set if the initform is a constant
                                        ; expression 
  (reader :initform nil)
  (writer :initform nil)
  (accessor :initform nil)
  (slot-of :initform nil)               ; the class which defines the slot
  (type :initform nil)                  ; the class for slot values
  (specializes :initform nil)           ; a slot-desc if the slot specializes
                                        ; another one inherited from a
                                        ; superclass 
  offset
  )

;;------------------------------------------------------------------------------
;; Die formale Parameterliste einer Funktionsdefinition.
;; Dieser Knoten taucht nur als Slot in einer Funktionsdefinition auf, seine
;; Slots koennten also auch direkt in dem Knoten 'fun' angegeben werden.
;;------------------------------------------------------------------------------
(def-lzs-object params ()
  (var-list :initform ())               ; required Parameters
  (opt-list :initform ())               ; Liste von Instanzen von 'opt'
  (rest :initform nil)                  ; &Rest Variable oder nil
  (key-list :initform ())               ; Liste von Instanzen von 'key'
  (allow-other-keys :initform nil)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object opt ()
  var
  init                                  ; Init Value
  (suppl :initform nil)                 ; Supplied-p Variable oder nil
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object key (opt)
  sym                                   ; Keyword Symbol
  :Annotations
  ;;-----------
  )


;;------------------------------------------------------------------------------
;; Funktion
;; Der Typ 'function' ist in CL reserviert.
;;------------------------------------------------------------------------------
(def-lzs-object fun ()
  params

  (setter :initform nil)                ; the setter function
      
  :Annotations
  ;;-----------
  (range-and-domain :initform ())       ; types of result and arguments
                                        ; a vector #(result-type argtype...)
  (arg-num :initform ())                 ; Argumentanzahl
  (var-descr :initform ())               ; Variablendeskriptor
  (type-descr :initform ())              ; formaler Typedeskriptor
  (type-descr-s :initform ())            ; tmp formale Signatur
  (signature :initform ())               ; formale Signatur
  (actual  :initform 0)                  ; aktualitaet der Signatur
  (pass :initform 0)                     ; Bearbeitungszustand der Funktion
  (applications :initform ())            ; alle Aufrufe von fun
  (place :initform ())                   ; Aufrufadresse von fun
  (reduce :initform ())                  ; zum Vereinfachen von Funkt.aufr.
  (function-type :initform 0)            ; ist fun ein closure ?
  (read-glocs :initform ())              ; Lesen von glob. Variablen
  (write-glocs :initform ())             ; Schreiben von glob. Variablen
  (fread-gloc :initform ())              ; the result of all read-glocs
  (fwrite-gloc :initform ())             ; the result of all write-glocs
  (sys-glocs :initform ())               ; are fread-gloc and fwrite-gloc
                                         ; changeable
  (inline :initform ())                  ; value: nil, test or value
  statement-status                       ; *rr* status for mzs2asm 

  (interpreter :initform () )           ; function in the compilation
                                        ; environment to interpret calls of fun
   (expanded-literal :initform nil)     ; instance of <literal-instance>
  )

;;------------------------------------------------------------------------------
;; Einfache Funktion (nicht generisch)
;;------------------------------------------------------------------------------
(def-lzs-object simple-fun (fun)
  body
  :Annotations
  ;;-----------
  function-label                         ; zum Einsammeln der MZS-Bloecke
  calls                                  ; alle Funktionsaufrufe in fun
  rec-calls                              ; alle rekursiven Funktionsaufrufe von
                                         ; fun
  tests
  moves

  get-slot-value
  set-slot-value

)

;;------------------------------------------------------------------------------
;; Definierte einfache Funktion
;;------------------------------------------------------------------------------
(def-lzs-object defined-fun (simple-fun)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; Globale definierte einfache Funktion
;;------------------------------------------------------------------------------
(def-lzs-object global-fun (:global defined-fun)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; module initializing function
;;------------------------------------------------------------------------------
(def-lzs-object module-init-fun (global-fun)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; lokale einfache Funktion
;; (Kann nicht importiert sein, das ist syntaktisch nicht moeglich.)
;;------------------------------------------------------------------------------
(def-lzs-object local-fun (:named defined-fun)
  :Annotations
  ;;-----------
  closure-vars                           ; closure-Variablen
  )

;;------------------------------------------------------------------------------
;; importierte einfache Funktion
;;------------------------------------------------------------------------------
(def-lzs-object imported-fun (:global :imported simple-fun)
  (body :initform ^unknown)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; Systemfunktion, die in gewissen Phasen des Compilers einer speziellen
;; Behandlung beduerfen.
;;------------------------------------------------------------------------------
(def-lzs-object special-sys-fun (imported-fun)
  :Annotations
  ;;-----------
; *rr* neue slots ?annotations?
  protocol-type
;  arg-count == arg-num of <fun>
  match-list
  inline
  )

;;------------------------------------------------------------------------------
(def-lzs-object generic-fun (fun)
  (method-list :initform ())
  domain                 ; list of <class-def>
  class
  method-class
  
  :Annotations
  ;;-----------
  discriminating-fun
  method-lookup-fun
  discrimination-depth
  discrimination-arguments
  )

;;------------------------------------------------------------------------------
(def-lzs-object defined-generic-fun (generic-fun)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object global-generic-fun (:global defined-generic-fun)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object local-generic-fun (defined-generic-fun)
  :Annotations
  ;;-----------
  closure-vars                           ; closure-Variablen
)

;;------------------------------------------------------------------------------
(def-lzs-object imported-generic-fun (:global :imported generic-fun)
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object method-def ()
  fun                                   ; the working function
  (domain :initform ())                 ; list of <class-def>
  class
  :Annotations
  ;;-----------
  generic-fun     ; the methods generic function
  )

;;------------------------------------------------------------------------------
;; Eine Funktions-Anwendung;
;; 'form' ist ein 'fun' oder evaluiert zur Laufzeit zu einer Funktion.
;;------------------------------------------------------------------------------
(def-lzs-object app ()
  function
  (arg-list :initform ())
  :Annotations
  ;;-----------
  (read-glocs :initform ())              ; all global-reads in the arguments
  type-descr
  )

;;------------------------------------------------------------------------------
(def-lzs-object setq-form ()
  location
  form
  :Annotations
  ;;-----------
  type-descr
  (write-gloc :initform ())              ; setq to a global variable
  (read-gloc :initform ())               ; a read of a global variable
)

;;------------------------------------------------------------------------------
(def-lzs-object progn-form ()
  form-list
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object if-form ()
  pred
  then
  else
  :Annotations
  ;;-----------
  (read-gloc :initform ())                ; pred is an read access to a global
                                          ; variable 
  )

;;------------------------------------------------------------------------------
(def-lzs-object switch-form ()
  form
  case-list                             ; Liste von labeled-form
  otherwise                             ; Eine 'form'
  :Annotations
  ;;-----------
  )
;;------------------------------------------------------------------------------
(def-lzs-object labeled-form ()
  value                                 ; sym oder simple-literal
  form
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object let*-form ()
  (var-list :initform ())               ; List of var
  (init-list :initform ())              ; List of initial values
  body
  :Annotations
  ;;-----------
  (type-list :initform ())
  read-gloc-list                         ; all read-glocs of the init-list
  write-gloc-list                        ; all write-glocs of the var-list
  )

;;------------------------------------------------------------------------------
(def-lzs-object labels-form ()
  (fun-list :initform ())                ; List of fun
  body
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object let/cc-form ()
  cont
  body
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
(def-lzs-object cont (local-static)
  :Annotations
  ;;------------
  (link :initform ())
  )

;;------------------------------------------------------------------------------
(def-lzs-object tagbody-form ()
  first-form                            ; Ausdruck vor dem 1. Tag, evtl. nil
  tagged-form-list
  :Annotations
  ;;-----------
  )

;;------------------------------------------------------------------------------
;; tagged-form repraesentiert zugleich das Tag und
;; alle zugehoerigen Go Ausdruecke
;;------------------------------------------------------------------------------
(def-lzs-object tagged-form ()
  form
  tagbody
  :Annotations
  ;;-----------
  label
  )
;;------------------------------------------------------------------------------
;; Konstrukt zum Ausdruecken der Special Forms multiple-value-call und
;; multiple-value-prog1 in der Zwischensprache.
;; Dieses Konstrukt ist sehr aehnlich zu dem Makro multiple-value-bind mit
;; der Ausnahme, dass eine beliebige Lambda-Liste angegeben werden kann.
;;------------------------------------------------------------------------------
(def-lzs-object mv-lambda ()
  params
  body
  arg                                   ; generiert evtl. multiple Werte
  :Annotations
  ;;-----------
  )
;;------------------------------------------------------------------------------
;; slot access
(def-lzs-object get-slot-value ()
  instance ; a form
  slot     ; a slot-desc
  :Annotations
  ;;-----------
  ; annotations needed for the usage in the MZS
  block
  (arg-num                              ; the number of arguments
   :initform 1)
  var-descr                             ; a variable descriptor
  type-descr                            ; the general type-descriptor
  type-descr-s                          ; list of type descriptors
)

(def-lzs-object set-slot-value ()
  instance ; a form
  slot     ; a slot-desc
  value    ; a form
  :Annotations
  ;;-----------
  ; annotations needed for the usage in the MZS
  block
  (arg-num                              ; the number of arguments
   :initform 2)
  var-descr                             ; a variable descriptor
  type-descr                            ; the general type-descriptor
  type-descr-s                          ; list of type descriptors
)

;;; -----------------------------------------------------------------------------------
;;; extension of the LZS for EuLisp
;;; -----------------------------------------------------------------------------------

;;; -----------------------------------------------------------------------------------
;;; some specializations of <defined-class>

(def-lzs-object standard-class-def (defined-class)
  :Annotations
  ;;-----------
  )

(def-lzs-object abstract-class-def (standard-class-def) 
  :Annotations
  ;;-----------
  )

(def-lzs-object tail-class-def (standard-class-def) 
  :Annotations
  ;;-----------
  )

(def-lzs-object metaclass-def (standard-class-def) 
  :Annotations
  ;;-----------
  )

;;; -----------------------------------------------------------------------------------
;;; some specializations of <global-fun> for functions automatically created by
;;; %define-...-class 

(def-lzs-object slot-accessor-fun (global-fun)
  :Annotations
  ;;-----------
  slot)

(def-lzs-object slot-init-fun (global-fun)
  :Annotations
  ;;-----------
  slot)

(def-lzs-object constructor-fun (global-fun)
  :Annotations
  ;;-----------
  initargs
  constructor-for)

(def-lzs-object predicate-fun (global-fun)
  :Annotations
  ;;-----------
  )

;;; -----------------------------------------------------------------------------------
;;; predicates testing mixins
;;; -----------------------------------------------------------------------------------

(defgeneric imported-p (object))

(defmethod imported-p (object) nil)

(defgeneric named-p (object))

(defmethod named-p (object) 
  ; this means that all 'global' object are also 'named'
  ; 'global' is a submixin of 'named'
  (global-p object))

(defgeneric global-p (object))

(defmethod global-p (object) nil)

;;; -----------------------------------------------------------------------------------
;;; compatibility to old annotation module-id
;;; -----------------------------------------------------------------------------------

(export ?module-id)

(defun ?module-id (lzs-object)
  (if (?module lzs-object)
    (?identifier (?module lzs-object))
    nil))

#module-end 

;;;end of module lzs
