;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs-syntax -*-
#|
-----------------------------------------------------------------------------------
TITLE: An interpreter for the LZS
-----------------------------------------------------------------------------------
File:    lzs-syntax.em
Version: 1.1 (last modification on Fri Jan 28 11:54:35 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:lzs-syntax contains the macro def-lzs-object for lzs

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Heinz Knutzen

CONTACT: 
Heinz Knutzen

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/lzs-syntax.em[1.1]:
  done
[1.1] Fri Jan 28 11:55:06 1994 wheick@isst published
  done

-----------------------------------------------------------------------------------
|#

#module lzs-syntax

(import (eulisp0
         apply-standard
         accessors
         )
 syntax (eulisp0 
         apply-standard
         )
 import ((only (append caar intern format last) 
           common-lisp))
 syntax ((only (pushnew) 
           common-lisp))
 export (def-lzs-object  ; macro
         make-structure-and-annotation-slots
         make-predicate-name
         <lzs-object>
         lzs-object-p)
 ;export (imported-p named-p global-p) ;mixin predicates
 expose (accessors)
 )

;;; defstandardclass of <lzs-object> here inserted
;;; because of name conflict with symbol <lzs-object>
;;; in function make-supers

(defstandardclass <lzs-object> ()       ; the top node
  (source :initform ())                 ; some reference to the source
  :predicate)



(deflocal *structure-slots* nil)
(deflocal *annotation-slots* nil)

;;; only to create accessor table for the module 'accessors'
(defun print-slots (slots)
  (format t "~%; --- slots ---~%~{~(~A~%~)~}"
          (cl:sort slots
                   #'cl:string<
                   :key #'cl:string))
  )

(defconstant $default-annotations '(source))

(defun make-lzs-slots (supers slots)
  (make-structure-and-annotation-slots 
   (add-annotations (add-mixin-slots supers slots)
                    $default-annotations)))

(defun add-structure-slots (new-slots slots)
  (append new-slots slots))

(defun add-annotations (new-slots slots)
  (append slots new-slots))

(defun add-mixin-slots (supers slots)
  (cond ((null supers) slots)
        ((eq (car supers) ':named)
         (add-mixin-slots (cdr supers)
                          (add-annotations 
                           '((identifier :initform ())
                             (module :initform ())
                             (code-identifier :initform ()))
                           slots)))
        ((eq (car supers) ':global)
         (add-mixin-slots (cons ':named (cdr supers))
                          (add-structure-slots 
                           '((exported :initform ()))
                           slots)))
        ((eq (car supers) ':imported)
         (add-mixin-slots (cdr supers)
                          (add-annotations
                           '((definition :initform ()))
                           slots)))
        (t
         (add-mixin-slots (cdr supers) slots))
        ))

(defun make-structure-and-annotation-slots (slots)
  (cond ((null slots) nil)
        ((eq (car slots) ':annotations)
         (make-annotations (cdr slots)))
        ((consp (car slots))
         (pushnew (caar slots) *structure-slots*)
         (cons 
          (append (car slots)
                  '(:accessor :writer :initarg))
          (make-structure-and-annotation-slots (cdr slots))))
        (t 
         (pushnew (car slots) *structure-slots*)
         (cons 
          (list (car slots) ':accessor ':writer ':initarg)
          (make-structure-and-annotation-slots (cdr slots))))))

(defun make-annotations (slots)
  (cond ((null slots) nil)
        ((consp (car slots))
         (pushnew (caar slots) *annotation-slots*)
         (cons 
          (append (car slots)
                  '(:accessor :writer :initarg))
          (make-annotations (cdr slots))))
        (t 
         (pushnew (car slots) *annotation-slots*)
         (cons 
          (list (car slots) ':accessor ':writer ':initarg)
          (make-annotations (cdr slots))))))

(defun get-superclass-name (supers)
  (make-eulisp-class-id (car (last supers))))

(defun make-supers (supers)
  (if (null supers) 
    '(<lzs-object>)
    (list (get-superclass-name supers))))

(defun make-predicate-name (class-name)
  (intern (format nil "~A-P" class-name)))

(defun make-mixin-predicates (class-name supers)
  (cond ((null supers) nil)
        ((member (car supers) '(:named :global :imported))
         (cons
          `(defmethod ,(make-predicate-name (car supers)) 
                      ((object ,(make-eulisp-class-id class-name)))
             t)
          (make-mixin-predicates class-name (cdr supers))))
        (t
         (make-mixin-predicates class-name (cdr supers)))
        ))

(defmacro def-lzs-object (name supers . slots)
  `(progn
     (defstandardclass
       ,(make-eulisp-class-id name)
       ,(make-supers supers)
       ,@(make-lzs-slots supers slots)
       :predicate)
     ,@(make-mixin-predicates name supers)
     (export 
       ,(make-eulisp-class-id name)
       ,(make-predicate-name name))))

#module-end

;;; eof module lzs-syntax
