;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs-mop -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: A part of the EuLisp Meta Object Protocol used at Compile Time
-----------------------------------------------------------------------------------
File:    lzs-mop.em
Version: 1.21 (last modification on Thu Feb  3 08:46:51 1994)
State:   published

DESCRIPTION:
This module provides some subclasses of the LZS-class <class-def> for a better
division of standard-, meta- and tail-classes.

This module also provides functions of the EuLisp-MOP which are needed by the
compiler to compute resp. initialize things like classes and generic functions
at compile time. The domain of these functions are the compile time
representations (LZS representation) of classes, generic functions etc.

The naming is done by prefixing the original names of the EuLisp MOP by a tilde.
For example ~class-precedence-list is a function like
class-precedence-list of EuLisp but works with LZS representations of classes.

DOCUMENTATION:

NOTES:
1. The arguments of the ~-functions are not exactly the same as for their EuLisp
counterparts. They differ in structure. For example ~compute-slot-descriptions
gets a list of slot descriptions instead a list of slot specifications (the list
form). 

2. The following activation order must be taken into account during class
initailization (read top down): 

                     ~compute-representation
                          |            |
~compute-runtime-initialization   ~compute-reader/writer
         | 
~compute-allocator
         | 
~compute-constructor

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/lzs-mop.em[1.21]:
  Provides some specializations of <defined-class> and <global-fun> 
  and a compile time MOP which works with the specializations of
  <defined-class>. This is needed for the implementation of 
  %define-standard/abstract/tail/meta-class and also for some other parts
  of the APPLY compiler.
[1.1] Thu Mar 18 14:16:06 1993 imohr@isst saved
  
[1.2] Fri Mar 19 15:03:19 1993 wheick@isst saved
  [Thu Mar 18 14:56:04 1993] Intention for change:
  to init the representation slots
  compute-representation inserted
[1.3] Mon Mar 22 16:44:26 1993 imohr@isst saved
  MOP for transformation of class definitions into LZS
[1.4] Tue Mar 23 09:43:50 1993 wheick@isst saved
  [Mon Mar 22 17:27:56 1993] Intention for change:
  function for slot representation inserted
[1.5] Wed Mar 24 13:46:53 1993 imohr@isst proposed
  classes and generic functions ok
[1.6] Wed Mar 24 16:49:31 1993 imohr@isst proposed
  class options representation. ok
[1.7] Thu Mar 25 15:36:07 1993 imohr@isst proposed
  + import of accessors
[1.8] Wed Mar 31 10:40:28 1993 imohr@isst proposed
  literals for structures, literal expanders and expose ok
[1.9] Tue Apr  6 16:10:54 1993 imohr@isst proposed
  + stuff for lattice types
[1.10] Fri Apr 16 17:07:01 1993 imohr@isst proposed
  %object is now an abstract-class-def
[1.11] Mon May  3 13:31:50 1993 imohr@isst proposed
  vector classes
[1.12] Tue May  4 08:53:14 1993 imohr@isst proposed
  ~vector-class-element-initfunction
[1.13] Mon Aug 30 15:25:17 1993 imohr@isst proposed
  [Mon Aug 30 14:11:44 1993] Intention for change:
  collecting subclasses in a class
[1.14] Wed Sep 15 11:56:21 1993 imohr@isst saved
  [Thu Sep  9 12:03:33 1993] Intention for change:
  + ~-generic-functions for <generic-fun> and <method>
[1.15] Wed Sep 15 16:58:36 1993 imohr@isst proposed
  [Wed Sep 15 14:42:54 1993] Intention for change:
  + discrimination-depth
[1.16] Tue Sep 28 08:17:44 1993 hfried@isst proposed
  [Mon Sep 27 14:19:53 1993] Intention for change:
  add compute-discrimination-arguments
[1.17] Thu Sep 30 16:16:11 1993 imohr@isst published
  [Wed Sep 29 07:36:05 1993] Intention for change:
  completing slot-descriptions
[1.18] Mon Nov  8 11:54:34 1993 ukriegel@isst proposed
  [Mon Nov  8 10:56:49 1993] Intention for change:
  vector-class-instance-length-literal
  new machine description, ~vector-class-instance-lengt ~vector-class-instance-length-literal
[1.19] Fri Nov 26 10:52:51 1993 imohr@isst proposed
  [Wed Nov 24 11:29:05 1993] Intention for change:
  class-definitions -> lzs
[1.20] Tue Dec 14 17:18:41 1993 imohr@isst proposed
  [Tue Dec 14 12:48:08 1993] Intention for change:
  add inheritance of converters
[1.21] Mon Feb  7 08:26:42 1994 imohr@isst published
  [Thu Feb  3 08:27:25 1994] Intention for change:
  + compute-runtime-initialization, compute-allocator
  new slot access and imported classes ok

-----------------------------------------------------------------------------------
|#

#module lzs-mop
(import (level-1-eulisp 
         accessors
         lzs
         el2lzs
         (only (remove-duplicates substitute find append mapc make-instance)
           common-lisp))

 syntax (level-1-eulisp 
         apply-standard
         el2lzs)

 ;--- lzs specializations
 expose ((only (<standard-class-def>
                <abstract-class-def>
                <tail-class-def>
                <metaclass-def>
                <slot-accessor-fun>
                <slot-init-fun> 
                <constructor-fun>)
           lzs))
         
 ;--- predefined classes for applications
 export ($<object>
         $<class>
         $<tail-class>
         $<abstract-class>
         
         initialize-predefined-classes)
         
 ;--- General
 export (~initialize
         ~class-of)
         
 ;--- Class Introspection
 export (~class-name 
         ~class-precedence-list 
         ~class-slot-descriptions 
         ~class-initargs
         ~class-representation
         ~find-slot-description 
         ~class-subclasses
         ~converter)
         
 ;--- Slot Introspection
 export (~slot-description-name 
         ~slot-description-initfunction 
         ~slot-description-slot-reader 
         ~slot-description-slot-writer 
         ~slot-description-type 
         ~slot-description-initarg
         ~slot-description-initvalue)
         
 ;--- Generic Function Introspection
 export (~generic-function-domain
         ~generic-function-method-class
         ~generic-function-methods
         ~generic-function-method-lookup-function
         ~generic-function-discriminating-function
         ~generic-function-discrimination-depth)
         
 ;--- Method Introspection
 export (~method-domain
         ~method-function
         ~method-generic-function)
         
 ;--- Class Initialization
 export (~compute-class-precedence-list 
         ~compute-inherited-slot-descriptions 
         ~compute-slot-descriptions 
         ~compute-inherited-initargs 
         ~compute-initargs
         ~compute-representation
         ~compute-lattice-type
         ~compute-constructor 
         ~compute-predicate
         ~compute-runtime-initialization
         ~compute-allocator)
         
 ;--- Inheritance Protocol
 export (~compute-and-ensure-slot-accessors
         ~compute-slot-reader
         ~compute-slot-writer)
         
 ;--- Method Lookup and Generic Dispatch
 export (~compute-method-lookup-function
         ~compute-discriminating-function
         ~add-method
         ~compute-discrimination-depth
         ~compute-discrimination-arguments)
         
 ;--- Introspection of Vector Classes
 export (~vector-class-instance-length 
         ~vector-class-instance-length-literal
         ~vector-class-element-type
         ~vector-class-element-initfunction)

 ) ;end of module header

;;; -----------------------------------------------------------------------------------
;;; predefined classes for applications 
;;; -----------------------------------------------------------------------------------
;;; The following classes are placed as top-lexical bindings into the basic
;;; application module TAIL.

(define-tail %object export (abstract-class-def)
  :supers nil
  :direct-slots nil
  :representation nil
  )

(define-tail %class export (metaclass-def)
  :supers (list %object)
  :representation nil
  )

(define-tail %abstract-class export (metaclass-def)
  :supers (list %class)
  :class %class
  :representation nil
  )

(define-tail %tail-class export (metaclass-def)
  :supers (list %class)
  :class %class
  :representation nil
  )

;;; -----------------------------------------------------------------------------------
;;; General
;;; -----------------------------------------------------------------------------------

(defgeneric ~initialize (object initlist))

(defgeneric ~class-of (object))

;;; -----------------------------------------------------------------------------------
;;; Class Introspection
;;; -----------------------------------------------------------------------------------

(defgeneric ~class-name (class))

(defgeneric ~class-precedence-list (class))

(defgeneric ~class-slot-descriptions (class))

(defgeneric ~class-initargs (class))

(defgeneric ~class-representation (class))

(defgeneric ~find-slot-description (class slot-name))

(defgeneric ~class-subclasses (class))

(defgeneric ~converter (class))

;;; -----------------------------------------------------------------------------------
;;; Slot Introspection
;;; -----------------------------------------------------------------------------------

(defgeneric ~slot-description-name (slot))

(defgeneric ~slot-description-initfunction (slot))

(defgeneric ~slot-description-slot-reader (slot))

(defgeneric ~slot-description-slot-writer (slot))

(defgeneric ~slot-description-type (slot)) ;returns the class for slot values

(defgeneric ~slot-description-initarg (slot))

(defgeneric ~slot-description-initvalue (slot))

;;; -----------------------------------------------------------------------------------
;;; Generic Function Introspection
;;; -----------------------------------------------------------------------------------

(defgeneric ~generic-function-domain (generic-fun))

(defgeneric ~generic-function-method-class (generic-fun))

(defgeneric ~generic-function-methods (generic-fun))

(defgeneric ~generic-function-method-lookup-function (generic-fun))

(defgeneric ~generic-function-discriminating-function (generic-fun))

(defgeneric ~generic-function-discrimination-depth (generic-fun))

;;; -----------------------------------------------------------------------------------
;;; Method Introspection
;;; -----------------------------------------------------------------------------------

(defgeneric ~method-domain (method-def))

(defgeneric ~method-function (method-def))

(defgeneric ~method-generic-function (method-def))

;;; -----------------------------------------------------------------------------------
;;; Class Initialization
;;; -----------------------------------------------------------------------------------

(defgeneric ~compute-class-precedence-list (class direct-superclasses))

(defgeneric ~compute-inherited-slot-descriptions (class direct-superclasses))

(defgeneric ~compute-slot-descriptions (class direct-slot-specs
                                              inherited-slot-descriptions))

(defgeneric ~compute-inherited-initargs (class direct-superclasses))

(defgeneric ~compute-initargs (class initargs inherited-initarg-lists))

(defgeneric ~compute-representation (class representation-spec
                                     allocation-spec mm-type))

(defgeneric ~compute-lattice-type (class direct-superclasses
                                   direct-super-lattice-types))

(defgeneric ~compute-constructor (class parameters))

(defgeneric ~compute-predicate (class))

(defgeneric ~compute-runtime-initialization (class))
(defgeneric ~compute-allocator (class))

;;; -----------------------------------------------------------------------------------
;;; Inheritance Protocol
;;; -----------------------------------------------------------------------------------

(defgeneric ~compute-and-ensure-slot-accessors
            (class effective-slots inherited-slots))

(defgeneric ~compute-slot-reader
            (class slot effective-slots))

(defgeneric ~compute-slot-writer
            (class slot effective-slots))

;;; -----------------------------------------------------------------------------------
;;; Method Lookup and Generic Dispatch
;;; -----------------------------------------------------------------------------------

(defgeneric ~set-discriminating-function (generic-fun)
  ;called after loading application modules and before analyzing functions
  ;this means that all statically collected methods are stored in the
  ;generic-fun, but a call of add-method at runtime may add additional methods
  )

(defgeneric ~compute-method-lookup-function (generic-fun domain))

(defgeneric ~compute-discriminating-function (generic-fun domain
                                              lookup-fn methods))

(defgeneric ~add-method (generic-fun method))

(defgeneric ~compute-discrimination-depth (generic-fun))

(defgeneric ~compute-discrimination-arguments (generic-fun))

;;; -----------------------------------------------------------------------------------
;;; Introspection of Vector Classes
;;; -----------------------------------------------------------------------------------

(defgeneric ~vector-class-instance-length (vector-class))

(defgeneric ~vector-class-instance-length-literal (vector-class))

(defgeneric ~vector-class-element-type (vector-class))

(defgeneric ~vector-class-element-initfunction (vector-class))

#module-end
