;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: letstar-form -*-
#|
-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    letstar-form.em
Version: 1.7 (last modification on Wed Aug 11 15:21:59 1993)
State:   published

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Firedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/letstar-form.em[1.7]:
  text
[1.1] Thu Mar 18 09:00:52 1993 hfried@isst proposed
  [Fri Mar  5 13:04:25 1993] Intention for change:
[1.2] Wed Mar 24 13:49:22 1993 hfried@isst proposed
  [Thu Mar 18 09:12:39 1993] Intention for change:
  + glob anna
[1.3] Thu Mar 25 11:20:31 1993 hfried@isst proposed
  [Wed Mar 24 14:54:28 1993] Intention for change:
  + gen-fun
  new head
[1.4] Tue Apr 13 14:10:05 1993 hfried@isst proposed
  [Thu Mar 25 11:54:37 1993] Intention for change:
[1.5] Wed Jun  2 08:21:04 1993 hfried@isst proposed
  [Tue Apr 13 14:16:11 1993] Intention for change:
  result von letstar-a korrigiert
[1.6] Mon Jun 21 11:46:56 1993 hfried@isst saved
  [Thu Jun  3 09:18:36 1993] Intention for change:
  result-variable nicht gelinkt
[1.7] Wed Aug 18 11:47:29 1993 hfried@isst published
  [Mon Aug  9 15:16:58 1993] Intention for change:
  type-list

-----------------------------------------------------------------------------------
|#

#module-name letstar-form
#module-import 
( level-1-eulisp 
  accessors
  context
  LZS
  analyse-h
  MZS 
  move
  gutter
  type-inference
) 

#module-syntax-import (level-1-eulisp simple-programming  )
#module-syntax-definitions

;--- defmacro forms

#module-header-end

;--- exports

;       #########
(export letstar-a) ; con, form 
;       #########

; (expose ...) - exportieren ohne zu importieren
; macros: ...

;--- definitions, exportations, initialization forms

(defun letstar-a (con form)
;   [let* var-list                             ; List of var
;         init-list                            ; List of initial values
;         type-list
;         read-gloc-list                       ; read-glocs of initial values
;         write-gloc-list                      ; write-glocs of var's
;         body]
  (dynamic-let ((closure (dynamic closure)))
               (let ((oldenv (dynamic env))
                     (var-list (?var-list form))
                     res)
                 (bind-vars var-list (?init-list form)
                            (?type-list form)
                            (?read-gloc-list form)
                            (?write-gloc-list form))
                 (if (join-label-p con) 
                   (setf (?rebind-vars con)
                         (cons var-list
                               (?rebind-vars con)))
                   ())
                 (setq res (l2m-a con (?body form)))
                 ; !!!!! missing unbind !!!!!
                 (if (or (function-label-p con)
                         (join-label-p con))
                   () (unbind var-list oldenv))
                 res
)))

(defun unbind (vlist oenv)
  (let ((cenv (dynamic env)))
    (setf (dynamic env) (unbind1 vlist cenv oenv))))

(defun unbind1  (vl cenv oenv)
  (cond ((eq cenv oenv) oenv)
        ((member (car (car cenv)) vl) (unbind1 vl (cdr cenv) oenv))
        (t (cons (car cenv) (unbind1 vl (cdr cenv) oenv)))))

(defun bind-vars (var-list init-list type-list rgloc-list wgloc-list)
  (cond ((null var-list) ())
        (t (bind-vars1 (car var-list)
                       (if init-list (l2m-a (dynamic *arg-context*) 
                                            (car init-list)) ())
                       (if type-list (class-as-type-expr
                                      (car type-list))
                           ())
                       (car rgloc-list) (car wgloc-list))
           (bind-vars (cdr var-list) (if init-list (cdr init-list) ())
                      (if type-list (cdr type-list) ())
                      (cdr rgloc-list) (cdr wgloc-list)))))

    
(defgeneric bind-vars1 (var init type rgloc wgloc))

(defmethod bind-vars1 ((var <local-static>) init type rgloc wgloc)
  (if (?closure var)
    (add-closure-var-value var init (dynamic block))
    (if (tempvar-p init) 
      (progn 
        (subst-and-check-tempvar (?link init) var type)
        (add-env var var))
      (add-move var init type rgloc wgloc)))
)

(defun subst-and-check-tempvar (link locstat type)
  (setf (?link locstat) link)
  (subst-and-check-tempvar1 link locstat type))

(defun subst-and-check-tempvar1 (link var type)
  (if (null link) ()
      (let* ((stat (car (car link)))
             (in (cdr (car link)))
             (td (?type-descr stat))
             (tds (?type-descr-s stat)))
        (setf (vector-ref (?var-vec (?var-descr stat)) in) var)
        (if type
          (progn 
            (set-descr-type td in type)
            (if tds (check-result-subtypes tds td) ()))
          ())
        (subst-and-check-tempvar1 (cdr link) var type))))

(defmethod bind-vars1 ((var <global-static>) init type rgloc wgloc)
  (add-move var init type rgloc wgloc)
)

(defmethod bind-vars1 ((var <imported-static>) init type rgloc wgloc)
  (add-move var init type rgloc wgloc)
)

(defmethod bind-vars1 ((var <dynamic>) init type rgloc wgloc)
  (print "dynamic-let not jet implemented")
)



#module-end