;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: gutter -*-
#|
-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    gutter.em
Version: 1.6 (last modification on Fri Sep  3 12:59:15 1993)
State:   published

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Firedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/gutter.em[1.6]:
  
[1.1] Tue Apr 13 14:28:17 1993 hfried@isst proposed
  [Tue Apr 13 14:15:43 1993] Intention for change:
[1.2] Mon Jun 21 11:43:39 1993 hfried@isst saved
  [Tue Apr 13 14:28:48 1993] Intention for change:
[1.3] Wed Aug 18 11:50:36 1993 hfried@isst proposed
  [Wed Aug 18 09:41:59 1993] Intention for change:
  closures
[1.4] Thu Aug 26 11:47:58 1993 hfried@isst proposed
  [Wed Aug 18 15:13:59 1993] Intention for change:
  gloc -> glocs
[1.5] Tue Aug 31 12:12:09 1993 hfried@isst proposed
  [Sat Aug 28 13:30:40 1993] Intention for change:
  function-literal
[1.6] Fri Sep  3 15:46:30 1993 hfried@isst published
  [Thu Sep  2 11:27:25 1993] Intention for change:
  eingefuegte Funktionen mit analysieren

-----------------------------------------------------------------------------------
|#

#module-name gutter
#module-import 
( level-1-eulisp 
  SIMPLE-PROGRAMMING
  lzs
  mzs
  accessors
  vector
  analyse-h
  type-propagation
  type-inference
  side-effects-h
  lzs-to-mzs-fun
  apply-funs
  tail-module
  expand-literal
  (only (assoc) common-lisp)) 

#module-syntax-import 
( level-1-eulisp )

#module-syntax-definitions

;--- defmacro forms

#module-header-end

;  #######
;  exports
;  #######

;        ########################################################
(export  
  make-a-closure-function ; (fun block)
  set-closure-var         ; (var value block)
  add-closure-var-value   ; (var value block)
  add-closure-var         ; (var block)
  rename                  ; (var)
)
;        ########################################################


;--- definitions, exportations, initialization forms

;      ######  
(defun rename (var)
;      ######
  (if (?closure var)
    (read-closure-var var (dynamic block))
    (cdr (assoc var (dynamic env))))
)
 
;  (let ((newvar (assoc var (dynamic env))))
;    (cond ((null newvar) 
;           (setq newvar (assoc var (dynamic globenv)))
;           (cond ((null newvar)
;                  (warning
;                 "seltsam, die Variable ~s ist nicht in der Umgebung"
;                          var)
;                  var)
;                 (t (setq newvar (cdr newvar))
;                    (add-closure-var newvar) newvar)))
;          (t (cdr newvar)))))

;      ###############
(defun add-closure-var (var block)
;      ###############
  (let ((result (add-function-call %closure-push
                                   block 2 var 
                                   (if (dynamic closure) 
                                     (car (car (dynamic closure))) ())
                                   ())))
    ; extension of the closure (description)
    (dynamic-setq closure
                  (cons (cons result var)
                        (dynamic closure))))
)

;      #####################
(defun add-closure-var-value (var value block)
;      #####################
  (let ((result (add-function-call %closure-push
                                   block 2 value 
                                   (if (dynamic closure) 
                                     (car (car (dynamic closure))) ())
                                   ())))
    ; extension of the closure (description)
    (dynamic-setq closure
                  (cons (cons result var)
                        (dynamic closure))))
)
;      ----------------
(defun read-closure-var (var block)
;      ----------------
  (let ((cl (dynamic closure)))
    (add-function-call %closure-value block 2 (car (car cl))
                       (get-closure-number var cl 0) ()))
)

;      ###############
(defun set-closure-var (var value block)
;      ###############
  (let ((cl (dynamic closure)))
    (add-function-call %set-closure-value block 3
                       (car (car cl))
                       (get-closure-number var cl 0)
                       value)))

;      #######################
(defun make-a-closure-function (fun block)
;      #######################
  ; add-function in fun-list !!!
  
  (add-function-call %make-function block 3
                     (compute-arg-descr fun)
                     (car (car (dynamic closure)))
                     (%function-literal fun)
;                     (make <literal-instance> 
;                           :value-list (list fun)
;                           :class %function)
))

(defun compute-arg-descr (fun)
  (let* ((p (?params fun))
         (n (compute-arg-descr1 (?var-list p))))
    (if (?rest p)
      (mk-sigwi (- 0 (+ n 1)))
      (mk-sigwi n))))

(defun compute-arg-descr1 (var)
  (if (null var) 0
      (+ 1 (compute-arg-descr1 (cdr var)))))

(defun mk-sigwi (n)
  (make-literal-instance %signed-word-integer (list n))
)
;  (make <literal-instance> :value-list (list n)
;        :class %signed-word-integer))


;      ------------------
(defun get-closure-number (var cl nr)
;      ------------------
  (if (null cl) 
    (progn (warning "Var ~s not found in closure" var) nr)
    (if (eq (cdr (car cl)) var) (mk-sigwi nr)
        (get-closure-number var (cdr cl) (+ nr 1))))
)





#module-end
