;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: function-call -*-
#|
-----------------------------------------------------------------------------------
TITLE: a call to a function
-----------------------------------------------------------------------------------
File:    function-call.em
Version: 1.23 (last modification on Tue Dec  7 14:36:42 1993)
State:   published

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/function-call.em[1.23]:
  text
[1.1] Thu Mar 18 09:00:08 1993 hfried@isst proposed
  [Fri Mar  5 13:03:47 1993] Intention for change:
[1.2] Wed Mar 24 13:48:31 1993 hfried@isst proposed
  [Thu Mar 18 09:11:35 1993] Intention for change:
  + glob anna
[1.3] Thu Mar 25 11:19:36 1993 hfried@isst proposed
  [Wed Mar 24 14:53:29 1993] Intention for change:
  + gen-fun
  new head
[1.4] Tue Apr 13 14:09:18 1993 hfried@isst proposed
  [Thu Mar 25 11:54:06 1993] Intention for change:
[1.5] Tue Apr 20 15:45:34 1993 hfried@isst proposed
  [Tue Apr 13 14:15:30 1993] Intention for change:
  cast
[1.6] Mon Jun 21 11:41:58 1993 hfried@isst saved
  [Tue Apr 20 15:54:15 1993] Intention for change:
[1.7] Wed Jun 30 10:43:05 1993 hfried@isst saved
  [Tue Jun 29 15:09:35 1993] Intention for change:
  inline
[1.8] Wed Jun 30 12:20:12 1993 hfried@isst saved
  
[1.9] Thu Aug  5 14:33:24 1993 hfried@isst proposed
  
[1.10] Wed Aug 18 11:48:20 1993 hfried@isst proposed
  [Mon Aug  9 11:02:56 1993] Intention for change:
  inline alloc-functions
[1.11] Thu Aug 26 11:47:05 1993 hfried@isst proposed
  [Tue Aug 24 08:39:30 1993] Intention for change:
  inline-Ausschriften
[1.12] Tue Aug 31 12:11:34 1993 hfried@isst published
  [Fri Aug 27 10:59:38 1993] Intention for change:
  add funcall & apply
[1.13] Fri Sep 10 09:00:55 1993 hfried@isst saved
  [Fri Sep 10 08:30:02 1993] Intention for change:
  resulttype by inline
[1.14] Fri Sep 17 16:18:38 1993 hfried@isst proposed
  [Fri Sep 17 16:16:13 1993] Intention for change:
  result-typen
[1.15] Fri Sep 24 10:31:57 1993 hfried@isst proposed
  [Fri Sep 24 10:19:11 1993] Intention for change:
  define unlink
[1.16] Fri Sep 24 11:23:49 1993 hfried@isst proposed
  [Fri Sep 24 11:20:16 1993] Intention for change:
  result after unlink
[1.17] Wed Sep 29 14:49:00 1993 hfried@isst proposed
  [Tue Sep 28 15:58:22 1993] Intention for change:
  inline-Kriterium vergroessern
[1.18] Thu Sep 30 16:16:50 1993 wheick@isst saved
  [Wed Sep 29 16:31:52 1993] Intention for change:
  inline fuer local funs??
[1.19] Wed Oct  6 14:37:01 1993 hfried@isst published
  [Thu Sep 30 16:25:21 1993] Intention for change:
  module-init-fun
[1.20] Wed Oct  6 16:33:48 1993 hfried@isst saved
  [Wed Oct  6 15:55:51 1993] Intention for change:
  method-descr.
[1.21] Tue Nov 16 11:56:31 1993 hfried@isst proposed
  [Mon Nov 15 15:08:51 1993] Intention for change:
  method-subset
[1.22] Fri Nov 26 10:40:40 1993 imohr@isst proposed
  [Wed Nov 24 13:26:35 1993] Intention for change:
  remove definition of  slot-accessor-fun-p because it is now defined in lzs
[1.23] Tue Dec  7 17:05:52 1993 imohr@isst published
  [Mon Dec  6 13:50:44 1993] Intention for change:
  inline flag

-----------------------------------------------------------------------------------
|#

#module function-call

(import (level-1-eulisp
         SIMPLE-PROGRAMMING
         lzs 
         mzs 
         lzs-mop
         accessors
         context 
         analyse-h ; make-vector and vector-ref
         type-propagation
         progn-context
         vector
         lzs-to-mzs-fun
         function-call-context
         (only (error format) common-lisp)
         type-inference
         side-effects
         gutter
         name-of-fun
         inline
         debugging
         tail-module ; %cast
         configuration ; nothing imported, only to initialize (dynamic *inline*) 
         )

 syntax (level-1-eulisp)

 export (call-a-function ; fun arg-list last
         )
 )

;      ---------------
(defun call-a-function (fun arg-list last read-glocs)
;      ---------------
;
; fun = <global-fun>, <local-fun>, <imported-fun>, <special-sys-fun>,
; <global-generic-fun>, <local-generic-fun>, imported-generic-fun>, <var-ref>,
; <cont>, <defined-named-constant>, <imported-named-constant>
;
; global-fun - normal function call last-call
; local-fun - closure-call possible last-call
; imported-function - closure-call possible last-call
; special-sys-fun - last-asm
; global-generic-fun - last-call
; local-generic-fun - closure-possible last-call
; imported-generic-fun - closure possible last-call
; var-ref - funcall
; cont - goto ??
;  defined-named-const, imported-named-const - funcall
  (if (named-const-p fun)
    (setq fun (?value fun)) 
    (if (var-ref-p fun) (setq fun (?var fun)) ()))
  (let* ((arg-num (length arg-list))
         (call
          (cond ((fun-p fun)
                 (let ((rglocs 
                        (if (?fread-gloc fun)
                          (balance-side-effects1
                           (?glocs (?fread-gloc fun)) read-glocs)
                          read-glocs))
                       (wglocs
                        (if (?fwrite-gloc fun)
                          (?glocs (?fwrite-gloc fun)) ())))
                   (if (special-sys-fun-p fun)
                     (if last 
                       (make <last-asm> :function fun 
                             :read-glocs rglocs
                             :write-glocs wglocs)
                     (make <asm> :function fun  
                             :read-glocs rglocs
                             :write-glocs wglocs))
                   (if last 
                     (make <last-call> :function fun 
                             :read-glocs rglocs
                             :write-glocs wglocs)
                     (make <call> :function fun 
                             :read-glocs rglocs
                             :write-glocs wglocs))
                   ))
                 )
; var = <local-static>, <global-static>, <imported-static>, <dynamic>
                ((local-static-p fun)
                 (make <funcall> :value fun :closure-call t
                       :read-glocs (balance-side-effects1 
                                    (?glocs *funcall-fread-gloc*)
                                    read-glocs)
                       :write-glocs (?glocs *funcall-fwrite-gloc*)))
                ((var-p fun) 
                 ; global-read
                 (make <funcall> :value fun :closure-call t
                       :read-glocs (balance-side-effects1 
                                    (?glocs *funcall-fread-gloc*)
                                    read-glocs)
                       :write-glocs (?glocs *funcall-fwrite-gloc*)))
                (t (error " ~s is no function" fun))))
         (result (make <tempvar> :tnr (dynamic *counter*)))
         (var-vec (make-vector (+ arg-num 1)))
         (inline ()) )
    (setf (dynamic *counter*) (+ (dynamic *counter*) 1))
    (setf (vector-ref var-vec  0) result)
    (setf (?arg-num call) arg-num)
    (setf (?var-descr call) (make <var-descr>
                                  :var-vec var-vec
                                  :constant-counter 0))
    (setf (?type-descr call) (general-var-actual-descr arg-num))
    (setf (?type-descr-s call) ())
; fill the var-descr
    (l2m-call call arg-list)
; constant propagation 
; fill type-descr-s 
    (if (eq fun %cast)
      (progn (setf (vector-ref (?var-vec (?var-descr call))
                               1)
                   (make <cast> 
                         :type 
                         (vector-ref (?var-vec (?var-descr call))
                                     1))))
      ())

    (let ((typedescrs 
           (make-actual-type-descr (dynamic typepathes)
                                   call
                                   (?var-descr call)
                                   arg-num 
                                   ()))
          )
; rename local-static-variable
      (if (and (funcall-p call) (local-static-p (?value call)))
        (let ((tempvar (rename (?value call))))
          (setq fun  tempvar)
          (setf (?value call) fun))
        (progn
; analyse called function first
          (lzs2mzs-fun fun)
; set the inline-flag
          (if (inline-able fun)
            (setq inline t)
; add annotations to called function
            (setf (?applications fun)
                  (cons call (?applications fun))))
          ))
; make a type - inference
      (setq typedescrs 
	(inference fun typedescrs))
      (if (and (generic-fun-p fun) *actual-method-subset*
	       (null (cdr *actual-method-subset*))) ; only one method
	  (progn 
	    (format t "M")
	    (setq fun (?fun (car *actual-method-subset*)))
	    (setf (?function call) fun)
	    (if (inline-able fun) (setq inline t) (setq inline ())))
	())
      (if (null typedescrs) (error "Typeerror")
          (progn
; add the type-descriptors
            (setf (?type-descr-s call) typedescrs)
            (setf (dynamic typepathes) typedescrs))
      )
; inline or not 
    (if inline
      (progn 
        (inline-information fun)
        (link-var-vec var-vec call arg-num)
        (setq result (inline-a last fun var-vec result))
        (unlink-var-vec var-vec call 0 arg-num)
	result
        )
; link variable
    (let ((curblock (dynamic block)))
      (link-var-vec var-vec call arg-num)
      (if (funcall-p call)
        (link-funcall-variable (?value call) call) ())
; add the statement to the Block
      (setf (?block call) curblock)
      (setf (?body curblock) 
            (append-stat (?body curblock) call)) 
          
; add annotation to the function 
    (cond ((null (funcall-p call))
           (setf (dynamic calls)
                 (cons call (dynamic calls)))))
; result 
      result)))))

(defun unlink-var-vec (var-vec call nr arg-num)
  (if (> nr arg-num) var-vec
      (let ((var (vector-ref var-vec nr)))
        (if (or (local-static-p var)
                  (tempvar-p var))
          (setf (?link var) (unlink-var-vec1 (?link var) call))
          ())
        (unlink-var-vec var-vec call (+ nr 1) arg-num))))

(defun unlink-var-vec1 (link call)
  (if link
    (if (eq (car (car link)) call)
      (unlink-var-vec1 (cdr link) call)
      (cons (car link) (unlink-var-vec1 (cdr link) call)))
    ()))


(defun inline-information (foo)
  (format t "i")
;  (let ((fun (analysed-fun)))
;    (format t "~% -------------------------------------------")
;    (format t "~% in ~a function ~a:" 
;            (funtype-of fun) (name-of fun))
;    (format t "~% inline of ~a function ~a"
;            (funtype-of foo) (name-of foo))
;    (format t "~% -------------------------------------------"))
)

; inlining is controlled by the dynamic variable *inline* which is set by the
; configuration 'inline' and which may contain the following values:
; nil - no inlining at all
; 0   - only inlining of slot-accessors and slot-initfunctions if they meet the
;       requirement of (dynamic *inline*) = 1
; n   - inlining takes place if the "complexity" of the function is less than n 
; (dynamic *inline*) is defined in the module 'configuration'

(defun inline-able (fun)
  (if (global-fun-p fun)
    (progn (lzs2mzs-fun fun)
           (if (and (dynamic *inline*)
                    (> (?pass fun) 2))
             (let* ((f-label (?function-label fun))
                    (start-block (?start-block f-label))
                    (end-blocks  (?end-blocks f-label))
                    (calls (?calls fun)))
               (if (and (eq start-block (car end-blocks))
                        (null (cdr end-blocks)))
                 (if (or (module-init-fun-p (analysed-fun))
                         (eq (dynamic *inline*) 0))
                   (and (or (slot-accessor-fun-p fun)
                            (slot-init-fun-p fun))
                        (only-asm-stats-small calls))
                   (only-asm-stats-big calls))
                 ()))
             () ))
    ()))

(defun only-asm-stats-small (stats)
  (let ((nr (only-asm-stats1 stats 0)))
    (if (< nr 1) t ())))

(defun only-asm-stats-big (stats)
  (let ((nr (only-asm-stats1 stats 0)))
    (if (< nr (dynamic *inline*)) t ())))

(defun only-asm-stats1 (stats n)
  (if (null stats) n
      (let ((stat (car stats)))
        (if (or (last-asm-p stat)
                (asm-p stat)
                (and (or (call-p stat) (last-call-p stat))
                     (constructor-fun-p (?function stat))))
          (only-asm-stats1 (cdr stats) n)
          (only-asm-stats1 (cdr stats) (+ n 1))
))))

#module-end