;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: expand-literal -*-
#|
-----------------------------------------------------------------------------------
TITLE: Expand-Literal
-----------------------------------------------------------------------------------
File:    expand-literal.em
Version: 1.5 (last modification on Wed Sep 29 13:21:25 1993)
State:   published

DESCRIPTION:
Provides things to transform literals into instances of <literal-instance>.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/expand-literal.em[1.5]:
  provides only expand-literal to avoid module cycles
[1.1] Fri Aug 27 17:07:15 1993 imohr@isst saved
  [Fri Aug 27 08:03:40 1993] Intention for change:
  + right handling of function objects
[1.2] Mon Aug 30 07:48:17 1993 imohr@isst saved
  some bugs removed
[1.3] Wed Sep  1 18:07:42 1993 imohr@isst published
  
[1.4] Wed Sep 29 11:29:41 1993 imohr@isst proposed
  [Fri Sep 24 15:00:07 1993] Intention for change:
  remove package qualifier machine-description
  %function-literal for generic functions
[1.5] Thu Sep 30 16:15:54 1993 imohr@isst published
  [Wed Sep 29 13:20:16 1993] Intention for change:

-----------------------------------------------------------------------------------
|#

#module-name expand-literal
#module-import
(level-0-eulisp
 lzs accessors
; tail-module using explicitely machine-description::%function
 (only (remove-if-not make-instance mapcan) 
   common-lisp))
#module-syntax-import 
(level-1-eulisp
 (only (push) 
   common-lisp))
#module-syntax-definitions

#module-header-end

(export 
  expand-literal
  %function-literal
  make-literal-instance
  reset-literals
  *literals*
  get-functions-used-in-literals)

(defgeneric expand-literal (literal))

(defun %function-literal (function-object)
  (if (symbolp function-object)
    function-object            ; return ^unknown... as it is
    (make-literal-instance 
     ;%function
     (cl:symbol-value (cl:find-symbol "%FUNCTION" "MACHINE-DESCRIPTION"))
     (list (if (generic-fun-p function-object)
             (?discriminating-fun function-object)
             function-object)))))

(deflocal *literals* nil)

(defun reset-literals ()
  (setq *literals* nil))

(defun make-literal-instance (class value-list)
  (let ((inst (make-instance <literal-instance> 
                :class class
                :value-list value-list)))
    (push inst *literals*)
    inst))

(defmethod get-functions-used-in-literals ()
  (mapcan (lambda (lit)
            (remove-if-not #'fun-p (?value-list lit)))
          *literals*))



#module-end
