;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-basic -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    el2lzs-basic.em
Version: 1.3 (last modification on Mon Jan 31 08:54:48 1994)
State:   published

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/el2lzs-basic.em[1.3]:
  some syntax stuff for el2lzs-*.em
[1.1] Wed Nov 10 13:33:46 1993 imohr@isst proposed
  [Wed Nov 10 13:32:38 1993] Intention for change:
  import of el2lzs-error
[1.2] Thu Jan 13 15:38:31 1994 wheick@isst saved
  done
[1.3] Mon Jan 31 08:55:16 1994 wheick@isst published
  [Thu Jan 13 15:24:56 1994] Intention for change:
  eulisp0
  done

-----------------------------------------------------------------------------------
|#

#module el2lzs-basic
(import (eulisp1
         el2lzs-error
         (only (first get)
           common-lisp)
         (only                      ; for literal expansion only
           (find make-instance mapcar mapc
            warn)
           common-lisp)
         expand-literal
         accessors)
 syntax (eulisp1
         (only (declare ignore)
           common-lisp)
         apply-standard             ; for literal expansion only
         (only (push)               ; for literal expansion only
           common-lisp))
 expose ()
 export ())

;;; -----------------------------------------------------------------------------------
;;;  deftrans: defines a transformation for list-expressions
;;; -----------------------------------------------------------------------------------

(defmacro define-transformation (name)
  `(progn 
     (defgeneric ,name (source))
     (export ,name)
     (defmethod ,name ((expr <pair>))
       (if (check-syntax (get-trans-pattern ',(make-eulisp-symbol name) (car expr))
                         expr)
         (apply (get-trans-function ',(make-eulisp-symbol name) 
                                    (car expr)) 
                expr expr)              ; first expr is for _whole-form_
         nil))
     (defmacro ,(make-identifier (string-append "DEF" (symbol-name name)))
               (pattern result)
       (define-trans ',name pattern result))))

(defun define-trans (trans-function pattern result) 
(let ((trans-function (make-eulisp-symbol trans-function)) 
      (form-keyword (first pattern)))
  (if (symbolp form-keyword)
    (progn
      (setq form-keyword (make-eulisp-symbol (car pattern))) 
      `(progn (setf (get ',form-keyword ',trans-function) 
                    (cons
                     (lambda (_whole-form_ form-keyword ,@(cdr pattern)) 
                       (declare (ignore form-keyword))
                       _whole-form_ ; to avoid warnings by the CL compiler
                       ,result)
                     ',pattern))
              (cons ',trans-function ',pattern)))
    `(progn (setf (get ^t ',trans-function) 
                  (cons
                   (lambda (_whole-form_ ,(first form-keyword) ,@(cdr pattern)) 
                     _whole-form_ ; to avoid error messages by the compiler
                     ,result)
                   nil))
            (cons ',trans-function ',pattern)))))

(defun get-trans-function (trans-function key)
  (car (or (and (symbolp key)
	        (get key trans-function))
           (get ^t trans-function))))

(defun get-trans-pattern (trans-function key)
  (cdr (or (and (symbolp key)
	        (get key trans-function))
           (get ^t trans-function))))

(defmacro whole-form () '_whole-form_)

;;; -----------------------------------------------------------------------------------
;;; check syntax
;;; -----------------------------------------------------------------------------------

(defun check-syntax (pattern expr)
  (if (or (null pattern
                )(and (consp expr)
                      (check-syntax-components pattern expr)))
    t
    (progn (error-invalid-syntax pattern expr)
           nil)))

(defun check-syntax-components (pattern expr)
  (cond ((null pattern)
         (null expr))
        ((atom pattern) 
         (true-list-p expr))
        ((null expr)
         nil)
        ((atom expr)
         nil)
        (t
         (check-syntax-components (cdr pattern) (cdr expr)))))

(defun true-list-p (l)
  (cond ((consp l) (true-list-p (cdr l)))
        ((null l) t)
        (t nil)))

;;; -----------------------------------------------------------------------------------
;;; syntax for el2lzs-literals
;;; -----------------------------------------------------------------------------------
(export 
  expand-literal-using-desc
  <literal-expansion>
  get-literal-expander-arguments 
  add-literal-expander 
  reset-literal-expanders
  expanded-empty-list
  ?module ?expander ?expansions ?slots ?literal-class ?class
  )

(defmacro def-literal-class (literal-class class . slots)
  ;expansion-type: single, multiple
  `(progn
     (push (make-instance <literal-expansion>
             :literal-class ',(make-eulisp-symbol literal-class)
             :class ,class
             :slots (list ,@(mapcar (lambda (slot)
                                      `(cons ',(make-eulisp-symbol (car slot))
                                             ,(cdr slot)))
                                    slots)))
           *literal-expanders*)
     (defmethod expand-literal ((literal ,class))
       (expand-literal-using-desc literal 
                                  (find ,class *literal-expanders* :key #'?class)))))

(defgeneric expand-literal-using-desc (literal exp-desc))

;;; -----------------------------------------------------------------------------------
;;; Literal Expanders

(deflocal *literal-expanders* nil)      ;list of literal-expansion
(deflocal expanded-empty-list nil)

(defstandardclass <literal-expansion> ()
  (literal-class :initarg :reader)
  (class :initarg :reader)
  (expander :accessor :initform nil)
  (module :accessor :initarg)
  (expansions :accessor :initform nil)
  (slots :initarg :reader))

(defun get-literal-expander-arguments (literal-class)
  (let ((exp-desc (find literal-class *literal-expanders* :key #'?literal-class)))
    (if (null exp-desc)
      (warn "invalid literal class: ~A" literal-class)
      (mapcar #'car (?slots exp-desc)))))

(defun add-literal-expander (literal-class expander)
  (let ((exp-desc (find literal-class *literal-expanders* :key #'?literal-class)))
    (if (null exp-desc)
      (warn "invalid literal class: ~A" literal-class)
      (progn (setf (?expander exp-desc) expander)
             (setf (?module exp-desc) (dynamic *current-module*))))))

(defun reset-literal-expanders ()
  (mapc (lambda (exp-desc)
          (setf (?expander exp-desc) nil)
          (setf (?module exp-desc) nil)
          (setf (?expansions exp-desc) nil))
        *literal-expanders*)
  (setq expanded-empty-list ()))


#module-end
