;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: c-data -*-
#|
-----------------------------------------------------------------------------------
TITLE: Code Generator for Data
-----------------------------------------------------------------------------------
File:    c-data.em
Version: 1.11 (last modification on Fri Dec 17 21:28:20 1993)
State:   published

DESCRIPTION:
This modules provides the generation of code for global Variables, named
constants and literals. Only assembly code for the SPARC processor is generated
which can be processed by the SPARC-Assembler from SUN.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:

CONTACT: 

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/c-data.em[1.11]:
  c-code for data
[1.1] Fri Aug 27 17:07:35 1993 imohr@isst saved
  [Thu Aug 26 09:55:01 1993] Intention for change:
  --- no intent expressed ---+ function objects
[1.2] Mon Aug 30 13:50:26 1993 imohr@isst saved
  collection of GC root addresses simplified
  collection of literals ok
[1.3] Tue Aug 31 12:07:21 1993 imohr@isst saved
  
[1.4] Tue Aug 31 12:11:15 1993 imohr@isst saved
  
[1.5] Wed Sep  1 18:11:47 1993 imohr@isst proposed
  
[1.6] Thu Sep  2 14:56:53 1993 imohr@isst proposed
  
[1.7] Mon Sep  6 16:41:41 1993 imohr@isst published
  bug removed in initialization of GC for static vectors
[1.8] Fri Sep 10 11:20:27 1993 imohr@isst published
  length of vector literals now in bytes
[1.9] Mon Nov  8 09:01:51 1993 imohr@isst proposed
  + suppression of gc for classes
[1.10] Fri Nov 26 10:28:06 1993 imohr@isst proposed
  [Fri Nov 26 09:03:51 1993] Intention for change:
  STAG and VTAG to make tagging of structures and vectors variable
[1.11] Sat Dec 18 15:46:27 1993 imohr@isst published
  [Fri Dec 17 21:22:09 1993] Intention for change:

-----------------------------------------------------------------------------------
|#

#module-name c-data

#module-import
(level-1-eulisp list-ext
 el2lzs-literals
 code-identifier
 c-typing
 machine-description
 expand-literal
 lzs
 lzs-mop
 accessors
 (only (configurationp) configuration)
 (only (format mapc stringp make-list char subseq char-code find
        princ alphanumericp remove reverse
        mapcan nconc
        make-instance)
   common-lisp))

#module-syntax-import 
(level-1-eulisp
 (only (with-output-to-string
        push
        dolist)
   common-lisp))

#module-syntax-definitions

#module-header-end

(export 
  generate-c-data
  get-instance
  reset-c-data
  make-c-string
  disable-gc
  )

;;; -----------------------------------------------------------------------------------
;;; variables and reset
;;; -----------------------------------------------------------------------------------

(deflocal *structure-roots* nil)
(deflocal *vector-roots* nil)

(defun reset-c-data ()
  (setq *structure-roots* nil)
  (setq *vector-roots* nil))

;;; -----------------------------------------------------------------------------------
;;; code output
;;; -----------------------------------------------------------------------------------

(defun write-data (format . args)
  (apply #'format (dynamic code-output) format args))

;;; -----------------------------------------------------------------------------------
;;; generate-c-data
;;; -----------------------------------------------------------------------------------

(defun generate-c-data ()
  (setq *literals* (reverse *literals*))
  (when (configurationp ':fixed-precision-integer ':small) 
    (write-data "~%SMALL_INT_SKIP;"))
  (mapc (lambda (lit)
          (literal-declaration lit 
                               (?class lit) 
                               (?representation (?class lit))))
        *literals*)
  (mapc (lambda (literal)
          (literal-definition literal
                              (?class literal)
                              (?representation (?class literal)))) 
        *literals*)
  (write-data "~2%void *STRUCTURE_ROOTS[~A] = {~{~%~A,~} 0};"
                (+ (length *structure-roots*) 1)
                *structure-roots*)
  (write-data "~2%struct VECTOR_ROOTS{int length; void **pointer;}VECTOR_ROOTS[~A] ~
               = {~{~%~A,~} {0, 0}};~%"
                (+ (length *vector-roots*) 1)
                *vector-roots*))

;;; -----------------------------------------------------------------------------------
;;; disabling gc for literals
;;; -----------------------------------------------------------------------------------

(defgeneric disable-gc (literal))

(defmethod disable-gc (literal) nil)

(defmethod disable-gc ((class <defined-class>))
  (disable-gc (expand-literal class)))

(defmethod disable-gc ((literal <literal-instance>))
  (unless (?gc-not-needed literal)
    (setf (?gc-not-needed literal) t)
    (mapc #'disable-gc (?value-list literal))))

;;; -----------------------------------------------------------------------------------
;;; collection of root addresses for GC
;;; -----------------------------------------------------------------------------------

(defun add-structure-root (literal slot)
  (unless (?gc-not-needed literal)
    (push (format nil "~:/EXPR/.~A" 
                  literal
                  (c-identifier slot))
          *structure-roots*)))

(defun add-vector-root (length literal)
  (unless (?gc-not-needed literal)
    (push (format nil "{~A, (void**)~/EXPR/}"
                  length
                  literal)
          *vector-roots*)))

;;; -----------------------------------------------------------------------------------
;;; Declaring Literals
;;; -----------------------------------------------------------------------------------
(defgeneric literal-declaration (literal class representation))

(defmethod literal-declaration (literal class 
                                    (representation <%pointer-to-struct>))
  (write-data "~%S_LITERAL(~A, ~A);"
              (type-identifier (?class literal))
              (c-identifier literal)))

(defmethod literal-declaration (literal class 
                                    (representation <%pointer-to-vector>))
  (write-data "~%V_LITERAL(~A, ~A, ~A);"
              (type-identifier (~vector-class-element-type class))
              (c-identifier literal)
              (get-length-of-vector-literal literal class)))

(defmethod literal-declaration (literal (class <tail-class-def>) 
                                    representation)
  nil)

(defmethod literal-declaration (literal class representation)
  nil)

;;; -----------------------------------------------------------------------------------
;;; Defining Literals (with initial value)
;;; -----------------------------------------------------------------------------------

(defgeneric literal-definition (literal class representation))

(defmethod literal-definition (literal class representation)
  nil)

(defmethod literal-definition (literal class (representation <%direct>))
  ; direct can be used only for class mappings to basic classes like
  ; %signed-word-integer 
  (let ((class (~slot-description-type (car (~class-slot-descriptions class)))))
    (literal-definition literal class (?representation class))))

(defmethod literal-definition (literal class 
                                       (representation <%pointer-to-struct>))
  
  (write-data "~%LITERAL(~A) = {STAG(~:/EXPR/), {~{~:/EXPR/~^, ~}}};"
              (c-identifier literal)
              class
              (get-structure-components 
               literal
               (?value-list literal)
               (~class-slot-descriptions class))))

(defmethod literal-definition (literal (class <tail-class-def>) 
                                       (representation <%pointer-to-struct>))
  (write-data "~%struct ~A ~A = {~{~:/EXPR/~^, ~}};"
              (type-identifier class)
              (c-identifier literal)
              (get-structure-components 
               literal
               (?value-list literal)
               (~class-slot-descriptions class))))

(defmethod literal-definition (literal class 
                                       (representation <%pointer-to-vector>))
  (let* ((length (get-length-of-vector-literal literal class))
         (element-type (~vector-class-element-type class))
         (components (get-vector-components 
                      length
                      (second (?value-list literal))    ; the components
                      element-type)))
    (if (stringp components)
      (write-data "~%LITERAL(~A) = {VTAG(~A, ~:/EXPR/), \"~A\"};"
                  (c-identifier literal)
                  length
                  class
                  components)
      (progn 
        (when (is-pointer element-type)
          (add-vector-root length literal))
        (write-data "~%LITERAL(~A) = {VTAG(~A*sizeof(~A), ~:/EXPR/), {~{~:/EXPR/~^, ~}}};"
                    (c-identifier literal)
                    length
                    (type-identifier element-type)
                    class
                    components)))))

;tail vectors are stored like lisp vectors to make the length available
;(defmethod literal-definition (literal (class <tail-class-def>) 
;                                       (representation <%pointer-to-vector>))
;  (let* ((length (get-length-of-vector-literal literal class))
;         (element-type (~vector-class-element-type class))
;         (components (get-vector-components 
;                      length
;                      (second (?value-list literal))    ; the components
;                      element-type)))
;    (if (stringp components)
;      (write-data "~%~A ~A = \"~A\";"
;                  (type-identifier class)
;                  (c-identifier literal)
;                  components)
;      (progn 
;        (when (is-pointer element-type)
;          (add-vector-root length literal))
;        (write-data "~%~A ~A[~A] = {~{~:/EXPR/~^, ~}};"
;                    (type-identifier (~vector-class-element-type class))
;                    (c-identifier literal)
;                    length
;                    components)))))

(defmethod literal-definition (literal (class <%string>) 
                                       representation)
  nil)

(defconstant $unknown-initializer
  (make-literal-instance 
    %unsigned-word-integer
    '(0)))

(defun get-structure-components (literal values slots)
  (if (null values) nil
      (progn 
        (when (is-pointer (~slot-description-type (car slots)))
          (add-structure-root literal (car slots)))
        (cons (if (eq (car values) ^unknown)
                $unknown-initializer
                (type-expr-for-c (~slot-description-type (car slots))
                                 (car values)))
              (get-structure-components literal (cdr values) (cdr slots))))))

(defun get-length-of-vector-literal (literal class)
  (setf (first (?value-list literal))
        (or (first (?value-list literal))     ; the length spec in literal
            (~vector-class-instance-length class) ; defined length in class
            (length (second (?value-list literal))) ;the length of the given sequence
            )))

(defgeneric get-vector-components (length components class))

(defmethod get-vector-components (length components class)
  (cond ((= length 0) nil)
        ((null components) 
         nil)
        ((null (cdr components))
         (make-list length 
                    :initial-element (type-expr-for-c class 
                                                      (car components))))
        (t 
         (cons (type-expr-for-c class 
                                (car components))
               (get-vector-components (- length 1)
                                      (cdr components)
                                      class)))))

(defmethod get-vector-components (length (components <string>) 
                                         (class <%unsigned-byte-integer>))
  (cond ((< length (length components))
         (string-code (subseq components 0 length) length #\space))
        ((= length (length components))
         (string-code components length #\space))
        (t 
         (string-code components length
                      (char components (- (length components) 1))))))

;;; -----------------------------------------------------------------------------------
;;; Strings
;;; -----------------------------------------------------------------------------------

(defun string-code (string length padchar)
  (convert-to-c-string (format nil "~V,,,VA" length padchar string)))

(defun convert-to-c-string (string)
    (with-output-to-string (c-string)
      (cl:map nil
              (lambda (char)
                (princ (cond ((alphanumericp char) char)
                             ((find char " !#$%&'()*+,-./:;<=>?@[]^_`{|}~")
                              char)
                             ((eq char #\0) "\\a")
                             ((eq char #\backspace) "\\b")
                             ((eq char #\page) "\\f")
                             ((eq char #\newline) "\\n")
                             ((eq char #\return) "\\r")
                             ((eq char #\tab) "\\t")
                             ((eq char #\?) "\\?")
                             ((eq char #\') "\\'")
                             ((eq char #\") "\\\"")
                             ((eq char #\\) "\\\\")
                             (t (format nil "\\~3,'0O" (char-code char))))
                       c-string))
              string)))

(defun make-c-string (literal)
  (get-vector-components (get-length-of-vector-literal literal (?class literal))
                         (second (?value-list literal))
                         (~vector-class-element-type (?class literal))))

#module-end
