;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: binding -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    binding.em
Version: 1.2 (last modification on Mon Feb  7 10:42:51 1994)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/binding.em[1.2]:
  
[1.1] Mon Jan 31 14:48:23 1994 ukriegel@isst proposed
  [Mon Jan 31 14:47:39 1994] Intention for change:
  copyright
  done
[1.2] Mon Feb  7 11:31:27 1994 imohr@isst published
  [Mon Feb  7 10:40:09 1994] Intention for change:
  repair finally-refered-object

-----------------------------------------------------------------------------------
|#

#module binding
(import (level-0-eulisp
         apply-standard
         accessors
         (only (make-instance call-next-method)
           common-lisp))
 syntax (level-0-eulisp
         apply-standard)
 export (<binding>
         binding-p
         make-binding
         finally-refered-object 
         get-lzs-object)
 )

;;; -----------------------------------------------------------------------------------
;;; bindings
;;; -----------------------------------------------------------------------------------

(defstandardclass <binding> ()
  (identifier :reader :initarg)
  (code-identifier :accessor :initform ())
  (refers-to :reader :initarg)
  (refers-finally-to :accessor :initform ())
  :predicate)

(defun make-binding options
  (let ((binding (apply #'make-instance <binding> options)))
    (setf (?refers-finally-to binding) 
          (finally-refered-object (?refers-to binding)))
    binding))

(defgeneric finally-refered-object (obj))
(defmethod finally-refered-object (obj) obj)
(defmethod finally-refered-object ((obj <binding>))
  (or (?refers-finally-to obj)
    (setf (?refers-finally-to obj)
          (finally-refered-object (?refers-to obj)))))

(defmethod ?exported ((ref <binding>))
  (?exported (?refers-finally-to ref)))

(defun get-lzs-object (object)
  ;; get-lzs-object returns the object finally refered to if object is a
  ;; renamed object or otherwise returns its argument 
  (if (binding-p object)
    (?refers-finally-to object)
    object))


#module-end
