;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: apply-funs -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-----------------------------------------------------------------------------------
TITLE: Providing LZS-Objects definied in the Application Module APPLY
-----------------------------------------------------------------------------------
File:    apply-funs.em
Version: 1.31 (last modification on Thu Feb  3 10:54:18 1994)
State:   published

DESCRIPTION:
The function set-apply-funs sets some variables to LZS-objects extracted from
the lexical environment of the module APPLY. The variables are all exported. The
function set-apply-funs can be called after! the module apply was loaded.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Dist/Apply/apply-funs.em[1.31]:
  
[1.1] Fri Apr  2 16:28:11 1993 ukriegel@isst proposed
  [Fri Apr  2 16:17:55 1993] Intention for change:
  include names of trace functions
  trace-pair, trace-noting, trace-pointer, trace-general-object included
[1.2] Wed Apr  7 13:45:29 1993 ukriegel@isst proposed
  [Wed Apr  7 13:32:36 1993] Intention for change:
  add functions for run-time intialization of mm
  set/make-card/type-descriptor added
[1.3] Thu Apr  8 11:26:25 1993 hfried@isst proposed
  [Thu Apr  8 09:17:34 1993] Intention for change:
  add closure-functions
  done
[1.4] Thu Apr  8 11:56:32 1993 ukriegel@isst saved
  [Thu Apr  8 11:32:21 1993] Intention for change:
  add last-used-card-descriptor last-used-type-descriptor
  max-used-type-descriptor
  max-used-card-descriptor
[1.5] Thu Apr  8 13:25:25 1993 ukriegel@isst proposed
  [Thu Apr  8 13:12:31 1993] Intention for change:
  add allocation functions
  added
[1.6] Thu Apr  8 15:04:53 1993 ukriegel@isst proposed
  [Thu Apr  8 15:01:41 1993] Intention for change:
  add class-mm-type class-mm-card
  done
[1.7] Wed Apr 14 12:15:18 1993 ukriegel@isst saved
  done
[1.8] Wed Apr 14 14:38:08 1993 ukriegel@isst saved
  [Wed Apr 14 14:36:18 1993] Intention for change:
  add class-mm-card class-mm-type to export list
  done
[1.9] Thu Apr 15 08:31:52 1993 ukriegel@isst saved
  [Thu Apr 15 08:21:54 1993] Intention for change:
  spit appl-funs into apply-objects and mm-objects
  done
[1.10] Thu Apr 15 09:20:54 1993 ukriegel@isst saved
  done
[1.11] Thu Apr 15 09:21:29 1993 ukriegel@isst proposed
  
[1.12] Thu Apr 29 08:10:08 1993 ukriegel@isst published
  [Wed Apr 28 18:32:39 1993] Intention for change:
  add object-size - needed for vector-classes
  done
[1.13] Thu Apr 29 14:01:19 1993 ukriegel@isst saved
  [Thu Apr 29 13:54:04 1993] Intention for change:
  object-size -> %vector-instance-size
  done
[1.14] Thu Apr 29 14:38:26 1993 ukriegel@isst proposed
  [Thu Apr 29 14:32:02 1993] Intention for change:
  set-level-2-objects
  done
[1.15] Mon May 10 14:02:33 1993 ukriegel@isst proposed
  [Mon May 10 13:58:11 1993] Intention for change:
  incorporate <pointer-to-void>
  done
[1.16] Thu Jun 17 11:19:25 1993 imohr@isst proposed
  [Thu Jun 17 11:16:24 1993] Intention for change:
  cons
  ok
[1.17] Tue Jun 29 09:03:04 1993 hfried@isst proposed
  [Mon Jun 28 13:06:00 1993] Intention for change:
  nullfun & eqfun
[1.18] Tue Jul  6 11:41:41 1993 ukriegel@isst proposed
  [Fri Jul  2 13:54:41 1993] Intention for change:
  largest-predefined-type-descriptor added to level-1
[1.19] Wed Aug 18 11:44:54 1993 hfried@isst saved
  [Wed Aug 18 09:37:43 1993] Intention for change:
  add closure-functions
[1.20] Thu Aug 19 11:23:22 1993 imohr@isst proposed
  [Thu Aug 19 11:19:55 1993] Intention for change:
  + %class-of
  ok
[1.21] Tue Aug 31 12:10:49 1993 hfried@isst proposed
  [Fri Aug 27 10:32:29 1993] Intention for change:
  add funcall & apply
[1.22] Wed Sep  1 18:07:52 1993 imohr@isst proposed
  [Wed Sep  1 15:29:23 1993] Intention for change:
  + set-lowest-type/card-descriptor
[1.23] Wed Sep 15 15:02:41 1993 hfried@isst proposed
  [Wed Sep  8 13:27:07 1993] Intention for change:
  add %std-discr
[1.24] Mon Sep 20 13:15:47 1993 imohr@isst proposed
  [Mon Sep 20 09:02:01 1993] Intention for change:
  + retrieving <list> from apply-level-2
[1.25] Fri Oct  1 18:47:36 1993 imohr@isst proposed
  [Fri Oct  1 15:06:58 1993] Intention for change:
  lonjmp
[1.26] Wed Oct 13 15:24:14 1993 ukriegel@isst proposed
  [Wed Oct 13 14:22:44 1993] Intention for change:
  no-applicable-method-error, typecheck
[1.27] Fri Oct 15 07:41:19 1993 hfried@isst proposed
  [Wed Oct 13 15:38:21 1993] Intention for change:
[1.28] Mon Oct 18 11:41:00 1993 hfried@isst published
  [Mon Oct 18 10:57:19 1993] Intention for change:
  add call-next-method, next-method-p
[1.29] Fri Jan  7 16:18:11 1994 ukriegel@isst saved
  [Fri Jan  7 14:05:10 1994] Intention for change:
  add $mtss $stss $stms
  done
[1.30] Mon Jan 31 09:29:19 1994 akind@isst proposed
  [Mon Jan 10 11:23:57 1994] Intention for change:
  new variable binding <function> and <null>
[1.31] Mon Feb  7 08:25:39 1994 imohr@isst published
  [Thu Feb  3 08:33:41 1994] Intention for change:
  retrieving class-mm-...-functions from class %class
  new slot access and imported classes ok 

-----------------------------------------------------------------------------------
|#

#module-name apply-funs
#module-import
(level-0-eulisp
 el2lzs
 lzs accessors
 tail-module)
#module-syntax-import 
(level-0-eulisp)
#module-syntax-definitions

#module-header-end

(export 
  set-apply-objects
  set-apply-level-1-objects
  set-apply-level-2-objects
;;; -----------------------------------------------------------------------------------
;;; apply-level-1-objects begin
;;; -----------------------------------------------------------------------------------

  trace-pair
  trace-pointer
  trace-nothing
  trace-general-object
  make-type-descriptor
  make-card-descriptor
  set-type-descriptor
  set-card-descriptor
  set-lowest-used-type-descriptor
  set-lowest-used-card-descriptor
  set-class-mm-type
  set-class-mm-card
  class-mm-type
  class-mm-card
  allocate-on-single-card
  allocate-on-multiple-type-card
  allocate-on-multiple-size-card

  $mtss
  $stms
  $stss

  max-used-card-descriptor
  max-used-type-descriptor
  $largest-predefined-type-descriptor
  <pointer-to-void>
;;; -----------------------------------------------------------------------------------
;;; apply-level-1-objects end
;;; -----------------------------------------------------------------------------------
;;; -----------------------------------------------------------------------------------
;;; apply-level-2-objects begin
;;; -----------------------------------------------------------------------------------
  
  %instance-of-p
  %class-of
  
  %vector-class-instance-size

  %cons %list <null>-class <function>-class <fpi>-class
  nullfun
  eqfun
  test-functions
  no-applicable-method-error
  %call-next-method
  %next-method-p
  typecheck
 
;;; -----------------------------------------------------------------------------------
;;; apply-level-2-objects end
;;; -----------------------------------------------------------------------------------

  %initialize-class  

  ; for closures
  %closure-push ; (var closure-or-())
  %closure-value ; (closure pos-fixnum)
  %set-closure-value ; (closure pos-fixnum value)
  %make-function ; (closure function)
  ; for function-call
  %apply ; (fun . args)
  %apply1 ; (fun args)
  %apply2 ; (fun arg1 args)
  %apply3 ; (fun arg1 arg2 args)
  %apply4 ; (fun arg1 arg2 arg3 args)
  %apply5 ; (fun arg1 arg2 arg3 arg4 args)
  %apply6 ; (fun arg1 arg2 arg3 arg4 arg5 args)
  %apply7 ; (fun arg1 arg2 arg3 arg4 arg5 arg6 args)
  %apply8 ; (fun arg1 arg2 arg3 arg4 arg5 arg6 arg7 args)

  %funcall0 ; (fun)
  %funcall1 ; (fun arg1)
  %funcall2 ; (fun arg1 arg2)
  %funcall3 ; (fun arg1 arg2 arg3)
  %funcall4 ; (fun arg1 arg2 arg3 arg4)
  %funcall5 ; (fun arg1 arg2 arg3 arg4 arg5)
  %funcall6 ; (fun arg1 arg2 arg3 arg4 arg5 arg6)
  %funcall7 ; (fun arg1 arg2 arg3 arg4 arg5 arg6 arg7)
  %funcall8 ; (fun arg1 arg2 arg3 arg4 arg5 arg6 arg7)

;let/cc, dynamic, unwind-protect
  %unwind
  %stop-unwind-before
  %continue-at
  %unwind-continue
  %letcc-result
  %dynamic
  %top-dynamic
  %get-dynamic
  %set-dynamic
  %make-dynamic
;;; -----------------------------------------------------------------------------------
;;; apply objects end
;;; -----------------------------------------------------------------------------------

  apply-environment

  )

;;; -----------------------------------------------------------------------------------
;;; apply-level-1-objects begin
;;; -----------------------------------------------------------------------------------
 
(deflocal trace-pair ())
(deflocal trace-pointer ())
(deflocal trace-nothing ())
(deflocal trace-general-object ())
(deflocal make-type-descriptor ())
(deflocal make-card-descriptor ())
(deflocal set-type-descriptor ())
(deflocal set-card-descriptor ())
(deflocal set-lowest-used-type-descriptor ())
(deflocal set-lowest-used-card-descriptor ())
(deflocal set-class-mm-type ())
(deflocal set-class-mm-card ())
(deflocal class-mm-type ())
(deflocal class-mm-card ())
(deflocal allocate-on-single-card ())
(deflocal allocate-on-multiple-type-card ())
(deflocal allocate-on-multiple-size-card ())
(deflocal $mtss ())
(deflocal $stms ())
(deflocal $stss ())

(deflocal max-used-card-descriptor ())
(deflocal max-used-type-descriptor ())
(deflocal $largest-predefined-type-descriptor ())
(deflocal <pointer-to-void> ())

;;; -----------------------------------------------------------------------------------
;;; apply-level-1-objects end
;;; -----------------------------------------------------------------------------------
;;; -----------------------------------------------------------------------------------
;;; apply-level-2-objects begin
;;; -----------------------------------------------------------------------------------

(deflocal %instance-of-p ())
(deflocal %class-of ())
(deflocal %vector-class-instance-size ())
(deflocal %list ())
(deflocal %cons ())
(deflocal <null>-class ())
(deflocal <function>-class ())
(deflocal <fpi>-class ())
(deflocal nullfun ())
(deflocal eqfun ())
(deflocal test-functions ())
(deflocal no-applicable-method-error ())
(deflocal %call-next-method ())
(deflocal %next-method-p ())
(deflocal typecheck ())

;;; -----------------------------------------------------------------------------------
;;; apply-level-2-objects end
;;; -----------------------------------------------------------------------------------
 
(deflocal %initialize-class ())
; for closures
(deflocal %closure-push ())
(deflocal %closure-value ())
(deflocal %set-closure-value ())
(deflocal %make-function ())

  ; for function-call
(deflocal   %apply   ()) ; (fun . args)
(deflocal   %apply1 ()) ; (fun args)
(deflocal   %apply2 ()) ; (fun arg1 args)
(deflocal   %apply3 ()) ; (fun arg1 arg2 args)
(deflocal   %apply4 ()) ; (fun arg1 arg2 arg3 args)
(deflocal   %apply5 ()) ; (fun arg1 arg2 arg3 arg4 args)
(deflocal   %apply6 ()) ; (fun arg1 arg2 arg3 arg4 arg5 args)
(deflocal   %apply7 ()) ; (fun arg1 arg2 arg3 arg4 arg5 arg6 args)
(deflocal   %apply8 ()) ; (fun arg1 arg2 arg3 arg4 arg5 arg6 arg7 args)

(deflocal   %funcall0 ()) ; (fun)
(deflocal   %funcall1 ()) ; (fun arg1)
(deflocal   %funcall2 ()) ; (fun arg1 arg2)
(deflocal   %funcall3 ()) ; (fun arg1 arg2 arg3)
(deflocal   %funcall4 ()) ; (fun arg1 arg2 arg3 arg4)
(deflocal   %funcall5 ()) ; (fun arg1 arg2 arg3 arg4 arg5)
(deflocal   %funcall6 ()) ; (fun arg1 arg2 arg3 arg4 arg5 arg6)
(deflocal   %funcall7 ()) ; (fun arg1 arg2 arg3 arg4 arg5 arg6 arg7)
(deflocal   %funcall8 ()) ; (fun arg1 arg2 arg3 arg4 arg5 arg6 arg7)

;let/cc, dynamic, unwind-protect
(deflocal %unwind ())
(deflocal %stop-unwind-before ())
(deflocal %continue-at ())
(deflocal %unwind-continue ())
(deflocal %letcc-result ())
(deflocal %dynamic ())
(deflocal %top-dynamic ())
(deflocal %get-dynamic ())
(deflocal %set-dynamic ())
(deflocal %make-dynamic ())
;;; -----------------------------------------------------------------------------------
;;; apply objects end
;;; -----------------------------------------------------------------------------------

(deflocal apply-environment ())


(defun set-apply-objects ()
  (setq %initialize-class (find-lexical ^%initialize-class ^apply))
  ; for closures
  (setq %closure-push (find-lexical ^%closure-push ^apply))
  (setq %closure-value (find-lexical ^%closure-value ^apply))
  (setq %set-closure-value (find-lexical ^%set-closure-value ^apply))
  (setq %make-function (find-lexical ^%make-function ^apply))
  ; for function-call
  (setq %apply   (find-lexical ^apply ^function)) 
  (setq %apply1 (find-lexical ^%apply1 ^function)) 
  (setq %apply2 (find-lexical ^%apply2 ^function)) 
  (setq %apply3 (find-lexical ^%apply3 ^function)) 
  (setq %apply4 (find-lexical ^%apply4 ^function)) 
  (setq %apply5 (find-lexical ^%apply5 ^function)) 
  (setq %apply6 (find-lexical ^%apply6 ^function)) 
  (setq %apply7 (find-lexical ^%apply7 ^function)) 
  (setq %apply8 (find-lexical ^%apply8 ^function)) 

  (setq %funcall0 (find-lexical ^%funcall0 ^function)) 
  (setq %funcall1 (find-lexical ^%funcall1 ^function)) 
  (setq %funcall2 (find-lexical ^%funcall2 ^function)) 
  (setq %funcall3 (find-lexical ^%funcall3 ^function)) 
  (setq %funcall4 (find-lexical ^%funcall4 ^function)) 
  (setq %funcall5 (find-lexical ^%funcall5 ^function)) 
  (setq %funcall6 (find-lexical ^%funcall6 ^function)) 
  (setq %funcall7 (find-lexical ^%funcall7 ^function)) 
  (setq %funcall8 (find-lexical ^%funcall8 ^function)) 

  (setq %unwind             (find-lexical ^unwind ^apply))
  (setq %stop-unwind-before (find-lexical ^stop-unwind-before ^apply))
  (setq %continue-at        (find-lexical ^continue-at ^apply))
  (setq %unwind-continue    (find-lexical ^unwind-continue ^apply))
  (setq %letcc-result       (find-lexical ^letcc-result ^apply))
  (setq %dynamic            (find-lexical ^<dynamic> ^apply))
  (setq %top-dynamic        (find-lexical ^top-dynamic ^apply))
  (setq %get-dynamic        (find-lexical ^%dynamic ^apply))
  (setq %set-dynamic        (find-lexical ^%dynamic-setq ^apply))
  (setq %make-dynamic       (find-lexical ^make-dynamic ^apply))
  
  (setq apply-environment (?lex-env (find-module ^apply)))
  )

(defun set-apply-level-1-objects ()
  (setq trace-pair (find-lexical ^trace-pair ^apply-level-1))
  (setq trace-pointer (find-lexical ^trace-pointer ^apply-level-1))
  (setq trace-nothing (find-lexical ^trace-nothing ^apply-level-1))
  (setq trace-general-object (find-lexical ^trace-general-object ^apply-level-1))
  (setq make-type-descriptor (find-lexical ^make-type-descriptor ^apply-level-1))
  (setq make-card-descriptor (find-lexical ^make-card-descriptor ^apply-level-1))
  (setq set-type-descriptor (find-lexical ^set-type-descriptor ^apply-level-1))
  (setq set-card-descriptor (find-lexical ^set-card-descriptor ^apply-level-1))
  (setq set-lowest-used-type-descriptor 
        (find-lexical ^set-lowest-used-type-descriptor ^apply-level-1))
  (setq set-lowest-used-card-descriptor 
        (find-lexical ^set-lowest-used-card-descriptor ^apply-level-1))
  (setq set-class-mm-type (find-lexical ^set-class-mm-type ^apply-level-1))
  (setq set-class-mm-card (find-lexical ^set-class-mm-card ^apply-level-1))
  (setq class-mm-type (find-lexical ^class-mm-type ^apply-level-1))
  (setq class-mm-card (find-lexical ^class-mm-card ^apply-level-1))
  (setq allocate-on-single-card (find-lexical ^allocate-on-single-card ^apply-level-1))
  (setq allocate-on-multiple-type-card (find-lexical ^allocate-on-multiple-type-card ^apply-level-1))
  (setq allocate-on-multiple-size-card (find-lexical
                                        ^allocate-on-multiple-size-card ^apply-level-1))
  (setq $mtss (find-lexical ^mtss ^apply-level-1))
  (setq $stms (find-lexical ^stms ^apply-level-1))
  (setq $stss (find-lexical ^stss ^apply-level-1))


  (setq max-used-card-descriptor (find-lexical ^max-used-card-descriptor ^apply-level-1))
  (setq max-used-type-descriptor (find-lexical ^max-used-type-descriptor
                                               ^apply-level-1))
  (setq $largest-predefined-type-descriptor (find-lexical ^$largest-predefined-type-descriptor
                                               ^apply-level-1))
  (setq <pointer-to-void> (find-lexical ^<pointer-to-void> ^apply-level-1)))

(defun set-apply-level-2-objects ()
  (setq %instance-of-p (find-lexical ^%instance-of-p ^apply-level-2))
  (setq %class-of (find-lexical ^%class-of ^apply-level-2))
  (setq %vector-class-instance-size (find-lexical ^%vector-class-instance-size
                                                  ^apply-level-2))
  (setq %list (find-lexical ^<list> ^apply-level-2))
  (setq %cons (find-lexical ^cons ^apply-level-2))
  (setq <null>-class (find-lexical ^<null> ^apply-level-2))
  (setq <fpi>-class (find-lexical ^<fixed-precision-integer> ^apply-level-2))
  (setq <function>-class (find-lexical ^<function> ^apply-level-2))

  (setq nullfun (find-lexical ^null ^apply-level-2))

  (setq eqfun (find-lexical ^eq ^apply-level-2))
  (setq test-functions (list %neq %eq %gt %lt %ge %le))
  (setq no-applicable-method-error (find-lexical ^no-applicable-method-error
                                                 ^apply-level-2))
  (setq %call-next-method (find-lexical ^call-next-method
                                                 ^apply-level-2))
  (setq %next-method-p (find-lexical ^next-method-p
                                                 ^apply-level-2))
  (setq typecheck (find-lexical ^typecheck  ^apply-level-2)))

#module-end
