;;; -*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: (mcs (lisp)) -*-

;;;           Copyright  1990    BY
;;;           G M D  
;;;           Postfach 1240
;;;           D-5205 St. Augustin
;;;           FRG

;;; -----------------------------------------------------------------------------------
;;;
;;; description:    This is the Module File of MCS.
;;;
;;; notes:          Version 1.3 (13.05.91)
;;;
;;; contact:        Juergen Kopp, Harry Bretthauer
;;;
;;; history:
;;;          date:      author:             comments:
;;;          27.04.90   Harry Bretthauer    initial version
;;;          22.05.90   Harry Bretthauer    Version 0.9
;;;          17.06.90   Harry Bretthauer    Version 0.91
;;;          10.07.90   Harry Bretthauer    Version 0.92
;;;          20.07.90   Juergen Kopp        Version 0.93
;;;                                         file laod-fns removed

;;;          18.10.90   Harry Bretthauer    Version 1.0
;;;          22.11.90   Juergen Kopp        exports
;;;          29.01.91   Harry Bretthauer    Version 1.1
;;;          01.02.91   Harry Bretthauer    Version 1.2 working
;;;                                         shadow for CLOS
;;;                                         shadow and define FUNCTION for :PROCEYON
;;;          13.05.91   Juergen Kopp        Version 1.3 (docu)
;;;          14.05.91   Juergen Kopp        TI patch
;;; -----------------------------------------------------------------------------------

;;; Define (module and) package

(in-package  "MCS" :use '("LISP"))

;;; MCS Version Number:

(defvar *mcs-version* "MCS 1.3 of 13.05.91")

;;; ***********************************************************************************
;;; The following four global variables have to be adapted by the user !!!!

;;; Define source and binary path-name, source-file and compiled-file extension.

(defvar *mcs-source-path-name*		;; where to find the sources of mcs
  #+:CCL (pathname-directory ccl::*loading-file-source-file*)
  #+:EXCL (subseq (namestring user::*source-pathname*)
               0
               (- (length (namestring user::*source-pathname*)) 8))
  #+:LUCID (subseq (namestring user::*source-pathname*)
               0
               (- (length (namestring user::*source-pathname*)) 8))
  #+:TI (subseq (namestring sys:fdefine-file-pathname)
                0
                (- (length (namestring sys:fdefine-file-pathname)) 3))
  #+:PROCYON ":mcs:source:")

(defvar *mcs-binary-path-name*		;; where to find/put the binaries of mcs
      (concatenate 'string
                   (subseq *mcs-source-path-name*
                           0 (- (length *mcs-source-path-name*) 7))
                   "binary"
                   (subseq *mcs-source-path-name*
                           (- (length *mcs-source-path-name*) 1)
                           (length *mcs-source-path-name*))))

(defvar *source-file-extension*
  #+:CCL ".lisp"
  #+:EXCL ".lisp"
  #+:LUCID ".lisp"
  #+:TI ".lisp"
  #+:PROCYON ".lisp")

(defvar *compiled-file-extension*
  #+:CCL ".fasl"
  #+:EXCL ".fasl"
  #+:LUCID ".sbin"
  #+:TI ".xld"
  #+:PROCYON ".fasl")

;;; ***********************************************************************************


;;; shadows for TI lisp

#+ :TI (shadow '(make-instance defmethod undefmethod))
#+ :PROCYON (shadow '(function))

#+(or :PROCYON (and :CLOS :EXCL))
   (shadow '(defclass defmethod defgeneric 
             make-instance allocate-instance
             initialize-instance reinitialize-instance
             class-of print-object change-class
             slot-value                    
          slot-exists-p
          slot-boundp
          slot-makunbound
          
          next-method-p
          call-next-method
              slot-unbound
          slot-missing
          no-applicable-methods
          find-method
          remove-method
          compute-applicable-methods
          method-p
          add-method
          method-name
          method-lambda-list
          method-specializers
          method-qualifiers
          method-function
          
          make-method-lambda 
          
          ;; initargs
          name lambda-list specializers qualifiers 
          find-class
          ensure-class
          class-p
          mixin-p
          abstract-p
          metaclass-p
          class-name
          class-precedence-list
          class-direct-superclasses
          class-direct-subclasses
          class-direct-methods
          class-direct-slots
          class-slots
          class-prototype
          find-slot

          make-reader
          make-writer
          
          ;; initargs
          name direct-superclasses direct-slots direct-initargs
          validate-superclass
          finalize-inheritance
          compute-class-precedence-list
          compute-effective-slot-definition
          compute-slots

          direct-slot-definition-class
          effective-slot-definition-class))

#+ :PROCYON (defmacro function (form)
              (cond
               ((symbolp form) `(symbol-function ',form))
               (t `#',form)))

#+ :CCL (import '(user::object))

;;; -----------------------------------------------------------------------------------
;;;  The external interface of MCS:
;;; -----------------------------------------------------------------------------------

;;; -----------------------------------------------------------------------------------
;;;  Application Programmer Interface
;;; -----------------------------------------------------------------------------------

;;; expressions

(export	'(defclass
          defabstract
          defmixin
          defconstructor
          defgeneric
          defmethod
          call-next-method
          next-method-p))

;;; object operations

(export '(initialize-instance
          reinitialize-instance
          slot-value
          slot-boundp
          slot-makunbound
          obj-describe
          print-object
          obj-typep
          obj-type-of))

;;; creating instances

(export '(make-instance
          make-instance-fast))

;;; other symbols

(export '(typep
          ; :reader
          ; :writer
          ; :accessor
          ; :initform
          ; :initarg
          ; :type
          ; :documentation
          ; :method-class
          ; :method-combination
          ; :before
          ; :after
          ; :around
          ))

;;; -----------------------------------------------------------------------------------
;;;  System Programmer Interface
;;;  additional to the Application Programmer Interface
;;; -----------------------------------------------------------------------------------

;;; expressions

(export '(defreader
          defwriter))

;;; objects

(export '(class-of
          slot-exists-p
          change-class
          obj-copy))

;;; names of built-in classes 

(export '(t
          number  complex  rational  ratio  integer  float
          character
          symbol  null
          array  sequence  vector  string  bit-vector  list  cons
          
          hash-table		; not documented
          stream		; not documented
          function))		; not documented

;;; names of defined classes

(export '(object
          
          abstract          instantiable
          single-inherited  multiple-inherited
          defined           built-in
          
          class
          abstract-built-in-class
          built-in-class
          mixin-class
          abstract-base-class
          base-class
          
          redefinable-mixin-class
          redefinable-abstract-base-class
          redefinable-base-class
          redefinable
          redefinable-instantiable
          
          slot-definition
          generic-function  reader         writer
          method            reader-method  writer-method
          method-combination

          standard-mixin-class
          standard-abstract-base-class
          standard-base-class))


;;; classes

(export '(;; initarg names
          name          superclasses       slots                    initargs
          initform      initfunction       slot-class               type
          qualifiers    lambda-list        specializers             function
          method-class  method-combination discriminating-function

          ;; slot names
          direct-superclasses
          direct-subclasses
          direct-slots
          direct-methods
          
          ;; operations on class names
          find-class
          ensure-class
          obj-subtypep
          
          ;; predicates
          abstract-p  class-p  mixin-p  metaclass-p
          
          ;; access functions
          class-direct-methods
          class-direct-subclasses
          class-direct-superclasses
          class-name
          class-precedence-list
          class-direct-slots
          class-slots
          class-direct-initargs
          class-initargs
          find-slot
          class-prototype
          
          ;;creating instances
          allocate-instance

          ;; inheritance
          finalize-inheritance
          compute-class-precedence-list
          compute-effective-slot-definition
          compute-slots
          compute-initargs
          direct-slot-definition-class
          effective-slot-definition-class
          validate-superclass

          ;;creating accessors
          make-reader
          make-writer

          ;; exception
          slot-missing
          slot-unbound))

;;; slot definitions

(export '(slot-definition-initform
          slot-definition-initfunction
          slot-definition-name
          slot-definition-type))


;;; generic functions

(export '(;; predicates
          generic-p

          ;; operaions on gfn names
          find-gfn
          ;; ensure-gfn					; not documented

          ;; access functions
          find-method
          generic-function-lambda-list
          generic-function-method-class
          generic-function-methods
          generic-function-name
          ;; generic-function-method-combination	; not documented
          
          ;; updating methods
          add-method
          remove-method

          ;; applicable methods
          compute-applicable-methods
          
          ;; exception
          no-applicable-method
          no-next-method))


;;; methods

(export '(;; predicates
          method-p

          ;; access functions
          method-function
          method-generic-function
          method-lambda-list
          method-name
          method-qualifiers
          method-specializers

          ;; make-method-lambda		; not documented
          ))


;;; method combination

;(export '(find-method-combination))


;;; other symbols

(export '(; :metaclass
          ; documentation
          standard
          <unbound>))
          

;;; -----------------------------------------------------------------------------------
;;;  Programming Environment
;;; -----------------------------------------------------------------------------------

(export '(;; expressions
          undefgeneric
          undefmethod
          
          ;; object operations
          obj-documentation
          apropos-protocol
          object-protocol
          
          ;; class operations
          class-direct-protocol
          class-protocol
          
          ;; redefinition
          redefine-mode))


;;; Tools Operations

(export '(apropos-class 
          which-slots 
          which-slotinits 
          class-describe
          apropos-gfn 
          gfn-describe 
          find-all-methods 
          method-select 
          method-describe
          which-cplist
          
          obj-documentation))

;;; CLOS compatibility

(export '(standard-object
          standard-class
          standard-method
          standard-generic-function
          standard-slot-definition))

;;; Help Macros

(export '(doplist))

;;; -----------------------------------------------------------------------------------
;;; Dependencies of System Files and Redefine Files
;;; -----------------------------------------------------------------------------------

(defvar *mcs-system-files-and-dependencies*
  ;  File               force recompilation
  '((macros               () )
    (low-it               (macros) )
    (low                  (low-it) )
    (globals              (macros low) )
    (slot-val             (macros low globals) )
    (cl-core              (macros low globals) )
    (cl-boot              (macros cl-core globals) )
    (gfn-core             (macros globals) )
    (gfn-look             (macros globals) )
    (gfn-boot             (macros globals cl-boot gfn-core) )
    (access-m             (macros globals gfn-core gfn-boot) )
    (class-m              (macros globals gfn-core gfn-boot) )
    (system-m             (macros globals gfn-core gfn-boot) )
    (util                 (macros globals gfn-core gfn-boot) )
    (gfn-comp             (gfn-look) )
    #+:ccl (mcsmenus      (macros globals gfn-core gfn-boot))
    #-:EXCL (optimize             (system-m gfn-comp class-m))
    (patches              (macros))
    ) )

(defvar *mcs-redefine-files-and-dependencies*		; now supported 
  ;  File               force recompilation
  '((redefine             (macros low gfn-boot) )
;    (update               (macros low m-boot) )
;    (re-mixin             (re-core) )
;    (re-metac             (re-core) )
;    (o-update             (re-core) )
;    (redef-it             () )
    ))

;;; -----------------------------------------------------------------------------------
;;; Utilities for loading and compiling
;;; -----------------------------------------------------------------------------------

(defun source-file (file-name)
  (concatenate 'string 
               *mcs-source-path-name*
               (string-downcase (string file-name)) 
               *source-file-extension*))

(defun binary-file (file-name)
  (concatenate 'string 
               *mcs-binary-path-name*
               (string-downcase (string file-name)) 
               *compiled-file-extension*))


(defun load-compile-files (files-and-dependencies)
  (dolist (file-spec files-and-dependencies)
    (let ((lisp-file (source-file (first file-spec)))
          (bin-file  (binary-file (first file-spec))))
      (when (and 
             ;; lisp-file exists:
             (lisp:probe-file lisp-file)
             (or 
              ;; bin-file does not exist:
              (not (lisp:probe-file bin-file))
              ;; lisp-file newer than bin-file:
              (< (lisp:file-write-date bin-file)
                 (lisp:file-write-date lisp-file))
              ;; lisp-file depends on a newer bin-file
              (dolist (file (second file-spec) nil)
                (if (< (lisp:file-write-date bin-file)
                       (lisp:file-write-date (binary-file file)))
                  (return t))) ))
        (compile-file lisp-file :output-file bin-file))
      (load bin-file))))

(defun load-lisp-files (files-and-dependencies)
  (dolist (file-spec files-and-dependencies)
    (let ((lisp-file (source-file (first file-spec))))
      (load lisp-file))))


;;; -----------------------------------------------------------------------------------
;;; load-compile-mcs                                                          Function
;;; -----------------------------------------------------------------------------------

(defun load-compile-mcs (&rest args)
  (let ((system (getf args ':system))
        (redefine (getf args ':redefine)))
    (if system 
      (load-compile-files *mcs-system-files-and-dependencies*))
    (if redefine
      (load-compile-files *mcs-redefine-files-and-dependencies*))
    ))


;;; -----------------------------------------------------------------------------------
;;; Load MCS
;;; -----------------------------------------------------------------------------------

(load-compile-mcs :system t :redefine t)
;; (load-lisp-files *mcs-system-files-and-dependencies*)

;;; Make the module public:

(provide 'mcs)
(pushnew :MCS *features*)


;;; eof


