/*
 * mprotect (vaddr, nbytes, key)
 *
 * kernel extension for memory protecting pages
 * in memory. 
 * 
 *
 *
 * return values:
 *			0 - OK
 *		        otherwise failed.
 */

#include <sys/vmuser.h>
#include <sys/param.h>
#include <sys/user.h>
/* #include <sys/mstsave.h> */
#define uptr 0x2ff98000
#define EORGVADDR  0


int sbrk();


int
mprotect(vaddr, nbytes, key)
char * vaddr;
int key,nbytes;
{
	int rc;
	if (key != RDONLY
	    && key != UDATAKEY)
	  return -1;
	if (nbytes < 0 ) return -1;
	if (vaddr < 0x20000000)
	  vaddr = 0x20000000;
	/* we MUST check for vaddr + nbytes > sbrk */
	{char *tem = (char *)sbrk(0);
	 if (tem < (vaddr + nbytes))
	   nbytes = tem -vaddr;
	 if (nbytes < 0) return 0;
       }
	   
	rc = vm_protect(vaddr, nbytes , key);
	return rc;
}

int
getfault()
{

/*  struct mstsave * mst;
    mst = (struct mstsave *) (&(((struct user * )(uptr))->u_save));
    return (mst->except[EORGVADDR]);
*/
       /* the fault address is 19'th word after the u */
        return ((int *) uptr)[19];
}


