(in-package 'si)

;; all the conditions specified by ANSI common lisp are defined below.

(defmacro loop (&rest l) `(sloop::sloop ,@ l))

(defstruct (condition-internal (:print-function print-condition-internal))
  name
  slots  )

(defun print-condition-internal (x stream n)
  (let ((name (condition-internal-name x))
	(slots (condition-internal-slots x))
	tem)
    (cond (*print-escape*
	   (format stream "#<~A ~d>" (condition-internal-name x)
		   (si::address x)))
	  ((setq tem (getf slots :format-control))
	   (apply 'format stream tem (getf slots :format-argumentsb)))
	  (t
	   (let ((pname (substitute  #\space #\- (symbol-name name))))
	     (format stream "A~:[n~;~] ~(~a~) occurred"
		     (member (aref pname 0) '(#\a #\e #\i #\o #\u))
		     pname)
	     (loop for (na val) on slots by 'cddr
		   with conj = " "
		   do
		   (setq billy  (list conj na val))
		   (format stream "~awith ~(~a~) `~s'" conj na val)
		   (setq conj " and ")))
	   (format stream ".")))))

(defun datum-and-args-to-condition (default datum args)
  (cond ((symbolp datum)
	 (setq datum (apply make-condition datum args)))
	((stringp datum)
	 (setq datum (make-condition 'simple-error
				     :format-control datum
				     :format-arguments args)))
	((or (typep datum 'condition)
	     (typep datum 'condition-internal))
	 (or (null args)
	     (warn t "~%Args supplied when first argument a condition"))
	 )
	(t (error "Bad arguments to error"))))

;;will become 'error' in cl package. 
(defun error-internal (datum &rest args)
  (setq datum (datum-and-args-to-condition 'simple-error datum args))
  (signal datum))

(defun signal (datum &rest args)
  (setq datum (datum-and-args-to-condition 'simple-condition datum args))
  (cond ((typep datum *break-on-signals*)
	 ;; invoke-debugger with a break allowing continuing with
	 ;; regular condition
	 (break "Breaking on signal of condition ~s" datum)))
  
	

	 
	
	 

(eval-when (compile eval)
(defstruct (cd (:type list)) parent slots)
)  	   
(defmacro define-condition (name parent &optional slots)
  `(progn (setf (get ',name 'condition-data)
		(list ',(car parent)
		      ',slots))
	  ,@ (loop for v in slots
		   collect
		   `(defun ,(getf (cdr v) :reader) (condition)
		      (getf (condition-internal-slots condition)
			    ,(getf (cdr v) :initarg))))))
			    
(defun make-condition (name &rest initializations)
  (let ((cd (get name 'condition-data)))
    (or cd (error "not a condition"))
    (make-condition-internal :name name
			     :slots
			     initializations)))


(defun condition-typep (obj condition-name)
  ;Test if OBJ is a condition and of type CONDITION-NAME.   
  (and (condition-internal-p obj)
       (symbolp condition-name)
       (or (eql t condition-name)
	   (eql 'condition condition-name)
	   (let ((name (condition-internal-name obj)) tem)
	     (or (eq name condition-name)
		 (loop while (setq tem (get name 'condition-data))
		       do
		       (setq parent (cd-parent tem))
		       (cond ((eq parent condition-name)(return t))
				(t (setq name parent)))))))))



(DEFINE-CONDITION SERIOUS-CONDITION (CONDITION))
(DEFINE-CONDITION ERROR (SERIOUS-CONDITION)) 
(DEFINE-CONDITION ARITHMETIC-ERROR (ERROR)
    ((OPERANDS :INITARG :OPERANDS :READER ARITHMETIC-ERROR-OPERANDS)
     (OPERATION :INITARG :OPERATION :READER ARITHMETIC-ERROR-OPERATION))) 
(DEFINE-CONDITION FLOATING-POINT-OVERFLOW (ARITHMETIC-ERROR)) 
(DEFINE-CONDITION SIMPLE-CONDITION (CONDITION)
    ((FORMAT-CONTROL :INITARG :FORMAT-CONTROL :READER
        SIMPLE-CONDITION-FORMAT-CONTROL)
     (FORMAT-ARGUMENTS :INITARG :FORMAT-ARGUMENTS :READER
        SIMPLE-CONDITION-FORMAT-ARGUMENTS)) )
(DEFINE-CONDITION SIMPLE-TYPE-ERROR (SIMPLE-CONDITION)) 
(DEFINE-CONDITION CELL-ERROR (ERROR)
    ((NAME :INITARG :NAME :READER CELL-ERROR-NAME)) )
(DEFINE-CONDITION FLOATING-POINT-UNDERFLOW (ARITHMETIC-ERROR)) 
(DEFINE-CONDITION SIMPLE-WARNING (SIMPLE-CONDITION)) 
;(DEFINE-CONDITION CONDITION (T)) 
(DEFINE-CONDITION PACKAGE-ERROR (ERROR)
    ((PACKAGE :INITARG :PACKAGE :READER PACKAGE-ERROR-PACKAGE)))
(DEFINE-CONDITION STORAGE-CONDITION (SERIOUS-CONDITION)) 
(DEFINE-CONDITION CONTROL-ERROR (ERROR)) 
(DEFINE-CONDITION PARSE-ERROR (ERROR)) 
(DEFINE-CONDITION STREAM-ERROR (ERROR)
    ((STREAM :INITARG :STREAM :READER STREAM-ERROR-STREAM)) )
(DEFINE-CONDITION DIVISION-BY-ZERO (ARITHMETIC-ERROR)) 
(DEFINE-CONDITION PRINT-NOT-READABLE (ERROR)
    ((OBJECT :INITARG :OBJECT :READER PRINT-NOT-READABLE-OBJECT)) )
(DEFINE-CONDITION STYLE-WARNING (WARNING)) 
(DEFINE-CONDITION END-OF-FILE (STREAM-ERROR)) 
(DEFINE-CONDITION PROGRAM-ERROR (ERROR)) 
(DEFINE-CONDITION TYPE-ERROR (ERROR)
    ((DATUM :INITARG :DATUM :READER TYPE-ERROR-DATUM)
     (EXPECTED-TYPE :INITARG :EXPECTED-TYPE :READER
		    TYPE-ERROR-EXPECTED-TYPE)))
(DEFINE-CONDITION READER-ERROR (PARSE-ERROR)) 
(DEFINE-CONDITION UNBOUND-SLOT (CELL-ERROR)
    ((INSTANCE :INITARG :INSTANCE :READER UNBOUND-SLOT-INSTANCE)))
(DEFINE-CONDITION FILE-ERROR (ERROR)
    ((PATHNAME :INITARG :PATHNAME :READER FILE-ERROR-PATHNAME))) 
(DEFINE-CONDITION UNBOUND-VARIABLE (CELL-ERROR)) 
(DEFINE-CONDITION FLOATING-POINT-INEXACT (ARITHMETIC-ERROR)) 
(DEFINE-CONDITION UNDEFINED-FUNCTION (CELL-ERROR)) 
(DEFINE-CONDITION FLOATING-POINT-INVALID-OPERATION (ARITHMETIC-ERROR)) 
(DEFINE-CONDITION SIMPLE-ERROR (SIMPLE-CONDITION ERROR)) 
(DEFINE-CONDITION WARNING (CONDITION)) 

;; The a list of lists of bindings to be searched.
(defvar *handler-bindings* nil)

;;in cl package
(defmacro handler-bind (bindings &rest forms)
  `(let ((*handler-bindings*
	  (cons (list
		 ,@ (loop for v in bindings
			  collect (cons (car v) (second v))))
		*handler-bindings*)))
     ,@forms))



(defun invoke-handler (condition)
;;Search the handler bindings for a condition type that matches condition.
  (loop for v on *handler-bindings*
	do (loop for w in (car v)
		 when (condition-typep condition (car w))
		 do (let ((*handler-bindings* (cdr v)))
		      (funcall (cdr w) condition)))))


(defmacro handler-case (expr &rest clauses)
  (let (no-error-clause (bl (gensym)) no-error-clause
			ans)
    (setq ans
	  `(handler-bind
	    ,(loop for v in clauses with tem
		   when (eq (car v) :no-error)
		   do (if no-error-clause (error "multiple no error clause"))
		   (setq no-error-clause v)
		   else
		   collect `(,(car v)
			     #'(lambda (,(setq tem (gensym)))
				 (return-from ,bl
					      (let ,(if (second v)
							(list (car (second v))
							      tem))
						,@ (cddr v))))))
	    ,expr))
    (when no-error-clause
	  (setq ans 
		`(multiple-value-call
		  #'(lambda ,(second no-error-clause)
		      ,@ (cddr no-error-clause))
		  ,ans)))
    `(block ,bl ,ans)))

(defmacro ignore-errors (&body forms)
  `(handler-case (progn ,@ forms)
		 (error (condition) (values nil condition))))


(defun warn (datum &rest args &aux handled)
  (setq datum (datum-and-args-to-condition 'warning datum args))
  (restart-bind ((muffle-warning #'(lambda () (setq handled t))))
		(signal datum))
  (unless handled 
	  (format *error-output* "~%;;Warning: ")
	  (format *error-output* datum args)))
  
  

#+init
;; the define-condition above is what is used.
(progn
(define-condition1 floating-point-overflow
  ( arithmetic-error error serious-condition condition t)
  )

(define-condition1 simple-type-error
  ( simple-condition type-error error serious-condition condition t)
  )
(define-condition1 cell-error (error serious-condition condition t)
 name )
(define-condition1 floating-point-underflow
  (arithmetic-error error serious-condition condition t)
  )
(define-condition1 simple-warning
  (simple-condition warning condition t)
  )
(define-condition1 condition (t)
  )
(define-condition1 package-error
  (error serious-condition condition t)
  package)
(define-condition1 storage-condition (serious-condition condition t)
  )
(define-condition1 control-error (error serious-condition condition t)
  )
(define-condition1 parse-error (error serious-condition condition t)
  )
(define-condition1 stream-error (error serious-condition condition t)
  stream)
(define-condition1 division-by-zero
  (arithmetic-error error serious-condition condition t)
  )
(define-condition1 print-not-readable (error serious-condition condition t)
  object )


(define-condition1 style-warning (warning condition t)
  )
(define-condition1 end-of-file
  (stream-error error serious-condition condition t)
  )
(define-condition1 program-error  (error serious-condition condition t)
  )
(define-condition1 type-error (error serious-condition condition t)
 datum
 expected-type)

(define-condition1 error (serious-condition condition t)
  )
(define-condition1 reader-error
  (parse-error stream-error error serious-condition condition t)
  )
(define-condition1 unbound-slot (cell-error error serious-condition condition t)
 instance )
(define-condition1 file-error (error serious-condition condition t)
 pathname )
(define-condition1 serious-condition (condition t)
  )
(define-condition1 unbound-variable
  (cell-error error serious-condition condition t)
  )
(define-condition1 floating-point-inexact
  ( arithmetic-error error serious-condition condition t)
  )
(define-condition1 simple-condition (condition t)
 format-control
 format-arguments)
(define-condition1 undefined-function
  (cell-error error serious-condition condition t)
  )
(define-condition1 floating-point-invalid-operation
  (arithmetic-error error serious-condition condition t)
  )

;The type simple-error consists of conditions that are signaled by error or
;cerror when a format control is supplied as the function's first argument.

(define-condition1 simple-error
  (simple-condition error serious-condition condition t)
  )
(define-condition1 warning (condition t)
  )

)
    
    