;;;-----------------------------------------------------------------------------
;;; Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel, Germany
;;;-----------------------------------------------------------------------------
;;; Projekt  : APPLY - A Practicable And Portable Lisp Implementation
;;;            ------------------------------------------------------
;;; Funktion : Laufzeitsystem, Funktion FORMAT
;;;
;;; $Revision: 1.8 $
;;; $Log: format.lisp,v $
;;; Revision 1.8  1993/07/15  12:56:36  hk
;;; Fehler bei ~p behoben
;;;
;;; Revision 1.7  1993/07/14  15:49:19  hk
;;; ~p implementiert, ~* erweitert, andere erweitert
;;;
;;; Revision 1.6  1993/07/07  08:50:31  hk
;;; lokale Funktion get-at-sign-or-colon in format
;;;
;;; Revision 1.5  1993/06/16  15:20:38  hk
;;;  Copyright Notiz eingefuegt.
;;;
;;; Revision 1.4  1993/04/22  10:47:09  hk
;;; (in-package "RUNTIME") -> (in-package "LISP"),
;;; Exports eingefuegt.
;;;
;;; Revision 1.3  1993/02/16  14:34:20  hk
;;; clicc::declaim -> declaim, clicc::fun-spec (etc.) -> lisp::fun-spec (etc.)
;;; $Revision: 1.8 $ eingefuegt
;;;
;;; Revision 1.2  1992/08/27  15:31:14  kl
;;; Fehlermeldungen erweitert.
;;;
;;; Revision 1.1  1992/03/24  17:12:55  hk
;;; Initial revision
;;;-----------------------------------------------------------------------------

(in-package "LISP")

(export '(format))

;;------------------------------------------------------------------------------
;; Einschraenkungen:
;; Bisher sind nur wenige Format-Direktiven implementiert
;; Wenn vermerkt, dann kann hoechstens 1 Praefix-Parameter angegeben werden,
;; # und v sind erlaubt.
;; - ~mincolA
;; - ~mincolS
;; - ~mincol[@]D  (wie ~mincolA, fuegt rechts Leerzeichen ein)
;; - ~mincolB  (wie ~mincolA, fuegt rechts Leerzeichen ein)
;; - ~mincolO  (wie ~mincolA, fuegt rechts Leerzeichen ein)
;; - ~mincolF  (wie ~mincolA, fuegt rechts Leerzeichen ein)
;; - ~n%
;; - ~&
;; - ~n~
;; - ~<newline>
;; - ~*
;; - ~?
;; - ~{~}
;; Sonst nichts.
;;------------------------------------------------------------------------------
(defun format (dest ctrl &rest args &aux stream)
  (cond
    ((or (null dest) (stringp dest))
     (setq stream (if dest
                      (make-string-output-stream dest)
                      (make-string-output-stream)))
     (unwind-protect
          (progn (format2 stream ctrl args)
                 (if dest nil (get-output-stream-string stream)))
       (close stream)))
    ((eql T dest) (format2 *standard-output* ctrl args))
    ((output-stream-p dest) (format2 dest ctrl args))
    (T (error "illegal destination ~S for format" dest))))

;;------------------------------------------------------------------------------
;; Terminate hat den Wert:  nil, #\), #\], #\}, #\>
;; Values: 1: die Liste der nicht verbrauchten Argumente
;;         2: Die Position hinter einem ~}, wenn die Bearbeitung
;;------------------------------------------------------------------------------
(defun format2 (stream ctrl orig-args &optional (terminator nil) (ctrl-index 0))
  (let ((args orig-args)
        (arg-index 0)
        (last-arg nil)
        (ctrl-len (length ctrl))
        c param
        at-sign colon)

    (labels
        ((get-arg ()
           (when (null args) (error "Not enough arguments for format"))
           (incf arg-index)
           (setq last-arg (pop args)))
         
         (get-ctrl ()
           (cond
             ((>= ctrl-index ctrl-len) nil)
             (T (prog1 (char ctrl ctrl-index)
                  (incf ctrl-index)))))
         
         (get-param (&aux c x d)
           (tagbody
              (when (>= ctrl-index ctrl-len)
                (go SYNTAX-ERROR))
              (setq c (char ctrl ctrl-index))
              (case c
                (#\#       (setq param (length args))
                           (incf ctrl-index))
                ((#\V #\v) (setq param (get-arg))
                 (incf ctrl-index))
                (T (setq x (digit-char-p c))
                   (cond
                     ((null x) (setq param nil))
                     (t (loop
                         (incf ctrl-index)
                         (when (>= ctrl-index ctrl-len) (go SYNTAX-ERROR))
                         (setq c (char ctrl ctrl-index))
                         (setq d (digit-char-p c))
                         (when (null d) (setq param x) (return))
                         (setq x (+ (* 10 x) d)))))))
              (return-from get-param)
            SYNTAX-ERROR
              (error "Syntax error at end of control-string: ~s" ctrl)))
         
         (get-at-sign-or-colon ()
           (setq at-sign nil
                 colon nil)
           (loop
            (cond
              ((>= ctrl-index ctrl-len)
               (error "Syntax error at end of control-string: ~s" ctrl))
              ((eql (char ctrl ctrl-index) #\@)
               (when at-sign
                 (error "Too many at-signs supplied."))
               (setq at-sign T)
               (incf ctrl-index))
              ((eql (char ctrl ctrl-index) #\:)
               (when colon
                 (error "Too many colons supplied."))
               (setq colon T)
               (incf ctrl-index))
              (t (return)))))
         
         (get-directive ()
           (cond
             ((>= ctrl-index ctrl-len)
              (error "Syntax error at end of control-string: ~s" ctrl))
             (T (prog1 (char ctrl ctrl-index)
                  (incf ctrl-index)))))
         
         (skip (terminator)
           (loop
            (case (get-ctrl)
              (nil (error "~~~A expected in control-string" terminator))
              (#\~ (when (eql (get-ctrl) terminator) (return)))
              (T nil))))
         
         (insert-space (param col)
           (when (numberp param)
             (setq col (- (funcall (stream-column stream)) col))
             (do ()
                 ((>= col param))
               (write-char #\Space stream)
               (incf col)))))
      
      (loop
        (setq c (get-ctrl))
        (when (null c) (return))
        (cond
          ((not (eql c #\~)) (write-char c stream))
          (T (get-param)
             (get-at-sign-or-colon)
             (setq c (get-directive))
             (case (char-upcase c)
;;;-----------------------------------------------------------------------------
               (#\A
                (let ((col (funcall (stream-column stream))))
                  (princ (get-arg) stream)
                  (insert-space param col)))
;;;-----------------------------------------------------------------------------
               (#\S
                (let ((col (funcall (stream-column stream))))
                  (prin1 (get-arg) stream)
                  (insert-space param col)))
;;;-----------------------------------------------------------------------------
               (#\D
                  (let ((col (funcall (stream-column stream)))
                        (arg (get-arg))
                        (*PRINT-RADIX*  NIL)
                        (*PRINT-BASE*   10))
                     (when (and (integerp arg) at-sign (plusp arg))
                       (write-char #\+ stream))
                     (princ arg stream)
                     (insert-space param col)))
;;;-----------------------------------------------------------------------------
               (#\B
                  (let ((col (funcall (stream-column stream)))
                        (*PRINT-RADIX*  NIL)
                        (*PRINT-BASE*   2))
                     (princ (get-arg) stream)
                     (insert-space param col)))
;;;-----------------------------------------------------------------------------
               (#\O
                  (let ((col (funcall (stream-column stream)))
                        (*PRINT-RADIX*  NIL)
                        (*PRINT-BASE*   8))
                     (princ (get-arg) stream)
                     (insert-space param col)))
;;;-----------------------------------------------------------------------------
               (#\P
                (let ((arg (if colon last-arg (get-arg))))
                  (if (eql arg 1)
                      (when at-sign (write-char #\y stream))
                      (if at-sign
                          (princ "ies" stream) (write-char #\s stream)))))
;;;-----------------------------------------------------------------------------
               (#\F
                  (let ((col (funcall (stream-column stream))))
                     (princ (get-arg) stream)
                     (insert-space param col)))
;;;-----------------------------------------------------------------------------
               (#\% (if (numberp param)
                      (dotimes (i param) (terpri stream))
                      (terpri stream)))
;;;-----------------------------------------------------------------------------
               (#\& (if (numberp param)
                        (unless (zerop param)
                          (fresh-line stream)
                          (dotimes (i (1- param)) (terpri stream)))
                        (fresh-line stream)))
;;;-----------------------------------------------------------------------------
               (#\| (if (numberp param)
                      (dotimes (i param) (write-char #\Page stream))
                      (write-char #\Page stream)))
;;;-----------------------------------------------------------------------------
               (#\~ (if (numberp param)
                      (dotimes (i param) (write-char #\~ stream))
                      (write-char #\~ stream)))
;;;-----------------------------------------------------------------------------
               (#\Newline
                (when at-sign
                  (when colon (error "illegal directive ~~:@p"))
                  (terpri stream))
                (unless colon
                  (loop
                   (setq c (get-ctrl))
                   (when (null c) (return))
                   (unless (eq c #\Space)
                     (decf ctrl-index)
                     (return)))))
;;;-----------------------------------------------------------------------------
               (#\*
                (labels ((goto (n)
                           (cond
                             ((eql n 0)
                              (setq args orig-args)
                              (setq arg-index 0)
                              (setq last-arg nil))
                             (t (setq args (nthcdr orig-args (1- n)))
                                (setq arg-index n)
                                (get-arg))))) 
                  (cond
                    (at-sign
                     (when colon (error "illegal directive ~~:@*"))
                     (unless (numberp param) (setq param 0))
                     (goto param))
                    (colon
                     (when (not (numberp param))
                       (setq param 1))
                     (when (> param arg-index)
                       (error "~~~a:* will skip to nonexistant argument"
                              param))
                     (goto (- arg-index param)))
                    (t (when (not (numberp param))
                         (setq param 1))
                       (dotimes (i param) (get-arg))))))
;;;-----------------------------------------------------------------------------
               (#\? (funcall #'format2 stream (get-arg) (get-arg)))
;;;-----------------------------------------------------------------------------
               (#\{ (let ((arg (get-arg))
                          (new-ctrl-index nil))
                      (loop
                        (when (null arg) (return))
                        (multiple-value-setq (arg new-ctrl-index)
                          (funcall #'format2 stream ctrl arg #\} ctrl-index)))

                      (if new-ctrl-index
                        (setq ctrl-index new-ctrl-index)
                        
                        ;; !!! Fehlerhaft bei geschachtelten '~{~}' !!
                        ;;----------------------------------------
                        (skip #\}))))
;;;-----------------------------------------------------------------------------
               (#\} (if (eql terminator #\})
                      (return-from format2 (values args ctrl-index))
                      (error "unexpected ~~} in control-string")))
;;;-----------------------------------------------------------------------------
               (T (error "illegal / unimplemented directive (~A) in ~
                          control-string" c))))))))

  (when terminator (error "unexpected end of control-string")))

