/*------------------------------------------------------------------------------
 * Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel
 *------------------------------------------------------------------------------
 * Projekt  : APPLY - A Practicable And Portable Lisp Implementation
 *            ------------------------------------------------------
 * Funktion : System-Funktionen: Lists
 *
 * $Revision: 1.7 $
 * $Log: list.c,v $
 * Revision 1.7  1993/06/16  14:43:22  hk
 * Copyright Notiz eingefuegt.
 *
 * Revision 1.6  1993/04/22  10:29:34  hk
 * fun_decl.h -> sys.h.
 *
 * Revision 1.5  1993/02/17  15:51:57  hk
 * CLICC -> APPLY, Revison Keyword.
 *
 * Revision 1.4  1992/11/26  17:05:38  hk
 * Viele Funktionen von hier nach list.lisp.
 *
 * Revision 1.3  1992/09/28  17:20:28  hk
 * Lerror -> Labort, neues Lerror mit Lisp-Parameter
 *
 * Revision 1.2  1992/07/21  14:58:07  hk
 * Fset_car --> set_car, Fset_cdr --> set_cdr.
 *
 * Revision 1.1  1992/03/24  17:03:37  hk
 * Initial revision
 *----------------------------------------------------------------------------*/

#include <c_decl.h>
#include "sys.h"

/* Laufzeitfehlermeldungen */

char No_list[] = "~a is not a list";

/*----------------------------------------------------------------------------*/
/* Abstand zwischen neu allozierten Listenelementen                           */
/*----------------------------------------------------------------------------*/
#define FORWARD   2

/*----------------------------------------------------------------------------*/
/* Primitive Listfunktionen                                                   */
/*----------------------------------------------------------------------------*/
#define GET_CDR(cons) (cons) + 1

#define CAR(cons) GET_FORM(cons)
#define CDR(cons) GET_CDR(CAR(cons))

#define NTH(newlist, i) ((newlist) + FORWARD * (i))
#define LINK_LIST(list1, list2) COPY(list2, list1 - 1)

/*----------------------------------------------------------------------------*/
/* Voraussetzung: <lptr> ist ein Zeiger auf ein Listenelement                 */
/* Rueckgabewert: Falls das Listenende erreicht wurde (Rest der Liste ist     */
/*                NIL oder ein Atom) wird NULL zurueckgegeben.                */
/*                Sonst ein Zeiger auf das naechste Listenelement.            */
/*----------------------------------------------------------------------------*/
CL_FORM *NEXT_CAR(lptr)
CL_FORM *lptr;
{
   lptr++;                      /* Zeiger auf Zelle fuer CDR */
   if(CL_CONSP(lptr))
      return(CAR(lptr));
   else
      return((CL_FORM *)NULL);
}

/*----------------------------------------------------------------------------*/
/* Ermittelt die Laenge einer Liste.                                          */
/* Voraussetzung: <lptr> Zeiger -> CONS-Form                                  */
/* Rueckgabewert: Laenge der Liste                                            */
/*----------------------------------------------------------------------------*/
long list_length(lptr)
CL_FORM *lptr;
{
   long list_len = 0;

   lptr = CAR(lptr);
   while(lptr)
   {
      list_len++;
      lptr = NEXT_CAR(lptr);
   }
   return(list_len);
}

/*----------------------------------------------------------------------------*/
/* list &rest args                                                            */
/*----------------------------------------------------------------------------*/
void Flist(base, nargs)
CL_FORM *base;
int nargs;
{
   CL_FORM *lptr;
   int i;

   if(nargs == 0)               /* (list) = () */
   {
      LOAD_NIL(STACK(base, 0));
   }
   else
   {
      lptr = list_alloc(STACK(base, nargs), nargs);
      for(i = 0; i < nargs; i++)
         COPY(STACK(base, i), NTH(lptr, i));
      LOAD_CONS(lptr, STACK(base, 0));
   }
}

/*----------------------------------------------------------------------------*/
/* list* arg &rest others                                                     */
/*----------------------------------------------------------------------------*/
void FlistX(base, nargs)
CL_FORM *base;
int nargs;
{
   CL_FORM *lptr;
   int i;

   if(nargs == 1)              /* (list* x) = x */
      return;

   lptr = list_alloc(STACK(base, nargs), nargs - 1);
   for(i = 0; i < nargs - 1; i++)
      COPY(STACK(base, i), NTH(lptr, i));
   LINK_LIST(NTH(lptr, nargs - 1), STACK(base, nargs - 1));
   LOAD_CONS(lptr, STACK(base, 0));
}

/*----------------------------------------------------------------------------*/
/* append &rest lists                                                         */
/*----------------------------------------------------------------------------*/
void Fappend(base, nargs)
CL_FORM *base;
int nargs;
{
   int i, list_len = 0;
   CL_FORM *result, *lptr1, *lptr2;

   switch(nargs)
   {
   case 0:                      /* (APPEND) = NIL */
      LOAD_NIL(STACK(base, 0));
      return;
   case 1:                      /* (APPEND arg) = arg */
      return;
   default:
      for(i = 0; i < nargs - 1; i++) /* Gesamtlistenlaenge der ersten */
      {                         /* N - 1 Argumente bestimmen */
         switch(TYPE_OF(STACK(base, i)))
         {
         case CL_NIL : break;
         case CL_CONS:
            list_len += list_length(STACK(base, i));
            break;
         default: Lerror(STACK(base, i), No_list);
         }
      }

      if(list_len == 0)
      {
         COPY(STACK(base, nargs - 1), STACK(base, 0));
         return;
      }

      result = lptr2 = list_alloc(STACK(base, nargs), list_len);

      /* Kopieren der ersten N - 1 Listen */
      /*----------------------------------*/
      for(i = 0; i < nargs - 1; i++)
      {
         switch(TYPE_OF(STACK(base, i)))
         {
         case CL_NIL : break;
         case CL_CONS:
            lptr1 = CAR(STACK(base, i));
            while(lptr1)
            {
               COPY(lptr1, lptr2);
               lptr1 = NEXT_CAR(lptr1);
               lptr2 += FORWARD;
            }
            break;
         }
      }
      /* Neue Liste mit dem letzten Argument verknuepfen */
      /* ----------------------------------------------- */
      LINK_LIST(lptr2, STACK(base, nargs - 1));
      LOAD_CONS(result, STACK(base, 0));
   }
}
