/*------------------------------------------------------------------------------
 * Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel
 *-----------------------------------------------------------------------------
 * Projekt  : APPLY - A Practicable And Portable Lisp Implementation
 *            ------------------------------------------------------
 * Funktion : Laufzeitsystem: Funktionen des Objektsystems
 *
 * $Revision: 1.8 $
 * $Log: clos.c,v $
 * Revision 1.8  1993/07/14  08:53:40  ft
 * nderung der Parameterreihenfolge in instance-ref/set.
 *
 * Revision 1.7  1993/07/06  16:16:38  sma
 * OFFSET-Makro eingefhrt.
 *
 * Revision 1.6  1993/06/16  14:43:22  hk
 * Copyright Notiz eingefuegt.
 *
 * Revision 1.5  1993/04/22  10:29:34  hk
 * fun_decl.h -> sys.h.
 *
 * Revision 1.4  1993/04/15  13:06:13  ft
 * Erweiterung um set-slot-unbound.
 *
 * Revision 1.3  1993/03/12  10:00:10  ft
 * Zugriff auf Instanzen optimiert.
 *
 * Revision 1.2  1993/02/17  15:32:05  hk
 * CLICC -> APPLY, Revison Keyword.
 *
 * Revision 1.1  1992/12/11  07:20:27  ft
 * Initial revision
 *----------------------------------------------------------------------------*/

#include <c_decl.h>
#include "sys.h"

/*------------------------------------------------------------------------------
 * instancep object
 *----------------------------------------------------------------------------*/
void instancep (base)
CL_FORM *base;
{
   RET_BOOL(TYPE_OF(STACK(base, 0)) == CL_INSTANCE);
}

/*------------------------------------------------------------------------------
 * make-instance-internal  instance
 *----------------------------------------------------------------------------*/
void make_instance_internal (base)
CL_FORM *base;
{
   TYPE_OF(STACK(base, 0)) = CL_INSTANCE;
}

/*------------------------------------------------------------------------------
 * instance-ref instance offset
 *----------------------------------------------------------------------------*/
void instance_ref (base)
CL_FORM *base;
{
   CL_FORM *header = GET_FORM(STACK(base, 0));
   long offset = GET_FIXNUM(STACK(base, 1));
   COPY(OFFSET(AR_BASE(header), 1+offset), STACK(base, 0));
}

/*------------------------------------------------------------------------------
 * instance-set new-value instance offset
 *----------------------------------------------------------------------------*/
void instance_set (base)
CL_FORM *base;
{
   CL_FORM *header = GET_FORM(STACK(base, 1));
   long offset = GET_FIXNUM(STACK(base, 2));
   COPY(STACK(base, 0), OFFSET(AR_BASE(header), 1+offset));
}

/*------------------------------------------------------------------------------
 * set-slot-unbound instance offset
 *----------------------------------------------------------------------------*/
void set_slot_unbound (base)
CL_FORM *base;
{
   CL_FORM *header = GET_FORM(STACK(base, 0));
   long offset = GET_FIXNUM(STACK(base, 1));
   LOAD_UNBOUND(OFFSET(AR_BASE(header), 1+offset));
}

