;;;-----------------------------------------------------------------------------
;;; Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel, Germany
;;;-----------------------------------------------------------------------------
;;; Projekt  : APPLY - A Practicable And Portable Lisp Implementation
;;;            ------------------------------------------------------
;;; Funktion : Zwischensprachkonstrukte fuer das Foreign Function Interface
;;;
;;; $Revision: 1.7 $
;;; $Log: ffzsdef.lisp,v $
;;; Revision 1.7  1993/06/17  08:00:09  hk
;;; Copright Notiz eingefuegt
;;;
;;; Revision 1.6  1993/05/31  17:03:53  pm
;;; Struktur fuer call-in-Funktionen eingefuegt
;;;
;;; Revision 1.5  1993/03/10  12:48:47  pm
;;; Kleinigkeiten geaendert
;;;
;;; Revision 1.4  1993/02/16  15:23:12  hk
;;; Revision Keyword eingefuegt.
;;;
;;; Revision 1.3  1992/11/05  10:47:02  pm
;;; Ueberarbeitet
;;;
;;; Revision 1.2  1992/10/16  16:05:10  pm
;;; Zwischensprach-Konstrukt fuer Foreign-Functions
;;;
;;; Revision 1.1  1992/10/16  16:02:58  pm
;;; Initial revision
;;;-----------------------------------------------------------------------------

(in-package "CLICC")

;;------------------------------------------------------------------------------
;; Fuer Foreign Functions wird ein eigenes Zwischensprachkonstrukt
;; eigerichtet, da keins der Vorhandenen geeignete Slots enthaelt.
;; Foreign-Functions sind naemlich keine Funktionen im Sinne von LISP.  Die
;; Slots im Einzelnen: 
;;
;; - arg-type-list: Enthaelt die Typ-Signatur der Foreign-Function
;; - foreign-name: Name der zu generierenden FF
;; - return-type: Der von der FF zurueckgelieferte Wert.
;; - call-back: Die Funktion wird ueber ein Event-Handler aufgerufen.
;; - call-in: Die FF ruft selbst LISP-Funktionen auf.
;;------------------------------------------------------------------------------
(defzws foreign-fun (form)
  (arg-type-list :type list)
  (foreign-name :type string)
  return-type
  (call-back :initform nil :type bool)
  (call-in :initform nil :type bool)
  ;; Annotation
  ;;-----------
  (symbol :type symbol)                 ; Name im Quelltext
)


;;------------------------------------------------------------------------------
;; Call-In-Funktions sind LISP-Funktionen, die speziell behandelt werden
;; muessen. Da sie vorwaerts deklariert werden, koennen die Informationen
;; nicht ins Globale Environment unter operators abgelegt werden. Deshalb
;; muessen diese gemerkt werden. Dies geschieht durch folgendes lokales
;; Zwischensprachkonstrukt. Man haette auch eine Struktur dafuer verwenden
;; koennen, doch so geht es einfacher.
;; Fuer dieses Konstrukt muessen keine Methoden geschrieben werden.
;;------------------------------------------------------------------------------
(defzws call-in-fun (form)
  (arg-type-list :type list)
  (foreign-name :type string)
  return-type
)

;;------------------------------------------------------------------------------
(provide "ffzsdef")









