;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%&%#%s%I%&%9%H%j!<%`4XO"(B
;;; yy-stream.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%&%#%s%I%&%9%H%j!<%`5Z$S%S%C%H%^%C%W%9%H%j!<%`$NDj5A(B
;;; 2/27 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-2-17

;;; Change log
;;; Update get-new-position-add  6/24 T.kosaka
;;; Add icon class for window stream 7/4 T.kosaka
;;; Change window parts and window stream class 2/24 T.kosaka
;;; And then functions, the all primitives of consist with window stream, 
;;; ware changed.

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%&%#%s%I%&$N?F;R7;Do4X78%/%i%9(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-relation ()
  ((parent-window :initform nil
		  :initarg :parent-window
		  :accessor parent-window)
   (old-brother-window :initform nil
		       :accessor old-brother-window)
   (young-brother-window :initform nil
		:accessor young-brother-window)

   (children-windows :initform nil
	     :accessor children-windows)))

;;; $BF~NO%^%9%/%F!<%V%k(B
(defvar *default-input-mask-table*
  ;;;$B%3!<%I(B   $B%3%^%s%I(B
  '(( 16 .   delete-text) (8 . back-space-text) (1 . top-buffer-text) (5 . end-buffer-text)
    (6 . next-cursor-text) (2 . before-cursor-text) (11 . delete-after-text)
    (3. kana-kanji)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%&%#%s%I%&$N%"%$%3%s%/%i%9(B   ;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass icon (event-drawable-piece window-parts)
  ((p-left :initarg :p-left :accessor p-left
		:initform 0)
   (p-bottom :initarg :p-bottom :accessor p-bottom
	     :initform 0)
   (p-width :initarg :p-width :accessor p-width
	    :initform 0)
   (p-height :initarg :p-height :accessor p-height
	     :initform 0)
  ))
				      
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%&%#%s%I%&%9%H%j!<%`%/%i%9(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-stream
  (window-relation fundamental-character-input-stream drawable-piece
		   event-method-mixin)

   ;;; $B%&%#%s%I%&$NBg$-$5%\!<%@$NBg$-$5$G$b$"$k(B
  ((window-region :initarg :window-region
			   :initform (make-region :width 100 :height 100)
			   :reader window-region)
   ;;;$B%\!<%@$NI}(B
   (border-belt :initarg :border-belt :initform 1
		:accessor border-belt)

   (real-border-belt :initarg real-border-belt
		     :initform 1 :accessor real-border-belt)

   (border-visible :initform T :accessor border-visible
                   :initarg :border-visible)

   (border-color :initarg :border-color
		 :initform *black-color*
		 :accessor border-color)

   ;;; $B3F9=@.MWAG$N$?$a$N%9%m%C%H(B
   (child-object-list :initarg :child-object-list
		      :accessor child-object-list
		      :initform nil)

   ;;; $B%&%#%s%I%&$N>uBV$r<($9!#(B :window $B%&%#%s%I%&(B :icon $B%"%$%3%s(B
   (window-status :initarg :window-status 
		  :initform :window ;;; :icon $B$K$b$J$k(B
		  :accessor window-status)

   ;;; $B%"%$%3%s%/%i%9$N%$%s%9%?%s%9$,F~$k(B
   (window-icon :initarg :window-icon :initform nil
		:accessor window-icon)

   (window-symbol :initform (gentemp)
		  :accessor window-symbol)

   ;;; $BF~NO%^%9%/(B
   (input-mask-table :initarg :input-mask-table
                     :initform *default-input-mask-table*
                     :accessor input-mask-table)

   (window-mouse-cursor :initarg window-mouse-cursor
			:initform *SYSTEM-MOUSE-CURSOR*
			:accessor window-mouse-cursor)

   ;;; $B%"%/%F%#%V%j!<%8%g%s$N$,F~$k(B
   (active-region-list :initform nil
		       :accessor active-region-list)

  ;;; $B%&%#%s%I%&$NItIJ(B
  (title-bar :accessor window-title-bar
	     :reader title-bar-region :initform nil)

  (horizontal-scroll-bar :accessor window-horizontal-scroll-bar
			 :reader horizontal-scroll-region
			 :initform nil)

  (vertical-scroll-bar :accessor window-vertical-scroll-bar
		       :reader vertical-scroll-region
		       :initform nil)
  
  (coordinate-area :accessor window-coordinate-area
		  :initform nil)

  (frame :initarg :frame :accessor window-frame
	 :reader frame-region :initform nil)

  (border :initarg :border :accessor border-method
	  :reader window-border :initform nil)
  ))
  
;;; $B%&%#%s%I%&%9%H%j!<%`$NI=<(!?HsI=<((B
(defmethod (setf window-visible) (value (window window-stream))
  (setf (draw-piece-visible window) value))

;;; $B%&%#%s%I%&%9%H%j!<%`$NI=<(>uBV$N;2>H(B
(defmethod window-visible ((window window-stream))
  (draw-piece-visible window))


;;; $B%&%#%s%I%&%9%H%j!<%`$N@8@.(Bafter $B%a%=%C%I(B
;;; $B%&%#%s%I%&$N9=@.MWAG%$%s%9%?%s%9$,$"$l$P=i4|2=$9$k!#(B
(defmethod initialize-instance :after ((ob window-stream) &rest args
				       &key &allow-other-keys)
  (declare (special *root-territory-no* *default-font*)
	   (function REDISPLAY-WINDOW (t) t)
	   (function set-window-component-size (T) T))
  (let* ((border (make-instance 'window-border :parent-window ob))
	 (frame (if (find-list :window-frame args)
		    (make-instance (find-list :window-frame args) 
				  :parent-window ob)
		  (make-instance 'window-frame :parent-window ob)))

	 (region (window-region ob))
	 (parent (parent-window ob))
         (ptno (if parent (world-territory-no parent) *ROOT-TERRITORY-NO*))
	 (start-x (if parent (world-x-start parent) 0))
	 (start-y (if parent (world-y-start parent) 0))
	 (bottom (with-translate-coordinate-stream (region-bottom region)
						   (parent-window ob)))
	 (font (if (find-list :font args)
		   (find-list :font args)
		 *default-font*))
	 (old-b-window nil))

    ;;; $B2<C<$N@_Dj(B
    (unless (= bottom (region-bottom region))
	(setf bottom (- bottom (region-height region))))
	 	 
    ;;; $B%\!<%@!<$H%U%l!<%`$N@_Dj(B
    (setf (window-frame ob) frame (border-method ob) border
	  (territory ob)
	  (with-object-make-territory border
	     :parent ptno :visible nil :x (+ (region-left region) start-x)
	   	 :y (+ bottom start-y) :width (region-width region) 
		 :height (region-height region))
	  (frame-territory-no frame)
	  (with-object-make-territory frame
		 :width 10 :height 10
		 :fence T :parent (territory ob)))

    ;;; $B%U%l!<%`$KBP$7$F%^%9%/$r@_Dj(B
    (yy-protocol-72 (frame-territory-no frame)
		    #b0001111111111111)
    
    ;;; $B:BI8JQ49MQ%9%m%C%H$KCM$r@_Dj(B
    (setf (slot-value ob 'translate-coordinate)
      (if (eq (find-list :translate-coordinate args) :left-bottom)
	  (make-instance 'translate-coordinate-left-bottom)
	(make-instance 'translate-coordinate-left-top)))
	      
    ;;; $B%U%)%s%H$N@_Dj(B
    (setf (stream-font ob) font)

     ;;; $B3F9=@.MWAG(B
    (apply #'make-title-bar ob args)
    (apply #'make-horizontal-scroll-bar ob args)
    (apply #'make-vertical-scroll-bar ob args)
    (apply #'make-coordinate-area ob args)
    (apply #'make-default-icon ob args)

	 
    ;;; $B3F9=@.MWAG$NBg$-$5$N:F7W;;(B
    (set-window-component-size ob)
    
    ;;; $B%\!<%@$N%a%=%C%I$rDj5A(B
    (set-window-border-method ob 'window-pop-up
			      :event-mask *mouse-right-1*)
    ;;; $B%G%U%)%k%H$N%\!<%@I}@_Dj(B
    (setf (slot-value ob 'real-border-belt) (border-belt ob))

    ;;; $B%G%U%)%k%H$N%o!<%k%I$NBg$-$5$r@_Dj(B
    (setf (world-height ob) (region-height frame)
	  (world-width ob) (region-width frame)
	  (world-height (window-vertical-scroll-bar ob))
	  (region-height frame)
	  (world-width (window-horizontal-scroll-bar ob))
	  (region-width frame)
	  (region-width ob) (region-width frame)
	  (region-height ob) (region-height frame))

    ;;; $B?F;R7;Do4X78$N@_Dj(B
    (when parent
	(setf old-b-window (car (last (children-windows parent))))

	(if (children-windows parent)
	    (push ob (cdr (last (children-windows parent))))
	  (push ob (children-windows parent)))

	(if old-b-window
	    (setf (young-brother-window old-b-window)
		  ob)
	  )

	(setf (old-brother-window ob) old-b-window))

    ;;; $B%&%#%s%I%&$NI=<((B
    (redisplay-window ob)
    (setf (window-visible ob) (find-list :visible args))

        ;;; $B%+!<%=%k%]%8%7%g%s$N=i4|@_Dj(B
    (setf (stream-cursor-y-position ob)
	  (font-kanji-base-line (stream-font ob)))
))
    
;;; $B%?%$%H%k%P!<$N@8@.(B
(defun make-title-bar (window &rest args &key &allow-other-keys)
  (declare (special *DEFAULT-FONT* *black-color* *mouse-right-1*))
  (when (find-list :title-bar args)
    (let* ((string  (find-list :title-bar-string args))
	   (font (find-list :title-bar-font args))
	   (color (find-list :title-bar-color args))
	   (ins (apply #'make-instance (find-list :title-bar args)
		 :parent-window window :object-parent window
		 :draw-piece-visible  (find-list :title-bar-visible args)
		 :right 10 :top 10
		 :title-bar-font (if font font *DEFAULT-FONT*)
		 :title-bar-string (if string string "")
		 :title-bar-color (if color color *black-color*)
		 args)))
	 	 ;;; $B%$%Y%s%H%a%=%C%I$N@_Dj(B		      
      (with-event-object (ins)
	 (setf (right-button-down-1-method ins) 'window-pop-up
	       (slot-value ins 'event-mask) *mouse-right-1*))

      (setf (slot-value window 'title-bar) ins))
    ))
		
;;; $B2#%9%/%m!<%k%P!<(B
(defun make-horizontal-scroll-bar (window &rest args &key &allow-other-keys)
  (declare (special *black-color* *mouse-move* *mouse-button-down-1*))
  (when (find-list :horizontal-scroll-bar args)
	(let* ((color (find-list :scroll-bar-color args))
	       (ins (apply #'make-instance 
			   (find-list :horizontal-scroll-bar args)
			  :parent-window window  :object-parent window
			  :right 10 :top 10
			  :draw-piece-visible
			  (find-list :horizontal-scroll-visible args)
			  :scroll-bar-color (if color	color *black-color*)
			  args)))
	  (with-event-object (ins)			     	
	      (setf (slot-value window 'horizontal-scroll-bar) ins
		    (left-button-down-1-method ins)
		    'horizontal-scroll-left-internal
		    (middle-button-down-1-method ins)
		    'horizontal-scroll-middle-internal
		    (right-button-down-1-method ins)
		    'horizontal-scroll-right-internal
		    (move-mouse-cursor-method ins)
		    'horizontal-scroll-move-internal
		    (slot-value ins 'event-mask)
		    (logior *mouse-button-down-1* *mouse-move*)))
	  )))
				

;;; $B=D%9%/%m!<%k%P!<(B
(defun make-vertical-scroll-bar (window &rest args &key &allow-other-keys)
  (declare (special *black-color* *mouse-move* *mouse-button-down-1*))
  (when (find-list :vertical-scroll-bar args)
	(let* ((color (find-list :scroll-bar-color args))
	       (coordinate (find-list :translate-coordinate args))
	       (ins (apply #'make-instance (find-list :vertical-scroll-bar args)
			  :parent-window window :object-parent window
			  :draw-piece-visible
			  (find-list :vertical-scroll-visible args)
			  :right 10 :top 10
			  :coordinate (if coordinate  coordinate :left-top)
			  :scroll-bar-color (if color color *black-color*)
			  args)))
	  (with-event-object (ins)			     	
	      (setf (slot-value window 'vertical-scroll-bar) ins
		    (left-button-down-1-method ins) 
		    'vertical-scroll-left-internal
		    (middle-button-down-1-method ins)
		    'vertical-scroll-middle-internal
		    (right-button-down-1-method ins) 
		    'vertical-scroll-right-internal
		    (move-mouse-cursor-method ins) 
		    'vertical-scroll-move-internal
		    (slot-value ins 'event-mask)
		    (logior *mouse-button-down-1* *mouse-move*)))
	  )))

;;; $B:BI87OI=<(%(%j%"(B
(defun make-coordinate-area (window &rest args &key &allow-other-keys)
  (declare (special *black-color*))
  (when (find-list :COORDINATE-AREA args)
    (let* ((color (find-list :coordinate-area-color args))
	   (coordinate (find-list :translate-coordinate args)))
      (setf (slot-value window 'coordinate-area)
	(apply #'make-instance (find-list :COORDINATE-AREA args)
	       :parent-window window :object-parent window
	       :draw-piece-visible
	       (find-list :coordinate-area-visible args)
	       :right 10 :top 10
	       :coordinate (if coordinate coordinate :left-top)
	       :coordinate-area-color
	       (if color color	*black-color*)
	       args))
      )))

;;; $B%"%$%3%s$N@8@.(B
(defun make-default-icon (window &rest args &key &allow-other-keys)
  (declare (special *DEFAULT-FONT* *black-color*))
  (if (find-list :window-icon args)
      (let* ((region (window-region window))
	     (ins (make-instance (find-list :window-icon args)
		   :parent-window window :object-parent window
		   :right 10 :top 10
		   :draw-piece-visible  nil
		   :p-left (region-left region)
		   :p-bottom (region-bottom region)
		   :p-width (region-width region)
		   :p-height (region-height region))))
	 	   ;;; $B%$%Y%s%H%a%=%C%I$N@_Dj(B		      
	(with-event-object (ins)
		   (setf (right-button-down-1-method ins) 'icon-pop-up
			 (slot-value window 'window-icon) ins))
      ins)
    (let* ((region (window-region window))
	   (ins (make-instance 'icon
		  :parent-window window :object-parent window
		  :draw-piece-visible  nil
		  :right 10 :top 10
		  :p-left (region-left region)
		  :p-bottom (region-bottom region)
		  :p-width (region-width region)
		  :p-height (region-height region))))
      (with-event-object (ins)
                           (setf (right-button-down-1-method ins) 'icon-pop-up
                                 (slot-value window 'window-icon) ins))
      ins)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; $B%Z!<%8%b!<%I%&%#%s%I%&%9%H%j!<%`(B  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass page-window-stream (window-stream drawable-page-world) ())

;;; $B%Z!<%8%b!<%I$N%&%#%s%I%&$N=i4|2=(B
(defmethod initialize-instance :after ((ob page-window-stream) &rest args
				       &key &allow-other-keys)
  (let* ((output-direction (find-list :output-direction args))
	 (coordinate (find-list :translate-coordinate args))
	 (font (find-list :text-font args))
	 (line-feed (find-list :line-feed args))
	 (frame (window-frame ob))
	 (width (region-width frame))
	 (height (region-height frame))
	 (tno (with-object-make-territory ob
		  :parent (frame-territory-no frame)
		  :width width
		  :height height
		  :window-mode nil)))

	 (yy-protocol-80 tno
			 (font-no font)
			 line-feed
			 (if (eq output-direction :horizontal)  0  1)
			 (if (eq coordinate :left-top) 0 1)
			 0 0)

	 (setf (world-territory-no ob) tno)))


;;; $B%Z!<%8%&%#%s%I%&%9%H%j!<%`$NI=<(%a%=%C%I(B
(defmethod print-object ((window page-window-stream) stream)
  (format stream "\#<Window Stream Page :Size ~a>" 
	  (window-region window)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $B%S%e!<%]!<%H%b!<%I%&%#%s%I%&%9%H%j!<%`(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass viewport-window-stream (window-stream drawable-viewport-world)
	  ())

;;; $B%S%e!<%]!<%H%&%#%s%I%&$N=i4|2=(B
(defmethod initialize-instance :after ((ob viewport-window-stream) &rest args
				       &key &allow-other-keys)
#-:PCL
  (declare (ignore args))

  (let* ((frame (window-frame ob))
	 (width (region-width frame))
	 (height (region-height frame))
	 (tno (with-object-make-territory ob
			:parent (frame-territory-no frame)
			:width width
			:height height)))
    
    (setf (world-territory-no ob) tno)))


;;; $B%S%e!<%]!<%H%&%#%s%I%&%9%H%j!<%`$NI=<(%a%=%C%I(B
(defmethod print-object ((window viewport-window-stream) stream)
  (format stream "\#<Window Stream Viewport :Size ~a>" 
	  (window-region window)))

;;; $B%U%l!<%`%5%$%:$r7W;;(B
;;; calcu-window-frame window
;;; ARG.
;;;         window   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;         (vaslues width height)
(defmethod calcu-window-frame ((window window-stream))
  (declare (special *SCROLL-BAR-BELT*))
  (let* ((width (region-width (window-region window)))
	 (height (region-height (window-region window)))
	 (belt (real-border-belt window))
	 (f-l belt)
	 (f-b belt)
	 (f-r (- width belt))
	 (f-t (- height belt)))

    (if (window-title-bar window)
	(when (draw-piece-visible (window-title-bar window))
	  ;;; $B%?%$%H%k%P!<$,$"$k(B
	  (let ((region (window-title-bar window)))
	    (setf f-b (font-kanji-height
		       (slot-value region 'title-font))))
	  ))

    (if (window-coordinate-area window)
	(when (draw-piece-visible (window-coordinate-area window))
	  ;;; $B:BI87OI=<(%(%j%"$,$"$k(B
	  (setf  f-t (- height belt *SCROLL-BAR-BELT*)
		 f-l (+ belt *SCROLL-BAR-BELT*))
	  ))
    (if (window-horizontal-scroll-bar window)
	(when (draw-piece-visible (window-horizontal-scroll-bar window))
	  ;;; $B2#%9%/%m!<%k%P!<$,$"$k(B
	  (setf f-t (- height belt *SCROLL-BAR-BELT*))))

    (if (window-vertical-scroll-bar window)
	;;; $B=D%9%/%m!<%k%P!<$,$"$k(B
	(when (draw-piece-visible (window-vertical-scroll-bar window))
	  (setf f-l (+ belt *SCROLL-BAR-BELT*))))

    (values (- f-r f-l) (- f-t  f-b))
  ))

;;; parent-stream
;;;
(defmethod parent-stream ((window window-stream))
    window)

;;; parent-stream
(defmethod parent-stream ((object drawable-piece))
  (parent-stream (object-parent object)))

;;; $B%&%#%s%I%&$N%^%&%9%+!<%=%k$NJQ99(B
(defmethod (setf window-mouse-cursor) :around (mouse (window window-stream))
  (declare (function mouse-cursorp (T) T))
  (if (mouse-cursorp mouse)
      (call-next-method)
    (error "The argument ~a is not a mouse cursor" mouse)))


;;; $B%o!<%k%I$N>l9g(B
(defmethod xy-from-object ((window window-stream) x y)
  (values (- x (world-x-start window))
	 (- y (world-y-start window))))


;;; $BB>$N%*%V%8%'%/%H$N>l9g(B
(defmethod xy-from-object ((ob T) x y)
   (values x y))

;;; $BF~NO%;%l%/%7%g%s%F!<%V%k(B
(defvar *selection-table* nil)
(defvar *force-selection-table* nil)
(defvar *cursor-display-table* (make-array 64. :fill-pointer 0 :adjustable t))

;;; $BF~NO%;%l%/%7%g%s%a%=%C%I(B
(defmethod select-window ((window window-stream))
  (if (null *force-selection-table*)
      (progn (select-window-exec window)
	     (setf *selection-table* window))
    )
  window)

;;; $B6/@)F~NO%;%l%/%7%g%s%a%=%C%I(B
(defmethod force-select  ((window window-stream))
  (setf *force-selection-table* window)
  (setf *selection-table* window)
  (select-window-exec window)
  window)

;;; select-page 
(defmethod select-window-exec ((stream window-stream))
	 (yy-protocol-71 (world-territory-no stream)))

;;; $B%F%-%9%HF~NO%+!<%=%k$NI=<(!?HsI=<((B
(defmethod display-text-cursor ((window window-stream))
  (when (> (text-curcor-visible window) 0)
    (let ((font (current-font window))
	  (string (slot-value window 'edit-string))
	  (index (slot-value window 'index))
	  (y-pos (text-cursor-y window))
	  (x-pos (text-cursor-x window)))

      (multiple-value-setq (x-pos y-pos)
	(transform-by-matrix-xy x-pos y-pos 
				(stream-transform-by-matrix window)))
      
      (setf y-pos (with-translate-coordinate-stream y-pos window))

      (if (eq (current-output-direction window) :vertical)
	  (yy-protocol-28 (world-territory-no window)
			(+ x-pos (world-x-start window))
			(- (+ y-pos (world-y-start window))
			   (font-kanji-width font))
			(font-kanji-width font)
			(if (= (length string) index)
			    (round (/ (font-kanji-height font) 2))
			  (if (> (char-code (elt string index)) #xA1)
			      (font-kanji-height font)
			    (round (/ (font-kanji-height font) 2))))
			(current-operation window)
			(color-no (current-text-color window))
			0)

	(yy-protocol-28 (world-territory-no window)
			(+ x-pos (world-x-start window))
		      (- (+ y-pos (world-y-start window))
			 (font-kanji-base-line font))
		      (if (= (length string) index)
			  (round (/ (font-kanji-width font) 2))
			(if (> (char-code (elt string index)) #xA1)
			    (font-kanji-width font)
			  (round (/ (font-kanji-width font) 2))))
		      (font-kanji-height font)
		      (current-operation window)
		      (color-no (current-text-color window))
		      0)))
    )
)

;;; $BJT=8J8;zNs$NI=<(%*%Z%l!<%7%g%s$N7hDj(B
(defmethod get-text-edit-operation ((back-color color) (text-color color))
(declare (special *BLACK-COLOR* *WHITE-COLOR*))
  (if (and (or (eq back-color *BLACK-COLOR*)
	       (eq back-color *WHITE-COLOR*))
	   (or (eq text-color *BLACK-COLOR*)
	       (eq text-color *WHITE-COLOR*)))
      (if (zerop (color-no *BLACK-COLOR*))
	  *GEQIV*
	*GXOR*)
    *GXOR*))
  

;;; $B%&%#%s%I%&$N%\!<%@!<$N%\%?%s%a%=%C%I$r@_Dj(B
;;; set-window-border-method 
;;;          window $B%&%#%s%I%&%9%H%j!<%`$N%$%s%9%?%s%9(B
;;;          method $B5/F0$9$k%a%=%C%IL>(B
;;;          &key (event-mask  *mouse-left-1*) $B%^%&%9%9%F!<%H$N%Q%i%a!<%?(B
(defmethod set-window-border-method ((window window-stream)
					method 
					&key (event-mask *mouse-left-1*))
  (let* ((event-method (window-border window))
	 (s-name (event-method-slot-name event-method event-mask)))

    (if s-name
	(progn 
           ;;; $B%9%m%C%H$K%a%=%C%I$r@_Dj(B
	  (setf (slot-value event-method s-name)  method
		(event-mask event-method) 
		(if method 
		    (logior event-mask (event-mask event-method))
		  (logand (event-mask event-method))))
		  
	  ;;; $B%^%9%/$N@_Dj(B
	  (yy-protocol-72 (territory window)
			  (event-mask event-method))
	  method)
    (error "The event-mask ~a is not a avilable." event-mask))
    ))


;;; $B%&%#%s%I%&$N%\%?%s%a%=%C%I$r@_Dj(B
;;; set-window-method 
;;;          window $B%&%#%s%I%&%9%H%j!<%`$N%$%s%9%?%s%9(B
;;;          method $B5/F0$9$k%a%=%C%IL>(B
;;;          &key (event-mask  *mouse-left-1*) $B%^%&%9%9%F!<%H$N%Q%i%a!<%?(B
(defmethod set-window-method ((window window-stream)
					method 
					&key (event-mask *mouse-left-1*))
  (let* ((event-method window)
	 (s-name (event-method-slot-name event-method event-mask)))

    (if s-name
	(progn 
           ;;; $B%9%m%C%H$K%a%=%C%I$r@_Dj(B
	  (setf (slot-value event-method s-name) method
		(event-mask event-method) 
		(if method 
		    (logior event-mask (event-mask event-method))
		  (logand event-mask (event-mask event-method))))
    
          ;;; $B%^%9%/$N@_Dj(B
	  (yy-protocol-72 (world-territory-no window)
		    (event-mask event-method))
	  method)
      (error "The event-mask ~a is not a avilable." event-mask)))
  )

;;; $B%^%&%9%+!<%=%k$N>uBV3MF@(B
(defun mouse-status (&optional (mouse-state *SYSTEM-MOUSE-STATE*))

  (declare (special *SYSTEM-MOUSE-CURSOR* *SYSTEM-INTERRUPT-EVENT*
		    *ROOT-WINDOW*))
  (let ((m-t-no (if *SYSTEM-MOUSE-CURSOR*
                    (slot-value *SYSTEM-MOUSE-CURSOR* 'mouse-territory-no)
                  0)))

    (yy-protocol-95 m-t-no *SYSTEM-INTERRUPT-EVENT*)

     ;;; $B%^%&%9>uBV$N%*%V%8%'%/%H$r5a$a$k(B
    (let ((object (get-lisp-object (territory-no *SYSTEM-INTERRUPT-EVENT*)))
	  (x 0) (y 0))
#+:YY2.0
      (multiple-value-setq (x y)
	  (xy-from-object object
		       (position-x (event-position *SYSTEM-INTERRUPT-EVENT*))
			(position-y (event-position *SYSTEM-INTERRUPT-EVENT*))
			  ))
#-:YY2.0
      (multiple-value-setq (x y) ;;; SERVER BUG 
	   (values  (position-x (event-position *SYSTEM-INTERRUPT-EVENT*))
		    (position-y (event-position *SYSTEM-INTERRUPT-EVENT*))))
#-:YY2.0
      (setf object *ROOT-WINDOW*)

      ;;; mouse-state $B$NFbMF$rJQ99$9$k(B
      (setf (mouse-state-x-position mouse-state) x
	    (mouse-state-y-position mouse-state) y
	    (mouse-state-button-state mouse-state)
	    (event-mask *SYSTEM-INTERRUPT-EVENT*)
	    (mouse-state-object mouse-state)
	    object)))

  mouse-state)

;;; $B%$%Y%s%H$N%0%m!<%P%kCM(B
(defvar *keybord-event1* (make-instance 'yy-keybord-event))
(defvar *interrupt-event1* (make-instance 'yy-interrupt-event))
(defvar *resize-event1* (make-instance 'yy-resize-event))


;;; $B%5!<%P!<$+$i$NF~%$%Y%s%H@)8f(B
(defun event-dispatch ()
  (declare (special *keybord-event1* *interrupt-event1* *resize-event1*))
   (let ((keybord-event *keybord-event1*)
   	 (interrupt-event *interrupt-event1*)
	 (resize-event *resize-event1*)
	 (mouse-state (make-mouse-state)))
     ;;; $BF~NO$NL58B%k!<%W!!(B
     (loop 
       (multiple-value-bind (event no)
	   (yy-tuuchi keybord-event interrupt-event resize-event)
	 (WITH-INHIBIT-SCHEDULING
	  (case no
	    (1 (yy-event-method1 event mouse-state))
	    (2 (yy-event-method2 event))
	    (3 (yy-event-method3 event)))))
      )
     ))


;;; $B%$%Y%s%H$N%0%m!<%P%kCM(B
(defvar *keybord-event2* (make-instance 'yy-keybord-event))
(defvar *interrupt-event2* (make-instance 'yy-interrupt-event))
(defvar *resize-event2* (make-instance 'yy-resize-event))

;;; $B%5!<%P!<$+$i$NF~%$%Y%s%H@)8f(B $B%-%c%i%/%?!<F~NOMQ(B
(defun event-dispatch-window (window)
  (let ((keybord-event *keybord-event2*)
         (interrupt-event *interrupt-event2*)
	 (resize-event *resize-event2*)
	 (mouse-state (make-mouse-state)))

     ;;; $BF~NO$NL58B%k!<%W!!(B
     (loop
      (if (> (length (slot-value window 'input-string)) 0)
	  (return))

       (multiple-value-bind (event no)
	   (yy-tuuchi keybord-event interrupt-event resize-event)

	 (case no
	   (1 (yy-event-method-window1 window event mouse-state))
	   (2 (yy-event-method-window2 window event))
	   (3 (yy-event-method-window3 window event)))))
     ))

;;; $B%f!<%6Dj5A%a%=%C%I$N5/F0(B
(defun yy-event-method1 (event mouse-state)
  (execution-mause-method event mouse-state))

;;; $B%^%&%9%a%=%C%I$N<B9T4X?t(B
(defun execution-mause-method (event mouse-state)   
  (declare (inline not zerop null eq make-mouse-state))
  (let* ((instance (get-lisp-object (territory-no event)))
	 (method-mixin instance)
	 (pos (event-position event))
	 (method nil))

;(format t "Button ~b ~%" (event-mask event))

	(if method-mixin
            ;;; $B%$%Y%s%H%^%9%/$rD4$Y$k!#(B
	    (if (not (zerop (event-mask event)))
		(if (null (setf method (get-available-method method-mixin
						     (event-mask event))))
		    (values)
                ;;; $B%a%=%C%I$N5/F0(B
		  (if (or (eq method 'vertical-scroll-left-internal)
			  (eq method 'vertical-scroll-middle-internal)
			  (eq method 'vertical-scroll-right-internal)
			  (eq method 'vertical-scroll-move-internal)
			  (eq method 'horizontal-scroll-left-internal)
			  (eq method 'horizontal-scroll-middle-internal)
			  (eq method 'horizontal-scroll-right-internal)
			  (eq method 'horizontal-scroll-move-internal))
;#-:SYMBOLICS
		      (funcall method (parent-window instance)
			       pos
			       (event-mask event))
;#+:SYMBOLICS
;                      (run-process method instance pos
;				   (event-mask event))
		    
		    ;;; $B%a%=%C%I$r8F$S=P$9(B
		    (if (null (get method 'single-process))
			;;; $B%^%k%A%W%m%;%9(B
			(let ((m-state (make-mouse-state 
					    :mask (event-mask event)
					    :any-object instance)))
			  (multiple-value-bind (x y)
			      (xy-from-object instance 
					      (position-x pos)
					      (position-y pos))
			    (setf (mouse-state-x-position m-state) x
				  (mouse-state-y-position m-state) y))

			  (RUN-PROCESS method instance m-state))
		      (progn 
			(multiple-value-bind (x y)
			    (xy-from-object instance
					    (position-x pos)
					    (position-y pos))
			  (setf (mouse-state-x-position mouse-state) x
				(mouse-state-y-position mouse-state) y
				(mouse-state-object mouse-state) instance
				(mouse-state-button-state mouse-state)
				(event-mask event)))
			(funcall method instance mouse-state))))))
			
	  ))

    (values))

;;; $B%-!<%\!<%I%$%Y%s%H(B
(defun yy-event-method2 (event)
  (let ((instance (get-lisp-object (territory-no event))))
     ;;; $B%-!<%\!<%IF~NO(B
    (set-string-to-stream instance (event-string event)))
  )

;;; $B%F%j%H%j!<$N%j%5%$%:(B
(defun yy-event-method3 (event)
  (declare (function set-world-region-internal (T T) T))
  (let ((instance (get-lisp-object (territory-no event))))
    ;;; $B%o!<%k%I$N%j%5%$%:(B
    (set-world-region-internal (event-region event) instance)))

			
;;; $BF~NO=hM}Cf$N%$%Y%s%H5/F0%a%=%C%I(B
(defun yy-event-method-window2 (window event)
  (declare (ignore window))
  (let ((instance (get-lisp-object (territory-no event))))
     ;;; $B%-!<%\!<%IF~NO(B
    (set-string-to-stream instance (event-string event)))
  )

;;; $B%F%j%H%j!<$N%j%5%$%:(B
(defun yy-event-method-window3 (window event)
  (declare (function set-world-region-internal (T T) T)
	   (ignore window))
  (let ((instance (get-lisp-object (territory-no event))))
    ;;; $B%o!<%k%I$N%j%5%$%:(B
    (set-world-region-internal (event-region event) instance)))


;;; $BF~NO=hM}Cf$N%$%Y%s%H5/F0%a%=%C%I(B
(defun yy-event-method-window1 (window event mouse-state)
  (declare (ignore window))
  (execution-mause-method event mouse-state)
  nil)


;;; $BJ8;zNs$r(Binput-stream $B$KA^F~(B
(defmethod set-string-to-stream ((stream fundamental-character-input-stream)
				 (string string))
  (with-slots (input-string) stream
     (setf input-string (nconc input-string 
			       (coerce string 'list)))))
;;; END




