;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/03/05 by Masayuki Ida  (ida@csrl.aoyama.ac.jp)
;;;   update      90/03/23 by Takashi Kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;;  Version 1.0 Written by Masayuki Ida  90-03-05
;;; ----------------------------------------------------------
;;; This file is completely brought from the David Gray's 
;;; Proposal to X3J13.
;;; ----------------------------------------------------------
;;; Version 1.0   Updated by t.kosaka 1990-3-23
;;; update	  report-eof is added symbolics code
;;;		  clear-input is added symbolics code
;;;		  read-char-no-hang added symbolics code
;;;		  finish-output,clear-output,stream-read-char,yy-edit-read

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This is for string stream  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass yy-string-input-stream ()
  ((string :initarg :string :type string)
     (index :initarg :start :type fixnum)
     (end :initarg :end :type fixnum)
     ))

;;; Input method

#| Not use YY
  (defmethod STREAM-PEEK-CHAR ((stream fundamental-character-input-stream))
    (let ((character (stream-read-char stream)))
      (unless (eq character :eof)
	(stream-unread-char stream character))
      character))
|#
  ;;; YY STREAM-PEEK-CHAR  By T.kosaka
  (defmethod STREAM-PEEK-CHAR ((stream fundamental-character-input-stream))
    (let ((ret nil))
      (loop 
       (wait-process 'STREAM-LISTEN stream)
       (with-slots (input-string ) stream
			 (setf ret (elt input-string 0))
			 
			 (if (null (assoc (char-code ret) (input-mask-table stream)))
			     (return ret))))))
    

   ;;; LISP PEEK$B!<(BCHAR   T.kosaka
   (defmethod STREAM-PEEK-CHAR (stream)
     (lisp::peek-char stream))

#| Not use YY
  (defmethod STREAM-LISTEN ((stream fundamental-character-input-stream))
    (let ((char (stream-read-char-no-hang stream)))
      (and (not (null char))
	   (not (eq char :eof))
	   (progn (stream-unread-char stream char) t))))
|#

   ;;; YY STREAM-LISTEN T.kosaka
   (defmethod STREAM-LISTEN ((stream fundamental-character-input-stream))
     (loop 
       (with-slots (input-string ) stream
			 (if (zerop (length input-string))
			     (return nil)
			 (if (null (assoc (char-code (elt input-string 0)) 
					  (input-mask-table stream)))
			     (return T)
			   (return nil))))))

   ;;;; LISP LISTEN T.kosaka
   (defmethod STREAM-LISTEN (stream)
     (lisp::listen stream))

   ;;; YY Window edit listen
   (defun STREAM-EDIT-LIsten (stream)
     (let ((string (stream-input-string-internal (first stream))))
      (if (zerop (length string))
	       nil
	     T)))
     

#| Not use YY
  (defmethod STREAM-READ-LINE ((stream fundamental-character-input-stream))
    (let ((line (make-array 64 :element-type 'string-char 
			    :fill-ponter 0 :adjustable t)))
      (loop (let ((character (stream-read-char stream)))
	      (if (eq character :eof)
		  (return (values line t))
		(if (eql character #\newline)
		    (return (values line nil))
		  (vector-push-extend character line)))))))
|#
  ;;; YY stream STREAM-READ-LINE
  (defmethod STREAM-READ-LINE ((stream fundamental-character-input-stream))
    (yy-edit-read-line stream))
    

   ;;;; LISP READ-LINE      T.kosaka
   (defmethod STREAM-READ-LINE (stream)
     (lisp::READ-LINE stream))

  ;;; YY stream READ T.kosaka
(defmethod STREAM-READ ((stream fundamental-character-input-stream))
  (yy-edit-read stream))

  ;;; LISP READ T.kosaka
(defmethod STREAM-READ (stream)
  (lisp::read stream))

;;;; OUTPUT Method
(defmethod STREAM-START-LINE-P ((stream fundamental-character-output-stream))
  (equal (stream-line-column stream) 0))

(defmethod STREAM-WRITE-STRING ((stream fundamental-character-output-stream)
				string &optional (start 0) end)
  (if (null end)
      (setf end (length string)))
  
  (do ((i start (1+ i)))
      ((>= i end) string)
      (stream-write-char stream (char string i))))

   ;;;; LISP WRITE-STRING T.kosaka
(defmethod STREAM-WRITE-STRING (stream string &optional (start 0) end)
  (lisp::WRITE-STRING string stream :start start :end end))


;;; YY  Drawing text to graphic stream T.kosaka
(defmethod STREAM-FORCE-OUTPUT ((stream fundamental-character-output-stream))
  (with-slots (string ) stream
	  ;;; YY Graphic stream
	      (if (graphic-stream-p stream)
		  (drawing-text stream (if (null string)
					   ""
					 (coerce (prog1 string (setq string nil)) 'simple-string))))
	      nil))

;;; LISP force output T.kosaka
(defmethod STREAM-FORCE-OUTPUT (stream)
  (lisp::FORCE-OUTPUT stream))


(defmethod STREAM-TERPRI ((stream fundamental-character-output-stream))
  (stream-write-char stream #\Newline)
  (with-slots (endp) stream
	      (setf endp 0))
  nil)

  ;;;; LISP TERPRI  T.kosaka
(defmethod STREAM-TERPRI (stream)
  (lisp::TERPRI stream))

(defmethod STREAM-FRESH-LINE ((stream fundamental-character-output-stream))
  (if (stream-start-line-p stream)
      nil
    (progn (stream-terpri stream) t)))

   ;;; LISP FRESH-LINE T.kosaka
(defmethod STREAM-FRESH-LINE (stream)
  (lisp::FRESH-LINE stream))


#|    Now Not Use !!!! T.kosaka
  (defmethod STREAM-ADVANCE-TO-COLUMN ((stream fundamental-character-output-stream) 
				       column)
    (let ((current (stream-line-column stream)))
      (unless (null current)
	(dotimes (i (- current column) t)
	  (stream-write-char stream #\space)))))


  (defmethod INPUT-STREAM-P ((stream fundamental-input-stream)) t)
  (defmethod INPUT-STREAM-P ((stream fundamental-output-stream))
    ;; allow the two classes to be mixed in either order
    (typep stream 'fundamental-input-stream
     (drawing-text stream (if string
			      string
			    "")))
))
|#

(defmethod OUTPUT-STREAM-P ((stream fundamental-character-output-stream)) t)

  ;;; Lisp OUTPUT-STREAM-P
(defmethod OUTPUT-STREAM-P (stream)
  (lisp::OUTPUT-STREAM-P stream))

  ;;; Add T.kosaka 
(defmethod STREAMP ((stream fundamental-character-output-stream)) t)

(defmethod STREAMP (stream)
  (lisp::streamp stream))



#|
  (defmethod OUTPUT-STREAM-P ((stream fundamental-input-stream))
    (typep stream 'fundamental-output-stream))
|#

  ;;;; Following is an example of how the existing I/O Methods could
  ;;;; be implemented using standard Common Lisp and the generic
  ;;;; Methods specified above.  The standard Methods being defined
  ;;;; are in upper case.

;;  Internal helper Methods

(proclaim '(inline decode-read-arg decode-print-arg check-for-eof))
(defun decode-read-arg (arg)
  (cond ((null arg) *standard-input*)
	((eq arg t) *terminal-io*)
	(t arg)))

(defun decode-print-arg (arg)
  (cond ((null arg) *standard-output*)
	((eq arg t) *terminal-io*)
	(t arg)))

(defun check-for-eof (value stream eof-errorp eof-value)
  (if (eq value :eof)
      (report-eof stream eof-errorp eof-value)
    value))

;;; added symbolics code 31.Oct.90
(defun report-eof (stream eof-errorp eof-value)
  (if eof-errorp
      #-symbolics
      (error 'end-of-file :stream stream)
      #+symbolics
      (error "~% End of File :stream ~a" stream)
    eof-value))

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;  Common Lisp input Methods ;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun READ-CHAR (&optional input-stream (eof-errorp t) eof-value recursive-p)
  (declare (ignore recursive-p)) ; a mistake in CLtL?
  (let ((stream (decode-read-arg input-stream)))
    (check-for-eof (stream-read-char stream) stream eof-errorp eof-value)))

(defun PEEK-CHAR (&optional peek-type input-stream (eof-errorp t) 
			    eof-value recursive-p)
  (declare (ignore recursive-p))
  (let ((stream (decode-read-arg input-stream)))
    (if (null peek-type)
	(check-for-eof (stream-peek-char stream) stream eof-errorp eof-value)
      (loop
       (let ((value (stream-peek-char stream)))
	 (if (eq value :eof)
	     (return (report-eof stream eof-errorp eof-value))
	   (if (if (eq peek-type t)
		   (not (member value '(#\space #\tab #\newline
					#\page #\return #\linefeed)))
		 (char= peek-type value))
	       (return value)
	     (stream-read-char stream))))))))

(defun UNREAD-CHAR (character &optional input-stream)
  (stream-unread-char (decode-read-arg input-stream) character))

(defun LISTEN (&optional input-stream)
  (stream-listen (decode-read-arg input-stream)))

(defun READ-LINE (&optional input-stream (eof-error-p t) 
			    eof-value recursive-p)
  (declare (ignore recursive-p))
  (let ((stream (decode-read-arg input-stream)))
    (multiple-value-bind (string eofp)
			 (stream-read-line stream)
			 (if eofp
			     (if (= (length string) 0)
				 (report-eof stream eof-error-p eof-value)
			       (values string t))
			   (values string nil)))))

(defun READ (&optional input-stream (eof-error-p t) 
		       eof-value recursive-p)
  (declare (ignore recursive-p))
  (let ((stream (decode-read-arg input-stream)))
    (multiple-value-bind (string eofp)
			 (stream-read stream)
			 (if eofp
			     (if (= (length string) 0)
				 (report-eof stream eof-error-p eof-value)
			       (values string t))
			   (values string nil)))))

;;; added symbolics code 31.Oct.90
(defun CLEAR-INPUT (&optional input-stream)
;  #-symbolics
  (stream-clear-input (decode-read-arg input-stream))
;  #+symbolics
;  (cl:CLEAR-INPUT (decode-read-arg input-stream))
  )

;;; added symbolics code 31.Oct.90
(defun READ-CHAR-NO-HANG (&optional input-stream (eof-errorp t) 
				    eof-value recursive-p)
  (declare (ignore recursive-p))
  (let ((stream (decode-read-arg input-stream)))
    (check-for-eof
;     #-symbolics
     (stream-read-char-no-hang stream)
;     #+symbolics
;     (cl:read-char-no-hang stream)
      stream eof-errorp eof-value)))

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;  Common Lisp output Methods  ;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun WRITE-CHAR (character &optional output-stream)
  (stream-write-char (decode-print-arg output-stream) character))

(defun FRESH-LINE (&optional output-stream)
  (stream-fresh-line (decode-print-arg output-stream)))

(defun TERPRI (&optional output-stream)
  (stream-terpri (decode-print-arg output-stream)))

(defun yy::WRITE-STRING (string &optional output-stream &key (start 0) end)
  (stream-write-string (decode-print-arg output-stream) string start end))

(defun WRITE-LINE (string &optional output-stream &key (start 0) end)
  (let ((stream (decode-print-arg output-stream)))
    (stream-write-string stream string start end)
    (stream-terpri stream)
    string))

(defun FORCE-OUTPUT (&optional stream)
  (stream-force-output (decode-print-arg stream)))

;;; added Symbolics code 31.Oct.90
(defun FINISH-OUTPUT (&optional stream)
;  #-symbolics
  (stream-finish-output (decode-print-arg stream))
;  #+symbolics
;  (cl:finish-output (decode-print-arg stream))
  )

;;; added Symbolics code 31.Oct.90
(defun yy::CLEAR-OUTPUT (&optional stream)
;  #-symbolics
  (stream-clear-output (decode-print-arg stream))
;  #+symbolics
;  (cl:clear-output (decode-print-arg stream))
  )


  ;;;  Binary streams
#|
  (defun READ-BYTE (binary-input-stream &optional (eof-errorp t) eof-value)
    (check-for-eof (stream-read-byte binary-input-stream) 
		   binary-input-stream eof-errorp eof-value))
  
  (defun WRITE-BYTE (integer binary-output-stream)
    (stream-write-byte binary-output-stream integer))
|#
  ;;;  String streams

#|
  (defclass string-input-stream (fundamental-character-input-stream)
    ((string :initarg :string :type string)
     (index :initarg :start :type fixnum)
     (end :initarg :end :type fixnum)
     ))
|#


(defun MAKE-STRING-INPUT-STREAM (string &optional (start 0) end)
  (make-instance 'string-input-stream :string string 
		 :start start :end (or end (length string))))

(defmethod stream-read-char ((stream yy-string-input-stream))
  (with-slots (index end string) stream
	      (if (>= index end)
		  :eof
		(prog1 (char string index)
		  (incf index)))
	      ))

;;;Window stream stream-read-char T.kosaka  
;;; added Symbolics code 31.Oct.90
(defmethod stream-read-char ((stream fundamental-character-input-stream))
  (let ((ret nil))
    (loop 
    #-symbolics
    (wait-process 'stream-listen stream)
    #+symbolics
    (wait-process #'stream-listen stream)
     (if (setf ret
	      (stream-read-char-no-hang stream)
	 )
	 (return ret)))
    (setf (for-unread-char stream) ret)))

;;; 2.Nov.90 Yohta
;(defmethod stream-read-char (stream)
;  (lisp:read-char stream)
;  )


(defmethod STREAM-READ-CHAR-NO-HANG ((stream yy-string-input-stream))
  (with-slots (index end string) stream
       (if (>= index end)
	   nil
	 (prog1 (char string index)
                  (incf index)))
       ))

;;;Window stream stream-read-char-no-hang T.kosaka  
(defmethod stream-read-char-no-hang ((stream fundamental-character-input-stream))
 ;;; 1$BJ8;z<h$j=P$9(B
  (let ((code nil))
    (with-slots (input-string) stream
     (if (null input-string)
	 nil
       (progn 
	 (setf code (elt input-string 0)
	       input-string (cdr input-string))
	 ;; 2.Nov.90 Yohta
#+:Symbolics
         (setf code (case (char-code code)
			((10 13)
			 #\Newline)
			(t
			 code)))

	 (setf (for-unread-char stream)
;	    (code-char code)
	   code)
	 )))))

(defmethod STREAM-CLEAR-INPUT ((stream yy-string-input-stream))
  (with-slots (index end string) stream
     (setf  string nil
	   index 0
	   end 0)))

(defmethod STREAM-CLEAR-INPUT ((stream fundamental-character-input-stream))
  (with-slots (input-string edit-string index) stream
      (setf input-string nil
	    edit-string nil
	    index 0))
  )

(defmethod stream-unread-char ((stream yy-string-input-stream) character)
  (with-slots (index  string) stream
	      (decf index)
	      (assert (eql (char string index) character))
	      nil))

;;; Window stream stream-unread-char T.kosaka
(defmethod stream-unread-char ((stream fundamental-character-input-stream) character)
  (with-slots (for-unread-char) stream
	      (assert (eql for-unread-char character))
	      nil))


(defmethod stream-read-line ((stream yy-string-input-stream))
  (with-slots (index end string) stream
	      (let* ((endline (position #\newline string :start index :end end))
		     (line (subseq string index endline)))
		(if endline
		    (progn (setq index (1+ endline))
			   (values line nil))
		  (progn (setq index end)
			 (values line t))))))

;;; string-output-stream CLASS 
#|
  (defclass string-output-stream (fundamental-character-output-stream)
    ((string :initform nil :initarg :string)))
|#
;;; For YY string-stream-output-stream
(defclass yy-string-output-stream (fundamental-character-output-stream) ())

;;;    ((string :initform nil :initarg :string)
;;;     (endp    :initform 0 :initarg :endp :type :integer)))

#|
  (defun MAKE-STRING-OUTPUT-STREAM ()
    (make-instance 'string-output-stream))

  (defun GET-OUTPUT-STREAM-STRING (stream)
    (with-slots (string) stream
      (if (null string)
	  ""
	(prog1 string (setq string nil)))))
|#

(defmethod stream-write-char ((stream fundamental-character-output-stream) character)
  (with-slots (string endp) stream
	      (when (null string)
		    (setq string (make-array 64. 
				:element-type
#-:EXCL
                      'string-char 
#+:EXCL
                      'character

					     :fill-pointer 0 :adjustable t)))
	      (vector-push-extend character string)
	      (incf endp)
	      character))

  ;;; Lisp write-char
(defmethod stream-write-char (stream character)
  (lisp::write-char character stream))

(defmethod STREAM-FINISH-OUTPUT ((stream fundamental-character-output-stream))
  (stream-force-output stream)
  )

(defmethod STREAM-FINISH-OUTPUT (stream)
  (lisp::FINISH-OUTPUT stream))

(defmethod STREAM-CLEAR-OUTPUT ((stream fundamental-character-output-stream))
  (with-slots (string endp) stream
      (setf (fill-pointer string) 0
	    endp 0)))

(defmethod STREAM-CLEAR-OUTPUT (stream)
  (lisp::CLEAR-OUTPUT stream))



#|
  (defmethod stream-line-column ((stream yy-string-output-stream))
    (with-slots (string) stream
      (if (null string)
	  0
	(let ((nx (position #\newline string :from-end t)))
	  (if (null nx)
	      (length string)
	    (- (length string) nx 1))
	  ))))
|#

;;; YY Stream   graphic stream  or string stream T.kosaka
(defmethod stream-line-column ((stream fundamental-character-output-stream))
  (with-slots (string endp ) stream
	      (if (zerop endp)
		  (if string
		      (length string)
		    0)
		endp)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; YY Edit read line T.kosaka    ;;;
;;; This is viewport mode         ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; added unwind-protect by Yohta on 5.Nov.90
(defmethod yy-edit-read-line ((stream viewport-window-stream))

  ;;; $B%F%-%9%H%+!<%=%k$r>C$9(B
  (display-text-cursor stream)

  ;;; $B%m!<%+%kDj?t$N@_Dj(B
      (setf (sx-position stream) (position-x (slot-value stream 'cursor-position))
	    (sy-position stream) (position-y (slot-value stream 'cursor-position))
	    (text-cursor-x stream) (position-x (slot-value stream 'cursor-position))
	    (text-cursor-y stream) (position-y (slot-value stream 'cursor-position))
	    (current-output-direction stream) (stream-output-direction stream)
	    (current-matrix stream) (stream-transform-by-matrix stream)
	    (current-text-color stream ) (graphic-color stream)
	    (current-line-feed stream) (slot-value stream 'line-feed)
	    (current-font stream) (stream-font stream)
	    (slot-value stream 'edit-string) nil
	    (slot-value stream 'index) 0
	    (current-operation stream) (get-text-edit-operation (world-back-color stream)
								(graphic-color stream)))

      (incf (text-curcor-visible stream))
  ;;; $BF~NO%;%l%/%7%g%s%F!<%V%k$K%&%#%s%I%&$r@_Dj(B
;	(vector-push-extend stream *cursor-display-table*)
      ;; added unwind-protect by Yohta on 5.Nov.90
      (let ((process *event-process*)
	    (cursor-write t))
	(unwind-protect
	    (let ((code nil) (kanji "  ")
		  (ret-val nil)
;		  (process *event-process*)
		  )
	      (if process
		  (progn 
		    (setf *event-process* nil)
		    (killed-process process)))
    ;;; Line feed or Return $B$,$/$k$^$G!"%k!<%W(B
    (loop 
      (setf cursor-write t)
      (display-text-cursor stream)
      (event-dispatch-window stream)
      (setf cursor-write nil)
      (display-text-cursor stream)
      ;;; 1$BJ8;z<h$j=P$9(B
      (with-slots (input-string index edit-string) stream
      
	(setf code (elt input-string 0)
	      input-string (cdr input-string))
      
          ;;; $BJ8;z%3%s%H%m!<%k(B
	  (if (assoc (char-code code) (input-mask-table stream))
	    ;;; $B4X?t<B9T(B
	    (funcall (cdr (assoc (char-code code) (input-mask-table stream)))
		 stream )

	      ;;; $BF~NO=hM}(B
	      (case (char-code code)
	         ;;; $B%G%k%_%?!<$,Mh$?!#(B
		 ((10 13)
		  ;;; $B%G%k%_%?!<F~NO;~$NI=<(=hM}(B
		  (end-comming-disply stream  )
		  (setf ret-val (coerce edit-string 'simple-string))
				      
		  (return))
		 
		 ;;; $BF~NOJ8;z(B
		 (T

		  (if (> (char-code code) #xA1)
      		       ;;; $B4A;z$,Mh$?(B
                      (if (char= (char kanji 0) #\space)
			  (setf (char kanji 0) code)
			(progn
			  (if (= (length edit-string) index)
			      (add-end-display stream  (setf (char kanji 1) code))
			    (add-continue-display stream  (setf (char kanji 1) code)))
			  (setf (char kanji 0) #\space)))

                      ;;; $B%"%9%-!<J8;z(B
		      (if (= (length edit-string) index)
			  (add-end-display stream  (string code))
			(add-continue-display stream  (string code)))))
					   
		 ))))
      ret-val)
	  (if process
	      (setf *event-process* (run-process 'event-dispatch)))
	  (if (and cursor-write (zerop (- (text-curcor-visible stream) 1)))
	      (display-text-cursor stream))

	  (decf (text-curcor-visible stream))
	  )
	)
      )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; YY Edit read line T.kosaka    ;;;
;;; This is Page mode             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; added unwind-protect by yohta on 4.Nov.90
(defmethod yy-edit-read-line ((stream page-window-stream))
  (let ((process *event-process*))
    ;; added unwind-protect by yohta on 4.Nov.90
    (unwind-protect
	(let ((terminate-string "  ")
	      (interrupt-string " ")
	      (ret-string nil))

    ;;; $BF~NO%W%m%;%9$NCf;_(B
    (if process
	(progn 
	  (setf *event-process* nil)
	  (killed-process process)))
      
    ;;; $B=*N;%-!<$N@_Dj(B
    (setf (char terminate-string 1)
	  (code-char 10)
	  (char terminate-string 0)
	  (code-char 13))

    (setf (char interrupt-string 0)
	  (code-char 3))

    ;;; $B%W%m%H%3%k$r@8@.(B
    (yy-protocol-82 (world-territory-no stream)
		    (page-column stream)
		    (page-line stream)
		    1
		    ""
		    terminate-string
		    interrupt-string)

    (loop 
     ;;; $BJ8;zNs$,F~$k$^$G%k!<%W(B
     (event-dispatch-window stream)

     (if (> (length (slot-value stream 'input-string)) 0)
	 (return)))

      ;;; $BJ8;zNs$r<h$j=P$9(B
    (setf ret-string (coerce (stream-input-string-internal stream) 'string))

    ;;; $BF~NOJ8;zNs$r#0$K$9$k(B
    (setf (slot-value stream 'input-string) nil)
    
    ;;; $B%W%m%;%9$N5/F0(B
;    (if process
;	(setf *event-process* (run-process 'event-dispatch)))
    ret-string)
      (progn 
	(if process
	  (setf *event-process* (run-process 'event-dispatch)))
	(yy-protocol-83 (world-territory-no stream))))
    )
  )


    
;;; $B%G%k%_%?!<$NF~NO;~$NI=<((B
(defmethod end-comming-disply ((stream fundamental-character-input-stream) )
  (with-slots (edit-string) stream

      ;;; $BA0$NI=<($r>C$9(B
      (drawing-text-read stream (coerce edit-string 'simple-string) 
			 (sx-position stream)
			 (sy-position stream) (current-operation stream) nil)

      (drawing-text-read stream (coerce edit-string 'simple-string) 
			 (sx-position stream)
			 (sy-position stream) (graphic-operation stream) nil)
      ))


;;; $B#1J8;zF~NO(B $B:G8eHx$KDI2C(B
(defmethod add-end-display ((stream fundamental-character-input-stream) 
				(data string))  ;;; $B:GBg#2J8;z(B
  (let ((ret-pos nil))
    (with-slots (edit-string index) stream
	(setf ret-pos (drawing-text-read stream data
					 (text-cursor-x stream) 
					 (text-cursor-y stream) 
					 (current-operation stream) )
	    (text-cursor-x stream) (first ret-pos)
	    (text-cursor-y stream) (second ret-pos))

	(if (= (length data) 2)
	    (progn 
	      (incf index)
	      (setf edit-string (nconc edit-string (list (char data 0)
							 (char data 1)))))
	  (setf edit-string (nconc edit-string (list (char data 0)))))
	(incf index))))



;;; $B#1J8;zF~NO(B $BESCf0LCV$KDI2C(B
(defmethod add-continue-display ((stream fundamental-character-input-stream) 
				 (data string))
  (let ((ret-pos nil))
    (with-slots (edit-string index) stream
         ;;; $B%+!<%=%k0J9_$r>C5n(B
	 (drawing-text-read stream 
			    (coerce (nthcdr index edit-string) 'simple-string)
			    (text-cursor-x stream)
			    (text-cursor-y stream) 
			    (current-operation stream)  NIL)

	 (if (< (length data) 2)
	     (if (= index 0)
		 (push (char data 0) edit-string)
	       (let ((sub (nthcdr (- index 1) edit-string)))
		 (setf (cdr sub) (cons (char data 0) (cdr sub))
	           ;;; $BA^F~J8;z$rIA2h(B
		   ret-pos (drawing-text-read stream data 
					      (text-cursor-x stream)
					      (text-cursor-y stream) 
					      (current-operation stream))
		   (text-cursor-x stream) (first ret-pos)
		   (text-cursor-y stream) (second ret-pos))))

	   ;;; $B4A;z$N>l9g(B
	     (if (= index 0)
		 (setq edit-string 
		   (nconc (list (char data 0) (char data 1))
			  edit-string))
	     (let ((sub (nthcdr (- index 1) edit-string)))
	       (setf (cdr sub) (list* (char data 0) (char data 1)
				      (cdr sub))
	      ;;; $BA^F~J8;z$rIA2h(B
	      ret-pos (drawing-text-read stream data (text-cursor-x stream)
                                  (text-cursor-y stream) 
				  (current-operation stream))
	      (text-cursor-x stream) (first ret-pos)
              (text-cursor-y stream) (second ret-pos))
	       )))
	 
	 ;;; $B;D$j$NJ8;z$rIA2h(B
	 (drawing-text-read stream 
			    (coerce (subseq edit-string (incf index)) 
				    'simple-string)
			    (text-cursor-x stream)
			    (text-cursor-y stream) 
			    (current-operation stream)
			    NIL))
    ))


;;; $B#1J8;z>C5n(B
(defun delete-text (stream )
  (with-slots (edit-string index) stream
    (when (not (zerop (length edit-string)))
         ;;; $B%+!<%=%k0J9_$r>C5n(B
	 (drawing-text-read stream 
			    (coerce (subseq edit-string index) 'simple-string)
			    (text-cursor-x stream)
			    (text-cursor-y stream) 
			    (current-operation stream)  NIL)
	 
	 ;;; $B4A;z$rD4$Y$k(B
	 (if (>= (char-code (elt edit-string index)) #xA1)
	       (setf edit-string
		     (delete (elt edit-string index) edit-string :count 1)))
	       
	 (setf edit-string 
	       (delete (elt edit-string index) edit-string :count 1))

	 (when (> (length (subseq edit-string index)) 0 )

	     ;;; $B;D$j$NJ8;z$rIA2h(B
	     (drawing-text-read stream 
			(coerce (subseq edit-string index) 'simple-string)
			(text-cursor-x stream)
			(text-cursor-y stream) 
			(current-operation stream)
			NIL)
	     )
	 )))

;;; $BA0$NJ8;z$r>C5n(B
(defun back-space-text (stream )
  (with-slots (edit-string index) stream
      (when (and (not (zerop (length edit-string))) (> index 0))
	 (let ((ret nil))
	   ;;; $BA0$NJ8;z$N0LCV$r5a$a$k(B
	   ;;; $B4A;z$rD4$Y$k(B
	   (if (>= (char-code (elt edit-string (- index 1))) #xA1)
	       (decf index 2)
	     (decf index 1))

	   (setf ret (text-read-cursor stream 
		       (coerce (subseq edit-string 0 index) 'simple-string)
		       (sx-position stream) 
		       (sy-position stream))
		 (text-cursor-x stream) (first ret)
		 (text-cursor-y stream) (second ret))

	   ;;; $B%+!<%=%k0J9_$r>C5n(B
	 (drawing-text-read stream 
		    (coerce (subseq edit-string index) 'simple-string)
		    (text-cursor-x stream)
		    (text-cursor-y stream) 
		    (current-operation stream)  NIL)
	 
	   ;;; $B4A;z$rD4$Y$k(B
         (if (>= (char-code (elt edit-string index)) #xA1)
	     (if (= index 0)
		 (progn (pop edit-string)
			(pop edit-string))
	       (let ((sub (nthcdr (- index 1) edit-string)))
		 (setf (cdr sub) (cdddr sub))))
	   (if (= index 0)
	       (pop edit-string)
	     (let ((sub (nthcdr (- index 1) edit-string)))
	       (setf (cdr sub) (cddr sub)))))
	       
         (when (> (length (subseq edit-string index)) 0)
	       (drawing-text-read stream 
			 (coerce (subseq edit-string index) 'simple-string)
			 (text-cursor-x stream)
			 (text-cursor-y stream) 
			 (current-operation stream)
			 NIL))
	 ))
      ))

;;; $B%+!<%=%k$rA0$K$9$k(B
(defun before-cursor-text (stream)
  (with-slots (edit-string index) stream
      (when (and (not (zerop (length edit-string))) (> index 0))
         (let ((ret nil))
	   ;; $BA0$NJ8;z$N0LCV$r5a$a$k(B
           ;;; $B4A;z$rD4$Y$k(B
           (if (>= (char-code (elt edit-string (- index 1))) #xA1)
               (decf index 2)
             (decf index 1))

           (setf ret (text-read-cursor stream 
			   (coerce (subseq edit-string 0 index) 'simple-string)
			   (sx-position stream) 
			   (sy-position stream))
                 (text-cursor-x stream) (first ret)
                 (text-cursor-y stream) (second ret))
	   )
	 )))


;;; $B%+!<%=%k$r8e$m$K$9$k(B
(defun next-cursor-text (stream)
  (with-slots (edit-string index) stream
     (when (< index (length edit-string))
	   (let ((ret nil))
	     (if (< (+ index 1) (length edit-string))
	       ;;; $B8e$m$NJ8;z$rD4$Y$k(B
		 (if (>= (char-code (elt edit-string (+ index 1))) #xA1)
			 (incf index 2)
		       (incf index 1))
		 (incf index))
		
	     (setf ret (text-read-cursor stream 
		         (coerce (subseq edit-string 0 index) 'simple-string)
			 (sx-position stream) 
			 (sy-position stream))
		   (text-cursor-x stream) (first ret)
		   (text-cursor-y stream) (second ret))))

     ))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; YY Edit read  T.kosaka    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; update 2.Nov.90 Yohta Modifyed to use standard character 
(defmethod yy-edit-read ((stream viewport-window-stream))
  ;;; $B%F%-%9%H%+!<%=%k$r>C$9(B
  (display-text-cursor stream)

  ;;; $B%m!<%+%kDj?t$N@_Dj(B
  (setf (sx-position stream) (position-x (slot-value stream 'cursor-position))
	(sy-position stream) (position-y (slot-value stream 'cursor-position))
	(text-cursor-x stream) 
	(position-x (slot-value stream 'cursor-position))
	(text-cursor-y stream) 
	(position-y (slot-value stream 'cursor-position))
	(current-output-direction stream) (stream-output-direction stream)
	(current-matrix stream) (stream-transform-by-matrix stream)
	(current-text-color stream ) (graphic-color stream)
	(current-line-feed stream) (slot-value stream 'line-feed)
	(current-font stream) (stream-font stream)
	(slot-value stream 'edit-string) nil
	(slot-value stream 'index) 0
	(current-operation stream) 
	(get-text-edit-operation (world-back-color stream)
				 (graphic-color stream)))

  (incf (text-curcor-visible stream))
  ;;; $BF~NO%;%l%/%7%g%s%F!<%V%k$K%&%#%s%I%&$r@_Dj(B
  (vector-push-extend stream *cursor-display-table*)
  ;; added unwind-protect by yohta on 4.Nov.90
  (let ((process *event-process*)
	(cursor-write t))
    (unwind-protect
	(let ((code nil) (kanji "  ")
	      (ret-val1 nil) (ret-val2 nil)
	      (cr-flg nil)
;	      (process *event-process*)
	      )
	  (if process
	      (progn 
		(setf *event-process* nil)
		(killed-process process)))
    ;;; Line feed or Return $B$,$/$k$^$G!"%k!<%W(B
    (loop 
      (setf cursor-write t)
      (display-text-cursor stream)
      (event-dispatch-window stream)
      (display-text-cursor stream)
      (setf cursor-write nil)
      ;;; 1$BJ8;z<h$j=P$9(B
      (with-slots (input-string index edit-string) stream
      
	(setf code (elt input-string 0)
	      input-string (cdr input-string))
      
#+:symbolics
          (setf code (case (char-code code)
		       ((10 13)
			#\linefeed)
		       (t 
			code)))
          ;;; $BJ8;z%3%s%H%m!<%k(B
	  (if (assoc (char-code code) (input-mask-table stream))
	    ;;; $B4X?t<B9T(B
	    (funcall (cdr (assoc (char-code code) (input-mask-table stream)))
		 stream)
	 ;;; $BF~NO=hM}(B
	 (progn 
	   (if (> (char-code code) #xA1)
      	     ;;; $B4A;z$,Mh$?(B
             (if (char= (char kanji 0) #\space)
		 (setf (char kanji 0) code)
	       (progn
		 (if (= (length edit-string) index)
		     (add-end-display stream (setf (char kanji 1) code))
		   (add-continue-display stream (setf (char kanji 1) code)))
		 (setf (char kanji 0) #\space)))

               ;;; $B%"%9%-!<J8;z(B
               (progn
		 ;; 2.Nov.90 Yohta
		 (when (member (char-code code) 
			       (list 10 13  (char-code #\linefeed)
				     (char-code #\space)))
		     ;(member code '(#\return #\linefeed #\newline))
		       (setf cr-flg T))
		     
		 (if (= (length edit-string) index)
		     (add-end-display stream (string code))
		   (add-continue-display stream (string code)))))

	   ;;; $B=*N;%A%'%C%/(B
           (multiple-value-setq (ret-val1 ret-val2)
		    ;; 13.Aug.90 yohta added #+ExCL and #-ExCL
                 (#-(or ExCL Symbolics) ignore-errors
                  #+ExCL excl::ignore-errors
		  #+Symbolics scl:ignore-errors
		  			(read-from-string 
					     (coerce edit-string 
						     'simple-string))))
	   ;; Modifyed by Yohta on 2.Nov.90
	   ;; For ignore-errors of multi-lisp-implementation.
	   ;; On case of Symbolics, 2nd returned value is error condition.
	   ;; But the other case, 2nd returned value is last form result or
	   ;; error condition.
           (if (and #-Symbolics (numberp ret-val2)
		    #+Symbolics (not ret-val2)
		    cr-flg)
	       (return)
	     (if (and #-Symbolics (numberp ret-val2)
		      #+Symbolics (not ret-val2)
		      (not (or
			  (eq 'SYMBOL (type-of ret-val1))
			  (eq 'FIXNUM (type-of ret-val1))
			  (eq 'BIGNUM (type-of ret-val1))
			  (eq 'FLOAT (type-of ret-val1))
			  (eq 'COMPLEX (type-of ret-val1)))))
		      (return)))
		 ))))
      (vector-pop *cursor-display-table*)

      ;;; $B%+!<%=%k$N0LCV$rJQ99(B
      (if (eq (stream-output-direction  stream) :vertical)
	  (setf (position-x (slot-value stream 'cursor-position))
	    (text-cursor-x stream))
	
	(setf (position-y (slot-value stream 'cursor-position)) 
	  (text-cursor-y stream)))

      ret-val1)
      (if process
	  (setf *event-process*
	    (run-process 'event-dispatch)))
      (if (and cursor-write (zerop (- (text-curcor-visible stream) 1)))
	  (display-text-cursor stream))
      (decf (text-curcor-visible stream))
      )
    )
  )

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; YY Edit read line T.kosaka    ;;;
;;; This is Page mode             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod yy-edit-read ((stream page-window-stream))
  (let ((process *event-process*)
	(ret nil))
    ;; added unwind-protect by yohta on 5.Nov.90
    (unwind-protect
	(let ((terminate-string "  ")
	      (interrupt-string " ")
	      (semi-strminate-string "    ")
	      (ret-string nil) (ret-val1 nil) (ret-val2 nil)
	      (event-list nil))

    ;;; $BF~NO%W%m%;%9$NCf;_(B
    (if process
	(progn 
	  (setf *event-process* nil)
	  (killed-process process)))
      
    ;;; $B=*N;%-!<$N@_Dj(B
    (setf (char terminate-string 0)
	  (code-char 10)
	  (char terminate-string 1)
	  (code-char 13))

    ;;; $B3d$j9~$_$-!<$N@_Dj(B
    (setf (char interrupt-string 0)
	  (code-char 3))

    ;;; $BESCfDd;_%-!<$N@_Dj(B
    (setf (char semi-strminate-string 1)
	  #\)
	  (char semi-strminate-string 2) #\"
	  (char semi-strminate-string 3) (code-char 13))

    ;;; $B%W%m%H%3%k$r@8@.(B
    (yy-protocol-82 (world-territory-no stream)
		    (page-column stream)
		    (page-line stream)
		    1
		    semi-strminate-string
		    ""
		    interrupt-string)

    ;;; $BJ8;zNs$r>C5n(B
    (setf (slot-value stream 'input-string) nil)

    (loop 
     ;;; $BJ8;zNs$,F~$k$^$G%k!<%W(B
     (event-dispatch-window stream)
     (when (> (length (slot-value stream 'input-string)) 0)

       (setf event-list (stream-input-string-internal stream))

       ;;; $BF~NOJ8;zNs$r#0$K$9$k(B
       (setf (slot-value stream 'input-string) nil)
       
        ;;; $BJ8;zNs$r<h$j=P$9(B
       (setf ret-string 
	 (coerce event-list 'string))

#+:symbolics 
       (dotimes (i (length ret-string))
	 (if (or (= 10 (char-code (char ret-string i)))
		 (= 13 (char-code (char ret-string i))))
	     (setf (char ret-string i) #\Newline)))

;(format t "~a ~%" ret-string)

	   ;;; $B=*N;%A%'%C%/(B
       (multiple-value-setq (ret-val1 ret-val2)
			 ;; 13.Aug.90 yohta added #+ExCL and #-ExCL
			 (#-(or ExCL Symbolics) ignore-errors
			    #+ExCL excl::ignore-errors
			    #+Symbolics scl:ignore-errors;2.Nov.90 Yohta
				 (read-from-string ret-string)))
      ;; Modifyed by Yohta on 2.Nov.90
       (if (or #-Symbolics (numberp ret-val2)
	       #+Symbolics (not ret-val2)
	       (eq 'SYMBOL (type-of ret-val1))
	       (eq 'FIXNUM (type-of ret-val1))
	       (eq 'BIGNUM (type-of ret-val1))
	       (eq 'FLOAT (type-of ret-val1))
	       (eq 'COMPLEX (type-of ret-val1)))

	   (return))
       )
      )

    ;;; $BF~NOJ8;zNs$r#0$K$9$k(B
    (setf (slot-value stream 'input-string) nil)

    ;;; $B9T$H(By-position $B$r@_Dj(B
    (setf ret (yy-protocol-84 (world-territory-no stream)
			      (graphic-operation stream)
			      (color-no (graphic-color stream))
			      (font-no (stream-font stream))
			      " "))
    (set-y-position-for-page-maode stream (nth 4 ret) (nth 5 ret))
    
    ;;; $B%W%m%;%9$N5/F0(B
    ret-val1)

      ;;; $B%W%m%;%9$N5/F0(B
      (progn 
	(if process
	    (setf *event-process* (run-process 'event-dispatch)))
	(yy-protocol-83 (world-territory-no stream)))
      )
    )
  )


;;; $B%(%G%#%C%HMQ$NJ8;zNsI=<((B
(defun drawing-text-read (stream string x y op  &optional (mode T))
  (if (eq (current-output-direction stream) :vertical)
      (drawing-text-read-tate stream string x y op mode)
    (drawing-text-read-yoko stream string x y op  mode)))

;;; $B%+!<%=%k$N0LCV$r5a$a$k(B
(defun text-read-cursor (stream string x y)
  (let ((ret nil))
    (if (eq (current-output-direction stream) :vertical)
        (setf ret (string-display-region-tate
		   (current-font stream) 
		   (work-region2 stream) string (current-line-feed stream)
		   x y (current-matrix stream) (stream-top-margin stream)
		   (stream-bottom-margin stream)
		   (stream-translate-coordinate stream)))

      (setf ret (string-display-region-yoko
                 (current-font stream) 
		 (work-region2 stream) string (current-line-feed stream)
                 x y (current-matrix stream) (stream-left-margin stream)
                 (stream-right-margin stream)
		 (stream-translate-coordinate stream)))
      )
    (list (second ret) (third ret))))




  



