;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $B%&%#%s%I%&$N%a%=%C%I4XO"(B
;;; window-method.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%&%#%s%I%&$N%^%K%e%T%e%l%$%H(B
;;; 6/20 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-6-20

(in-package :yy)

    
;;; $B%*%V%8%'%/%H$N$"$k0LCV$r%k!<%H%&%#%s%I%&%9%H%j!<%`$+$i$N0LCV$KJQ99$7$?(B
;;; $B0LCV$r5a$a$k(BXY$BMQ(B $B%&%#%s%I%&%9%H%j!<%`MQ(B
(defmethod translate-root-xy ((window window-stream) x y)
  (declare (inline +)
	   (special *root-window*))
  (let* ((frame-region (frame-region window))
	 (window-region (window-region window)))

    (if (eq *root-window* window)
	(values (+ x (slot-value window 'world-x-offset) 
		   (region-left frame-region)
		   (region-left window-region))
		(+ (with-translate-coordinate-stream y window)
		   (region-bottom frame-region) (region-bottom window-region)))
    (translate-root-xy (parent-window window)
	    (+ x (slot-value window 'world-x-offset) (region-left frame-region)
	       (region-left window-region))
	    (+ (with-translate-coordinate-stream y window)
	       (region-bottom frame-region) (region-bottom window-region)))
     )))

;;; $B%*%V%8%'%/%H$N$"$k0LCV$r%k!<%H%&%#%s%I%&%9%H%j!<%`$+$i$N0LCV$KJQ99$7$?(B
;;; $B0LCV$r5a$a$k(BXY$BMQ(B $BIA2h%j!<%8%g%sMQ(B
(defmethod translate-root-xy ((object drawable-piece) x y)
  (if (window-streamp (object-parent object))
      (let ((region (window-region (object-parent object))))
	(translate-root-xy (parent-window (object-parent object))
			 (+ x (region-left object) 
			    (region-left region))
			 (+ y (region-bottom object)
			    (region-bottom region))))
    (translate-root-xy (object-parent object)
		       (+ x (region-left object))
		       (+ y (region-bottom object)))))

;;; $B%*%V%8%'%/%H$N$"$k0LCV$r%k!<%H%&%#%s%I%&%9%H%j!<%`$+$i$N0LCV$KJQ99$7$?(B
;;; $B0LCV$r5a$a$k(BXY$BMQ(B $B%\!<%@MQ(B
(defmethod translate-root-xy ((object window-border) x y)
  (let ((parent (parent-window object)))
    (translate-root-xy (parent-window parent)
       (+ x (region-left (window-region parent)))
       (+ y (region-bottom (window-region parent))))))

;;; $B%*%V%8%'%/%H$N$"$k0LCV$r%k!<%H%&%#%s%I%&%9%H%j!<%`$+$i$N0LCV$KJQ99$7$?(B
;;; $B0LCV$r5a$a$k(BXY$BMQ(B $B%U%l!<%`MQ(B
(defmethod translate-root-xy ((object window-frame) x y)
  (let ((parent (parent-window object)))
    (translate-root-xy (parent-window parent)
       (+ x (region-left (window-region parent))
	  (region-left object))
       (+ y (region-bottom (window-region parent))
	  (region-bottom object)))))


;;; $B%k!<%H%&%#%s%I%&$N0LCV$+$i;XDj$5$l$?%&%#%s%I%&$N0LCV$K$9$k(B
(defmethod root-fram-window-position-xy ((window window-stream)
				      (x integer) (y integer))
  (multiple-value-bind (xx yy) (translate-root-xy window 0 
			          (- (with-translate-coordinate-stream 0 window)))
     (let ((new-x (- x xx))
	   (new-y (- y yy)))

       ;;; $B:BI8JQ498e$N0LCV$rJV$9(B
       (values new-x (with-translate-coordinate-stream new-y window))))
     )

;;; $BM?$($i$l$?%&%#%s%I%&$NM?$($i$l$?$"$k0LCV$+$i(B
;;; $B;XDj$5$l$?%&%#%s%I%&$N0LCV$rJV$9(B X Y $BMQ(B
(defmethod translate-window-xy-to-xy ((s-window window-stream)
				      (x integer) (y integer)
				      (d-window window-stream))
  (multiple-value-bind (xx yy) (translate-root-xy s-window x y)
    (root-fram-window-position-xy d-window xx yy)))

;;; whichw
;;; $B%^%&%9$,$"$k0LCV$N%&%#%s%I%&$rJV$9(B
;;; ARGS.
;;;             none
;;; RET.
;;;             $B%&%$%s%I%&%9%H%j!<%`(B
(defun whichw ()
  (let* ((mouse-state (mouse-status))
	 (object (mouse-state-object mouse-state)))
    (parent-stream object)))

;;; whicw-with-button
;;; $B%^%&%9$,2!2<$5$l$?$H$-$N%&%#%s%I%&$rJV$9(B
;;; ARGS.
;;;            none
;;; RET.
;;;            $B%&%#%s%I%&%9%H%j!<%`(B
(defun whichw-with-button ()
  (let* ((mouse-state nil))
    ;;; $B%^%&%9$,2!2<$5$l$k$^$GBT$D(B
    (with-mouse-grabbed *GET-POSITION-MOUSE-CURSOR*
       (loop
	 (setf mouse-state (mouse-status))
	  (unless (zerop (logand (mouse-state-button-state mouse-state)
                                  *mouse-button-down-1*))
	    (return))
	 ))

    (parent-stream (mouse-state-object mouse-state))))
    

;;; $B%^%&%9$,2!2<$5$l$?0LCV$rJV$9(B XY$BMQ(B
(defun get-position-xy (&optional (window *root-window*))
  (declare (special *GET-POSITION-MOUSE-CURSOR*))
  (if (window-streamp window)
      (let ((mouse-state nil))
		      
        ;;; $B$J$K$+%\%?%s$,2!$5$l$k$^$GBT$D(B
	(with-mouse-grabbed *GET-POSITION-MOUSE-CURSOR*
	   (loop 
	    (setf mouse-state (mouse-status))
	  
	    (if (not (zerop (logand (mouse-state-button-state mouse-state)
				  *mouse-button-down-1*)))
                ;;; $B2!2<$5$l$?(B
		(return))
	     ))
	(multiple-value-bind (xx yy)
	    (translate-root-xy (mouse-state-object mouse-state)
			       (mouse-state-x-position mouse-state)
			       (mouse-state-y-position mouse-state))
	  (if (eq *root-window* window)
	      (values xx yy)
	    (root-fram-window-position-xy window xx yy))
	  ))
    (error "The argument ~a is not a window stream" window)))


;;; get-position
;;; $B%^%&%9$,2!2<$5$l$?0LCV$rJV$9(B $B%]%8%7%g%sMQ(B
(defun get-position (&optional (window *root-window*))
  (multiple-value-bind (x y) (get-position-xy window)
    (make-position :x x :y y))
  )


(defvar *no-clip-territory1* nil)
(defvar *no-clip-territory2* nil)
(defvar *no-clip-territory3* nil)
(defvar *no-clip-territory4* nil)

#|
                        *no-clip-territory1*
                     +-----------------------+
*no-clip-territory2* |                       |*no-clip-territory4*
                     |                       |
                     +-----------------------+
                       *no-clip-territory3*
|#

;;; draw-region-region-no-clip
;;; $B6k7A$NIA2h$G!"A4$F$N%&%#%s%I%&$N%/%j%C%W$r$7$J$$(B
;;; $BM?$($i$l$k%j!<%8%g%s$O!"%k!<%H%&%#%s%I%&$K$*$1$k:BI8$G$"$k!#(B
(defmethod draw-region-region-no-clip ((stream graphic-stream) (region region))
  (declare (inline +))
  (WITH-INHIBIT-SCHEDULING
   (let ((x (region-left region))
	 (y (region-bottom region))
	 (width (region-width region))
	 (height (region-height region)))
        ;;; $B0\F05Z$S%5%$%:$NJQ99(B
     (yy-protocol-4 *no-clip-territory1* x y width 1)
     (yy-protocol-4 *no-clip-territory2* x y 1 height)
     (yy-protocol-4 *no-clip-territory3* x (+ y height) width 1)
     (yy-protocol-4 *no-clip-territory4* (+ x width) y 1 height))
   ))
      

;;; setup-draw-region-region-no-clip
;;; $B6k7A$NIA2h$G!"A4$F$N%&%#%s%I%&$N%/%j%C%W$r$7$J$$(B
;;; $BM?$($i$l$k%j!<%8%g%s$O!"%k!<%H%&%#%s%I%&$K$*$1$k:BI8$G$"$k!#(B
;;; mode -> T $BI=<((B mode -> nil $BHsI=<((B
(defmethod setup-draw-region-region-no-clip ((stream graphic-stream) 
					     (color color) mode)
  (WITH-INHIBIT-SCHEDULING
     (if mode
	 ;;; $BIA2h(B
	 (if (null *no-clip-territory1*)
	     (progn  
	       (setf 
		   *no-clip-territory1* (make-territory :x 0 :y 0 :width 1 
			          :height 1
				  :window-mode T
				  :parent (world-territory-no *root-window*))
	       *no-clip-territory2* (make-territory :x 0 :y 0 :width 1 
			          :height 1
				  :window-mode T
				  :parent (world-territory-no *root-window*))
	       *no-clip-territory3* (make-territory :x 0
				  :y 0
				  :width 1
			          :height 1
				  :window-mode T
				  :parent (world-territory-no *root-window*))
	       *no-clip-territory4* (make-territory 
				  :x 0
				  :y 0 :width 1
			          :height 1 
				  :window-mode T
				  :parent (world-territory-no *root-window*)))
	
	       ;;; $B%F%j%H%j!<$r;XDj$N?'$K$9$k(B
	       (yy-protocol-32 *no-clip-territory1* (color-no color))
	       (yy-protocol-32 *no-clip-territory2* (color-no color))
	       (yy-protocol-32 *no-clip-territory3* (color-no color))
	       (yy-protocol-32 *no-clip-territory4* (color-no color))
	       )
           ;;; $B0lHV>e$K$@$7!"IA2h%b!<%I(B
	   (progn 
	     (yy-protocol-7 *no-clip-territory1*)
	     (yy-protocol-7 *no-clip-territory2*)
	     (yy-protocol-7 *no-clip-territory3*)
	     (yy-protocol-7 *no-clip-territory4*)

	     (yy-protocol-2 *no-clip-territory1* 1)
	     (yy-protocol-2 *no-clip-territory2* 1)
	     (yy-protocol-2 *no-clip-territory3* 1)
	     (yy-protocol-2 *no-clip-territory4* 1)
	     ))
       ;;; $BHsI=<((B
       (progn
	 (yy-protocol-2 *no-clip-territory1* 0)
	 (yy-protocol-2 *no-clip-territory2* 0)
	 (yy-protocol-2 *no-clip-territory3* 0)
	 (yy-protocol-2 *no-clip-territory4* 0))
       )))


;;; get-box-region 
;;; $BNN0h$rF@$k(B
;;; get-box-region (init-region region &key end-condition *mouse-right-1*)
;;;                           (change-condition *mouse-left-1*)
;;;                           (move-mode :corner)
;;;                           (window *root-window*))
;;; ARGS.
;;; init-region $B=i4|%j!<%8%g%s$N@_Dj(B $B%k!<%H%&%#%s%I%&$K$*$1$k%j!<%8%g%s(B
;;; &key
;;; end-condition $B=*N;$N%^%&%9%\%?%s(B
;;; change-condition move-mode$B$,(B:corner$B$N$H$-!"3Q$NJQ99$rMW5a$9$k(B
;;;                  end-condition$B$,2!2<$5$l$?$b$C$H$b6a$$3Q$,A*$P$l$k(B
;;; move-mode   :corner $B3Q$G!"6k7A$,F0$/!#%]%8%7%g%s$,M?$($i$l$l$P!"(B
;;;             $B$=$N%]%8%7%g%s$r%^%&%9$N2TF/$9$k0LCV$H$7$F6k7A$,F0$/(B
;;;             $B%]%8%7%g%s$O!"%j!<%8%g%s$N:8>e6y$r86E@$H$7$?0LCV(B
;;; window      $B5a$^$C$?:BI8$r;XDj$5$l$?%&%#%s%I%&$N:BI8$K$9$k(B
(defmethod get-box-region ((init-region region)
			   &key (end-condition *mouse-right-1*)
			   (change-condition *mouse-left-1*)
			   (move-mode :corner)
			   (window *root-window*))

  (if (window-streamp window)
      (let* ((mouse-s (mouse-status))
	     (sub-status t)
	     (status nil)
	     (shift-x 0)
	     (shift-y 0)
	     (root-x 0)
	     (root-y 0))
	(multiple-value-setq (root-x root-y) 
	  (translate-root-xy (mouse-state-object mouse-s)
			     (mouse-state-x-position mouse-s)
			     (mouse-state-y-position mouse-s)))
         ;;;$BOH$NI=<((B
	(setup-draw-region-region-no-clip *root-window* 
					  (graphic-color window) T)
	(draw-region-region-no-clip *root-window* init-region)

        ;;; $B=hM}$r7+$jJV$9(B
	(loop

	  (setf mouse-s (mouse-status))

	  (multiple-value-setq (root-x root-y)
	    (translate-root-xy (mouse-state-object mouse-s)
			       (mouse-state-x-position mouse-s)
			       (mouse-state-y-position mouse-s)))

;	  (format t "~a ~a~%" root-x root-y)
         ;;; $B%\%?%s$N>uBV$r8+$k(B
	  (cond 
	   ((not (zerop (logand (mouse-state-button-state mouse-s)
			       end-condition)))
	    (if (null status)
	        ;;; $B=*N;(B
		(return)
	       ;;; $B%3!<%J!<$N7hDj(B
	      (multiple-value-bind (x y) 
		  (near-corner-xy init-region root-x root-y)
		(setf shift-x (- (region-left init-region) x)
		      shift-y (- (region-bottom init-region) y)
		      sub-status nil))))
	       
	    ((not (zerop (logand (mouse-state-button-state mouse-s)
				  change-condition)))
	      ;;; corner$B$N%A%'%C%/(B
		(unless (position-p move-mode)
		  (setf status T)))
	  (t
	   (if (null sub-status)
	       (setf sub-status T
		     status nil))
	   (unless status
		  ;;; $B?7$7$$0LCV$r5a$a!"OH$NIA2h(B
		  (draw-region-region-no-clip *root-window*
			  (set-region-position-xy init-region
				 (+ shift-x root-x)
				 (+ shift-y root-y)))))
	      ))
	(setup-draw-region-region-no-clip *root-window* 
					  (graphic-color window) nil)
        ;;; $B%k!<%H%&%#%s%I%&$N%A%'%C%/(B
	(if (eq *root-window* window)
	       init-region
	  (multiple-value-bind (x y)
	      (root-fram-window-position-xy window 
					    (region-left init-region)
					    (region-bottom init-region))
	    (set-region-position-xy  init-region x y)))
	)
    (error "The arument ~a is not a window stream" window)))


;;; $BM?$($i$l$?%3!<%J!<$H!"%]%8%7%g%s$G%j!<%8%g%s$rJQ99$9$k(B
(defmethod change-region-size ((region region)
			       (pos position)
			       (corner-pos position))
  (declare (inline =))
  (let ((pos-x (position-x pos))
	(pos-y (position-y pos))
	(r-posx (position-x corner-pos))
	(r-posy (position-y corner-pos)))

    (if (= (region-left region) r-posx)
	(setf (region-left region) pos-x))
    
    (if (= (region-right region) r-posx)
	(setf (region-right region) pos-x))

    (if (= (region-bottom region) r-posy)
	(setf (region-bottom region) pos-y))

    (if (= (region-top region) r-posy)
	(setf (region-top region) pos-y)))
  region
)

;;; $BM?$($i$l$?%3!<%J!<$H!"%]%8%7%g%s$G%j!<%8%g%s$rJQ99$9$k(B
(defmethod change-region-size-xy ((region region)
				  x y cx cy)
  (declare (inline =))
  (if (= (region-left region) cx)
      (setf (region-left region) x))
    
  (if (= (region-right region) cx)
      (setf (region-right region) x))

  (if (= (region-bottom region) cy)
      (setf (region-bottom region) y))

  (if (= (region-top region) cy)
      (setf (region-top region) y))
  region
)

(defvar *NEAR-REGION* 30)

;;; get-region 
;;; &key
;;; init-region $B=i4|%j!<%8%g%s$N@_Dj(B $B%k!<%H%&%#%s%I%&$K$*$1$k%j!<%8%g%s(B
;;; max-region $B:GBg%j!<%8%g%s(B
;;; min-region $B:G>.%j!<%8%g%s(B
;;; end-condition $B=*N;$N%^%&%9%\%?%s(B
;;; move-mode $B$O!"(B:corner $B$+(B :line $B$,A*Br$G$-$k(B
;;;               :corner$B$N$H$-$O!"3Q$G%i!<%P!<%P%s%I$r$R$-$:$k!#(B
;;;               :line $B$N$H$-$O!"OH@~$N0lIt$,$D$+$s$G%i!<%P!<%P%s%I$r$R$-$:$k(B
;;; change-condition move-mode$B$,(B:corner$B$N$H$-!"3Q$NJQ99$rMW5a$9$k(B
;;;                  end-condition$B$,2!2<$5$l$?$b$C$H$b6a$$3Q$,A*$P$l$k(B
;;;                  move-mode$B$,(B:line$B$N$H$-OH@~$NJQ99$rMW5a$9$k!#(B
;;;                  end-condition$B$,2!2<$5$l$?$b$C$H$b6a$$OH@~$,A*$P$l$k(B
;;; window      $B5a$^$C$?:BI8$r;XDj$5$l$?%&%#%s%I%&$N:BI8$K$9$k(B
(defun get-region ( &key 
			(init-region nil)
			(max-region nil)
			(min-region nil)
			(end-condition *mouse-right-1*)
			(move-mode :corner)
			(change-condition *mouse-left-1*)
			(window *root-window*))
  (declare (inline + < > - <= min max abs))
  ;;; $B0z?t$N%A%'%C%/(B
  (unless (window-streamp window)
	  (error "The argument ~a is not a window stream" window))

  (if max-region
      (unless (region-p max-region)
	      (error "The argument ~a is not a region" max-region)))

  (if min-region
      (unless (region-p min-region)
	      (error "The argument ~a is not a region" min-region)))

  (let* ((mouse-s (mouse-status))
	 (status nil)
	 (sub-status T)
	 (root-x 0) (root-y 0)
	 
	 (max-height (if max-region
			 (region-height max-region)
		       most-positive-fixnum))
	 (max-width (if max-region
			(region-width max-region)
		      most-positive-fixnum))
	 (min-width (if min-region
			(region-width min-region)
		      0))
	 (min-height (if min-region
			 (region-height min-region)
		       0))
	 (x1 0) (x2 0) (y1 0) (y2 0)
	 (origin 1))

    (multiple-value-setq (root-x root-y) 
      (translate-root-xy (mouse-state-object mouse-s)
			 (mouse-state-x-position mouse-s)
			 (mouse-state-y-position mouse-s)))

    (unless init-region
      ;;; $B=i4|E@$r5a$a$k(B
      (multiple-value-bind (x y) (get-position-xy window)
	(setf init-region (make-region :left x
				       :bottom y
				       :width 2
				       :height 2))))
    (setf x1 (region-left init-region)
	  x2 (region-right init-region)
	  y1 (region-bottom init-region)
	  y2 (region-top init-region))

    ;;; $B%^%&%9$N%0%i%V(B
    (yy-protocol-74 2)

    ;;; $BK\Ev$O$3$NJU$G!"%^%&%9%+!<%=%k$N0\F0$,M_$7$$!#(B
    ; (move-mouse-cursor ...)

    ;;; $BOH$NIA2h(B
    (setup-draw-region-region-no-clip *root-window* (graphic-color window) T)
    (draw-region-region-no-clip *root-window* init-region)

    ;;; $B=hM}$r7+$jJV$9(B
    (loop
      (setf mouse-s (mouse-status))

      (multiple-value-setq (root-x root-y) 
	(translate-root-xy (mouse-state-object mouse-s)
			   (mouse-state-x-position mouse-s)
			   (mouse-state-y-position mouse-s)))

     ;;; $B%\%?%s$N>uBV$r8+$k(B
     (cond 
      ;;; $B=*N;H=Dj(B
      ((not (zerop (logand (mouse-state-button-state mouse-s)
			   end-condition)))
       (if (null status)
           ;;; $B=*N;(B
	   (progn (print 'end)
	   (return))
	 ;;; $B%3!<%J!<$N7hDj(B
	 (let ((x root-x)
	       (y root-y))
	   (case move-mode
	     (:corner
	      (cond 
	       ((and (< x (+ x1 *NEAR-REGION*)) (> x (- x1 *NEAR-REGION*)))
		(cond
		 ((and (< y (+ y1 *NEAR-REGION*)) (> y (- y1 *NEAR-REGION*)))
		  (setf origin 4
			sub-status nil))
		 ((and (< y (+ y2 *NEAR-REGION*)) (> y (- y2 *NEAR-REGION*)))
		  (setf origin 2
			sub-status nil))))
	       ((and (< x (+ x2 *NEAR-REGION*)) (> x (- x2 *NEAR-REGION*)))
		(cond
		 ((and (< y (+ y1 *NEAR-REGION*)) (> y (- y1 *NEAR-REGION*)))
		  (setf origin 3
			sub-status nil))
		 ((and (< y (+ y2 *NEAR-REGION*)) (> y (- y2 *NEAR-REGION*)))
		  (setf origin 1
			sub-status nil))))))
	      
	     (:line
	      (cond 
	       ((and (> (max x1 x2) x) (> x (min x1 x2)))
		(cond
		 ((and (< y (+ y1 *NEAR-REGION*)) (> y (- y1 *NEAR-REGION*)))
		  (setf origin 3
			sub-status nil))
		 ((and (< y (+ y2 *NEAR-REGION*)) (> y (- y2 *NEAR-REGION*)))
		  (setf origin 1
			sub-status nil))
		 ))
	       ((and (> (max y1 y2) y) (> y (min y1 y2)))
		(cond
		 ((and (< x (+ x1 *NEAR-REGION*)) (> x (- x1 *NEAR-REGION*)))
		  (setf origin 2
			sub-status nil))
		 ((and (< x (+ x2 *NEAR-REGION*)) (> x (- x2 *NEAR-REGION*)))
		  (setf origin 4
			sub-status nil))
		 ))
	       ))
	     ))))

      ;;; $B0\F00LCV$NJQ99(B
      ((not (zerop (logand (mouse-state-button-state mouse-s) 
			   change-condition)))
       (setf status T))

      ;;; $BOH$NIA2h(B
      (t  (if (null sub-status)  (setf sub-status T status nil))

       (unless status
	  (when (and (<= min-width (abs (- x1 x2)))
		     (<= (abs (- x1 x2)) max-width)
		     (<= min-height (abs (- y1 y2)))
		     (<= (abs (- y1 y2)) max-height))

	    ;;; ORIGIN$B$K$h$j@_Dj(B
	    (case move-mode
	      (:corner
	       (case origin
		 (1 (setf x2  root-x
			  y2  root-y))
		 (2 (setf x1 root-x
			  y2 root-y))
		 (3 (setf x2 root-x
			  y1 root-y))
		 (4 (setf x1 root-x
			  y1 root-y))))
	      (:line
	       (case origin
		 (1 (setf y2 root-y))
		 (2 (setf x1 root-x))
		 (3 (setf y1 root-y))
		 (4 (setf x2 root-x)))))
	  )
	    
	  (setf (region-left init-region) (min x1 x2)
		(region-right init-region) (max x1 x2)
		(region-top init-region) (max y1 y2)
		(region-bottom init-region) (min y1 y2))

	    ;;; $B?7$7$$0LCV$r5a$a!"OH$NIA2h(B
	  (draw-region-region-no-clip *root-window* init-region)
	  )))
    )

    (setup-draw-region-region-no-clip *root-window* (graphic-color window) nil)
    (yy-protocol-74 1)
    ;;; $B%k!<%H%&%#%s%I%&$N%A%'%C%/(B
    (if (eq *root-window* window)
	init-region
      (multiple-value-bind (x y)
	  (root-fram-window-position-xy window 
					(region-left init-region)
					(region-bottom init-region))
	(set-region-position-xy  init-region x y)))
    ))
    
	

;;; $B%&%#%s%I%&$N%9%/%m!<%k(B
;;; scroll window-stream new-origin-x new-origin-y 
;;; origin-x,origin-y$B$O!"%&%#%s%I%&@8@.;~$K!":n$i$l$?%U%l!<%`$+$i%o!<%k%I$N(B
;;; $B0LCV$rJQ99$9$k!##0$r;XDj$9$k$H!"=i4|>uBV$N0LCV$K$J$k!#(B
(defmethod scroll ((window window-stream) (x-offset integer) (y-offset integer))
    (change-world-xy-offset window x-offset y-offset)
)

;;; $B%&%#%s%I%&$N(Bleft$B$r5a$a$k%a%=%C%I(B
;;; window-left window-stream
;;; ARG.
;;;             window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;             left$B$NCM(B
(defmethod window-left ((window window-stream))
  (region-left (window-region window)))

;;; $B%&%#%s%I%&$N(Bleft$B$rJQ99$9$k%a%=%C%I(B
;;; (setf window-left) new-v window-stream
;;; ARG.
;;;           new-v           =  $B?7$7$$(Bleft
;;;           window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $B?7$7$$(Bleft
(defmethod (setf window-left) (new-v (window window-stream))
  (move-xy-internal window new-v (region-bottom (window-region window)))
  new-v)

;;; $B%&%#%s%I%&$N(Bbottom$B$r5a$a$k%a%=%C%I(B
;;; window-bottom window-stream
;;; ARG.
;;;             window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;             bottom$B$NCM(B
(defmethod window-bottom ((window window-stream))
  (region-bottom (window-region window)))

;;; $B%&%#%s%I%&$N(Bbottom$B$rJQ99$9$k%a%=%C%I(B
;;; (setf window-bottom) new-v window-stream
;;; ARG.
;;;           new-v           =  $B?7$7$$(Bbottom
;;;           window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $B?7$7$$(Bbottom
(defmethod (setf window-bottom) (new-v (window window-stream))
  (move-xy-internal window (region-left (window-region window))
		    new-v)
  new-v)

;;; $B%&%#%s%I%&$N(Bright$B$r5a$a$k%a%=%C%I(B
;;; window-right window-stream
;;; ARG.
;;;             window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;             right$B$NCM(B
(defmethod window-right ((window window-stream))
  (region-right (window-region window)))

;;; $B%&%#%s%I%&$N(Bright$B$rJQ99$9$k%a%=%C%I(B
;;; (setf window-right) new-v window-stream
;;; ARG.
;;;           new-v           =  $B?7$7$$(Bright
;;;           window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $B?7$7$$(Bright
(defmethod (setf window-right) (new-v (window window-stream))
  (with-slots (right) (window-region window)
	      (setf right new-v))
  (setf (window-region window) (window-region window))
  new-v)
	
;;; $B%&%#%s%I%&$N(Btop$B$r5a$a$k%a%=%C%I(B
;;; window-top window-stream
;;; ARG.
;;;             window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           top $B$NCM(B
(defmethod window-top ((window window-stream))
  (region-top (window-region window)))

;;; $B%&%#%s%I%&$N(Btop$B$rJQ99$9$k%a%=%C%I(B
;;; (setf window-top) new-v window-stream
;;; ARG.
;;;           new-v           =  $B?7$7$$(Btop
;;;           window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $B?7$7$$(Bright
(defmethod (setf window-top) (new-v (window window-stream))
  (with-slots (top) (window-region window)
	      (setf top new-v))
  (setf (window-region window) (window-region window))
  new-v)


;;; $B%&%#%s%I%&$NI}$r5a$a$k%a%=%C%I(B
;;; window-width window-stream
;;; ARG.
;;;             window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $BI}$NCM(B
(defmethod window-width ((window window-stream))
  (region-width (window-region window)))

;;; $B%&%#%s%I%&$NI}$rJQ99$9$k%a%=%C%I(B
;;; (setf window-width) new-v window-stream
;;; ARG.
;;;           new-v           =  $B?7$7$$I}(B
;;;           window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $B?7$7$$I}(B
(defmethod (setf window-width) (new-v (window window-stream))
  (with-slots (left right) (window-region window)
	      (setf right (+ left new-v)))
  (setf (window-region window) (window-region window))
  new-v)


;;; $B%&%#%s%I%&$N9b$5$r5a$a$k%a%=%C%I(B
;;; window-height window-stream
;;; ARG.
;;;             window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $B9b$5$NCM(B
(defmethod window-height ((window window-stream))
  (region-height (window-region window)))

;;; $B%&%#%s%I%&$N9b$5$rJQ99$9$k%a%=%C%I(B
;;; (setf window-height) new-v window-stream
;;; ARG.
;;;           new-v           =  $B?7$7$$9b$5(B
;;;           window-stream   =  $B%&%#%s%I%&%9%H%j!<%`(B
;;; RET.
;;;           $B?7$7$$9b$5(B
(defmethod (setf window-height) (new-v (window window-stream))
  (with-slots (bottom top) (window-region window)
	      (setf top (+ bottom new-v)))
  (setf (window-region window) (window-region window))
  new-v)


;;; $B%&%#%s%I%&$N0\F0(B
;;; move window-stream new-position
;;; new-position $B$O!"?F$N%&%$%s%I%&$J$$$N:BI8$G$"$k(B
(defmethod move ((window window-stream) (new-position position))
  (move-xy-internal window (position-x new-position)
		    (position-y new-position)))

;;; $B%&%#%s%I%&$N0\F0(B
;;; move-xy window-stream new-x new-y
;;; new-x,new-y $B$O!"?F%&%#%s%I%&Fb$G$N:BI8(B
(defmethod move-xy ((window window-stream) (new-x integer) (new-y integer))
  (move-xy-internal window new-x new-y))

;;; $B%&%#%s%I%&$N0\F0$N%$%s%?!<%J%k4X?t(B
(defun move-xy-internal (window new-x new-y)
  (set-region-position-xy (window-region window) new-x new-y)
      (if (parent-window window)
	  (yy-protocol-3 (territory window)
                    (- (region-left (window-region window))
                       (world-x-start (parent-window window)))
                     (- (with-translate-coordinate-stream
                         (region-bottom (window-region window))
                         (parent-window window))
                        (world-y-start (parent-window window))))
      ))


;;; $B%&%#%s%I%&$NBg$-$5JQ99(B
;;; reshape window-stream new-region
(defmethod reshape ((window window-stream) (new-region region))
    (setf (window-region window) new-region))


;;; $B%&%#%s%I%&$N%(%/%9%]!<%:(B $B%&%#%s%I%&$r0lHV>e$K$9$k(B
;;; expose window-stream
(defmethod expose ((window window-stream))
  (let* ((p-window (parent-window window))
	 (child (children-windows p-window))
	 (old-b (old-brother-window window))
	 (young-w (young-brother-window window)))

    (yy-protocol-7 (territory window))
    
    ;;; $B%&%#%s%I%&$N@\B34X78$N:F@_Dj(B
    (if old-b
	(setf (young-brother-window old-b) young-w))

    (if young-w 
	(setf (old-brother-window young-w) old-b))

    (setf (old-brother-window window) (car child)
	  (young-brother-window window) nil)

    (when (car child)
	(setf (young-brother-window (car child)) window)
	(delete window child)
	(pushnew window child))
    window))

;;; $B%&%#%s%I%&$N%P%j!<(B $B%&%#%s%I%&$r0lHV2<$K$9$k(B
;;; bury window-stream
(defmethod bury ((window window-stream))
  (let* ((p-window (parent-window window))
	 (child (children-windows p-window))
	 (old-b (old-brother-window window))
	 (young-w (young-brother-window window)))

    (yy-protocol-8 (territory window))
    
    ;;; $B%&%#%s%I%&$N@\B34X78$N:F@_Dj(B
    (if old-b
	(setf (young-brother-window old-b) young-w))

    (if young-w 
	(setf (old-brother-window young-w) old-b))

    (setf (old-brother-window window) nil
	  (young-brother-window window) (car (last child)))

    (when (car child)
	(setf (old-brother-window (car (last child))) window)
	(delete window child)
	(nconc child (list window)))

    window))


;;; $B%&%#%s%I%&$r%7%e%j%s%/$9$k(B $B%&%#%s%I%&$r%"%$%3%s$K$9$k!#(B
;;; shrink window-stream &optional exp
;;; ARG.
;;;           window-stream   =   $B%&%#%s%I%&%9%H%j!<%`(B
;;;           exp             =   $B%S%C%H%^%C%W(B or $BJ8;zNs(B or $B%a%=%C%I(B
(defmethod shrink ((window window-stream) &optional (exp nil))
  (unless exp
	  (setf exp (title-bar-string window)))

  (if (stringp exp)
      (if (= (length exp) 0)
	  (setf exp (multiple-value-bind (b p j n g y)
                           (get-decoded-time)
                         (declare (ignore b))
                         (format nil "~a(Year) ~a/~a ~a:~a" y g n j p)))))

  (let ((icon (window-icon window)))

    ;;; $B3F9=@.MWAG$NHsI=<((B
    (temp-invisible-parts window)
    
    (resize-window-and-invisible window
				 (draw-icon icon  exp))
			       
    (setf  (window-status window) :icon)

    ;;; $B%"%$%3%s$rI=<($9$k(B
    (setf (draw-piece-visible icon) T)))

(defun resize-window-and-invisible (window region)
  (let* ((icon (window-icon window))
	 (wregion (window-region window))
	 (parent (parent-window window))
	 (start-x (if parent (world-x-start parent) 0))
	 (start-y (if parent (world-y-start parent) 0)))

    ;;; $B%&%#%s%I%&$NBg$-$5$NJQ99(B
    (with-slots (p-left p-bottom p-width p-height) icon
		(setf p-left (region-left wregion)
		      p-bottom (region-bottom wregion)
		      p-width (region-width wregion)
		      p-height (region-height wregion)))

;    (set-region wregion region)
    (setf (region-width wregion) 
      (+ (* 2 (real-border-belt window)) (region-width region))
      (region-height wregion)
      (+ (* 2 (real-border-belt window)) (region-height region)))



    (yy-protocol-4 (territory window) (+ (region-left wregion) start-x)
                   (+ (with-translate-coordinate-stream (region-bottom wregion)
                                                     parent)
                      start-y)
                   (region-width wregion) (region-height wregion))
    (redisplay-border window)
    nil))
	  
;;; $B%"%$%3%s$KIA2h$9$kAm>N4X?t(B
;;; draw-icon icon exp
;;; ARG.
;;;           icon   =   $B%"%$%3%s(B
;;;           exp    =   $BJ8;zNs(Bor$B%S%C%H%^%C%W(Bor$BMxMQ<TDj5A$N%a%=%C%I(B
;;;                      $BMxMQ<TDj5A$N%a%=%C%I$O!"(B(apply ***** icon)$B$G8F$P$l$k(B
;;;                      $BJ8;zNs$d%S%C%H%^%C%W$N>l9g$O%"%$%3%sBg$-$5$,@_Dj$5$l$k$,(B
;;;                      $BMxMQ<TDj5A$N>l9g$O!"MxMQ<T$,Dj5A$9$kI,MW$,$"$k!#(B
(defgeneric  draw-icon (icon exp)
  (:method ((icon icon) (exp string))
	   (let ((font (stream-font (parent-window icon))))
	     (with-real-object (icon)
	       (setf 
		   (region-bottom icon) 1
		   (region-left icon) 1
		   (region-width icon) (+ (font-string-length font exp) 2)
		   (region-height icon) (font-kanji-height font)))

	     (draw-piece-string icon 2 (font-kanji-base-line font) exp))
	   icon)
  (:method ((icon icon) (exp bitmap))
	   (with-real-object (icon)
              (setf (region-width icon) (bitmap-width exp)
		    (region-bottom icon) (bitmap-height exp)))
	   
	   (draw-piece-copy exp 0 0 icon 0 0 (region-width icon)
			    (region-bottom icon))
	   icon)
  (:method ((icon icon) exp)
	   (apply #'exp icon)
	   icon))
  
;;; $B%&%#%s%I%&$N9=@.MWAG$r0l;~E*$KHsI=<($9$k!#(B
(defun temp-invisible-parts (window)
  (if (window-title-bar window)
      (yy-protocol-2 (territory (window-title-bar window)) 0))
  (if (window-horizontal-scroll-bar window)
      (yy-protocol-2 (territory (window-horizontal-scroll-bar window)) 0))
  (if (window-vertical-scroll-bar window)
      (yy-protocol-2 (territory (window-vertical-scroll-bar window)) 0))
  (if (window-coordinate-area window)
      (yy-protocol-2 (territory (window-coordinate-area window)) 0))
  (yy-protocol-2 (territory (window-frame window)) 0))


;;; $B%&%#%s%I%&$N9=@.MWAG$N0l;~E*$JHsI=<($r;_$a$k(B
(defun temp-visible-parts (window)
  (let ((title    (window-title-bar window))
	(h-scroll (window-horizontal-scroll-bar window))
	(v-scroll (window-vertical-scroll-bar window))
	(co       (window-coordinate-area window))
	(frame    (window-frame window)))
    (if (draw-piece-visible title)
	(yy-protocol-2 (territory title) 1))
    (if (draw-piece-visible h-scroll)
	(yy-protocol-2 (territory h-scroll) 1))
    (if (draw-piece-visible v-scroll)
	(yy-protocol-2 (territory v-scroll) 1))
    (if (draw-piece-visible co)
	(yy-protocol-2 (territory co) 1))
    (if (frame-visible frame)
	(yy-protocol-2 (territory frame) 1))
    ))
      
  
;;; $B%"%$%3%s$r%(%/%9%Q%s%I$9$k(B
;;; exapnd window-stream 
(defmethod expand ((window window-stream))
  (when (eq :icon (window-status window))
     (let* ((icon (window-icon window))
	    (region (window-region window)))
       
       (with-slots (p-left p-bottom p-width p-height) icon
		   (setf (region-left region) p-left
			 (region-bottom region) p-bottom
			 (region-width region) p-width
			 (region-height region) p-height))

       ;;; $B%"%$%3%s$rHsI=<((B
       (setf (draw-piece-visible icon) NIL
	     (window-status window) :window)

       ;;; $B9=@.$N$7D>$7(B
       (setf (window-region window) region)

       ;;; $B9=@.MWAG$rI=<((B
       (temp-visible-parts window)
       )
;     (redisplay-window window)
  ))
      

;;; $B%&%#%s%I%&$r%"%/%F%#%V$K$9$k(B
;;; acitivate window
;;; ARG.
;;;           window  =  $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod activate ((window window-stream))
  (setf (window-visible window) T))


;;; $B%&%#%s%I%&$rHs%"%/%F%#%V$K$9$k(B
;;; deactivate window
;;; ARG.
;;;            window = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod deactivate ((window window-stream))
  (setf (window-visible window) nil))


;;; $B%&%#%s%I%&$N%/%j%"!<(B
;;; clear-window-stream window-stream
;;; ARGS.
;;;           window-stream  = $BBP>]$K$J$k%0%i%U%#%C%/%9%9%H%j!<%`(B
;;; $B%/%j%"!<%a%=%C%I(B
(defmethod clear-window-stream ((stream window-stream))
  (setf (stream-cursor-y-position  stream)
    (font-kanji-base-line (stream-font stream))
    (position-x  (slot-value stream 'cursor-position))
    0)
  (claer-graphic-stream stream (stream-default-color-pattern stream))
  (setf (world-x-offset stream) 0)
  (setf (world-y-offset stream) 0)
stream)


;;; $B%0%i%U%#%C%/%9%9%H%j!<%`$N%/%j%"!<(B  $B%+%i!<$N>l9g(B
(defmethod claer-graphic-stream ((stream window-stream) (color color))
  (yy-protocol-32 (world-territory-no stream)
		  (color-no color)))


;;; $B%0%i%U%#%C%/%9%9%H%j!<%`$N%/%j%"!<(B  $B%$%a!<%8$N>l9g(B
(defmethod claer-graphic-stream ((stream window-stream) (image image))
  (let* ((tno (make-territory 
	       :width (image-width image)
	       :height (image-height image)
	       :visible nil))
	 (format1 (if (eq (image-format image) :yy)
                      2
                    1))
	 (format (case (image-type image)
		   (:color
		    (logior #x8000 format1))
		   (:gray
		    (logior #x4000 format1))
		   (t
		    (logior #x2000 format1)))))

    (yy-protocol-61 tno 0 0 (image-width image) (image-height image)
                        format (image-data image))

    (yy-protocol-33 (world-territory-no stream) tno)
    
    (yy-protocol-5 tno)))

;;; $B%0%i%U%#%C%/%9%9%H%j!<%`$N%/%j%"!<(B  $B%S%C%H%^%C%W$N>l9g(B
(defmethod claer-graphic-stream ((stream window-stream) (bitmap bitmap))
    (yy-protocol-33 (world-territory-no stream)
		    (bitmap-territory-no bitmap)))

;;; $B%$%Y%s%H$N0l;~Dd;_(B $B%&%$%s%I%&MQ(B
;;; disnable-event window mask
;;; ARG.
;;;          window = $B%&%#%s%I%&%9%H%j!<%`(B
;;;          mask   = $B%$%Y%s%H$N%^%9%/(B
(defmethod disnable-event ((window window-stream) mask)
  (let* ((event-method window)
	 (old-mask (event-mask event-method))
	 (new-mask (logand (lognot mask) old-mask)))
    (yy-protocol-72 (world-territory-no window) new-mask)))


;;; $B%$%Y%s%H$N2sI|(B $B%&%#%s%I%&MQ(B
;;; enable-event  window
;;; ARG.
;;;               window = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod enable-event ((window window-stream))
  (yy-protocol-72 (world-territory-no window) 
		  (event-mask window)))


;;; $B%&%#%s%I%&$N>C5n(B
;;; $B%&%#%s%I%&$r$J$/$9!#$3$N;~!"%&%#%s%I%&$K$"$k(B
;;; $B%"%/%F%#%V%j!<%8%g%s$d%W%l%<%s%F!<%7%g%s$b(B
;;; $B>C5n5n$l$k(B
;;; flush-window window-stream
;;; ARG. 
;;;          window-stream = $B%&%#%s%I%&%9%H%j!<%`(B
(defmethod flush-window ((window window-stream))
  
  ;;; $B?F$+$i<+J,$r<h$j=|$/(B
  (if (parent-window window)
      (setf (children-windows (parent-window window))
	(delete window (children-windows (parent-window window)))))

  ;;; $B7;Do4X78$N:o=|(B
  (let ((young (young-brother-window window))
	(old   (old-brother-window window)))
  (if young
    (if (old-brother-window young)
      (setf (old-brother-window young) old)))
  (if old
      (if (young-brother-window old) 
	  (setf (young-brother-window old) young)))

  ;;; $B<+J,<+?H$NItIJ$r:o=|(B
  (delete-window-parts window nil)

  ;;; $B<+J,$N;R$I$b$r:o=|(B
  (dolist (item (children-windows window))
    (delete-window-parts item nil))

  (setf (children-windows window) nil)

  ;;; $B%F%j%H%j!<$NGK2u(B
  (yy-protocol-5 (territory window))

  (setf (territory window) nil)))
  

;;; $BItIJ$N:o=|(B
(defun delete-window-parts (window &optional (territory T))
  (declare (function flush-active-region (T T) T)
	   (function flush-presentation (T T) T))

  ;;; $BItIJ$N>C5n(B
  (dolist (item (child-object-list window))
    (flush-draw-piece item territory))

  ;;; $B%"%/%F%#%V%j!<%8%g%s$N>C5n(B
  (dolist (item (active-region-list window))
    (flush-active-region item territory))

  ;;; $B%W%l%<%s%F!<%7%g%s$N>C5n(B
  (dolist (item (present-list window))
    (flush-presentation item territory))

  ;;; $B%o!<%k%I$N<h$j30$7(B
  (delete-lisp-object (world-territory-no window))
  (setf (world-territory-no window) nil)

  ;;; $B%U%l!<%`$N<h$j30$7(B
  (delete-lisp-object (frame-territory-no 
		       (window-frame window)))

  (setf (frame-territory-no (window-frame window)) nil)

  ;;; $B%\!<%@$N<h$j30$7(B
  (delete-lisp-object (territory window))
  )
  
;;; End of file.

