;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;
;; YY$B%&%#%s%I%&%7%9%F%`$NJ8;zNsI=<(%a%=%C%I(B
;;               1990.3.20  $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-3-20
;;;               Change LOG   Add page mode drawing 
;;;               Change LOG   Change drawing-text-internal-yoko-mode
;;; Version 1.3   90/12/19 By T.kosaka
;;;               Add method drawing-text becouse presentation needs 
;;;               after method.
;;; Version 1.4   Take off ***-mode 

(in-package :yy)

;;; $BJ8;zNs$NI=<((B
;;; $B%9%H%j!<%`$N%+!<%=%k0LCV$+$iI=<((B

(defmethod drawing-text ((stream world-primitive) (string string))
  (if (eq (stream-output-direction stream) :vertical)
      (drawing-text-internal-tate stream string)
    (drawing-text-internal-yoko stream string)))


;;; drawing-text after method
;;; $BIA2h%7!<%1%s%9$r5-21(B
(defmethod drawing-text :after ((stream world-primitive) (string string))

  (if (presentation-instance stream)
      (push #'(lambda (new-stream) (drawing-text new-stream string))
	    (cdr (last (drawing-sequence (presentation-instance stream)))))
    ))
						 

;;; $B%Z!<%8MQ(B $B2#=q$-J8;zNs$NI=<((B
;;; $B=q$$$?Bg$-$5$r(Bdrawing-region $B$K@_Dj(B
(defmethod drawing-text-internal-yoko ((stream page-window-stream)
					(string string))
  (let ((region (page-drawing-text stream string)))
    ;;; $B%+!<%=%k0LCV$r@_Dj(B
    (set-cursor-yoko-mode stream string region)))


;;; $B%S%e%]!<%HMQ(B $B2#=q$-J8;zNs$NI=<((B
;;; $B=q$$$?Bg$-$5$r(Bdrawing-region $B$K@_Dj(B
(defmethod drawing-text-internal-yoko ((stream viewport-window-stream)
					(string string))
  (declare (inline max min))
	(let* ((posx (position-x (slot-value stream 'cursor-position)))
           (posy (position-y (slot-value stream 'cursor-position)))
	       (ret (string-display-region-yoko (stream-font stream)
					      (work-region2 stream)
					  string
					  (slot-value stream 'line-feed)
					  posx posy
					  (stream-transform-by-matrix stream)
					  (stream-left-margin stream)
					  (stream-right-margin stream)
					  (stream-translate-coordinate stream)
	                                  (stream-truncate-width stream)))

	     (new-region   (change-coodinate-region (first ret)
							    stream))
	     (new-posx 0)
	     (new-posy 0)
	     (s-list nil)
	     (drawing-region (drawing-region stream)))
    
	(setf new-posx (second ret)
	      new-posy (third ret)
	      s-list (nthcdr 3 ret))
    
        ;;; $B%o!<%k%I%j!<%8%g%s$NJQ99(B
	(setf (world-region stream) new-region)

        ;;; $BJ8;zNs$r%W%m%H%3%k$KAw$k(B
	(draw-text-with-matrix (stream-transform-by-matrix stream)
			    stream (graphic-operation stream)
			    s-list)
		
         ;;; $B%+!<%=%k%]%8%7%g%s$r@_Dj(B
	(setf (position-x (slot-value stream 'cursor-position)) new-posx
	      (position-y (slot-value stream 'cursor-position)) new-posy)

        ;;; drawing-region$B$K:#$N%j!<%8%g%s$rDI2C(B
	(set-drawing-region drawing-region (first ret))
    ))

;;; $B%F%-%9%H%+!<%=%k$NI=<((B
(defmethod drawing-text-internal-yoko :before ((stream viewport-window-stream)
					    (string string))
  (display-text-cursor stream))

;;; $B%F%-%9%H%+!<%=%k$NHsI=<((B
(defmethod drawing-text-internal-yoko :after 
	   ((stream  viewport-window-stream)
	    (string string))
	    
  (display-text-cursor stream))


;;; $BJ8;zNs$r%W%m%H%3%k$KAw$k(B
;;; $B2sE>9TNs$J$7(B
(defmethod draw-text-with-matrix ((matrix graphic-transform-matrix-non)
				  (stream world-primitive) op s-list)
  (declare (inline + incf))
  (let ((tno (world-territory-no stream))
	(color-no (color-no (graphic-color stream)))
	(font-no (font-no (stream-font stream)))
	(start-x (world-x-start stream))
	(start-y (world-y-start stream))
	(posx 0)
	(posy 0))
		 
    ;;; $BJ8;zNs$NIA2h(B $B2sE>9TNsL5;k(B
    (do ((item s-list (cddr item)))
	((null item))
	  (setf posx (car (car item))
	        posy (second (car item)))
      (let ((t-px (+ posx start-x))
	    (t-py (+ (with-translate-coordinate-stream posy stream)
		     start-y)))

	(when (> (length (second item)) 0)

	  (if (not (presentation-instance stream))
	      (yy-protocol-31 tno t-px t-py op color-no font-no (second item))
	    (push #'(lambda (pt-no dx dy)
		      (yy-protocol-31 pt-no (+ t-px dx) (+ t-py dy) 
				      op color-no
				      font-no (second item)))
		  (cdr (last (after-drawing-list 
			      (presentation-instance stream)))))))

	))
    ))


;;; $BJ8;zNs$r%W%m%H%3%k$KAw$k(B
;;; $B2sE>9TNs$"$j(B
(defmethod draw-text-with-matrix ((matrix graphic-transform-matrix-exec)
				  (stream world-primitive) op s-list)

  (declare (inline + * round))
  (let ((tno (world-territory-no stream))
	(color-no (color-no (graphic-color stream)))
	(font-no (font-no (stream-font stream)))
	(start-x (world-x-start stream))
	(start-y (world-y-start stream))
	(posx 0) (posy 0))

    (do ((item s-list (cddr item)))
	((null item))
	(setf posx (car (car item))
		  posy (second (car item)))
			   
      (let ((t-px (+ posx start-x))
	    (t-py (+ (with-translate-coordinate-stream posy stream)
		     start-y)))

	(when (> (length (second item)) 0)
	      (if (not (presentation-instance stream))
		  (yy-protocol-44 tno t-px t-py op color-no font-no
			  (round (matrix-x-time 
				  (stream-transform-by-matrix stream)))
			  (round (matrix-y-time 
				  (stream-transform-by-matrix stream)))
#+:YY2.0
			  (round (* (matrix-theta 
				     (stream-transform-by-matrix stream)) 64))
#-:YY2.0
                          (if 
			      (not (zerop 
				    (matrix-theta
				     (stream-transform-by-matrix stream))))
			      (round (*  (matrix-theta 
				     (stream-transform-by-matrix stream))
					   
					-64))
			    0)
		
			  (second item))

		(push #'(lambda 
			    (pt-no dx dy)
			    (yy-protocol-44 
			     pt-no (+ t-px dx) (+ t-py dy) 
			     op color-no  font-no
			     (round (matrix-x-time
				     (stream-transform-by-matrix stream)))
			     (round (matrix-y-time
				     (stream-transform-by-matrix stream)))
			     (round (* (matrix-theta
				     (stream-transform-by-matrix stream)) 64))
                                  (second item)))
		      (cdr (last (after-drawing-list 
				  (presentation-instance stream))))))
	      )
	      ))
    ))

;;; read $B$H(Bread-line$B$N0Y$N%j!<%8%g%s$N3HBg(B
(defun region-union-expand-text (w-region region temp-region expand-width
                                 expand-height)
  (with-slots
   (left bottom right top) temp-region
   (setf left (region-left region) 
	 bottom (region-bottom region)
	 right (region-right region)
	 top (region-top region))
   (let ((union-region (region-union-no-copy region w-region)))

      ;;; $BI}$K$D$$$F9-$,$k$+!)(B
     (when (> (region-width union-region) (region-width w-region))
       ;;; $B$I$C$A$NJ}8~$K9-$,$k$+!)(B
       (if (< (region-left union-region) (region-left w-region))
	   (setf left (- (region-left union-region) expand-width))
	 (setf left (region-left union-region)))
       (if (> (region-right union-region) (region-right w-region))
	   (setf right (+ (region-right union-region) expand-width))
	 (setf right (region-right union-region))))

     (when (> (region-height union-region) (region-height w-region))
	;;; $B$I$C$A$NJ}8~$K9-$,$k$+!)(B
       (if (< (region-bottom union-region) (region-bottom w-region))
	   (setf bottom (- (region-bottom union-region) expand-height))
	 (setf bottom (region-bottom union-region)))
       (if (> (region-top union-region) (region-top w-region))
	   (setf top (+ (region-top union-region) expand-height))
	 (setf top (region-top union-region)))))

     temp-region))
	  	  	   	  

;;; $B2#=q$-J8;zNs$NI=<((B read-lline read $BMQ(B
(defmethod drawing-text-read-yoko ((input-stream  window-stream) 
				   (string string) 
				   (x integer) (y integer) op  
				   &optional (mode T))
  (with-temp-region-args ((region) (work-region1 input-stream)
			  :left (- (world-x-start input-stream))
			  :bottom (- (world-y-start input-stream))
			  :width (region-width input-stream)
			  :height (region-height input-stream))
      
      (let* ((matrix (current-matrix input-stream))
         (line-feed (current-line-feed input-stream))
	 (font (current-font input-stream))
	 (posx x)
         (posy y)
	 (ret (string-display-region-yoko font (work-region2 input-stream)
					string line-feed
			 posx posy matrix 
			 (stream-left-margin input-stream)
			 (stream-right-margin input-stream)
			 (stream-translate-coordinate input-stream)))

	 (l-t-region (change-coodinate-region (first ret) input-stream))

	 (new-region (region-union-expand-text region l-t-region
 		      (work-region4 input-stream)	
			  (round 
			   (/ (region-width (frame-region input-stream)) 2))
			  (round 
			   (/ (region-height (frame-region input-stream)) 2))))
	 (new-posx 0)
	 (new-posy 0)
	 (s-list nil))

    (setf new-posx (second ret)
	  new-posy (third ret)
	  s-list (nthcdr 3 ret))

    ;;; $B%o!<%k%I%j!<%8%g%s$NJQ99(B
    (setf (world-region input-stream) new-region)

    ;;; $B=*C<0LCV$,%U%l!<%`$KF~$C$F$$$k$+D4$Y$F!"F~$C$F$$$J$1$l$P(B
    ;;; $B%*%U%;%C%H$NJQ99$7$F!"%U%l!<%`$NCf1{$K$9$k!#(B
    (when mode
	  (change-offset-xy input-stream new-posx 
			    (with-translate-coordinate-stream new-posy 
							      input-stream)))

    ;;; $BJ8;zNs$r%W%m%H%3%k$KAw$k(B
    (draw-text-with-matrix (stream-transform-by-matrix input-stream)
			    input-stream op s-list)

    (list new-posx new-posy))
))


;;; $B;XDj0LCV$,%U%l!<%`$NCf1{$KF~$k$h$&$K%*%U%;%C%H$rJQ99(B
;;; $B$3$N%a%=%C%I$O!":BI87O$,$$$D$b:8>e(B
(defun change-offset-xy (stream x y)
  (declare (inline - + / < >))
  (let* ((offset-x (world-x-offset stream))
	 (offset-y (world-y-offset stream))
	 (base-line (font-kanji-base-line (stream-font stream)))
	 (add-height (- (font-kanji-height (stream-font stream)) base-line))
	 (new-x (+ x offset-x))
	 (new-y (+ y offset-y))
	 (new-offset-x nil)
	 (new-offset-y nil)
	 (f-width (region-width (frame-region stream)))
	 (f-height (region-height (frame-region stream)))
	 (x-shift (round (/ f-width 2)))
	 (y-shift (round (/ f-height 2))))

;(format t "x : ~a offset ~a start ~a ~%" x offset-x world-x)
    ;;; $B%*%U%;%C%H$GH=CG$9$k(B
    (cond 
     ;;; $B%*%U%;%C%H$,#0$G$"$k(B
     ((zerop offset-x)
      ;;; $B:8B&$K0\F0$+!)(B
      (if (< x 0)
	(setf new-offset-x x-shift)
      ;;; $B1&$K0\F0$+!)(B
      (if (> (+ x (font-kanji-width (stream-font stream)))  f-width)
	  (setf new-offset-x (- x-shift)))))
     ;;; $B%*%U%;%C%H$,#0$h$jBg$-$$(B --> $B%o!<%k%I$,1&$K$$$C$F$$$k(B
     ((> offset-x 0)
      ;;; $B1&$K0\F0$+!)(B
      (if (< x (- offset-x))
	  (setf new-offset-x (+ offset-x x-shift))
	(if (> (+ new-x (font-kanji-width (stream-font stream))) f-width)
	    (setf new-offset-x (- offset-x x-shift)))))
     ;;; $B%*%U%;%C%H$,#0$h$j>.$5$$(B --> $B%o!<%k%I$,:8$K$h$C$F$$$k(B
     (t
      ;;; $B1&$K0\F0$+!)(B
      (if (< (+ offset-x x) 0)
	  (setf new-offset-x x-shift)
	(if (> (+ offset-x x (font-kanji-width (stream-font stream))) f-width)
	    (setf new-offset-x (- offset-x x-shift))))))

;(format t "offset-y : ~a world-y : ~a ~% region : ~a ~%" offset-y world-y
	;(world-region stream))

    ;;; $B%*%U%;%C%H$GH=CG$9$k(B
    (cond 
     ;;; $B%*%U%;%C%H$,#0$G$"$k(B
     ((zerop offset-y)
      ;;; $B:8B&$K0\F0$+!)(B
      (if (< (- y base-line) 0)
	 (setf new-offset-y y-shift))
      ;;; $B1&$K0\F0$+!)(B
      (if (> (+ y add-height)  f-height)
	  (setf new-offset-y (- y-shift))))
     ;;; $B%*%U%;%C%H$,#0$h$jBg$-$$(B --> $B%o!<%k%I$,2<$K$$$C$F$$$k(B
     ((> offset-y 0)
      ;;; $B1&$K0\F0$+!)(B
      (if (< (- y base-line) (- offset-y))
	  (setf new-offset-y (+ offset-y y-shift))
	(if (> (+ new-y add-height) f-height)
	    (setf new-offset-y (- offset-y y-shift)))))
     ;;; $B%*%U%;%C%H$,#0$h$j>.$5$$(B --> $B%o!<%k%I$,>e$K$h$C$F$$$k(B
     ((< offset-y 0)
      ;;; $B1&$K0\F0$+!)(B
      (if (< (+ offset-y y base-line) 0)
	  (setf new-offset-y y-shift)
	(if (> (+ offset-y y add-height) f-height)
	    (setf new-offset-y (- offset-y y-shift))))))

    ;;; $B%*%U%;%C%H$rJQ99(B
    (change-world-xy-offset stream new-offset-x new-offset-y)))



;;; $B;XDj0LCV$KF~$k$h$&$K%*%U%;%C%H$rJQ99$9$k(B
(defmethod change-offset-position ((stream world-primitive) (pos position))
  (change-offset-xy stream (position-x pos) (position-y pos)))


;;; $B%Z!<%8MQ(B $B=D=q$-J8;zNs$NI=<((B
;;; $B=q$$$?Bg$-$5$r(Bdrawing-region $B$K@_Dj(B
(defmethod drawing-text-internal-tate ((stream page-window-stream)
				       (string string))
  (let ((region (page-drawing-text stream string)))
    (set-cursor-tate-mode stream string region)))

;;; $B%S%e%]!<%HMQ=D=q$-J8;zNs$NI=<((B
;;; $B=q$$$?Bg$-$5$r(Bdrawing-region $B$K@_Dj(B
(defmethod drawing-text-internal-tate ((stream viewport-window-stream)
				       (string string))
  (declare (inline + -min max))
  (let* ((posx (position-x (slot-value stream 'cursor-position)))
	     (posy (position-y (slot-value stream 'cursor-position)))
	     (matrix (stream-transform-by-matrix stream))
	     (ret (string-display-region-tate (stream-font stream)
					      (work-region2 stream)
				 string
				 (slot-value stream 'line-feed)
				 posx posy
				 matrix
				 (stream-top-margin stream)
				 (stream-bottom-margin stream)
				 (stream-translate-coordinate stream)
				 (stream-truncate-height stream)))
	     (new-region (change-coodinate-region (first ret) stream))
	     (new-posx 0)
	     (new-posy 0)
	     (s-list nil)
	     (op (graphic-operation stream))
	     (drawing-region (drawing-region stream)))

	(setf new-posx (second ret)
	      new-posy (third ret)
	      s-list (nthcdr 3 ret))

        ;;; $B%o!<%k%I%j!<%8%g%s$NJQ99(B
	(setf (world-region stream) new-region)

        ;;; $BJ8;zNs$NIA2h(B 
	(draw-text-with-matrix-tate stream op s-list)

        ;;; $B%+!<%=%k%]%8%7%g%s$r@_Dj(B
	(setf (position-x (slot-value stream 'cursor-position)) new-posx
	      (position-y (slot-value stream 'cursor-position)) new-posy)

        ;;; drawing-region$B$K:#$N%j!<%8%g%s$rDI2C(B
	(set-drawing-region drawing-region new-region)
    ))

;;; $BJ8;zNs$r%W%m%H%3%k$KAw$k(B $B=D=q$-MQ(B
;;; $B2sE>9TNs$"$j(B
(defun draw-text-with-matrix-tate (stream op s-list)
  (declare (inline + * round))
  (let ((tno (world-territory-no stream))
	(color-no (color-no (graphic-color stream)))
	(font-no (font-no (stream-font stream)))
	(start-x (world-x-start stream))
	(start-y (world-y-start stream))
	(posx 0) (posy 0))

    (do ((item s-list (cddr item)))
	((null item))
	(setf posx (car (car item))
		  posy (second (car item)))
			   
      (let ((t-px (+ posx start-x))
	    (t-py (+ (with-translate-coordinate-stream posy stream)
		     start-y)))
	(when (> (length (second item)) 0)
	  (if (not (presentation-instance stream))
	      (yy-protocol-43 tno t-px t-py op  color-no
			      font-no (second item))
	    (push #'(lambda (pt-no dx dy)
		      (yy-protocol-43 pt-no (+ t-px dx) (+ t-py dy)
				      (graphic-operation stream)
				      (color-no (graphic-color stream))
				      (font-no (stream-font stream))
				      (second item)))
		  (cdr (last (after-drawing-list 
			      (presentation-instance stream))))))
	  )
	))
    ))


;;; $B%F%-%9%H%+!<%=%k$r>C$9(B
(defmethod drawing-text-internal-tate
    :before ((stream viewport-window-stream)
	     (string string))
  (display-text-cursor stream))

;;; $B%F%-%9%H%+!<%=%k$r=q$/(B
(defmethod drawing-text-internal-tate :after
	   ((stream viewport-window-stream)
	    (string string))
  (display-text-cursor stream))


;;; $B=D=q$-J8;zNs$NI=<((B read-line read $BMQ(B
(defmethod drawing-text-read-tate  ((input-stream  window-stream) (string string)
				    (x integer) (y integer) op &optional (mode T))
  (declare (inline - + / round >))
  (with-temp-region-args ((region) (work-region1 input-stream)
			  :left (- (world-x-start input-stream))
			  :bottom (- (world-y-start input-stream))
			  :width (region-width input-stream)
			  :height (region-height input-stream))

      (let* ((matrix (current-matrix input-stream))
	     (line-feed (current-line-feed input-stream))
	     (font (current-font input-stream))
	     (posx x)
	     (posy y)
	     (ret (string-display-region-tate font (work-region2 input-stream)
					      string line-feed
					 posx 
					 posy 
					 matrix 
					 (stream-top-margin input-stream)
					 (stream-bottom-margin input-stream)
					 (stream-translate-coordinate input-stream)))

	     (l-t-region (change-coodinate-region 
			  (let ((rr (first ret)))
			    (decf (region-left rr) 1)
			    rr ) input-stream))
	     (new-region (region-union-expand-text region l-t-region
					   (work-region4 input-stream)
				   (round (/ (region-width 
					(frame-region input-stream)) 2))
			           (round (/ (region-height 
					(frame-region input-stream)) 2))))
	     (new-posx 0)
	     (new-posy 0)
	     (s-list nil))

	(setf new-posx (second ret)
	      new-posy (third ret)
	      s-list (nthcdr 3 ret))

        ;;; $B%o!<%k%I%j!<%8%g%s$NJQ99(B
	(setf (world-region input-stream) new-region)

        ;;; $B=*C<0LCV$,%U%l!<%`$KF~$C$F$$$k$+D4$Y$F!"F~$C$F$$$J$1$l$P(B
        ;;; $B%*%U%;%C%H$NJQ99(B
	(when mode
  	  (change-offset-xy input-stream new-posx 
			(with-translate-coordinate-stream
			     new-posy input-stream)))

;(format t "new  : ~a~%" region)

        ;;; $BJ8;zNs$NIA2h(B
	(draw-text-with-matrix-tate input-stream op s-list)

	(list new-posx new-posy)))
)


;;; $B%Z!<%8%b!<%I$N%F%-%9%H$NIA2h(B
;;; $B%Z!<%8%b!<%I$N%F%-%9%H$O!"%W%l%<%s%H$O$G$-$k$,0\F0$O$G$-$J$$(B
(defmethod page-drawing-text ((stream page-window-stream)
			      (string string))

  (let* ((tno (world-territory-no stream))
	 (color-no (color-no (graphic-color stream)))
	 (font-no (font-no (stream-font stream)))
	 (op (graphic-operation stream))
	 (drawing-region (drawing-region stream))
	 (ret nil))

#+:Symbolics
    (dotimes (i (length string))
      (if (char= (char string i) #\newline)
	  (setf (char string i) (code-char 10))))

    ;;; $B%W%m%H%3%k$KAw$k(B
    (setf ret (yy-protocol-84 tno op color-no font-no string))

    ;;; $B%+%i%`$H9T$r@_Dj(B
    (setf (page-column stream) (nth 4 ret)
	  (page-line stream) (nth 5 ret))

    ;;; $BIA2h%j!<%8%g%s$r5a$a$k(B
    (with-temp-region-args ((region) (work-region1 stream)
		 :left (first ret)
		 :bottom (second ret)
		 :width (third ret)
		 :height (nth 4 ret))
    
         ;;; $BIA2h%j!<%8%g%s$r:BI87O$K9g$o$9(B
        (setf region (change-coodinate-region region stream))

        ;;; drawing-region$B$K:#$N%j!<%8%g%s$rDI2C(B
	(if (null drawing-region)
	    (setf (drawing-region stream) region)
	  (setf (region-left drawing-region)
	    (min (region-left drawing-region) (region-left region))
	    (region-top drawing-region) 
	    (max (region-top drawing-region) (region-top region))
	    (region-right drawing-region)
	    (max (region-right drawing-region) (region-right region))
	    (region-bottom drawing-region)
	    (min (region-bottom drawing-region) (region-bottom region))))
	region)
    ))

    
;;; $B%Z!<%8%b!<%I$N(Bx,y$B%]%8%7%g%s$r@_Dj$9$k!#(B
(defmethod set-cursor-yoko-mode ((stream  page-window-stream)
				 (string string)
				 (region region))
  (declare (inline > -))
  (let ((last-c (char (reverse string) 0))
	(x 0) (y 0))

    ;;; $BIA2h%+!<%=%k$N@_Dj(B
    (if (> (char-code last-c) #xA1)
	;;; $B4A;z(B
	(setf y (- (region-bottom region)
		   (- (font-kanji-height  (stream-font stream))
		       (font-kanji-base-line (stream-font stream))))
	      x (- (region-right region)
		   (font-kanji-width (stream-font stream))))
      ;;; $B1Q;z(B
      (setf y (- (region-bottom region)
		 (- (character-height (stream-font stream) last-c)
		    (character-base-line (stream-font stream) last-c)))
	    x (- (region-right region)
		 (character-width (stream-font stream) last-c))))

    (setf (stream-cursor-x-position stream) x
	  (stream-cursor-y-position stream) y)
    ))



;;; $B%Z!<%8MQ(B $B=D=q$-J8;zNs$NI=<((B
;;; $B=q$$$?Bg$-$5$r(Bdrawing-region $B$K@_Dj(B
(defmethod set-cursor-tate-mode ((stream  page-window-stream)
				 (string string)
				 (region region))
  (declare (inline > -))
  (let ((last-c (char (reverse string) 0))
	(x 0) (y 0))

    ;;; $BIA2h%+!<%=%k$N@_Dj(B
    (if (> (char-code last-c) #xA1)
	;;; $B4A;z(B
	(setf y (- (region-bottom region)
		   (- (font-kanji-height  (stream-font stream))
		       (font-kanji-base-line (stream-font stream))))
	      x (- (region-right region)
		   (font-kanji-width (stream-font stream))))
      ;;; $B1Q;z(B
      (setf y (- (region-bottom region)
		 (character-width (stream-font stream) last-c))
	    x (- (region-right region)
		 (character-height (stream-font stream) last-c))))

    (setf (stream-cursor-x-position stream) x
	  (stream-cursor-y-position stream) y)
    ))

;;; $B9T$K$h$j(By-position$B$H9T$r@_Dj$9$k(B
(defmethod set-y-position-for-page-maode ((stream page-window-stream)
					  line-amount
					  colum-amount)
  (if (eq (stream-output-direction  stream) :vertical)
      (let ((colum-no (- colum-amount (page-column stream))))
	(setf (page-column stream) colum-amount
	      (stream-cursor-x-position stream)
	      (* colum-no (stream-line-feed stream))))
    (let ((lin-no (- line-amount (page-line stream))))
      (setf (page-line stream) line-amount
	    (stream-cursor-y-position stream)
	    (* lin-no (stream-line-feed stream)))
      )))




