;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;
;; YY$B%&%#%s%I%&%7%9%F%`$N%U%)%s%H4XO"$rDj5A$9$k!#(B
;;               1990.2.20  $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-2-20
;;; Chnage LOG    string-display-region-yoko is for LT LB coodinate 1990-8-24
;;;               string-display-region-tata is for LT LB coodinate 1990-8-24
;;;               Add ICS for string-display-region****
;;;		  font-string-length is added Symbolics code

(in-package :yy)


;;; $B%F%-%9%H%U%)%s%H%-%c%i%/%?$N%/%i%9(B
(defclass font-character ()
  ((character-width :initarg :character-width :initform 0)
   ;;; $B1Q;z$N9b$5$OA4$FF1$8(B
   (character-height :initarg :character-height :initform 0) 
   ;;; $B%Y!<%9%i%$%s$NBg$-$5$b0lDj(B
   (character-base-line :initarg :character-base-line :initform 0)))

;;; $B%F%-%9%H%U%)%s%H$N%/%i%9(B
(defclass text-font ()
  ;;; $B:G$bI}$N9-$$>l9g$O1Q;z$N(B2$BG\(B
  ((kanji-width :initarg :kanji-width :initform 0
		:reader font-kanji-width) 
   ;;; $B1Q;z$HF1$8(B
   (kanji-height :initarg :kanji-height :initform 0
		 :reader font-kanji-height) 
   ;;; $B1Q;z$HF1$8(B
   (kanji-base-line :initarg :kanji-base-line :initform 0
		    :reader font-kanji-base-line) 
   (font-name :initarg :fontname :initform "")
   (internal-font-no :initarg :internal-font-no :type integer :reader font-no)
   (ascii-font :initarg :ascii-font)))

;;; Font$B$N(Binternal$B@8@.4X?t(B
(defun make-internal-font (&key kanji-width kanji-height kanji-base-line)
  (let ((font (make-instance 'text-font :kanji-width kanji-width
                             :kanji-height kanji-height
                             :kanji-base-line kanji-base-line))
	(ascii-font (make-array 256 :element-type t)))

    (dotimes (i 256)
      (setf (elt ascii-font i)  (make-instance 'font-character)))

    (setf (slot-value font 'ascii-font) ascii-font)

    font))

;;; $B%U%)%s%H$N%m!<%I4X?t(B
(defun load-font (&key (font-name ""))
  (if (zerop (length font-name))
      (error "The argument ~a is not correct." font-name)
    (let ((font (make-internal-font)))
      ;;; $B%W%m%H%3%k$r8F$S=P$9(B
      (if (yy-protocol-10 font-name font) 
	  font
	(error "Sorry, Can not load ~a font" font-name)))))

;;; Font character $B$N%;%C%H4X?t(B
(defmethod set-font-char ((font text-font) (char character) 
		  (width integer) (height integer) 
			  (base-line integer))
  (let ((font-char (aref (slot-value font 'ascii-font) (char-code char))))
    (setf (slot-value font-char 'character-width) width
	  (slot-value font-char 'character-height) height
	  (slot-value font-char 'character-base-line) base-line)))


;;; Font $B$NI=<(4X?t(B
(defmethod print-object ((font text-font) stream)
  (format stream "\<#Fontname ~a >" (slot-value font 'font-name)))

;;; $B%F%-%9%H%U%)%s%H$N%"%/%;%C%9%a%=%C%I(B font-name
(defmethod font-name ((font text-font))
  (slot-value font 'font-name))

;;; $B%F%-%9%H%U%)%s%H%-%c%i%/%?$N%"%/%;%9%a%=%C%I(B character-width
(defmethod character-width ((font text-font) (charcter character))
  (slot-value (aref (slot-value font 'ascii-font) (char-code charcter)) 
	      'character-width))

;;; $B%F%-%9%H%U%)%s%H%-%c%i%/%?$N%"%/%;%9%a%=%C%I(B character-height
(defmethod character-height ((font text-font) (charcter character))
  (slot-value (aref (slot-value font 'ascii-font) (char-code charcter)) 
	      'character-height))

;;; $B%F%-%9%H%U%)%s%H%-%c%i%/%?$N%"%/%;%9%a%=%C%I(B character-base-line
(defmethod character-base-line ((font text-font) (charcter character))
  (slot-value (aref (slot-value font 'ascii-font) (char-code charcter)) 
	      'character-base-line))


;;;$B0u;z>e$NJ8;zNs$ND9$5$r5a$a$k%a%=%C%I(B
#+(or LUCID (and EXCL (not ICS)) Symbolics)
(defmethod font-string-length  ((font text-font) (string string))
  ;;; $B$3$N%a%=%C%I$O!"(Binternational character set$B$K$J$C$F$$$J$$(B
  ;;; LISP$B$G!"2TF/$9$k(B
  (declare (inline length >= + /))
  (let ((t-length 0) )
    (dotimes (i (length string))
	(if (>= (char-code (char string i)) #xA1)
	    ;;; $B4A;z$N>l9g(B
	    (setf t-length (+ t-length (round 
     			      (/ (font-kanji-width font) 2))))
            ;;; $B1Q;z$N>l9g(B
	    (setf t-length (+ t-length
			      (character-width font (char string i))))))
    t-length))
#+(and (or LUCID EXCL) ICS)
(defmethod font-string-length  ((font text-font) (string string))
  (declare (inline >= +))
    (let ((t-length 0) )
    (dotimes (i (length string))
	(if (>= (char-code (char string i)) #xA1)
	    ;;; $B4A;z$N>l9g(B
	    (setf t-length (+ t-length (font-kanji-width font)))
            ;;; $B1Q;z$N>l9g(B
	    (setf t-length (+ t-length
			      (character-width font (char string i))))))
    t-length))


;;;$B0u;z>e$NJ8;zNs$NBg$-$5$r5a$a$k$+$s$9$&(B $B2#=q$-MQ(B
;;;$B;XDj$5$l$?0LCV$+$i=q$-;O$a$?;~$N(Bregion$B$r5a$a$k(B
;;;$B2~9TJ8;z(B#\Newline$B$d(B#\Return$B$,$"$l$P9MN8$9$k(B
;;;$B$+$$$.$g$&$b$8$^$G$N!"$b$8$l$D%j%9%H$b!"$b$H$a$k(B
(defun string-display-region-yoko (font region string line-feed 
				   x y matrix left-m right-m 
				   coodinate &optional (truncate-width nil))
  (declare (ignore coodinate))
  (if (null left-m)
      (string-display-region-yoko-internal-no region font string line-feed
					      x y matrix)
    (string-display-region-yoko-internal region left-m right-m font string 
	      truncate-width  line-feed x y matrix)))

;;; $B$"$k0LCV$N%U%)%s%H$NCf1{$rJV$9!JI}!K(B
(defun font-half-width (x font)
  (round (+ x (/ (font-kanji-width font) 2))))

;;; $B$"$k0LCV$N%U%)%s%H$NCf1{$*JV$9!J9b$5!K(B
;;; Y$B$O%Y!<%9%i%$%s$K$"$k$b$N$H$9$k(B
(defun font-half-height (y font)
	(- (+ y (- (font-kanji-height font)
               (font-kanji-base-line font)))
       (round (/ (font-kanji-height font) 2))))

;;; $B2~9T;~$N=hM}$r$9$k(B
(defun line-feed-op (xpos ypos ret xy-list matrix line-feed font
			  &optional (l-m 0))
  (multiple-value-bind 
   (nx ny) (transform-by-matrix-xy xpos ypos matrix)
   (push (list (font-half-width nx font)
	           (font-half-height ny font)) xy-list))

  (multiple-value-bind 
   (nx ny) (transform-by-matrix-xy l-m (+ ypos line-feed) matrix)
   (push (list nx ny) ret)
   (push (list (font-half-width nx font) (font-half-height ny font)) xy-list))
  (setf xpos l-m ypos (+ ypos line-feed))
  (values xpos ypos ret xy-list))

;;; $B%^!<%8%s$H%H%i%s%1%$%H=hM}$r$7$J$$(B
(defun string-display-region-yoko-internal-no (region font string
					    line-feed x y matrix )
  (declare (inline + max min >= incf -))
  (let* ((posx x)
	 (posy y)
	 (end (length string)) (start 0)
	 (ret nil) (ii 0) 
	 (xy-list (list (list x y)))
	 (ch #\a)
	 (font-width (font-kanji-width font)))

	(multiple-value-bind 
	(nx ny) (transform-by-matrix-xy posx posy matrix)
	(push (list (font-half-width nx font)
                (font-half-height ny font)) xy-list)
	(push (list nx ny) ret))
	
    ;;; $BJ8;z$r7W;;(B
    (dotimes (i end)
	(setf ch (char string i))

#+:symbolics
      (if (char= ch #\newline)
	  (setf ch (code-char 10)))

    	(if (>= (char-code ch) #xA1)
	    (progn 
	    ;;; $B4A;z$N>l9g(B
	      (incf posx font-width)
#+(or LUCID (and EXCL (not ICS)))
              (incf i)
	      )
	  (case (char-code ch)
		  ((10  13);;; $B2~9TJ8;z(B
		   (push (subseq string start i) ret)
		   
		   (multiple-value-setq
		    (posx posy ret xy-list)
		    (line-feed-op posx posy ret xy-list matrix line-feed font))

		   (setf start (+ i 1)))
		  (t ;;; $B1Q;z$N>l9g(B
		   (incf posx (character-width font ch))
		   )))
		   
	(setf ii i))
    
    ;;; $B2sE>9TNs$r$+$1$k(B
    (multiple-value-bind (nx ny)
			 (transform-by-matrix-xy posx posy matrix)
			 (push (list (font-half-width nx font)
                         (font-half-height ny font)) xy-list))
    (if (> end 0)
	(push (subseq string start (incf ii)) ret))

    (push (list posx posy) ret)
    (setf ret (nreverse ret))
    (push posy ret)
    (push posx ret)

    (set-min-max-to-region region xy-list font)

    (push region ret)
    ret))

(defun set-min-max-to-region (region xy-list font)
  (let ((xmin MOST-POSITIVE-FIXNUM)
	(ymin MOST-POSITIVE-FIXNUM)
	(xmax most-negative-fixnum)
	(ymax most-negative-fixnum)
	(width (round (/ (font-kanji-width font) 2)))
	(height (round (/ (font-kanji-height font) 2))))
  (dolist (item xy-list)
	  (if (> (car item) xmax)
                 (setf xmax (car item)))
	  (if (<= (car item) xmin)
	      (setf xmin (car item)))

	  (if (> (second item) ymax)
                 (setf ymax (second item)))
	  (if (<= (second item) ymin)
	      (setf ymin (second item))))
    (with-slots 
     (left bottom right top) region
     (setf left (- xmin width) right (+ xmax width)
	   bottom (- ymin height) top (+ ymax height)))
	))

;;; $B%^!<%8%s=hM}$H%H%i%s%1%$%H=hM}$r$9$k(B
;;; $B2sE>9TNs$,$+$1$i$l$F$$$k>l9g$O!"%^!<%8%s$KBP$7$F$b(B
;;; $B2sE>9TNs$,$+$+$i$l$k!#(B
(defun string-display-region-yoko-internal (region left-m right-m font string
					    truncate-width 
					    line-feed x y matrix)
  (declare (inline >= max min + -))
  (let* ((end (length string))
	(ret nil)  (ii 1)
	(posx x)
	(xy-list (list (list x y)))
	(posy y)
	(font-width (font-kanji-width font))
	(truncate-flg nil)
	(start 0)
	(ch #\a))
	
	(multiple-value-bind 
	(nx ny) (transform-by-matrix-xy posx posy matrix)
	(push (list (font-half-width nx font)
                (font-half-height ny font)) xy-list)
	(push (list nx ny) ret))
	
    ;;; $BJ8;z$r7W;;(B
    (dotimes (i end)
	     (setf ch (char string i))

#+:symbolics
      (if (char= ch #\newline)
	  (setf ch (code-char 10)))

	     ;;; $B%H%i%s%1%$%H=hM}(B
	     (if (and truncate-flg (/= 10 (char-code ch))
		      (/= 13 (char-code ch)))
		 (incf start)
	       (setf truncate-flg nil))

	     (if (>= (char-code ch) #xA1)
		 (progn 
	            ;;; $B4A;z$N>l9g(B
		   (incf posx font-width)
		   (if (> posx right-m)
		       (if (null truncate-width)
			   (progn 
			     (push (subseq string start i) ret)
			     (multiple-value-setq
			      (posx posy ret xy-list)
			      (line-feed-op posx posy ret xy-list matrix 
					    line-feed font left-m))
			     (decf i)
			     (setf start i ))
			 (setf truncate-flg T))
#+(or LUCID (and EXCL (not ICS)))
                   (incf i)
		   ))
	       (case (char-code ch)
		     ((10  13);;; $B2~9TJ8;z(B
		      (push (subseq string start i) ret)
		      (multiple-value-setq
		       (posx posy ret xy-list)
		       (line-feed-op posx posy ret xy-list
                             matrix line-feed font left-m))
		      (setf start (+ i 1)))
		     (t ;;; $B1Q;z$N>l9g(B
		      (incf posx (character-width font ch))
		      (if (> posx right-m)
			  (if (null truncate-width)
			      (progn 
				(push (subseq string start i) ret)
				(multiple-value-setq
				 (posx posy ret xy-list)
				 (line-feed-op posx posy ret xy-list matrix 
					       line-feed font left-m))
				(decf i)
				(setf start i))
			    (setf truncate-flg T))))
		      ))
		   
	     (setf ii i))
    
    ;;; $B2sE>9TNs$r$+$1$k(B
    (multiple-value-bind (nx ny)
			 (transform-by-matrix-xy posx posy matrix)
			 (push (list (font-half-width nx font)
                         (font-half-height ny font)) xy-list))
    (if (> end 0)
	(push (subseq string start (incf ii)) ret))

    (push (list posx posy) ret)
    (setf ret (nreverse ret))
    (push posy ret)
    (push posx ret)

    (set-min-max-to-region region xy-list font)

    (push region ret)
    ret))


;;;$B0u;z>e$NJ8;zNs$NBg$-$5$r5a$a$k4X?t$O=D=q$-MQ(B
;;;$B;XDj$5$l$?0LCV$+$i=q$-;O$a$?;~$N(Bregion$B$r5a$a$k(B
;;;$B2~9TJ8;z(B#\Newline$B$d(B#\Return$B$,$"$l$P9MN8$9$k(B
;;;$B2~9T;~$N2sE>9TNs$O!"9MN8$9$k!#$7$+$7!"IA2h;~$N2sE>9TNs$OL5;k(B
(defun string-display-region-tate (font region string line-feed x y matrix
				   t-margin b-margin 
				   coodinate
				   &optional (truncate-height nil))
  (declare (inline max min + - <= >=)
	   (ignore coodinate))
  (let* ((end (length string))
	(ret nil)  (ii 1)
	(posx x)
	(xy-list (list (list x y)))
	(posy y)
	(font-height (font-kanji-height font))
	(truncate-flg nil)
	(start 0)
	(ch #\a))

    (unless t-margin
      (setf t-margin most-positive-fixnum))

    (unless b-margin
      (setf b-margin (font-kanji-base-line font)))

	(multiple-value-bind 
	(nx ny) (transform-by-matrix-xy posx posy matrix)
	(push (list (font-half-width nx font)
                (font-half-height ny font)) xy-list)
	(push (list nx ny) ret))
	
    ;;; $BJ8;z$r7W;;(B
    (dotimes (i end)
	     (setf ch (char string i))

#+:symbolics
      (if (char= ch #\newline)
	  (setf ch (code-char 10)))

	     ;;; $B%H%i%s%1%$%H=hM}(B
	     (if (and truncate-flg (/= 10 (char-code ch))
		      (/= 13 (char-code ch)))
		 (incf start)
	       (setf truncate-flg nil))

	     (if (>= (char-code ch) #xA1)
		 (progn 
	            ;;; $B4A;z$N>l9g(B
		   (incf posy font-height)
		   (if (> posy t-margin)
		       (if (null truncate-height)
			   (progn 
			     (push (subseq string start i) ret)
			     (multiple-value-setq
			      (posx posy ret xy-list)
			      (line-feed-op-tate posx posy ret xy-list matrix 
						 line-feed font b-margin))
			     (decf i)
			     (setf start i))
			 (setf truncate-flg T))
#+(or LUCID (and EXCL (not ICS)))
                   (incf i)
		   ))
	       (case (char-code ch)
		     ((10  13);;; $B2~9TJ8;z(B
		      (push (subseq string start i) ret)
		      (multiple-value-setq
		       (posx posy ret xy-list)
		       (line-feed-op-tate posx posy ret xy-list 
					  matrix line-feed font b-margin))
		      (setf start (+ i 1)))
		     (t ;;; $B1Q;z$N>l9g(B
		      (incf posy (character-width font ch))
		      (if (> posy t-margin)
			  (if (null truncate-height)
			      (progn 
				(push (subseq string start i) ret)
				(multiple-value-setq
				 (posx posy ret xy-list)
				 (line-feed-op-tate posx posy ret xy-list matrix 
					       line-feed font b-margin))
				(decf i)
				(setf start i))
			    (setf truncate-flg T))))
		      ))
		   
	     (setf ii i))
    
    ;;; $B2sE>9TNs$r$+$1$k(B
    (multiple-value-bind (nx ny)
			 (transform-by-matrix-xy posx posy matrix)
			 (push (list (font-half-width nx font)
                         (font-half-height ny font)) xy-list))
    (if (> end 0)
	(push (subseq string start (incf ii)) ret))

    (push (list posx posy) ret)
    (setf ret (nreverse ret))
    (push posy ret)
    (push posx ret)

    (set-min-max-to-region region xy-list font)

    (push region ret)
    ret))

;;; $B=D=q$-;~$N2~9T=hM}$r$9$k(B
(defun line-feed-op-tate (xpos ypos ret xy-list matrix line-feed font
			  &optional (l-m 0))

  (multiple-value-bind 
   (nx ny) (transform-by-matrix-xy xpos ypos matrix)
   (push (list (font-half-width nx font)
               (font-half-height ny font)) xy-list))
			  
  (multiple-value-bind 
   (nx ny) (transform-by-matrix-xy (- xpos line-feed) l-m matrix)
   (push (list nx ny) ret)
   (push (list (font-half-width nx font)
               (font-half-height ny font)) xy-list))
  (setf xpos (- xpos line-feed) ypos l-m)
  (values xpos ypos ret xy-list))

;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(B
;;; $B:8>e:BI87O(B
(defmethod font-top ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-top))
  (declare (inline -))
  (- (character-height font char)
     (character-base-line font char)))

;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(B
;;; $B:82<:BI87O(B
(defmethod font-top ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-bottom))
  (character-base-line font char))


;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(B
;;; $B:8>e:BI87O(B
(defmethod font-bottom ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-top))
  (character-base-line font char))


;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(B
;;; $B:82<:BI87O(B
(defmethod font-bottom ((font text-font)
		     (char character)
		     (coodinate translate-coordinate-left-bottom))
  (declare (inline -))
  (- (character-height font char)
     (character-base-line font char)))


;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(B
;;; $B:8>e:BI87O(B
(defmethod font-kanji-top ((font text-font)
		     (coodinate translate-coordinate-left-top))
  (- (font-kanji-height font)
     (font-kanji-base-line font )))

;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%H%C%W$rJV$9(B
;;; $B:82<:BI87O(B
(defmethod font-kanji-top ((font text-font)
		     (coodinate translate-coordinate-left-bottom))
  (font-kanji-base-line font ))


;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(B
;;; $B:8>e:BI87O(B
(defmethod font-kanji-bottom ((font text-font)
		     (coodinate translate-coordinate-left-top))
  (font-kanji-base-line font))


;;; $B:BI87O$r9MN8$7$?%U%)%s%H$N%Y!<%9%i%$%s$+$i$N%\%H%`$rJV$9(B
;;; $B:82<:BI87O(B
(defmethod font-kanji-bottom ((font text-font)
		     (coodinate translate-coordinate-left-bottom))
  (declare (inline -))
  (- (font-kanji-height font)
     (font-kanji-base-line font)))

;;; End of file
