;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; Mouse cusor $B4XO"(B
;;; mouse-cursor.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%^%&%9%+!<%=%k%/%i%9(B
;;; 6/22 1990 $B8E:d(B
;;; Version 1.0   Cored by t.kosaka 1990-6-22

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; $B%^%&%9%+!<%=%k%/%i%9(B ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass mouse-cursor ()
  ((mouse-cursor-territory-no :initarg :mouse-territory
			      :initform 0 :accessor mouse-territory-no)
   (mouse-width :initarg :mouse-width :initform 0 :accessor mouse-width)
   (mouse-height :initarg :mouse-height :initform 0 :accessor mouse-height)
   (mouse-cursor-bitmap :initarg :mouse-cursor-bitmap :initform nil
			:accessor mouse-cursor-bitmap)
   (x-hotspot :initarg :x-hotspot :initform 0 :accessor x-hotspot)
   (y-hotspot :initarg :y-hotspot :initform 0 :accessor y-hotspot)))


;;; $B%^%&%9%+!<%=%k$NI=<(%a%=%C%I(B
(defmethod print-object ((mouse mouse-cursor) stream)
  (format stream "\#<Mouse Cursor hotspot ~a,~a>" (x-hotspot mouse)
	  (y-hotspot mouse)))

;;; $B%^%&%9%+!<%=%k$+!)(B
(defun mouse-cursorp (object)
  (typep object 'mouse-cursor))


;;; $B%^%&%9%+!<%=%k%/%i%9$r:n$k(B
;;; $B%S%C%H%^%C%W$O!"%^%&%9%+!<%=%k$r:n$k;~$@$1!"$=$N3(>pJs$,;HMQ$5$l$k(B
;;; $B=>$C$F!"$=$N%S%C%H%^%C%W$r%^%&%9%+!<%=%k:n@.8e!"JQ99$7$F$b(B
;;; $B%^%&%9%+!<%=%k$N7A>u$O!"JQ2=$7$J$$!#(B
(defun make-mouse-cursor (width height bitmap &key (x-hotspot 0) 
				(y-hotspot 0))
  (declare (special *ROOT-TERRITORY-NO*))
  (let ((instance (make-instance 'mouse-cursor
				 :mouse-width width 
				 :mouse-height height
				 :mouse-cursor-bitmap bitmap
				 :x-hotspot x-hotspot
				 :y-hotspot y-hotspot)))

    (if (or (window-streamp bitmap)
	    (bitmap-streamp bitmap))
	(let ((no (yy-protocol-90 width height *ROOT-TERRITORY-NO*
			     x-hotspot y-hotspot
			     (world-territory-no bitmap))))
	  (if (zerop no)
	      (error "Can not make mause cursor"))
	  (progn
	     ;;; $BHV9f$H$N4XO"IU$1(B
	    (set-territory-object no instance)
	    (setf (mouse-territory-no instance) no)))
	(error "The argument ~a is not a bitmap-stream or window-stream" bitmap))

    instance))

;;; X-hotspot$B$NJQ99(B
(defmethod (setf x-hotspot) :around (new-value (mouse mouse-cursor))
  (if (integerp new-value)
      (progn
	(yy-protocol-91 (mouse-territory-no mouse)
		      new-value
		      (y-hotspot mouse))
	(call-next-method))
    (error "The argument ~a is not a integer" new-value)))

;;; Y-hotspot$B$NJQ99(B
(defmethod (setf y-hotspot) :around (new-value (mouse mouse-cursor))
  (if (integerp new-value)
      (progn
	(yy-protocol-91 (mouse-territory-no mouse)
		      (x-hotspot mouse)
		      new-value)
	(call-next-method))
    (error "The argument ~a is not a integer" new-value)))

;;; $B%^%&%9%+!<%=%k$N%S%C%H%^%C%W$NJQ99(B
(defmethod (setf mouse-cursor-bitmap) :around (new-b (mouse mouse-cursor))
  (if (or (window-streamp new-b)
	  (bitmap-streamp new-b))
      (progn 
	(yy-protocol-92 (mouse-territory-no mouse)
			(world-territory-no new-b))
	(call-next-method))
    (error "THe argument ~a is not a bitmap-stream or window-stream" new-b)))
	
;;; $B%^%&%9%+!<%=%k$N>C5n(B
(defmethod flush-mouse-cursor ((mouse mouse-cursor))
  (let ((return (yy-protocol-5 (mouse-territory-no mouse))))
    (if (zerop return)
        (error "Sorry ,can not remove ~a" mouse)
      (progn
      (delete-lisp-object (world-territory-no mouse))
      nil))))

;;; $B%^%&%9%+!<%=%k$NJQ99(B
(defmethod change-mouse-cursor ((mouse mouse-cursor))
  (declare (special *SYSTEM-MOUSE-CURSOR*))
  
  (setf *SYSTEM-MOUSE-CURSOR* mouse)
  (yy-protocol-96 (mouse-territory-no mouse))
  mouse)

;;; $B%^%&%9%+!<%=%k$NJQ99(B NULL$B$N>l9g(B
(defmethod change-mouse-cursor ((mouse NULL))
  mouse)

  
;;; $B%G%U%)%k%H$N%^%&%9%+!<%=%k$r:n$k(B
;;; bitmap-stream $B$N3($,:n$i$l$l$PJQ99$9$Y$7(B
(defun make-default-mosue-cursor ()
  (let ((bitmap (make-bitmap-stream :width 16 :height 16)))
    (yy-protocol-31 (world-territory-no bitmap)
		    0 4 *GCOPY* (color-no (graphic-color bitmap))
		    (font-no *DEFAULT-FONT*) "y")
    (yy-protocol-31 (world-territory-no bitmap)
		    12 12 *GCOPY* (color-no (graphic-color bitmap))
		    (font-no *DEFAULT-FONT*) "y")

    (yy-protocol-21 (world-territory-no bitmap)
		   4 8 12 8 1 *GCOPY* *SQUEAR-LINE-EDGE*
		   (color-no (graphic-color bitmap)) "")
		   
    (yy-protocol-21 (world-territory-no bitmap)
		   8 4 8 12 1 *GCOPY* *SQUEAR-LINE-EDGE*
		   (color-no (graphic-color bitmap)) "")
		   
    (make-mouse-cursor 16 16 bitmap :x-hotspot 8 :y-hotspot 8)))

;;; get-position $BMQ%^%&%9%+!<%=%k(B
(defun make-get-position-mouse-cursor ()
  (let ((bitmap (make-bitmap-stream :width 16 :height 6)))
    (yy-protocol-22 (world-territory-no bitmap)
		    8 8 8 1 *GCOPY* (color-no (graphic-color bitmap)) "")

    (yy-protocol-21 (world-territory-no bitmap)
                   0 8 16 8 1 *GCOPY* *SQUEAR-LINE-EDGE*
                   (color-no (graphic-color bitmap)) "")
    (yy-protocol-21 (world-territory-no bitmap)
                    8 0 8 16 1 *GCOPY* *SQUEAR-LINE-EDGE*
                   (color-no (graphic-color bitmap)) "")
    
    (make-mouse-cursor 16 16 bitmap :x-hotspot 8 :y-hotspot 8)))






