;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; ǥեȥݥåץåץ˥
;;; default-pop-up-menu.lisp
;;; This file is coeded by EUC.
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; 7/20 1990 ź
;;; Version 1.0   Corded by t.kosaka 1990-7-20
;;; Version 2.0   Corded by t.kosaka 1991-2-13
;;; 


(in-package :yy)

;;; ɥѤΥݥåץåץ˥
(defun default-window-pop-up-menu ()
  (let ((menu-list '(("Iconify " 'shrink "ɥΥ")
		     ("Resize " 'w-resize "ɥ礭ѹ")
		     ("Move" 'w-move "ɥΰư")
		     ("Bury" 'bury "ɥ򲼤ˤ")
		     ("Expose " 'expose "ɥˤ")
		     ("Clear" 'clear-window-stream "ɥɽä"))))
    (make-popup-menu menu-list :title-string "Window Menu")))

;;; ץ쥼ơѤΥݥåץåץ˥
(defun default-presentation-pop-up-menu ()
  (let ((menu-list '(("Move Object" 'move-object "ץ쥼Ȥ줿Τΰư")
		     ("Drawing Copy" 'drawing-copy "ץ쥼Ȥ줿򥳥ԡ")
		     ("Delete " 'delete-presentation-instance
		      "ץ쥼Ȥ줿ξõ")
		     ("Bury" 'bury-presentation "ˤ"))))
	(make-popup-menu menu-list :title-string "Presentation Menu")))

;;; ɥΥꥵ
(defmethod w-resize ((window window-stream))
  (let ((region (get-region :init-region (window-region window)
			    :window (parent-window window))))
    (reshape window region)
    ))

;;; ɥΰư
(defmethod w-move ((window window-stream))
  (let ((region (get-box-region (window-region window)
				:window (parent-window window))))
    (move window (region-position region :return :position)))
  )


;;; ѥݥåץåץ˥
(defun default-icon-pop-up-menu ()
  (let ((menu-list '(("Expand" 'expand "Υɥ")
		     ("Move" 'w-move "ΰư")
		     ("Bury" 'bury "򲼤ˤ")
		     ("Expose" 'expose "ˤ"))))
    (make-popup-menu menu-list :title-string "Icon Menu")))

;;; ݥåץåץ˥ɽ
(defmethod window-pop-up ((parts window-parts) state )
  (declare (special *pop-up-menu-window* *icon-pop-up-menu-window*
		    *root-window*))
  (let* ((x 0) (y 0) 
	 (window (parent-window parts))
	 (pop-up (if (eq (window-status window) :window)
		     *pop-up-menu-window*
		   *icon-pop-up-menu-window*))
	 (p-region (window-region pop-up))
	 (p-width (truncate (/ (region-width p-region) 2)))
	 (p-height (- (region-height p-region)
		      (font-kanji-height (title-bar-font pop-up))))
	 (r-width (region-width (window-region *root-window*)))
	 (r-height (region-height (window-region *root-window*))))

    (multiple-value-setq (x y) (translate-root-xy parts
						(mouse-state-x-position state)
						(mouse-state-y-position state)))
    
    (decf x p-width)
    (decf y (font-kanji-height (title-bar-font pop-up)))

    (when (< r-width (+ x p-width))
      (setf x (- x (- r-width  p-width))))
	  
    (when (> 0 (- x p-width))
      (setf x (- p-width x)))

    (when (< r-height (+ y p-height))
      (setf y (- r-height p-height)))
    
    (when (> 0 y)
      (incf y (- y)))

    (move-xy pop-up x y)

    (display-popup-menu pop-up x y window)
  ))

;;; ѥݥåץåץ˥ɽ
(defmethod icon-pop-up ((parts window-parts) state)
  (declare (special *pop-up-menu-window* *icon-pop-up-menu-window*
		    *root-window*))
  (let* ((x 0) (y 0) 
	 (window (parent-stream parts))
	 (pop-up  *icon-pop-up-menu-window*)
	 (p-region (window-region pop-up))
	 (p-width (truncate (/ (region-width p-region) 2)))
	 (p-height (- (region-height p-region)
		      (font-kanji-height (title-bar-font pop-up))))
	 (r-width (region-width (window-region *root-window*)))
	 (r-height (region-height (window-region *root-window*))))

    (when (eq (window-status window) :icon)

	  (multiple-value-setq (x y) (translate-root-xy parts
					(mouse-state-x-position state)
					(mouse-state-y-position state)))
    

	  (decf x p-width)
	  (decf y (font-kanji-height (title-bar-font pop-up)))

	  (when (< r-width (+ x p-width))
	      (setf x (- x (- r-width  p-width))))
	  
	  (when (> 0 (- x p-width))
	    (setf x (+ x (- p-width x))))

	  (when (< r-height (+ y p-height))
	      (setf y (- r-height p-height)))

	  (when (> 0 y)
	    (incf y (- y)))
	  (move-xy pop-up x y)
	  (display-popup-menu pop-up x y window))
    )
  )







