;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $B%&%#%s%I%&%9%H%j!<%`$N%"%/%;%5%j!<(B
;;; 3/128 1990 $B8E:d(B
;;; Version 1.0   Coded by t.kosaka 1990-3-13

(in-package :yy)


(defparameter *SCROLL-MOVE-STEP* 10)


;;; Y$B%*%U%;%C%H$r5a$a$k(B
(defun get-new-y-offset-internal (y world-height vscroll-height)
  (declare (inline round / *))
  (round (/ (* y world-height) vscroll-height)))


;;; X$B%*%U%;%C%H$r5a$a$k(B
(defun get-new-x-offset-internal (x world-width hscroll-width)
  (declare (inline round / *))
  (round (/ (* x world-width) hscroll-width)))


;;;$B%9%/%m!<%k%a%=%C%I:8%\%?%s(B INTERNAL $B>e$K0\F0(B
(defmethod vertical-scroll-left-internal ((window window-stream) 
				     (pos position)
				     &optional event-type)

  (declare (inline + - / *)
	   (ignore event-type))
  (let* ((s-height (region-height (vertical-scroll-region window)))
	 (w-height (region-height window))
	 (offset (round (/ (* (world-y-offset window) s-height) w-height)))

	 (co-style (class-name (class-of
				(stream-translate-coordinate window)))))

    (if (eq co-style 'translate-coordinate-left-bottom)
	(scroll window (world-x-offset window) 
	   (get-new-y-offset-internal (+ offset *scroll-move-step*)
				      w-height s-height))
      (scroll window (world-x-offset window)
	       (get-new-y-offset-internal (- offset *scroll-move-step*)
					    w-height s-height))
	   )
))
  


;;; $B%9%/%m!<%k%a%=%C%I1&%\%?%s(B INTERNAL $B2<$K0\F0(B
(defmethod vertical-scroll-right-internal ((window window-stream)
					   (pos position)
					   &optional event-type)
  (declare (inline round / * + -)
	   (ignore event-type))
  (let* ((s-height (region-height (vertical-scroll-region window)))
	 (w-height (region-height window))
	 (offset (round (/ (* (world-y-offset window) s-height) w-height)))

	 (co-style (class-name (class-of
				(stream-translate-coordinate window)))))

    (if (eq co-style 'translate-coordinate-left-bottom)
	(scroll window (world-x-offset window) 
	  (get-new-y-offset-internal (- offset *scroll-move-step*)
				      w-height s-height))
      (scroll window (world-x-offset window)
	      (get-new-y-offset-internal (+ offset *scroll-move-step*)
					    w-height s-height))
	   )))				;Removed extra close parenthis
  

;;; $B%9%/%m!<%k%a%=%C%ICf%\%?%s(B INTERNAL $B;XDj$5$l$?0LCV$K0\F0(B
(defmethod vertical-scroll-middle-internal ((window window-stream)
                                           (pos position)
                                           &optional event-type)
  (declare (inline round / * + -)
	   (ignore event-type))
   (let* ((s-height (region-height (vertical-scroll-region window)))
          (w-height (region-height window))
          (v-height (region-height (frame-region window)))
          (vh (round (/ (* s-height v-height) w-height)))
	  (new-y (- (position-y pos) (round (/ vh 2)))))

       (scroll window (world-x-offset window) 
	     (- (get-new-y-offset-internal new-y w-height s-height)))
     ))

;;; $B%\%?%s$,2!2<$5$l$J$,$iF0$$$?(B
(defmethod vertical-scroll-move-internal ((window window-stream)
                                           (pos position)
                                           event-type)
  (declare (inline round / * - abs))
  ;;; $BCf%\%?%s$,2!2<$5$l$?$+D4$Y$k(B
  (if (eq *mouse-move-while-mouse-middle-1*  event-type)
   (let* ((s-height (region-height (vertical-scroll-region window)))
          (w-height (region-height window))
          (v-height (region-height (frame-region window)))
          (vh (round (/ (* s-height v-height) w-height)))
	  (new-y (- (position-y pos) (round (/ vh 2))))
	  (offset (- (get-new-y-offset-internal new-y w-height s-height))))
     
	 ;;; $B0\F05wN%$rD4$Y$k(B
      (if (> (abs offset) *SCROLL-MOVE-STEP*)
	     (scroll window (world-x-offset window) offset)))
       ))


;;;$B%9%/%m!<%k%a%=%C%I:8%\%?%s(B INTERNAL $B:8$K0\F0(B
(defmethod horizontal-scroll-left-internal ((window window-stream) 
				     (pos position)
				     &optional event-type)
  (declare (inline round / * -)
	   (ignore event-type))
  (let* ((s-width (region-width (horizontal-scroll-region window)))
	 (w-width (region-width window))
	 (offset (round (/ (* (world-x-offset window) s-width) w-width))))
   (scroll window  (get-new-x-offset-internal (- offset *scroll-move-step*)
			       w-width s-width)
	   (world-y-offset window))
   ))

;;; $B%9%/%m!<%k%a%=%C%I1&%\%?%s(B INTERNAL $B1&$K0\F0(B
(defmethod horizontal-scroll-right-internal ((window window-stream)
					   (pos position)
					   &optional event-type)
  (declare (inline round / * +)
	   (ignore event-type))
  (let* ((s-width (region-width (horizontal-scroll-region window)))
	 (w-width (region-width window))
	 (offset (round (/ (* (world-x-offset window) s-width) w-width))))
   (scroll window (get-new-x-offset-internal (+ offset *scroll-move-step*)
					      w-width s-width)
	   (world-y-offset window))
  ))

;;; $B%9%/%m!<%k%a%=%C%ICf%\%?%s(B INTERNAL $B;XDj$5$l$?0LCV$K0\F0(B
(defmethod horizontal-scroll-middle-internal ((window window-stream)
                                           (pos position)
                                            &optional event-type)
  (declare (inline round / * -)
	   (ignore event-type))
   (let* ((s-width (region-width (horizontal-scroll-region window)))
          (w-width (region-width window))
          (v-width (region-width (frame-region window)))
          (vw (round (/ (* s-width v-width) w-width)))
	  (new-x (- (position-x pos) (round (/ vw 2)))))

     (scroll window (- (get-new-x-offset-internal new-x w-width s-width))
	     (world-y-offset window))
     ))

;;; $B%\%?%s$,2!2<$5$l$J$,$iF0$$$?(B
(defmethod horizontal-scroll-move-internal ((window window-stream)
                                           (pos position)
                                           event-type)
  (declare (inline round / * -))
  ;;; $BCf%\%?%s$,2!2<$5$l$?$+D4$Y$k(B
  (if (eq *mouse-move-while-mouse-middle-1*  event-type)
       (let* ((s-width (region-width (horizontal-scroll-region window)))
	      (w-width (region-width window))
	      (v-width (region-width (frame-region window)))
	      (vw (round (/ (* s-width v-width) w-width)))
	      (new-x (- (position-x pos) (round (/ vw 2))))
	      (offset (- (get-new-x-offset-internal new-x w-width s-width))))

	 ;;; $B0\F05wN%$rD4$Y$k(B
	 (if (> (abs offset) *SCROLL-MOVE-STEP*)
	     (scroll window offset (world-y-offset window))))
       ))


;;; $B%j%9%W%j%9%J!<(B 
(defun yy-lisp-listener (stream)
  (yy-top-level stream))


(defmethod yy-top-level ((stream window-stream))
  (let ((+ nil) (++ nil) (+++ nil)
	(* nil) (** nil) (*** nil))
    (select-window stream)
    (tagbody yy-top-level 
      (loop
	(write-string "> " stream)
	(force-output stream)
	(setf +++ +)
	(setf ++ +)
	(setf + (read stream))
	(setf *** **)
	(setf ** *)
	(multiple-value-bind (ret1 ret2)
	    (#-(or ExCL Symbolics) ignore-errors
	       #+ExCL excl::ignore-errors
	       #+Symbolics scl:ignore-errors
	       (setf * (eval +)))
	  (if ret2
	      (unwind-protect (eval +)
		(progn (terpri stream) (force-output stream)
		       (go yy-top-level)))))
	
	(terpri stream)
	(write-string (write-to-string *) stream)
	(terpri stream)
	(force-output stream)
	))))
	  
    


