/* -*-C-*-
********************************************************************************
*
* File:         w_funtab.h
* RCS:          $Header: /users/npm/src/widgit/src-server/RCS/w_funtab.h,v 2.9 1994/06/22 04:00:47 npm Exp $
* Description:  Indexes (pointers) into functiontable.... the values in this
*		file are needed when adding methods to clases in C ( see
*		xladdmsg()).
*		NOTE: IF YOU WANT TO ADD NEW C-IMPLEMENTED FUNCTIONS TO
*		YOUR OWN LOCAL VERSION OF WINTERP, SEE FILES app_fundecl.h,
*		app_funidx.h, and app_funextn.h. EVENTUALLY, YOU MAY WANT TO
*		MIGRATE ESTABLISHED FUNCTIONALITY TO w_funtab.{c,h}... NOTE
*		HOWEVER, THAT EACH CHANGE TO w_funtab.h WILL ALSO FORCE A
*		MASSIVE RECOMPILE OF w_funtab.c AND wc_*.c tic_*.c -- ALL THOSE
*		SOURCES DEPEND ON VALUES FROM w_funtab.h THAT MAY HAVE CHANGED!!
* Author:       Niels Mayer
* Created:      Fri Nov 24 00:00:00 1989
* Modified:     Tue Jun 21 20:58:28 1994 (Niels Mayer) npm@indeed
* Language:     C
* Package:      N/A
* Status:       X11r6 contrib release
*
* Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
* WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
* WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
* 
* Permission to use, copy, modify, distribute, and sell this software and its
* documentation for any purpose is hereby granted without fee, provided that
* the above copyright notice appear in all copies and that both that
* copyright notice and this permission notice appear in supporting
* documentation, and that the name of Enterprise Integration Technologies,
* Hewlett-Packard Company, or Niels Mayer not be used in advertising or
* publicity pertaining to distribution of the software without specific,
* written prior permission. Enterprise Integration Technologies, Hewlett-Packard
* Company, and Niels Mayer makes no representations about the suitability of
* this software for any purpose.  It is provided "as is" without express or
* implied warranty.
* 
* ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
* DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
* INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
* FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
* RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
* CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
* CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*
********************************************************************************
*/

/*
*------------------------------------------------------------------------------
* See ./winterp/COPYRIGHT for information on contacting the authors.
* Please e-mail comments, modifications, questions, improvements and
* bugfixes to the WINTERP mailing list winterp@netcom.com. Please send 
* mailing list subscribe/unsubscribe notices to winterp-request@netcom.com .
* Post XLISP-specific questions/information to the USENET newsgroup
* comp.lang.lisp.x.
*------------------------------------------------------------------------------
*/

/*
 * NOTE:
 * The following enumerations must be in the exact same order as the
 * entries in w_funtab.c:funtab[]. w_funtab.c:Wfu_Funtab_Sanity_Check()
 * checks to make sure that the number of entries in funtab[] correspond
 * to the number of indexes generated by the enum below. This is done by
 * setting LAST_FUNTAB_POINTER_USED_BY_libWinterp to the last enumeration.
 * A corresponding constant is set to the count of the funtab[] entry in
 * w_funtab.c -- INDEX_OF_LAST_FUNTAB_ENTRY_USED_BY_libWinterp.
 */ 
enum {
  /* DO NOT ALTER ENTRIES UNTIL AFTER OBPRIN1 */
  /*
   * NOTE-FROM-NPM: if you re-order any entries between index 0-15, you must
   * also change the #defines in xlisp/xlisp.h accordingly:
   * #define FT_RMHASH   0
   * #define FT_RMQUOTE	 1
   * #define FT_RMDQUOTE 2
   * #define FT_RMBQUOTE 3
   * #define FT_RMCOMMA  4
   * #define FT_RMLPAR   5
   * #define FT_RMRPAR   6
   * #define FT_RMSEMI   7
   * -- #define xxxxxx   8 --
   * -- #define yyyyyy   9 --
   * #define FT_CLNEW	 10
   * #define FT_CLISNEW	 11
   * #define FT_CLANSWER 12
   * #define FT_OBISNEW	 13
   * #define FT_OBCLASS	 14
   * #define FT_OBSHOW	 15
   * #ifdef OBJPRNT
   * #define FT_OBPRIN1	16
   * #endif
   */

  FTAB_rmhash = 0,
  FTAB_rmquote,
  FTAB_rmdquote,
  FTAB_rmbquote,
  FTAB_rmcomma,
  FTAB_rmlpar,
  FTAB_rmrpar,
  FTAB_rmsemi,
  FTAB_xnotimp1,
  FTAB_xnotimp2,
  FTAB_clnew,
  FTAB_clisnew,
  FTAB_clanswer,
  FTAB_obisnew,
  FTAB_obclass,
  FTAB_obshow,
#ifdef OBJPRNT
  FTAB_obprin1,
#else
  FTAB_xnotimp3,
#endif				/* OBJPRNT */
  FTAB_xnotimp4,
  FTAB_xnotimp5,
  FTAB_xnotimp6,

  /******************************************************************************/
  /************************ BEGIN: WINTERP PRIMITIVES ***************************/
  /******************************************************************************/

  /****************** BEGIN: WINTERP METHODS (Motif >= 1.0) *********************/  
  FTAB_Application_Shell_Widget_Class_Method_GET_ARGV,
  FTAB_Application_Shell_Widget_Class_Method_ISNEW,
  FTAB_Application_Shell_Widget_Class_Method_SET_ARGV,
  FTAB_Popup_Shell_Widget_Class_Method_ISNEW,
  FTAB_Popup_Shell_Widget_Class_Method_POPDOWN,
  FTAB_Popup_Shell_Widget_Class_Method_POPUP,
  FTAB_Shell_Widget_Class_Method_ISNEW,
  FTAB_Shell_Widget_Class_Method_IS_MOTIF_WM_RUNNING,
  FTAB_Shell_Widget_Class_Method_LOWER_WINDOW,
  FTAB_Shell_Widget_Class_Method_MANAGE,
  FTAB_Shell_Widget_Class_Method_MAP_RAISED,
  FTAB_Shell_Widget_Class_Method_RAISE_WINDOW,
  FTAB_Shell_Widget_Class_Method_REALIZE,
  FTAB_Shell_Widget_Class_Method_UNMANAGE,
  FTAB_Shell_Widget_Class_Method_UNREALIZE,
  FTAB_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Widget_Class_Method_ADD_EVENT_HANDLER,
  FTAB_Widget_Class_Method_ADD_GRAB,
  FTAB_Widget_Class_Method_ADD_TAB_GROUP,
  FTAB_Widget_Class_Method_AUGMENT_TRANSLATIONS,
  FTAB_Widget_Class_Method_BUILD_EVENT_MASK,
  FTAB_Widget_Class_Method_DESTROY,
  FTAB_Widget_Class_Method_EXISTS_P,
  FTAB_Widget_Class_Method_GET_VALUES,
  FTAB_Widget_Class_Method_HAS_CALLBACKS,
  FTAB_Widget_Class_Method_INSTALL_ACCELERATORS,
  FTAB_Widget_Class_Method_INSTALL_ALL_ACCELERATORS,
  FTAB_Widget_Class_Method_ISNEW,
  FTAB_Widget_Class_Method_IS_COMPOSITE,
  FTAB_Widget_Class_Method_IS_CONSTRAINT,
  FTAB_Widget_Class_Method_IS_GADGET,
  FTAB_Widget_Class_Method_IS_MANAGED,
  FTAB_Widget_Class_Method_IS_MANAGER,
  FTAB_Widget_Class_Method_IS_PRIMITIVE,
  FTAB_Widget_Class_Method_IS_REALIZED,
  FTAB_Widget_Class_Method_IS_SENSITIVE,
  FTAB_Widget_Class_Method_IS_SHELL,
  FTAB_Widget_Class_Method_MANAGE,
  FTAB_Widget_Class_Method_MAP,
  FTAB_Widget_Class_Method_OVERRIDE_TRANSLATIONS,
  FTAB_Widget_Class_Method_PARENT,
  FTAB_Widget_Class_Method_PRIN1,
  FTAB_Widget_Class_Method_REMOVE_ALL_CALLBACKS,
  FTAB_Widget_Class_Method_REMOVE_GRAB,
  FTAB_Widget_Class_Method_REMOVE_TAB_GROUP,
  FTAB_Widget_Class_Method_SET_CALLBACK,
  FTAB_Widget_Class_Method_SET_EVENT_HANDLER,
  FTAB_Widget_Class_Method_SET_MAPPED_WHEN_MANAGED,
  FTAB_Widget_Class_Method_SET_SENSITIVE,
  FTAB_Widget_Class_Method_SET_VALUES,
  FTAB_Widget_Class_Method_UNINSTALL_TRANSLATIONS,
  FTAB_Widget_Class_Method_UNMANAGE,
  FTAB_Widget_Class_Method_UNMAP,
  FTAB_Widget_Class_Method_UPDATE_DISPLAY,
  FTAB_Widget_Class_Method_WINDOW,
  FTAB_Xm_Bulletin_Board_Widget_Class_Method_ISNEW,
  FTAB_Xm_Cascade_Button_Widget_Class_Method_HIGHLIGHT,
  FTAB_Xm_Command_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Command_Widget_Class_Method_APPEND_VALUE,
  FTAB_Xm_Command_Widget_Class_Method_ERROR,
  FTAB_Xm_Command_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_Command_Widget_Class_Method_GET_HISTORY_ITEMS,
  FTAB_Xm_Command_Widget_Class_Method_ISNEW,
  FTAB_Xm_Command_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Command_Widget_Class_Method_SET_VALUE,
  FTAB_Xm_Drawing_Area_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Drawing_Area_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Drawn_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Drawn_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_DO_SEARCH,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_ISNEW,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Form_Widget_Class_Method_ISNEW,
  FTAB_Xm_List_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_List_Widget_Class_Method_ADD_ITEM_UNSELECTED,
  FTAB_Xm_List_Widget_Class_Method_ADD_ITEM,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ITEM,
  FTAB_Xm_List_Widget_Class_Method_DELETE_POS,
  FTAB_Xm_List_Widget_Class_Method_DESELECT_ALL_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_DESELECT_ITEM,
  FTAB_Xm_List_Widget_Class_Method_DESELECT_POS,
  FTAB_Xm_List_Widget_Class_Method_GET_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_GET_SELECTED_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_ISNEW,
  FTAB_Xm_List_Widget_Class_Method_ITEM_EXISTS,
  FTAB_Xm_List_Widget_Class_Method_SELECT_ITEM,
  FTAB_Xm_List_Widget_Class_Method_SELECT_POS,
  FTAB_Xm_List_Widget_Class_Method_SET_BOTTOM_ITEM,
  FTAB_Xm_List_Widget_Class_Method_SET_BOTTOM_POS,
  FTAB_Xm_List_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_List_Widget_Class_Method_SET_HORIZ_POS,
  FTAB_Xm_List_Widget_Class_Method_SET_ITEM,
  FTAB_Xm_List_Widget_Class_Method_SET_POS,
  FTAB_Xm_Main_Window_Widget_Class_Method_SEP1,
  FTAB_Xm_Main_Window_Widget_Class_Method_SEP2,
  FTAB_Xm_Main_Window_Widget_Class_Method_SET_AREAS,
  FTAB_Xm_Message_Box_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_Message_Box_Widget_Class_Method_ISNEW,
  FTAB_Xm_Row_Column_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Row_Column_Widget_Class_Method_ISNEW,
  FTAB_Xm_Row_Column_Widget_Class_Method_MENU_POSITION,
  FTAB_Xm_Row_Column_Widget_Class_Method_OPTION_BUTTON_GADGET,
  FTAB_Xm_Row_Column_Widget_Class_Method_OPTION_LABEL_GADGET,
  FTAB_Xm_Row_Column_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Scale_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Scale_Widget_Class_Method_GET_VALUE,
  FTAB_Xm_Scale_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Scale_Widget_Class_Method_SET_VALUE,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_GET_VALUE,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Scroll_Bar_Widget_Class_Method_SET_VALUE,
  FTAB_Xm_Scrolled_Window_Widget_Class_Method_SET_AREAS,
  FTAB_Xm_Selection_Box_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Selection_Box_Widget_Class_Method_GET_CHILD,
  FTAB_Xm_Selection_Box_Widget_Class_Method_GET_LIST_ITEMS,
  FTAB_Xm_Selection_Box_Widget_Class_Method_ISNEW,
  FTAB_Xm_Selection_Box_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Text_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Text_Widget_Class_Method_CLEAR_SELECTION,
  FTAB_Xm_Text_Widget_Class_Method_DISABLE_REDISPLAY,
  FTAB_Xm_Text_Widget_Class_Method_ENABLE_REDISPLAY,
  FTAB_Xm_Text_Widget_Class_Method_GET_EDITABLE,
  FTAB_Xm_Text_Widget_Class_Method_GET_INSERTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_GET_LAST_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_GET_MAX_LENGTH,
  FTAB_Xm_Text_Widget_Class_Method_GET_SELECTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_GET_SELECTION,
  FTAB_Xm_Text_Widget_Class_Method_GET_STRING,
  FTAB_Xm_Text_Widget_Class_Method_GET_TOP_CHARACTER,
  FTAB_Xm_Text_Widget_Class_Method_GOTO_LINE,
  FTAB_Xm_Text_Widget_Class_Method_ISNEW,
  FTAB_Xm_Text_Widget_Class_Method_POS_TO_XY,
  FTAB_Xm_Text_Widget_Class_Method_READ_FILE_GOTO_LINE,
  FTAB_Xm_Text_Widget_Class_Method_READ_FILE,
  FTAB_Xm_Text_Widget_Class_Method_REPLACE,
  FTAB_Xm_Text_Widget_Class_Method_SCROLL,
  FTAB_Xm_Text_Widget_Class_Method_SEARCH,
  FTAB_Xm_Text_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Text_Widget_Class_Method_SET_EDITABLE,
  FTAB_Xm_Text_Widget_Class_Method_SET_INSERTION_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_SET_MAX_LENGTH,
  FTAB_Xm_Text_Widget_Class_Method_SET_SELECTION,
  FTAB_Xm_Text_Widget_Class_Method_SET_STRING,
  FTAB_Xm_Text_Widget_Class_Method_SET_TOP_CHARACTER,
  FTAB_Xm_Text_Widget_Class_Method_SHOW_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_WRITE_FILE,
  FTAB_Xm_Text_Widget_Class_Method_XY_TO_POS,
  FTAB_Xm_Toggle_Button_Gadget_Class_Method_GET_STATE,
  FTAB_Xm_Toggle_Button_Gadget_Class_Method_SET_STATE,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_GET_STATE,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Toggle_Button_Widget_Class_Method_SET_STATE,
  FTAB_Widget_Class_Method_SHOW,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Widget_Class_Method_SHOW
  /****************** END: WINTERP METHODS (Motif >= 1.0) *********************/

  /****************** BEGIN: WINTERP METHODS (Motif >= 1.1) *********************/  
#ifdef WINTERP_MOTIF_11
  FTAB_Widget_Class_Method_CALL_ACTION_PROC,
  FTAB_Widget_Class_Method_FORCED_EXPOSE_UPDATE,
  FTAB_Widget_Class_Method_GET_CHILDREN,
  FTAB_Widget_Class_Method_NAME,
  FTAB_Widget_Class_Method_PROCESS_TRAVERSAL,
  FTAB_Xm_Arrow_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Arrow_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Cascade_Button_Gadget_Class_Method_HIGHLIGHT,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_GET_DIR_LIST_ITEMS,
  FTAB_Xm_File_Selection_Box_Widget_Class_Method_GET_FILE_LIST_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_ADD_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ALL_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ITEMS_POS,
  FTAB_Xm_List_Widget_Class_Method_DELETE_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_GET_MATCH_POS,
  FTAB_Xm_List_Widget_Class_Method_GET_SELECTED_POS,
  FTAB_Xm_List_Widget_Class_Method_ITEM_POS,
  FTAB_Xm_List_Widget_Class_Method_PARENT,
  FTAB_Xm_List_Widget_Class_Method_REPLACE_ITEMS_POS,
  FTAB_Xm_List_Widget_Class_Method_REPLACE_ITEMS,
  FTAB_Xm_List_Widget_Class_Method_SET_ADD_MODE,
  FTAB_Xm_Main_Window_Widget_Class_Method_SEP3,
  FTAB_Xm_Push_Button_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Push_Button_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Row_Column_Widget_Class_Method_GET_POSTED_FROM_WIDGET,
  FTAB_Xm_Row_Column_Widget_Class_Method_GET_SUB_MENU_WIDGET,
  FTAB_Xm_Text_Field_Widget_Class_Method_CLEAR_SELECTION,
  FTAB_Xm_Text_Field_Widget_Class_Method_COPY,
  FTAB_Xm_Text_Field_Widget_Class_Method_CUT,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_ADD_MODE,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_BASELINE,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_CURSOR_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_EDITABLE,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_INSERTION_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_LAST_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_MAX_LENGTH,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_SELECTION_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_SELECTION,
  FTAB_Xm_Text_Field_Widget_Class_Method_GET_STRING,
  FTAB_Xm_Text_Field_Widget_Class_Method_INSERT,
  FTAB_Xm_Text_Field_Widget_Class_Method_PASTE,
  FTAB_Xm_Text_Field_Widget_Class_Method_POS_TO_XY,
  FTAB_Xm_Text_Field_Widget_Class_Method_REMOVE,
  FTAB_Xm_Text_Field_Widget_Class_Method_REPLACE,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_ADD_MODE,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_CURSOR_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_EDITABLE,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_HIGHLIGHT,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_INSERTION_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_MAX_LENGTH,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_SELECTION,
  FTAB_Xm_Text_Field_Widget_Class_Method_SET_STRING,
  FTAB_Xm_Text_Field_Widget_Class_Method_SHOW_POSITION,
  FTAB_Xm_Text_Field_Widget_Class_Method_XY_TO_POS,
  FTAB_Xm_Text_Widget_Class_Method_COPY,
  FTAB_Xm_Text_Widget_Class_Method_CUT,
  FTAB_Xm_Text_Widget_Class_Method_GET_ADD_MODE,
  FTAB_Xm_Text_Widget_Class_Method_GET_BASELINE,
  FTAB_Xm_Text_Widget_Class_Method_GET_CURSOR_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_INSERT,
  FTAB_Xm_Text_Widget_Class_Method_PARENT,
  FTAB_Xm_Text_Widget_Class_Method_PASTE,
  FTAB_Xm_Text_Widget_Class_Method_REMOVE,
  FTAB_Xm_Text_Widget_Class_Method_SET_ADD_MODE,
  FTAB_Xm_Text_Widget_Class_Method_SET_CURSOR_POSITION,
  FTAB_Xm_Text_Widget_Class_Method_SET_HIGHLIGHT,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#undef LAST_FUNTAB_POINTER_USED_BY_libWinterp
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Xm_Text_Widget_Class_Method_SET_HIGHLIGHT
#endif				/* WINTERP_MOTIF_11 */
  /****************** END: WINTERP METHODS (Motif >= 1.1) *********************/  

  /****************** BEGIN: WINTERP METHODS (Motif >= 1.2) *********************/  
#ifdef WINTERP_MOTIF_12
  FTAB_Widget_Class_Method_CHANGE_COLOR,
  FTAB_Widget_Class_Method_GET_FOCUS_WIDGET,
  FTAB_Widget_Class_Method_GET_TAB_GROUP,
  FTAB_Widget_Class_Method_IS_TRAVERSABLE,
  FTAB_Widget_Class_Method_GET_VISIBILITY,
  FTAB_Xm_Scrolled_Window_Widget_Class_Method_SCROLL_VISIBLE,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#undef LAST_FUNTAB_POINTER_USED_BY_libWinterp
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Xm_Scrolled_Window_Widget_Class_Method_SCROLL_VISIBLE
#endif /* WINTERP_MOTIF_12 */
  /****************** END: WINTERP METHODS (Motif >= 1.2) *********************/  

  /****************** BEGIN: WINTERP XmGraph METHODS **************************/
#ifdef HP_GRAPH_WIDGET		/* if HP_GRAPH_WIDGET defined */
  FTAB_Xm_Arc_Widget_Class_Method_ISNEW,
  FTAB_Xm_Graph_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xm_Graph_Widget_Class_Method_CENTER_AROUND_WIDGET,
  FTAB_Xm_Graph_Widget_Class_Method_DESTROY_ALL_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_DESTROY_ALL_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_DESTROY_SELECTED_ARCS_OR_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_GET_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_ARCS_BETWEEN_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_GET_ARC_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_GET_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_GET_NODE_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_SELECTED_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_GET_SELECTED_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_INPUT_OVER_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_INSERT_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_ISNEW,
  FTAB_Xm_Graph_Widget_Class_Method_IS_POINT_IN_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_IS_SELECTED_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_IS_SELECTED_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_LAYOUT,
  FTAB_Xm_Graph_Widget_Class_Method_MOVE_ALL,
  FTAB_Xm_Graph_Widget_Class_Method_MOVE_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_MOVE_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_NODE_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_SELECTED_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_NUM_SELECTED_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_RELAY_SUBGRAPH,
  FTAB_Xm_Graph_Widget_Class_Method_REMOVE_ARC_BETWEEN_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_REMOVE_ROOTS,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_SELECT_NODES,
  FTAB_Xm_Graph_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_ARC,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_ARCS,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_NODE,
  FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_NODES,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#undef LAST_FUNTAB_POINTER_USED_BY_libWinterp
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Xm_Graph_Widget_Class_Method_UNSELECT_NODES
#endif				/* HP_GRAPH_WIDGET */
  /****************** END: WINTERP XmGraph METHODS **************************/

  /****************** BEGIN: WINTERP Xtango METHODS **************************/
#ifdef WINTERP_XTANGO_WIDGET
  FTAB_Tango_Bitmap_Image_Class_Method_ISNEW,
  FTAB_Tango_Bitmap_Image_Class_Method_STOREON,
  FTAB_Tango_Bitmap_Image_Class_Method_TX_SHUFFLE,
  FTAB_Tango_Circle_Image_Class_Method_ISNEW,
  FTAB_Tango_Circle_Image_Class_Method_STOREON,
  FTAB_Tango_Composite_Image_Class_Method_ISNEW,
  FTAB_Tango_Composite_Image_Class_Method_STOREON,
  FTAB_Tango_Ellipse_Image_Class_Method_ISNEW,
  FTAB_Tango_Ellipse_Image_Class_Method_STOREON,
  FTAB_Tango_Image_Class_Method_EXISTS_P,
  FTAB_Tango_Image_Class_Method_IMAGE_COPY,
  FTAB_Tango_Image_Class_Method_ISNEW,
  FTAB_Tango_Image_Class_Method_PRIN1,
  FTAB_Tango_Image_Class_Method_TAP_COLOR,
  FTAB_Tango_Image_Class_Method_TAP_FILL,
  FTAB_Tango_Image_Class_Method_TAP_FLASH,
  FTAB_Tango_Image_Class_Method_TAP_JUMP,
  FTAB_Tango_Image_Class_Method_TAP_MOVE,
  FTAB_Tango_Image_Class_Method_TAP_SHOW,
  FTAB_Tango_Image_Class_Method_TAP_TRAVERSE,
  FTAB_Tango_Image_Class_Method_TAP_VIS_TOGGLE,
  FTAB_Tango_Image_Class_Method_TX_COLOR,
  FTAB_Tango_Image_Class_Method_TX_DELAY,
  FTAB_Tango_Image_Class_Method_TX_DELETE,
  FTAB_Tango_Image_Class_Method_TX_FILL,
  FTAB_Tango_Image_Class_Method_TX_LOWER,
  FTAB_Tango_Image_Class_Method_TX_MOVE,
  FTAB_Tango_Image_Class_Method_TX_RAISE,
  FTAB_Tango_Image_Class_Method_TX_REFRESH,
  FTAB_Tango_Image_Class_Method_TX_VISIBLE,
  FTAB_Tango_Image_Class_Method_TX_ZOOM,
  FTAB_Tango_Line_Image_Class_Method_ISNEW,
  FTAB_Tango_Line_Image_Class_Method_STOREON,
  FTAB_Tango_Non_Poly_Image_Class_Method_IMAGE_LOC,
  FTAB_Tango_Non_Poly_Image_Class_Method_TX_RESIZE,
  FTAB_Tango_Poly_Image_Class_Method_TX_GRAB1,
  FTAB_Tango_Poly_Image_Class_Method_TX_GRAB2,
  FTAB_Tango_Poly_Image_Class_Method_TX_GRAB3,
  FTAB_Tango_Poly_Image_Class_Method_TX_GRAB4,
  FTAB_Tango_Poly_Image_Class_Method_TX_GRAB5,
  FTAB_Tango_Poly_Image_Class_Method_TX_GRAB6,
  FTAB_Tango_Poly_Image_Class_Method_TX_GRAB7,
  FTAB_Tango_Poly_Image_Class_Method_TX_RESIZE1,
  FTAB_Tango_Poly_Image_Class_Method_TX_RESIZE2,
  FTAB_Tango_Poly_Image_Class_Method_TX_RESIZE3,
  FTAB_Tango_Poly_Image_Class_Method_TX_RESIZE4,
  FTAB_Tango_Poly_Image_Class_Method_TX_RESIZE5,
  FTAB_Tango_Poly_Image_Class_Method_TX_RESIZE6,
  FTAB_Tango_Poly_Image_Class_Method_TX_RESIZE7,
  FTAB_Tango_Polygon_Image_Class_Method_IMAGE_LOC,
  FTAB_Tango_Polygon_Image_Class_Method_ISNEW,
  FTAB_Tango_Polygon_Image_Class_Method_STOREON,
  FTAB_Tango_Polyline_Image_Class_Method_IMAGE_LOC,
  FTAB_Tango_Polyline_Image_Class_Method_ISNEW,
  FTAB_Tango_Polyline_Image_Class_Method_STOREON,
  FTAB_Tango_Rectangle_Image_Class_Method_ISNEW,
  FTAB_Tango_Rectangle_Image_Class_Method_STOREON,
  FTAB_Tango_Spline_Image_Class_Method_IMAGE_LOC,
  FTAB_Tango_Spline_Image_Class_Method_ISNEW,
  FTAB_Tango_Spline_Image_Class_Method_STOREON,
  FTAB_Tango_Text_Image_Class_Method_ISNEW,
  FTAB_Tango_Text_Image_Class_Method_STOREON,
  FTAB_Xtango_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Xtango_Widget_Class_Method_BEGIN_DRAWING,
  FTAB_Xtango_Widget_Class_Method_COLORS_STOREON,
  FTAB_Xtango_Widget_Class_Method_COPY_TO_2D_BITMAP_ARRAY,
  FTAB_Xtango_Widget_Class_Method_GET_EVENT_COORD,
  FTAB_Xtango_Widget_Class_Method_GET_EVENT_IMAGE,
  FTAB_Xtango_Widget_Class_Method_GET_IMAGES,
  FTAB_Xtango_Widget_Class_Method_INPUT_COORD,
  FTAB_Xtango_Widget_Class_Method_INPUT_IMAGE,
  FTAB_Xtango_Widget_Class_Method_INQ_COORD,
  FTAB_Xtango_Widget_Class_Method_ISNEW,
  FTAB_Xtango_Widget_Class_Method_LOAD_COLOR,
  FTAB_Xtango_Widget_Class_Method_MONO_PATTERN_REPRESENTATION,
  FTAB_Xtango_Widget_Class_Method_PAN,
  FTAB_Xtango_Widget_Class_Method_REFRESH,
  FTAB_Xtango_Widget_Class_Method_SET_ANIMATION_EVENT_PROCESSING,
  FTAB_Xtango_Widget_Class_Method_SET_BGCOLOR,
  FTAB_Xtango_Widget_Class_Method_SET_CALLBACK,
  FTAB_Xtango_Widget_Class_Method_SET_COORD,
  FTAB_Xtango_Widget_Class_Method_SET_DEBUG,
  FTAB_Xtango_Widget_Class_Method_SET_DELAY,
  FTAB_Xtango_Widget_Class_Method_ZOOM,
  FTAB_Tango_GIF_Image_Class_Method_ISNEW,
  FTAB_Tango_Image_Class_Method_SHOW,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#undef LAST_FUNTAB_POINTER_USED_BY_libWinterp
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Tango_Image_Class_Method_SHOW
#endif				/* WINTERP_XTANGO_WIDGET */
  /****************** END: WINTERP Xtango METHODS **************************/

/****************** BEGIN: WINTERP SgDropPocketWidget METHODS **********/
#ifdef SGI_DROP_POCKET_WIDGET	/* only for Irix 5.1 and IndigoMagic desktop */
  FTAB_Sg_Drop_Pocket_Widget_Class_Method_ADD_CALLBACK,
  FTAB_Sg_Drop_Pocket_Widget_Class_Method_SET_CALLBACK,
  FTAB_Sg_Finder_Widget_Class_Method_ADD_HISTORY_ITEM,
  FTAB_Sg_Finder_Widget_Class_Method_CLEAR_HISTORY,
  FTAB_Sg_Finder_Widget_Class_Method_SET_STRING,
  FTAB_Sg_Finder_Widget_Class_Method_GET_STRING,
  FTAB_Sg_Finder_Widget_Class_Method_GET_CHILD,

  /* Constant needed by Wfu_Funtab_Sanity_Check() */
#undef LAST_FUNTAB_POINTER_USED_BY_libWinterp
#define LAST_FUNTAB_POINTER_USED_BY_libWinterp FTAB_Sg_Finder_Widget_Class_Method_GET_CHILD
#endif /* SGI_DROP_POCKET_WIDGET */
/****************** END: WINTERP SgDropPocketWidget METHODS ************/

  /******************************************************************************/
  /************************ END: WINTERP PRIMITIVES *****************************/
  /******************************************************************************/

  /*
   * To embed additional C-implemented primitives in WINTERP, you must
   * add new primitive function declarations in file app_fundecl.h,
   * and add corresponding FTAB_* entries in file app_funidx.h, which
   * is included here.
   *
   * See comments preceding the w_funtab.c:funtab[] declaration for more
   * info on the files app_fundecl.h, app_funextn.h, and app_funidx.h .
   *
   * If you want to place your app_funextn.h file outside of 
   * the WINTERP source tree, just modify INCLUDES in the Makefile
   * such that the directory containing app_funextn.h precedes '-I.'
   */
#include <app_funidx.h>

  /*
   * This allows all entries above to terminate with  ',' without regards
   * to the special case for the last element.
   */
  FTAB_BOGUS_LAST_ELEMENT	
  };
