.\" $Header: /users/npm/src/widgit/doc/RCS/wl.man,v 2.6 1994/07/23 23:20:41 npm Exp $
.\" Copyright (C) 1994, Enterprise Integration Technologies Corp. and Niels Mayer.
.\" WINTERP 1.15-1.99, Copyright (c) 1993, Niels P. Mayer.
.\" WINTERP 1.0-1.14, Copyright (c) 1989-1992 Hewlett-Packard Co. and Niels Mayer.
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Enterprise Integration Technologies,
.\" Hewlett-Packard Company, or Niels Mayer not be used in advertising or
.\" publicity pertaining to distribution of the software without specific,
.\" written prior permission. Enterprise Integration Technologies, Hewlett-Packard
.\" Company, and Niels Mayer makes no representations about the suitability of
.\" this software for any purpose.  It is provided "as is" without express or
.\" implied warranty.
.\" 
.\" ENTERPRISE INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY AND NIELS MAYER
.\" DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL ENTERPRISE
.\" INTEGRATION TECHNOLOGIES, HEWLETT-PACKARD COMPANY OR NIELS MAYER BE LIABLE
.\" FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
.\" RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
.\" CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
.\" CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"  
.TH WL 1 "June 6, 1994" "X11r6 contrib"
.SH NAME
WL - Winterp-Lisp client for communicating with WINTERP UN*X Domain Eval-Server.
.SH SYNOPSIS
.B wl
[\fB\-f <socket-filepath>\fP] 
[\fB\<s-expr>\fP]
.SH DESCRIPTION

\-\-\->> FOR DETAILS ON WINTERP SEE /usr/local/winterp/doc/winterp.doc <<\-\-\-
.PP
The WINTERP client program 
.I wl
(stands for Winterp-Lisp) sends the
XLISP expression given on its command line to the WINTERP server.
.I wl
hangs until WINTERP has evaluated the s\-expression given on
.I wl's
command-line. After the s\-expression is successfully
evaluated by WINTERP, 
.I wl
prints to stdout the results of the evaluation,
and sets exit status 0. If an evaluation error occurs, an error messsage is
output to stderr, and exit status gets set to 127.
.PP
By default, WINTERP compiles with the Unix-Domain eval server enabled. If
for some reason your machine or OS does not support Unix Domain Sockets,
you may turn off compilation of these features. Do this by (1) removing
"\-DWINTERP_WANT_UNIX_SERVER" in the associated
<winterp\-top\-dir>/src\-server/Makefile.* makefile; or (2) make equivalent
change to the Imakefile or its generated Makefile in that directory; or (3)
edit <winterp\-top\-dir>/src\-server/config.h...
.PP
The Unix Domain Socket can also be enabled/disabled via X resource
<<Winterp.enableUnixServer:>>, or via command\-line arguments
<<\-no_unix_server>> or <<\-enable_unix_server>>. 
.PP
.I wl
will "hang" waiting for WINTERP to finish the evaluation.
When the evaluation completes, 
.I wl
prints the results of the evaluation to
stdout, and returns exit status 0.  If an error occurs in evaluation, an
exit status of 128 is returned and the following is printed to stderr: "wl:
an evaluation error occured in WINTERP server."  Finally, if some other
error occurs, e.g. network error, unable to bind socket, etc, then exit
status of 1 is returned and an eror message will appear on stderr.
.PP
If evaluation via 
.I wl
causes an error and *BREAKENABLE* is set
(including by selecting "Error Break-Loop" or "Error Trace-Back"
in the "WINTERP Control Panel), then 
.I wl
will hang until the
break-loop exits, typically because the user has invoked functions
'clean\-up', 'top\-level', or 'continue', or typed Control\-C or
Control\-D into WINTERP's controlling terminal.
.PP
Example: invoking the following in a UN*X command shell:
.PP
		wl '(load "rc\-shell")'
.PP
while there is a WINTERP running with a unix domain socket enable, will
cause WINTERP to load the file "rc\-shell" and pop up the widgetry
associated with loading that file.
.SH OPTIONS

.BI [\-f <socket\-filepath>] 

The optional <socket\-filepath> argument sets the pathname for the Unix
Domain Socket eval\-server.  By default, <socket\-filepath> is
"/tmp/.winterp_serv", you may want to specify a different <socket\-filepath>
if multiple 
.I winterp
 applications are running. Alternately, you may want
to hide the Unix Domain Socket from other users if you are on a multi-user
machine. Note that you may specify <socket\-filepath> via environment
variable WINTERP_UNIX_SOCKET_FILEPATH. The environment variable sets
<socket\-filepath> for both 
.I wl
and 
.I winterp
.

.BI [<s\-expr>] 

The <s\-expr> argument is a single Lisp s\-expression to be sent to WINTERP's
Lisp listener. If no <s\-expr> argument is given, 
.I wl
sends an EOF
(==Control\-D) to XLISP, which causes WINTERP to terminate. Note that the
<s\-expr> must be quoted with ['] so that the shell does not attempt to
interpret the parentheses as shell commands.

.SH AVAILABILITY:
You may obtain the latest released version of the WINTERP source,
documentation, and examples via anonymous ftp from internet host ftp.x.org
in directory /contrib/devel_tools, file winterp\-2.xx.tar.gz, where 'xx'
represents the revision number. Directory /contrib/devel_tools/winterp
contains slides, papers, further documentation, contributed code, etc.
.PP
An automated reply indicating the locations and status of the latest
WINTERP source may be obtained by sending an e\-mail message to
winterp\-source@netcom.com.

.SH CONTACTING OTHER USERS
winterp@netcom.com is the mailing list for WINTERP-related announcements
and discussions. To get added/removed from the list, send mail to
winterp\-request@netcom.com. Please do not send junk mail or
subscribe/unsubscribe messages to the mailing list winterp@netcom.com.
.PP
For discussions about XLISP, see the USENET newsgroup comp.lang.lisp.x.
.SH SEE ALSO
winterp(1), wl\-tcpip(1), http://www.eit.com/software/winterp/winterp.html .
.SH FILES
/tmp/.winterp_serv (default Unix domain socket for server);

$WINTERP_UNIX_SOCKET_FILEPATH (environment variable setting Unix domain socket).
.SH AUTHOR
Niels Mayer (mayer@netcom.com) (http://www.eit.com/people/mayer.html)
