
;;;; This function creates a panel which displays a node and
;;;;  provides hypermedia capabilities.

(in-package "PT")

(defun generate-hyper-panel ()
  (let* ((pname (cons "new-hip" (cons (string (gensym "hyper-panel-")) "panel")))
	 (cw (eval
	      `(defpanel ,pname (node)
		 (name "hyperpanel")
		 (title "hyper-panel")
		 (dynamic-variables node-name hw widget) 
		 (static-variables hyper-widgets locked rcpt active)
		 (base-size '(700 330))
		 (size '(700 330))
		 (gm 'anchor-gm)  
		 (dialogs
		  ((preferences ("new-hip" "preferences" . "dialog"))))
		 (menu-bar
		  ((pref
		   ("Preferences"
		    (p1 ("Preferences"
			 (setf #!*current-preferences* (call #!preferences :d #!*current-preferences*))))
		    (p2 ("Print Preferences"
			 (print #!*current-preferences*)))
		    )
		   )
		  (author-menu
		    ("Author"
		     (a0 ("Select Link Marker"
			 (progn
			   (unselect-current-marker #!hw)
			   (let ((lm (get-current-link-marker #!hw)))
			     (if lm
				 (select-link-marker #!hw lm)
			       (announce-error "No link marker at current position"))))))
		     (a1 ("Start Link"
			 ;; if there's no link in progress, start a
			 ;; new one:
			 (if (null #!*link-in-progress*)
			     (setf #!*link-in-progress*
				   (start-link #!node
					       (get-mark-region	#!hw)))
			   ;; else finish off the current one:
			   (let ((link (end-link #!*link-in-progress*
						 #!node
						 (get-mark-region #!hw))))
			     (when link
				   (edit link)
				   (setf #!*link-in-progress* nil))))))
		     (a2 ("Start Link from Selected Marker"
			  (if (get-current-link-marker #!hw)
			      (if (null #!*link-in-progress*)
				  (setf #!*link-in-progress*
					(start-link #!node
						    (get-current-link-marker #!hw)))
				(let ((link (end-link #!*link-in-progress*
						      #!node
						      (get-current-link-marker #!hw))))
				  (when link
					(edit link)
					(setf #!*link-in-progress* nil))))
			    (announce-error "No link marker at current position"))))
		     (a3 ("Edit Link"
			 (let ((link (choose-link-from #!node :op 'edit)))
			   (when link (Edit link)))))
		     (a3b ("Delete Link"
			 (let ((link (choose-link-from #!node :op 'delete)))
			   (when link (do-delete link)))))
		    ;; (a4 ("Move Link"))
		     (a5 ("Edit Node Attrs"
			 (edit #!node)))  ;; including perms?
		     (a5b ("Edit Marker Attrs"
			  (let ((m (get-current-marker #!hw)))
			    (when m (edit m)))))
		     (a6 ("Delete Node"
			 (do-delete #!node)))
		     (a7 ("Save to File"
			  (save #!node)))
		     )
		    )
		   ("Browse"
		    (b1 ("Hide Markers"
			 (toggle-marker-display #!hw)))
		    (b2 ("Create Bookmark"
			 (if (get-mark-region #!hw)
			     (create-bookmark #!hw))))
		    (b3 ("Delete Bookmark"
			 (let ((b (get-current-bookmark #!hw)))
			     (when b (wipe-out b)))))
		    (b4 ("Select From All Links"
			 (let ((link (choose-link-from #!node)))
			   (when link
				 (if (member link (links-from #!node))
				     (follow link :dir :forw)
				   (follow link :dir :back))))))
		    (b5 ("Select from Paths"
			 (let ((paths (paths #!*current-hyperdoc*)))
			   (if paths
			       (let ((p (choose-path paths)))
				 (when p (enter-path p)))
			     (announce-error "No paths defined on current hyperdocument")))))
		    (b6 ("Exit Path" (exit-path)))
		    )
		   ))
		 (children  
		  ((cg 
		    (make-collection-gadget
		      :gm 'packed-gm
		      :border-type nil
		      :border-width 0
		      :border-attributes '(:background nil :foreground nil)
		      :geom-spec '(0.02 0.03 .87 .85
			      ;; :anchor (:top :left :bottom :right)
			      :arrow (:horiz :vert))
		      :children 
		      ;; create one of each type of hyper-widget
		      '((text-wid  
			 (make-hyper-text-widget 			
			  :name "Hypertext node display"
			  :geom-spec :fill
			  :font (make-font :name  "8x13")))
			(table-wid
			 (make-hyper-table-widget
			  :name "Hypertable node display"
			  :col-titles '("Col 1" "Col 2" "Col 3")
			  :row-titles nil
			  :row-heights 20
			  :geom-spec :fill))
			(image-wid
			 (make-hyper-image-widget
			  :name "Hyperimage node display"
			  :geom-spec :fill
			  ))
			(coll-wid
			 (make-hyper-collection-widget
			  :name "Node record display"
			  :geom-spec :fill))
			(video-wid
			 (make-hyper-video-widget
			  :name "Video node controls"
			  :geom-spec :fill))
			)))
		   ;; and another collection for the buttons:
		   (browse-buttons
		    (make-collection-gadget
		     :gm 'anchor-gm
		     :geom-spec '(.9 .1 .1 .8 
				      :anchor (:top 5 :right 2 :bottom 5)
				      :arrow (:horiz :vert))
		     :children
		     '(
		       (lock-panel-button
			(make-gray-button
			 :value *unlocked-image*
			 :geom-spec '(0 0 1 .2
					:arrow (:horiz :vert))
			 :release-func '(if #!locked (unlock-panel #!po)
					  (lock-panel #!po))))
		       (follow-default-button
			(make-gray-button
			 :value *default-link-image*
			 :geom-spec '(0 .2 1 .2
					:arrow (:horiz :vert))
;;			 :geom-spec '(:top :top-pad 5)
			 :release-func '(progn
					  (make-last (if (typep #!po 'form)
							 (parent #!po)
						       #!po))
					  (follow-default-link #!hw))))
		       (select-link-button
			(make-gray-button
			 :value *select-link-image*
			 :geom-spec '(0 .4 1 .2
					:arrow (:horiz :vert))
;;			 :geom-spec '(:top :top-pad 5)
			 :release-func '(show-link-menu #!hw)))
		       (return-button 
			(make-gray-button
			 :value *return-arrow-image* 
			 :geom-spec '(0 .6 1 .2
					:arrow (:horiz :vert))
;;			 :geom-spec '(:top :top-pad 5)
			 :release-func '(return-from-node #!hw)))
		       (close-button 
			(make-gray-button
			 :value *close-node-image* 
			 :geom-spec '(0 .8 1 .2
					:arrow (:horiz :vert))
;;			 :geom-spec '(:top :top-pad 5)
			 :release-func `(user-close-node #!node)))
		       )))
		   ;; and one more collection for path info and commands:
		   (path-info
		    (make-collection-gadget
		     :gm 'anchor-gm
		     :geom-spec '(.25 .9 .65 .08 :arrow (:horiz :vert) 
				              :anchor (:bottom 4))
		     :children
		     '((current-path
			(make-text-gadget :label "Current Path: "
					  :label-type :left
					  :geom-spec '(0 0 .6 1 :arrow
							 (:horiz :vert))))
		       (arrow-buttons
			(make-collection-gadget
			 :gm 'anchor-gm
			 :geom-spec '(.65 0 .3 1 :arrow (:horiz :vert))
			 :base-height 30
			 :children 
			 '((prev-button
			    (make-gray-button :geom-spec '(0 0 .48 1
							      :arrow (:horiz :vert))
					      :base-height 25
					      :value "Prev"
					      :release-func
					      '(goto-prev #!node)))
			   (next-button
			    (make-gray-button :geom-spec '(.5 0 .48 1
							      :arrow (:horiz :vert))
					      :base-height 25
					      :value "Next"
					      :release-func
					      '(goto-next #!node)))
			   )))
		       )))
		   ))
		 (init-code 
		  (progn
		    (setup-panel-for-new-node #!po #!node)
		    (setf #!active t)
		    ))
		 (setup-code
		  (progn
		    (set-background-recursively self *panel-bg*)
		    (setf (background #!image-wid) "white"
			  (foreground #!image-wid) "black")
		    (setf #!hyper-widgets (children #!cg))
		    ;; start with a text-widget exposed
		    (setf #!hw #!text-wid)
		    
		    ;; make sure panel attributes change when it gets
		    ;; a new node:
		    (bind (name #!po) #!node-name)
		    (bind (title #!po) #!node-name)
		    (bind (icon-name #!po) #!node-name)

		    ;; get a handle on the actual widget:
		    (blet #!widget 
			  :var ((hw #!hw))
			  (and hw (widget hw)))

		    ;; This trigger ensures that changing hw will cause
		    ;; the appropriate widget to be exposed:
		    (set-trigger #!hw
		     `(progn
			(dolist (w ',#!hyper-widgets) (conceal w))
			(when (value ',#?hw)
			      (expose (value ',#?hw)))
			))

		    ;; Update menu items as appropriate:
		    (blet (dimmed #!author-menu)
			  :var ((m #!*user-mode*))
			  (eq m :browse))
		    (blet (dimmed #!a0) ;; select-link-marker
			  :var ((ms (markers-shown? #!hw)))
			  (not ms))
		;    (blet (dimmed #!a7)  ;; save to file
		;	  :var ((mod (modified? #!node)))
		;	  (not mod))
		    (blet (center #!b1)
			  :var ((ms (markers-shown? #!hw)))
			  (if ms "Hide Markers"
			    "Show Markers"))
		    (blet (dimmed #!b6) ;; exit path
			  :var ((cp #!*current-path*@(current-tool)))
			  (not cp))
		    (blet (center #!a1) ;; start/end link
			  :var ((l #!*link-in-progress*@(current-tool)))
			  (if l 
			      "End Link" 
			    "Start Link"))
		    (blet (center #!a2) ;; start/end link at marker
			  :var ((l #!*link-in-progress*@(current-tool)))
			  (if l 
			      "End Link at Marker" 
			    "Start Link at Marker"))

		    ;;  Update buttons, too:
		    (blet (dimmed #!return-button)
			  :var ((o (opener #!node)))
			  ;; return only makes sense if we got here
			  ;; via some link:
			  (not o)) 
		    (blet (dimmed #!return-button)
			  :var ((n #!node))
			  ;; return only makes sense if we got here
			  ;; via some link:
			  (not (opener n)))
		    (blet (value #!lock-panel-button)
			  :var ((l #!locked))
			  (if l *locked-image* *unlocked-image*))
		    ;;  Lots of things change according to whether
		    ;;  we're following a path or not:
		    (blet (dimmed #!follow-default-button)
			  :var ((cp #!*current-path*))
			  cp)
		    (blet (dimmed #!select-link-button)
			  :var ((cp #!*current-path*))
			  cp)
		    (blet (value #!current-path)
			  :var ((cp #!*current-path*))
			  (if cp (string (name cp)) ""))
		    (blet (dimmed #!prev-button)
			  :var ((cp #!*current-path*)
				(n #!node))
			  (or (not cp) (eq n (start-node cp))))
		    (blet (dimmed #!next-button)
			  :var ((cp #!*current-path*)
				(n #!node))
			  (or (not cp) (eq n (end-node cp))))
		    )
		  )
		 (exit-code
		  (progn
		    ;; if we're displaying video, make sure the video
		    ;; panel goes away too:
		    (if (and (current-p self)
			     (eq (type #!node@#!po) 'video)
			     (exposed-p #!video@(current-tool)))
			(ret #!video@(current-tool)))
		    ;; keep track of which panels are active
		    (setf #!active nil)
		  )
		 ))
	      )))
    cw))

#|  ;; This stuff was used to control dimming of selection buttons, but
    ;; it's really too much of a pain to define for all media:
		    ;; for each of the underlying widgets, set up
		    ;; propagation of current region values:
		    (blet (current-region #!text-wid)
			  :var ((mr (mark-row (widget #!text-wid)))
				(mc (mark-column (widget #!text-wid)))
				(r (row (widget #!text-wid)))
				(c (column (widget #!text-wid))))
			  (and mr mc r c
			       (list (cons r c) (cons mr mc))))
		    (blet (current-region #!table-wid)
			  :var ((ind (current-indices (widget #!table-wid))))
			  :with ((tw #?table-wid))
			  (get-mark-region (value tw)))
		    (blet (current-region #!image-wid)
			  :var ((w (width #!image-wid))
				(h (height #!image-wid)))
			  :with ((iw #!image-wid))
			  (get-mark-region iw))
		    
|#
