;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|
==================================================================
Change log:
    2/20/92 Andrew Mickish - Moved make-package call to Garnet-Loader
    2/18/92 Brad Myers - add gilt-gadget-utils
    3/26/91 Pervin - Load compiled files in Lucid.
    3/22/91 Ed Pervin - Added test to not load gadgets if compiling
	 	all of Garnet
    3/14/91 Andrew Mickish - Added Motif Version
   12/10/90 Brad Myers - created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(format t "Compiling Gilt...~%")

;; check first to see if pathname variable is set
(unless (boundp 'Garnet-Gilt-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Gilt-PathName before loading this file."))

;; Only loads these file when not compiling all of Garnet.
(dolist (pair '((:text-buttons "text-buttons-loader")
		(:x-buttons "x-buttons-loader")
		(:radio-buttons "radio-buttons-loader")
		(:labeled-box "labeled-box-loader")
		(:scrolling-labeled-box "scrolling-labeled-box-loader")
		(:error-gadget "error-gadget-loader")
		(:v-slider "v-slider-loader")
		(:prop-sheet-win "prop-sheet-win-loader")
		(:multi-selection "multi-selection-loader")
		(:motif-text-buttons "motif-text-buttons-loader")
		(:motif-check-buttons "motif-check-buttons-loader")
		(:motif-radio-buttons "motif-radio-buttons-loader")
		(:motif-v-scroll-bar "motif-v-scroll-loader")
		(:motif-h-scroll-bar "motif-h-scroll-loader")
		(:motif-slider "motif-slider-loader")
		(:motif-menu "motif-menu-loader")
		(:motif-gauge "motif-gauge-loader")
		(:motif-scrolling-labeled-box "motif-scrolling-labeled-box-loader")
		(:motif-prop-sheet-win "motif-prop-sheet-win-loader")))
    (unless (get :garnet-modules (car pair))
      (load (merge-pathnames (cadr pair)
			     #+cmu "gadgets:"
			     #+(not cmu) user::Garnet-Gadgets-PathName)
	    :verbose T)))


#+allegroV3.1
(user::gc t)

(defvar gilt-files '(
		     "gilt-string-edit"
		     "gilt-functions"
		     "gilt-font-imp" "gilt-font-props" "motif-gilt-font-props"
		     "gilt-gadget-utils"
		     "gilt-gadgets" "motif-gilt-gadgets"
		     "gilt"
		     "gilt-save" "motif-gilt-save"
		     "gilt-read" "motif-gilt-read"
		     "color-imp" "color-props" "motif-color-props"
		     "line-imp" "line-props" "motif-line-props"
		     "fill-imp" "fill-props" "motif-fill-props"
		     "align-imp" "align-props" "motif-align-props"
		     ))

(dolist (file gilt-files)
  (compile-file (merge-pathnames file
				 #+cmu "gilt-src:"
				 #+(not cmu) user::Garnet-Gilt-Src))
  (load (merge-pathnames file user::Garnet-Gilt-Src))
  #+allegroV3.1(user::gc t))

(setf (get :garnet-modules :gilt) t)
(setf (get :garnet-modules :gilt-functions) t)

(format t "... Done Compiling Gilt~%")
