;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: KR; Base: 10 -*-


(in-package "KR")


(defun i-depend-on (object slot)
  (let ((formula (get-value object slot)))
    (if (formula-p formula)
      (let ((dependencies nil))
	(do-one-or-list (schema (a-formula-depends-on formula))
	  (let ((slots (schema-slots schema)))
	    (iterate-slot-value (schema T T T)
	      (if (not (eq value *no-value*))
		(do-one-or-list (f (last-slot-dependents slots position))
		  (if (eq f formula)
		    (push (cons schema slot) dependencies)))))))
	dependencies))))
