;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-


(in-package 'user)

#+lucid
(user::change-memory-management :growth-limit 400)

#+lucid
(proclaim '(optimize (speed 3) (safety 0)(space 0) (compilation-speed 0)))
;#+excl
;(proclaim '(optimize (speed 3) (safety 1)(space 0) (compilation-speed 0)))

#+excl
(unless (excl::scheduler-running-p)
  (mp:start-scheduler))

;; make sure we set up for maximum speed except for asynchronous checks.
;#+excl
;(setq compiler::generate-interrupt-checks-switch
;      #'(lambda (safety space speed)
;	  (declare (ignore safety space speed))
;	  T))

;; directory for the top level directory of Express Windows.

(defvar *Default-EW-Pathname*
	#+symbolics #P"e:>ew>"
	#+unix (pathname "/usr2/ew/"))

;; directory for the Code of Expression Windows - both binary and source if you have it.

(defvar *Default-EW-Code-Pathname*
	#+symbolics #P"e:>ew>code>"
	#+unix (pathname "/usr2/ew/code/"))


;; directory for the Doc of Expression Windows - both binary and source if you have it.

(defvar *Default-EW-DOC-Pathname*
	#+symbolics #P"e:>ew>doc>"
	#+unix (pathname "/usr2/ew/doc/"))


;; directory for the CLX source and binaries provided free with Express Windows.

(defvar *Default-EW-CLX-Pathname*
	#+symbolics #P"e:>ew>code>clx-11-3>"
	#+unix (pathname "/usr2/ew/clx/"))

(defvar *Default-EW-Demos-Pathname*
	#+symbolics #P"e:>ew>demos>"
	#+unix (pathname "/usr2/ew/demos/"))


;; directory for the CLOS source and binaries provided free with Express Windows.

(defvar *Default-EW-CLOS-Pathname*
	#+symbolics #P"e:>ew>code>clos>"
	#+unix (pathname "/usr2/ew/clos/"))


#+allegro
(defun cd (directory) (excl:chdir directory))
#+allegro
(defun pwd () (excl:current-directory))

#-excl
(cond ((user::y-or-n-p "Load CLX?")
       (load (make-pathname :name "defsystem" :type "lisp"
			    :defaults *Default-EW-CLX-Pathname*))
       (let ((dir (user::pwd)))
	 (user::cd *Default-EW-CLX-Pathname*)
	 (user::load-clx)
	 (user::cd dir)))
      ((user::y-or-n-p "Compile CLX?")
       (load (make-pathname :name "defsystem" :type "lisp"
			    :defaults *Default-EW-CLX-Pathname*))
       (let ((dir (user::pwd)))
	 (user::cd *Default-EW-CLX-Pathname*)
	 (user::compile-clx)
	 (user::cd dir))))

#+excl
(cond ((user::y-or-n-p "Load CLX?")
       (load "/usr2/ew/clx/excldefsys.lisp")
       (let ((dir (user::pwd)))
	 (user::cd "/usr2/ew/clx/")
	 (funcall (intern "LOAD-CLX" (find-package "XLIB")))
	 (user::cd dir)))
      ((user::y-or-n-p "Compile CLX?")
       (load "/usr2/ew/clx/excldefsys.lisp")
       (let ((dir (user::pwd)))
	 (user::cd "/usr2/ew/clx/")
	 (funcall (intern "COMPILE-CLX" (find-package "XLIB")))
	 (user::cd dir))))



(cond ((user::y-or-n-p "Load CLOS?")
       (load (make-pathname :name "defsys" :type "lisp" :defaults *Default-EW-CLOS-Pathname*))
       (funcall (intern "LOAD-PCL" (find-package "PCL"))))
      ((user::y-or-n-p "Compile CLOS?")
       (load (make-pathname :name "defsys" :type "lisp" :defaults *Default-EW-CLOS-Pathname*))
       (funcall (intern "COMPILE-PCL" (find-package "PCL")))))


(load (make-pathname :name "system" :type "lisp" :defaults *Default-EW-Code-Pathname*))

(cond ((user::y-or-n-p "Load Express Windows?")
       (user::load-ew))
      ((user::y-or-n-p "Compile Express Windows?")
       (user::compile-ew)))

;; type (user::compile-ew) to recompile system.

;; put back safety to at least 1.
;(proclaim '(optimize (speed 3) (safety 1)(space 0) (compilation-speed 0)))
