;; -*- Mode: LISP; Syntax: Common-lisp; Package: Express-windows; Base: 10 -*-

;;; This file is part of Express Windows.

;;; Express Windows is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY.  No author or distributor
;;; accepts responsibility to anyone for the consequences of using it
;;; or for whether it serves any particular purpose or works at all,
;;; unless he says so in writing.  Refer to the Express Windows General Public
;;; License for full details.

;;; Everyone is granted permission to copy, modify and redistribute
;;; Express Windows, but only under the conditions described in the
;;; Express Windows General Public License.   A copy of this license is
;;; supposed to have been given to you along with Express Windows so you
;;; can know your rights and responsibilities.  It should be in a
;;; file named COPYING.  Among other things, the copyright notice
;;; and this notice must be preserved on all copies.  */


;;; ****************************************************************************************
;;; ****************************************************************************************
;;; ********** (c) Copyright 1988, 1989, 1990 Liszt Programming Inc. All Rights Reserved *********
;;; ****************************************************************************************
;;; ****************************************************************************************

;;; ****************************************************************************************
;;; ****************************************************************************************
;;; **************** Written by Dr. Andrew L. Ressler **************************************
;;; ****************************************************************************************
;;; ****************************************************************************************



(in-package 'express-windows :nicknames '(ew))


(defvar *Common-Lisp-Symbols-To-Shadow*
	'(lisp:clear-input
	   lisp:format
	   lisp:fresh-line
	   lisp:listen
	   lisp:peek-char
	   lisp:pi
	   lisp:prin1 lisp:princ lisp:print
	   lisp:read lisp:read-char lisp:read-char-no-hang
	   lisp:read-line lisp:read-preserving-whitespace
	   lisp:terpri
	   lisp:unread-char
	   lisp:write lisp:write-char lisp:write-line lisp:write-string
	   lisp:y-or-n-p lisp:yes-or-no-p
	   lisp:streamp
	   lisp:input-stream-p lisp:output-stream-p
	   lisp:stream-element-type
	   lisp:close
	   lisp:force-output
	   lisp:type-of lisp:typep
	   ))

(shadow *Common-Lisp-Symbols-To-Shadow* 'express-windows)


#+ew-clos
(import '(pcl::with-slots pcl::defclass pcl::defmethod pcl::make-instance pcl::print-object)
	'express-windows)


#+X
(export '(xfonts::init-fonts xfonts::9x15
			     xfonts::get-font-from-style xfonts::merge-character-styles)
	'xfonts)



(export '(
	  ;; symbols that replace common lisp functions.
	  clear-input
	  format fresh-line
	  listen
	  peek-char
	  prin1 princ print
	  read
	  read-char
	  read-char-no-hang
	  read-line
	  read-preserving-whitespace
	  terpri
	  unread-char
	  write
	  write-char
	  write-line
	  write-string
	  y-or-n-p yes-or-no-p

	  ;; io functions
	  peek-any-char
	  prompt-and-read
	  read-any-char
	  read-any-char-no-hang
	  unread-any-char
	  with-input-editing
	  with-input-editing-options
	  

	  pi
	  *90-degrees* *180-degrees* *270-degrees* *360-degrees*

	  ;; symbols having to do with command processor and commands.
	  build-command
	  command
	  command-in-command-table-p
	  *Command-Table*
	  *Default-Blank-Line-Mode*
	  define-command
	  delete-command-table
	  execute-command
	  find-command-table
	  *Full-Command-Prompt*
	  make-command-table
	  undefine-command

	  ;; basic symbols
	  query
	  query-from-string
	  query-values
	  query-values-choose-from-sequence
	  query-values-command-button
	  memo-write-string
	  query-values-into-list
	  querying-values
	  compare-char-for-query
	  describe-type
	  define-mouse-action
	  define-mouse-command
	  define-type-transform
	  define-type

	  display-as

	  erase-displayed-presentation

	  menu-choose
	  menu-choose-from-set

	  peek-char-for-query
	  parse-error
	  display
	  presentation-blip-case
	  
	  presentation-type-name
	  prompt-and-query
	  read-char-for-query
	  read-location
	  read-standard-token
	  standard-query-values-displayer
	  unread-char-for-query

	  replace-input-editor-string

	  with-output-recording-disabled
	  with-output-to-presentation-recording-string
	  with-presentations-disabled
	  with-presentations-enabled
	  with-presentation-input-context
	  with-type-decoded


	  *Activation-Chars*
	  *Token-Delimiter-Chars*

	  with-activation-chars
	  with-token-delimiters


	  ;; completion stuff
	  complete-from-sequence
	  complete-input
	  completing-from-suggestions
	  default-complete-function
	  *Standard-Completion-Delimiters*
	  suggest

	  ;; presentation type symbols
	  alist-member
	  alist-subset
	  boolean
	  ;; buffer what is a lucid buffer
	  class
	  ;; character-face-or-style
	  character-family
	  character-style
	  expression
	  font
	  form
	  host
	  ;; integer
	  inverted-boolean
	  keyword
	  member-sequence
	  no-type
	  ;; number
	  ;; null-or-type
	  ;; sequence
	  sequence-enumerated
	  subset
	  time-interval
	  time-interval-60ths
	  token-or-type
	  universal-time

	  ;; presentation semi-internal stuff.
	  call-presentation-menu
	  get-presentations-boundaries
	  highlight-presentation
	  insert-presentations-with-offset
	  insert-presentations



	  ;; incremental redisplay
	  run-memo
	  independently-redisplayable-format
	  program-redisplay
	  memo-format
	  memo-display
	  memo
	  memoize


	  ;; framework stuff.
	  clear-all
	  command-error
	  configuration
	  command-loop-eval-function
	  command-loop-print-function
	  default-command-top-level
	  define-command-menu-handler
	  define-program-command
	  define-program-framework
	  *Dispatch-Mode*
	  exit-program
	  find-program-window
	  get-pane
	  get-program-pane
	  margin-borders
	  margin-label
	  margin-scroll-bar
	  margin-white-borders
	  margin-whitespace
	  margin-ragged-borders
	  *Program*
	  *Program-Frame*
	  program-frame
	  program-name
	  read-accelerated-command
	  read-program-command
	  run-program
	  standard-command-menu-handler
	  set-configuration
	  set-program-frame-configuration


	  ;; graphic transformation symbols
	  build-graphics-transform
	  compose-transforms
	  make-graphics-transform
	  make-identity-transform
	  transform-distance
	  transform-point
	  with-rotation
	  with-scaling
	  with-translation
	  with-transform
	  with-identity-transform
	  
		 
	  ;; fancy display macros.
	  make-table-from-sequence
	  make-table-from-generated-sequence

	  make-table
	  table-row row
	  table-entry entry
	  table-column-headings

	  format-list
	  formatting-list
	  formatting-list-element
	  format-sequence-as-table-rows

	  with-indenting-output
	  with-border
	  with-centered-display
	  with-room-for-graphics
	  with-output-truncation
	  with-output-filling
	  with-underlining
	  with-output-abbreviating

		 
	  ;; basic graphic primitives.
	  bitblt
	  defstipple
	  draw-arrow
	  draw-circle
	  draw-ellipse
	  draw-line
	  draw-line-to
	  draw-glyph
	  draw-point
	  draw-polygon
	  draw-rectangle
	  draw-regular-polygon
	  draw-string
	  draw-triangle
	  drawing-path

	  *Default-Arrow-Width*
	  *Default-Arrow-Length*

	  ;; alu operations
	  draw-alu
	  *Draw-Alu*
	  *Erase-Alu*
	  *Flip-Alu*
	  with-proper-alu

	  ;; basic window operations
	  clear-history
	  clear-window
	  
	  set-viewport-position
	  set-viewport-position-after
	  visible-cursorpos-limits
	  x-scroll-to
	  x-scroll-to-after
	  x-scroll-position
	  y-scroll-position
	  y-scroll-to
	  y-scroll-to-after



	  ;; mouse variables.
	  *Global-Mouse-X*
	  *Global-Mouse-Y*
	  *Mouse-Buttons*
	  *Mouse-Window*
	  *Mouse-X*
	  *Mouse-Y*
	  mouse-char-bits
	  mouse-char-button
	  mouse-chord-shifts
	  tracking-mouse

	  mouse-char-for-gesture
	  mouse-char-gesture
	  mouse-char-gestures

	  ;; character style stuff
	  char-size
	  char-size-from-font
	  font-ascent
	  font-descent
	  font-height
	  font-width
	  get-font-from-style
	  merge-character-styles
	  with-character-face
	  with-character-size
	  with-character-style

	  ;; window attributes
	  window-inside-bottom
	  window-inside-left
	  window-inside-right
	  window-inside-top
	  window-bottom-margin-size
	  window-character-style
	  window-edges
	  window-end-of-line-mode
	  window-end-of-page-mode
	  window-font
	  window-font-ascent
	  window-gcontext
	  window-height
	  window-inferiors
	  window-inside-edges
	  window-inside-height
	  window-inside-size
	  window-inside-width
	  window-left
	  window-left-margin-size
	  window-line-height
	  window-line-spacing
	  window-more-p
	  window-name
	  window-real-window
	  window-right-margin-size
	  window-size
	  window-scroll-x-offset
	  window-scroll-y-offset
	  window-superior
	  window-top
	  window-top-margin-size
	  window-transform
	  window-width
	  window-x-pos
	  window-y-pos

	  center-window-around
	  kill-window
	  set-window-edges
	  set-window-inside-size
	  set-window-label
	  set-window-line-spacing
	  set-window-position
	  set-window-size
	  set-window-style

	  dynamic-window
	  make-window
	  window
	  dynamic-window-pane
	  window-call-relative

	  home-cursor
	  increment-cursorpos
	  read-cursorpos
	  set-cursorpos
	  set-cursorpos-and-size-from-char
	  tab-cursorpos

	  deexpose-window
	  expose-window
	  expose-window-near
	  exposed-window-p
	  select-window

	  make-presentation-window
	  presentation-window
	  presentation-window-presentations
	  presentation-window-quad-table

	  allocate-fake-window
	  deallocate-fake-window
	  fake-window
	  make-fake-window


	  compute-motion
	  text-position
	  textlength
	  compute-cursor-position-in-string
	  clear-rest-of-line
	  clear-rest-of-window

	  parse-interval-or-never
	  parse-universal-time
	  print-interval-or-never
	  read-interval-or-never
	  
	  beep
	  *Default-Sync*
	  describe-object
	  enable-cursor
	  find-window
	  initialize-window-system
	  lisp-window
	  mouse-warp
	  prepare-window
	  process-wait
	  send
	  sync
	  which-operations

	  *Mouse-Documentation-String*
	  set-mouse-documentation-string
	  with-mouse-documentation-string

	  *Mouse-Window*

	  turn-off-blinkers set-blinker-status

	  convert-global-mouse-to-local-mouse
	  convert-window-coords-to-screen-coords
	  convert-screen-coords-to-window-coords
	  convert-window-coords-to-screen-coords-macro

	  type-of
	  typep
	  self
	   
	  

	  screen-edges
	  indent-terpri
	  with-safe-windows

	  alphalessp
	  string-length
	  with-lock-held
	  )
	'express-windows)



#+lucid
(let ((importer
        #+LCL3.0 #'sys:import-from-lucid-pkg
	#-LCL3.0 (let ((x (find-symbol "IMPORT-FROM-LUCID-PKG" "LUCID")))
		   (if (and x (fboundp x))
		       (symbol-function x)
		       ;; Only the #'(lambda (x) ...) below is really needed, 
		       ;;  but when available, the "internal" function 
		       ;;  'import-from-lucid-pkg' provides better checking.
		       #'(lambda (name)
			   (import (intern name "LUCID")))))))
  ;;
  ;; We need the following "internal", undocumented Lucid goodies:
  (mapc importer '("DEFSTRUCT-SIMPLE-PREDICATE"))
  ;;
  ;; We import the following symbols, because in 2.1 Lisps they have to be
  ;;  accessed as SYS:<foo>, whereas in 3.0 lisps, they are homed in the
  ;;  LUCID-COMMON-LISP package.
  ;;(mapc importer '("ARGLIST" "NAMED-LAMBDA" "*PRINT-STRUCTURE*"))
  ;;
  ;; We import the following symbols, because in 2.1 Lisps they have to be
  ;;  accessed as LUCID::<foo>, whereas in 3.0 lisps, they have to be
  ;;  accessed as SYS:<foo>
  (mapc importer '(
		   "NEW-STRUCTURE"   	"STRUCTURE-REF"
		   "PROCEDUREP"     	"PROCEDURE-SYMBOL"
		   "PROCEDURE-ARGLIST"
		   "PROCEDURE-REF" 	"SET-PROCEDURE-REF" 
		   ))
  ;;
  ;;  The following is for the "patch" to the general defstruct printer.
  #+ignore
  (mapc importer '(
		   "OUTPUT-STRUCTURE" 	  "DEFSTRUCT-INFO"
		   "OUTPUT-TERSE-OBJECT"  "DEFAULT-STRUCTURE-PRINT" 
		   "STRUCTURE-TYPE" 	  "*PRINT-OUTPUT*"
		   ))
  ;;
  ;; The following is for a "patch" affecting compilation of %logand&.
  ;; On APOLLO, Domain/CommonLISP 2.10 does not include %logand& whereas
  ;; Domain/CommonLISP 2.20 does; Domain/CommonLISP 2.20 includes :DOMAIN/OS
  ;; on *FEATURES*, so this conditionalizes correctly for APOLLO.
;  #-(or (and APOLLO DOMAIN/OS) LCL3.0 VAX) 
;  (mapc importer '("COPY-STRUCTURE"  "GET-FDESC"  "SET-FDESC"))
  
  nil)