;;; -*- Mode: LISP; Syntax: Common-lisp; Package: XLIB; Base: 10; Lowercase: Yes -*-

;;; This file contains definitions for the DISPLAY object for Common-Lisp X windows version 11

;;;
;;;			 TEXAS INSTRUMENTS INCORPORATED
;;;				  P.O. BOX 2909
;;;			       AUSTIN, TEXAS 78769
;;;
;;; Copyright (C) 1987 Texas Instruments Incorporated.
;;;
;;; Permission is granted to any individual or institution to use, copy, modify,
;;; and distribute this software, provided that this complete copyright and
;;; permission notice is maintained, intact, in all copies and supporting
;;; documentation.
;;;
;;; Texas Instruments Incorporated provides this software "as is" without
;;; express or implied warranty.
;;;

;;;
;;; Change history:
;;;
;;;  Date	Author	Description
;;; -------------------------------------------------------------------------------------
;;; 12/10/87	LGO	Created

(in-package 'xlib :use '(lisp))

(defun enqueue-event (new-event display)
  ;; Place EVENT at the end of the event queue for DISPLAY
  (let ((event (list new-event)))
    (declare (type list event))
    (let* ((event-code (event-code new-event))
	   (event-key (and (< event-code (length *event-key-vector*))
			   (aref *event-key-vector* event-code))))
      (if (null event-key)
	  (format T "Ignore this event No handler for ~s event" event-key)
	(with-event-queue-internal (display)
	  (let ((new (display-new-events display)))
	    (declare (type list new))
	    (if new
		(setf (display-new-events display) (nconc new event))
	      (progn
		(setf (display-new-events display) event)
		(let ((old (display-event-queue display)))
		  (setf (display-event-queue display) (nconc old event)))))))))))