;;;-*-Mode:LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;


(in-package 'pcl)

#|

to do:

rename this file to dcode and complete change from dfun to dcode terminology

make *compile-dcodes-at-run-time-p* work by centralizing a facility for
call the template constructor of a dcode

also make *can-call-the-compiler-p* work in install-discriminator-code,
recompile-class-of and dfun-templ

make individuals work, at least a little

make a backup general case for dcode and hook it up to 
*compile-dcodes-at-run-time-p* so that PCL won't call the compiler at run
time unless that is really appropriate

finish some more of the special cases for dcode

move compute-discriminator-code and its friends from methods to the top of
here

work on getting this stuff to compile faster

work on state transition table techology for compute-discriminator-code


|#



;;;
;;;
;;;
;;; number of methods -- default only
;;;                      one only
;;;                      2 or more
;;;
;;; type of methods   -- all readers or writers
;;;                      some readers or writers
;;;                      no readers or writers
;;;
;;; metaclass of specialiers -- all standard-class
;;;                             all funcallable-standard-class
;;;                             all any one metaclass
;;;                             assortment
;;;


;;;
;;; Some support stuff for getting a hold of symbols that we need when
;;; building the discriminator codes.  Its ok for these to be interned
;;; symbols because we don't capture any user code in the scope in which
;;; these symbols are bound.
;;; 

(defvar *dcode-arg-symbols* ())

(defun dcode-arg-symbol (arg-number)
  (or (cdr (assoc arg-number *dcode-arg-symbols* :test #'=))
      (let ((new (cons arg-number
		       (intern (format nil "ARG-~D" arg-number)
			       *the-pcl-package*))))
	(push new *dcode-arg-symbols*)
	(cdr new))))

(eval-when (load) (dotimes (i 10) (dcode-arg-symbol (- 9 i))))

(defvar *dcode-wrapper-symbols* ())

(defun dcode-wrapper-symbol (arg-number)
  (or (cdr (assoc arg-number *dcode-wrapper-symbols* :test #'=))
      (let ((new (cons arg-number
		       (intern (format nil "WRAPPER-~D" arg-number)
			       *the-pcl-package*))))
	(push new *dcode-wrapper-symbols*)
	(cdr new))))

(eval-when (load) (dotimes (i 10) (dcode-wrapper-symbol (- 9 i))))



(defmacro generic-function-cache-entry (cache offset offset-from-offset)
  `(memory-block-ref ,cache (%+ ,offset ,offset-from-offset)))



;;;
;;; In the case where all the methods on a generic function are either writers
;;; or readers, we can win by pulling the slot-lookup caching that the methods
;;; would do when they are called directly into the discriminator code and its
;;; cache.
;;; For this case, the generic function cache is used as follows:
;;;
;;;                  -------------------
;;;    class-0 -->  | <wrapper for FOO> |
;;;    index-0 -->  |        3          |
;;;                 |                   |
;;;      .          |        .          |
;;;      .          |        .          |
;;;                 |                   |
;;;    class-n -->  | <wrapper for BAR> |
;;;    index-n -->  |        1          |
;;;                  -------------------
;;;
;;;    It is a one key cache, the keys are the class-wrapper of the
;;;    specialized argument.  (In the case of reader methods there
;;;    is only one argument, it is the
;;;
;;;
;;;
(defun make-all-std-class-readers-dcode (generic-function)
  (initialize-generic-function-cache generic-function ())
  (funcall
    (get-templated-function-constructor 'all-std-class-readers-dcode)
    generic-function
    (generic-function-cache generic-function)))

(defun make-all-std-class-writers-dcode (generic-function)
  (initialize-generic-function-cache generic-function ())
  (funcall
    (get-templated-function-constructor 'all-std-class-writers-dcode)
    generic-function
    (generic-function-cache generic-function)))

(defmacro r/w-cache-key () '(generic-function-cache-entry .CACHE. offset 0))
(defmacro r/w-cache-val () '(generic-function-cache-entry .CACHE. offset 1))

(define-function-template all-std-class-readers-dcode
			  ()
			  '(.GENERIC-FUNCTION. .CACHE.)
  (let ()
    `(function
       (lambda (arg)
	 (locally
	   (declare (optimize (speed 3) (safety 0)))
	   (let* ((wrapper (and (iwmc-class-p arg)
				(iwmc-class-class-wrapper arg)))
		  (offset 0)
		  (val nil))
	     (if (null wrapper)
		 (no-applicable-method .GENERIC-FUNCTION. arg)
		 (progn 
		   (setq offset
			 (cache-key-from-wrappers ,generic-function-cache-size
						  2
						  wrapper))
		   (without-interrupts
		     (if (and (eq (r/w-cache-key) wrapper)
			      (neq (setq val
					 (%svref (iwmc-class-static-slots arg)
						 (r/w-cache-val)))
				   ',*slot-unbound*))
			 val					     
			 (with-interrupts 
			   (all-std-class-readers-miss
			     arg wrapper .cache.
			     ,generic-function-cache-size
			     offset .generic-function.))))))))))))


(defun all-std-class-readers-miss
       (arg wrapper .cache. cache-size offset generic-function)
  (setq offset (cache-key-from-wrappers-2 cache-size arg))
  (let ((class (wrapper-class wrapper))
	(method (lookup-method-1 generic-function arg)))
    (if (null method)
	(no-applicable-method generic-function arg)
	(let* ((slot-name (reader/writer-method-slot-name method))
	       (slot-pos (all-std-class-readers-miss-1 class
						       wrapper
						       slot-name)))
	  (if (not (null slot-pos))
	      (progn 
		;; This is an instance slot, cache position and return value.
		(without-interrupts
		  (setf (r/w-cache-key) wrapper)
		  (setf (r/w-cache-val) slot-pos))
		(let ((val (%svref (iwmc-class-static-slots arg) slot-pos)))
		  (if (eq val *slot-unbound*)
		      (slot-unbound class arg slot-name)
		      val)))
	       (slot-value-using-class class arg slot-name))))))

(defmethod all-std-class-readers-miss-1
	   ((class standard-class) wrapper slot-name)
  (instance-slot-position wrapper slot-name))

(define-function-template all-std-class-writers-dcode
			  ()
			  '(.GENERIC-FUNCTION. .CACHE.)
  (let ()
    `(function
       (lambda (new-value arg)
	 (locally
	   (declare (optimize (speed 3) (safety 0)))
	   (let* ((wrapper (and (iwmc-class-p arg)
				(iwmc-class-class-wrapper arg)))
		  (offset 0))
	     (if (null wrapper)
		 (no-applicable-method .GENERIC-FUNCTION. new-value arg)
		 (progn
		   (setq offset
			 (cache-key-from-wrappers ,generic-function-cache-size
						  2
						  wrapper))
		   (without-interrupts
		     (if (eq (r/w-cache-key) wrapper)
			 (setf (%svref (iwmc-class-static-slots arg)
				       (r/w-cache-val))
			       new-value)
			 (with-interrupts 
			   (all-std-class-writers-miss
			     new-value arg wrapper .cache.
			     ,generic-function-cache-size
			     offset .generic-function.))))))))))))

(defun all-std-class-writers-miss
       (new-value arg wrapper .cache. cache-size offset generic-function)
  (setq offset (cache-key-from-wrappers-2 cache-size arg))
  (let ((class (wrapper-class wrapper))
	(method (lookup-method-1 generic-function arg)))
    (if (null method)
	(no-applicable-method generic-function new-value arg)
	(let* ((slot-name (reader/writer-method-slot-name method))
	       (slot-pos (all-std-class-readers-miss-1 class
						       wrapper
						       slot-name)))
	  (if (not (null slot-pos))
	      (progn 
		(without-interrupts
		  (setf (r/w-cache-key) wrapper)
		  (setf (r/w-cache-val) slot-pos))
		(setf (%svref (iwmc-class-static-slots arg) slot-pos)
		      new-value))
	      (setf (slot-value-using-class class arg slot-name)
		    new-value))))))
  
(eval-when (load)
  (pre-make-templated-function-constructor all-std-class-readers-dcode)
  (pre-make-templated-function-constructor all-std-class-writers-dcode))



(defmacro cached-method (cache offset &rest wrappers)
  `(and ,@(gathering ((eqs (collecting)))
	    (iterate ((wrapper (list-elements wrappers))
		      (key-no (interval :from 0)))
	      (gather `(eq (generic-function-cache-entry ,cache
							 ,offset
							 ,key-no)
			   ,wrapper)
		      eqs)))
	(generic-function-cache-entry ,cache ,offset ,(length wrappers))))

(define-function-template caching-discriminating-function
                          (required restp specialized-positions cache-size)
                          '(.GENERIC-FUNCTION. .CACHE.)
  (let* ((nspecialized				;the number of specialized
						;arguments
	   (length specialized-positions))
	 (line-size				;the number of elements in
						;a line of the cache
	   (+ nspecialized 1))
	 (args
	   (gathering ((args (collecting)))
	     (dotimes (i required)
	       (gather (dcode-arg-symbol i) args))))
         (wrapper-bindings
	   (gathering ((bindings (collecting)))
	     (dolist (pos specialized-positions)
	       (gather (list (dcode-wrapper-symbol pos)
			     `(wrapper-of-2 ,(nth pos args)))
		       bindings))))
         (wrappers (mapcar #'car wrapper-bindings)))
    
    `(function
       (lambda (,@args ,@(and restp '(&rest rest-arg)))
	 (locally
	   (declare (optimize (speed 3)
			      (safety 0)
			      #+lucid (lucid::compilation-speed 0)))
	   (prog ((method-function nil)
		  ,@wrapper-bindings
		  offset)
		 (setq offset (cache-key-from-wrappers ,cache-size
						       ,line-size
						       ,@wrappers))
		 
		 (if (setq method-function
			   (cached-method .cache. offset ,@wrappers))
		     (return ,(if restp
				  `(apply method-function ,@args rest-arg)
				  `(funcall method-function ,@args)))
		     (progn
		       ;; ***
		       ;; *** Backing cache lookup code goes here.
		       ;; ***
		       (return 
			 (caching-dcode-miss .generic-function.
					     .cache.
					     ',cache-size
					     ',specialized-positions
					     ,(and restp 'rest-arg)
					     ,@args))))))))))

(defun caching-dcode-miss
       (gf cache cache-size specialized-positions rest-arg &rest args)
  (let ((method-function (cdr (apply #'lookup-method-2 gf args))))
    (if (null method-function)
	(apply #'no-applicable-method gf (append args rest-arg))
	;; Recompute the offset for ourselves.  This also will do
	;; obsolete instance traps if that is required for any of
	;; the arguments.
	(let ((offset (cache-key-from-wrappers-1 cache-size
						 specialized-positions
						 args)))
	  
	  (without-interrupts
	    (when (generic-function-cache-entry cache offset 0)
	      ;; ***
	      ;; *** the code to transfer this entry to the
	      ;; *** backing cache goes here.
	      ;; ***
	      )
	    (let ((i 0)
		  (c 0))
	      (dolist (arg args)
		(when (null specialized-positions) (return))
		(when (= (car specialized-positions) i)
		  (setf (generic-function-cache-entry cache offset c)
			(wrapper-of-1 arg))
		  (setq specialized-positions (cdr specialized-positions))
		  (incf c))
		(incf i))
	      
	      (setf (generic-function-cache-entry cache offset c)
		    method-function)))
	  (apply method-function (append args rest-arg))))))


(defmacro pre-make-caching-discriminating-functions (specs)
  `(progn ,.(mapcar #'(lambda (s)
			`(pre-make-templated-function-constructor
			   caching-discriminating-function
			   ,.s))
		    specs)))