;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: clim-internals; Base: 10 -*-

;;;
;;;* This is an implementation of parts of the ISI Grapher algorithm for laying out
;;;  graphs originally described by Gabriel Robbins at the USC ISI.
;;;
;;; Bryan M. Kramer, Ph.D.	      416-978-7330, fax 416-978-1455
;;; Department of Computer Science, University of Toronto
;;; 6 King's College Road, Room 283E		
;;; Toronto, Ontario, Canada      M5S 1A4


;;; This code has been tried in clim2.0 beta from Franz Inc. running Allegro Common Lisp 4.2
;;;  Allegro CL 4.2.beta.0 [SPARC; R1] (11/27/92 18:45)
;;;  
;;; It works by redefining the method (layout-graph-nodes ((graph DIRECTED-GRAPH-OUTPUT-RECORD) stream))
;;; Furthermore, it does a change class on DIRECTED-GRAPH-OUTPUT-RECORD so it will not work if specializations of
;;; this record class are being used.
;;;
;;; ********** This code may be redistributed and / or modified as desired. ****************
;;;
;;; I am not actively playing with CLIM2.0 at the moment, so I may be of limited assistance.
;;;
;;; Franz has considerably changed the graph program since I wrote this. I have not looked at their new stuff.
;;;
;;;
;;;
;;; 



(in-package :clim-internals)

(defvar *minimum-x-distance* 10)
(setq *minimum-x-distance* 10)
(defvar *y-spacing* 1)
(setq *y-spacing* 1)

(defclass graph-layout-output-record (standard-graph-node-output-record)
	  (
	   (visited :accessor visited :initform nil :initarg :visited)
	   (visual-claimer :accessor visual-claimer :initform nil :initarg :visual-claimer)
	   (y-distance-to-farthest-son :accessor y-distance-to-farthest-son :initform nil :initarg :y-distance-to-farthest-son)
	   )
  )

(defmethod layout-info ((graph DIRECTED-GRAPH-OUTPUT-RECORD) (node standard-graph-node-output-record))
  (change-class node 'graph-layout-output-record)
  )

(defmethod layout-info ((graph DIRECTED-GRAPH-OUTPUT-RECORD) (node graph-layout-output-record))
  node
  )


(defmethod layout-x ((graph DIRECTED-GRAPH-OUTPUT-RECORD) (node standard-graph-node-output-record))
  (change-class node 'graph-layout-output-record)
  (layout-x graph node)
  )


(defmethod layout-x ((graph DIRECTED-GRAPH-OUTPUT-RECORD) (node graph-layout-output-record))
  (with-slots (node-children) node
    (with-slots (visited visual-claimer y-distance-to-farthest-son) node
      (user:-- visited)
      (when (>= 0 visited)
	(let ((tree_x (round (* 0.1 y-distance-to-farthest-son)))
	      (extra_x (round (* 0.06 (rectangle-width node) (length node-children)))))
	  (loop :for child :in node-children :do
	    (let ((min_x (cond ((eq node (slot-value (layout-info graph child) 'visual-claimer)) 0)
			       (t tree_x))))
	      (setf (graph-node-x child) (max (graph-node-x child)
					      (+ (graph-node-x node)
						 (rectangle-width node)
						 (max *minimum-x-distance* min_x extra_x))))
	      (layout-x graph child)
	      )
	    ))
	))
    )
  )


(defmethod layout-y ((graph DIRECTED-GRAPH-OUTPUT-RECORD) (node standard-graph-node-output-record) level visited_mark)
  (change-class node (find-class 'graph-layout-output-record))
  (layout-y graph node level visited_mark)
  )

(defmethod layout-y ((graph DIRECTED-GRAPH-OUTPUT-RECORD) (node graph-layout-output-record) level visited_mark)
  (with-slots (node-children) node
    (with-slots (visited visual-claimer y-distance-to-farthest-son) node
      (if (eql visited_mark visited)
	  level
	(let ((new-level level))
	  (setf visited visited_mark)
	  (loop :for child :in node-children :do
	    (with-slots (visual-claimer) (layout-info graph child)
	      (when (null visual-claimer)
		(setf visual-claimer node))
	      )
	    )
	  (loop :for child :in node-children :do
	    (setf new-level (layout-y graph child new-level visited_mark))
	    )
	  (let ((count 0)
		(sum 0)
		(first-height (if node-children (rectangle-height (car node-children))))
		(average new-level))
	    (loop :for child :in node-children
	      :when (eql node (slot-value (layout-info graph child) 'visual-claimer))
	      :do
	      (cust:++ count)
	      (cust:++ sum (slot-value child 'top))
	      )
	    (if (> count 0)
		(setf average (round (+ (/ sum count) (/ (- first-height (rectangle-height node)) 2))))
	      (setf average new-level))
					;(user:dbgf "~&Y: new-level ~d (rectangle-height node) ~d" average (rectangle-height node))
	    (if (< average level)
		(setf (graph-node-y node) level)
	      (setf (graph-node-y node) average)
	      )
	    (setf new-level (+ *y-spacing* (max new-level (+ level (rectangle-height node)))))
					;(user:dbgf "Y: new-level ~d (rectangle-height node) ~d" new-level (rectangle-height node))
	    )
	  new-level))
      )
    )
  )


(defun collect-elements (nodes elements)
  (loop :for node :in nodes :do
    (pushnew node (car elements))
    (collect-elements (slot-value node 'node-children) elements)
    )
  (car elements)
  )

(defmethod layout-graph-nodes ((graph DIRECTED-GRAPH-OUTPUT-RECORD) stream)
  (with-slots (root-nodes elements fill-pointer) graph
    (let ((y 0)
	  (key (gensym)))
      (loop :for node :in root-nodes :do
	(setf y (layout-y graph node y key))
	)
      (if (or (null fill-pointer) (zerop fill-pointer))
	  (loop :for node :in root-nodes :do
	    (with-slots (node-parents node-children top (graph-node-x node)) node
	      (with-slots (visited y-distance-to-farthest-son) (layout-info graph node)
		(setf visited (length node-parents))
		(setf (graph-node-x node) 0)
		(let ((farthest-y 0))
		  (loop :for child :in node-children :do
		    (setf farthest-y (max farthest-y (abs (- top (slot-value child 'top))))))
		  (setf y-distance-to-farthest-son farthest-y))
		)
	      ))
	(loop :for node :across elements
	  :for i :from 1 :to fill-pointer :do
	  (with-slots (node-parents node-children top (graph-node-x node)) node
	    (with-slots (visited y-distance-to-farthest-son) (layout-info graph node)
	      (setf visited (length node-parents))
	      (setf (graph-node-x node) 0)
	      (let ((farthest-y 0))
		(loop :for child :in node-children :do
		  (setf farthest-y (max farthest-y (abs (- top (slot-value child 'top))))))
		(setf y-distance-to-farthest-son farthest-y))
	      )
	    ))
	)
      (loop :for node :in root-nodes :do
	(layout-x graph node)
	)
      )
    )
  )
