(in-package :SRI)


;;;; Function display-env reads the DISPLAY environment variable used by the
;;;; X-window system and returns the host and display-number parts of that
;;;; variable as two return values.  If the environment variable has no
;;;; value then we prompt the user for its value.
;;;;
;;;; The user can supply the value of the variable as an optional parameter
;;;; if desired.

;;;; PDK  10/15/91


(export '(display-env))



(defun display-env (&optional display-env)
  (let (display colon host)

    (when display-env
      (setenv "DISPLAY" display-env) )

    (unless (setq display-env (getenv "DISPLAY"))
      (format *terminal-io*
	      "~%Enter name of X-window server to connect to (of the form HOST:N.M): ")
      (setq display-env (read-line *terminal-io*))
      (terpri *terminal-io*)
      (setenv "DISPLAY" display-env)
      )

    (setq colon (position  #\: display-env :test #'char-equal))

    (setq host (subseq display-env 0 colon))
    (when (equal host "")
      (setq host (machine-instance)))	;In openwindows 2 on a localhost, DISPLAY is ":0"

    (setq display (read-from-string
		   (subseq display-env
			   (1+ colon)
			   (position #\. display-env
				     :test #'char-equal
				     :start colon))))
    (values host display)
    ) )



(defun getenv (variable)
  #+Lucid
  (lcl:environment-variable variable)
  #+Franz-Inc
  (system:getenv variable)
  )


(defun setenv (variable value)
  #+Lucid
  (setf (lcl:environment-variable variable) value)
  #+Franz-Inc
  (excl::run-shell-command (concat "setenv " variable " " value))
  )
